/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authc.service.impl;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserAutoFillDto;
import com.jxdinfo.hussar.support.security.core.exception.SecurityTokenException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="hussar", name={"login-method"}, havingValue="default", matchIfMissing=false)
public class GetLoginUserServiceImpl
implements GetLoginUserService {
    public UserAutoFillDto getAutoUserInfo() {
        UserAutoFillDto userAutoFillDto = new UserAutoFillDto();
        try {
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            if (ToolUtil.isNotEmpty((Object)securityUser)) {
                userAutoFillDto.setUserId(securityUser.getId());
                userAutoFillDto.setUserName(securityUser.getName());
                if (ToolUtil.isNotEmpty((Object)securityUser.getTenantId())) {
                    userAutoFillDto.setTenantId(Long.valueOf(securityUser.getTenantId()));
                }
            }
            userAutoFillDto.setTokenValue(BaseSecurityUtil.getTokenValue());
            userAutoFillDto.setTokenName(BaseSecurityUtil.getTokenName());
            return userAutoFillDto;
        }
        catch (SecurityTokenException e) {
            return null;
        }
    }
}

