/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authc.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authc.dto.AuthcDto;
import com.jxdinfo.hussar.authc.service.AuthcService;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.authentication.vo.LoginInfoVo;
import com.jxdinfo.hussar.authentication.vo.LoginUserInfoVo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.properties.GlobalProperties;
import com.jxdinfo.hussar.common.properties.HussarProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.onlinehist.service.ISysOnlineHistService;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.permit.model.SysUsers;
import com.jxdinfo.hussar.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.permit.service.ISysUsersService;
import com.jxdinfo.hussar.permit.service.SysLoginUserService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.tenant.model.SysTenant;
import com.jxdinfo.hussar.tenant.service.SysTenantService;
import com.jxdinfo.hussar.theme.service.IThemeService;
import com.jxdinfo.hussar.welcome.service.ISysWelcomeService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="hussar", name={"login-method"}, havingValue="default", matchIfMissing=false)
public class AuthcServiceImpl
implements AuthcService {
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private SysDataSourceService sysDataSourceService;
    @Resource
    private ISysOnlineHistService iSysOnlineHistService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private SysLoginUserService sysLoginUserService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private HussarProperties hussarProperties;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private IThemeService themeService;
    @Resource
    private ISysWelcomeService sysWelcomeService;
    @Resource
    private HussarLoginService hussarLoginService;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private ISysResourcesService iSysResourcesService;

    public ApiResponse<LoginInfoVo> tenantLoginWithCode(AuthcDto authcDto) {
        String tenantCode = authcDto.getTenantCode();
        if ("000000".equals(tenantCode)) {
            return this.userLogin(authcDto);
        }
        List list = this.sysTenantService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysTenant::getTenantCode, (Object)tenantCode)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        SysDataSource dataSource = this.sysDataSourceService.getByTenantCode(tenantCode);
        if (list == null || list.size() <= 0) {
            throw new HussarException("\u79df\u6237\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        SysTenant tenant = (SysTenant)list.get(0);
        if ("1".equals(tenant.getLoginTimeLimit())) {
            String beginTime = tenant.getAccessLoginStartTime();
            String endTime = tenant.getAccessLoginEndTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date begin = sdf.parse(beginTime);
                Date end = sdf.parse(endTime);
                Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                    throw new HussarException("\u79df\u6237\u672a\u5728\u6709\u6548\u671f\u5185");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (ToolUtil.isEmpty((Object)dataSource) || ToolUtil.isEmpty((Object)dataSource.getConnName())) {
            throw new HussarException("\u672a\u80fd\u83b7\u53d6\u79df\u6237\u7684\u6570\u636e\u6e90");
        }
        this.sysDataSourceService.addDataSourceByConnName(dataSource.getConnName());
        return this.changeTempDs(dataSource.getConnName(), authcDto);
    }

    @HussarDs(value="#connName")
    private ApiResponse<LoginInfoVo> changeTempDs(String connName, AuthcDto authcDto) {
        authcDto.setDsName(connName);
        return this.userLogin(authcDto);
    }

    public ApiResponse<LoginInfoVo> tenantLoginByAccount(AuthcDto authcDto) {
        String username = authcDto.getUsername();
        String tenantCode = this.sysLoginUserService.getTenantCodeByAccount(username);
        if (ToolUtil.isNotEmpty((Object)tenantCode)) {
            SysDataSource dataSource;
            if ("000000".equals(tenantCode)) {
                return this.userLogin(authcDto);
            }
            List list = this.sysTenantService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysTenant::getTenantCode, (Object)tenantCode)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            if (list == null || list.size() <= 0) {
                throw new HussarException("\u7528\u6237\u6240\u5728\u79df\u6237\u83b7\u53d6\u5931\u8d25");
            }
            SysTenant tenant = (SysTenant)list.get(0);
            if ("1".equals(tenant.getLoginTimeLimit())) {
                String beginTime = tenant.getAccessLoginStartTime();
                String endTime = tenant.getAccessLoginEndTime();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date begin = sdf.parse(beginTime);
                    Date end = sdf.parse(endTime);
                    Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                    if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                        throw new HussarException("\u6240\u5728\u79df\u6237\u672a\u5728\u6709\u6548\u671f\u5185");
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (ToolUtil.isEmpty((Object)(dataSource = this.sysDataSourceService.getByTenantCode(tenantCode))) || ToolUtil.isEmpty((Object)dataSource.getConnName())) {
                throw new HussarException("\u672a\u80fd\u83b7\u53d6\u79df\u6237\u7684\u6570\u636e\u6e90");
            }
            this.sysDataSourceService.addDataSourceByConnName(dataSource.getConnName());
            return this.changeTempDs(dataSource.getConnName(), authcDto);
        }
        throw new HussarException("\u7528\u6237\u6240\u5728\u79df\u6237\u83b7\u53d6\u5931\u8d25");
    }

    public ApiResponse<LoginInfoVo> userLogin(AuthcDto authcDto) {
        Object userInfo = this.hussarLoginService.login(authcDto);
        String username = authcDto.getUsername();
        SysUsers sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)username)).eq(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode()), false);
        SecurityUtil.login((Object)sysUsers.getId());
        BaseSecurityUtil.setAttribute((String)"baseUserInfo", (Object)userInfo);
        BaseSecurityUtil.setAttribute((String)"baseConnName", (Object)this.dynamicDataSourceService.currentDsName());
        LoginInfoVo loginInfoVo = new LoginInfoVo();
        loginInfoVo.setAccessToken(SecurityUtil.getTokenValue());
        return ApiResponse.success((Object)loginInfoVo);
    }

    public void logout() {
        SecurityUtil.logout();
    }

    private boolean showTenantInfo(SecurityUser securityUser) {
        boolean flag = false;
        if (ToolUtil.isNotEmpty((Object)securityUser)) {
            String account = securityUser.getAccount();
            if (this.globalProperties.isTenantOpen() && "2".equals(this.globalProperties.getTenantUserModel()) && Arrays.asList(Constants.MANAGE_USER).contains(account)) {
                flag = true;
            }
        }
        return flag;
    }

    public ApiResponse<Map<String, String>> check() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.globalProperties.isForceChangePwd()) {
            SysUsers sysUser = this.iSysUsersService.getUser(shiroUser.getId());
            if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
                map.put("firstLogin", "NO");
                map.put("changePwd", "NO");
                return ApiResponse.success(map);
            }
            if (this.iSysUsersService.isFirstLogin(shiroUser.getId())) {
                map.put("firstLogin", "YES");
            } else {
                map.put("firstLogin", "NO");
            }
            if (this.iSysUsersService.isPwdOverdue(shiroUser.getId())) {
                map.put("changePwd", "YES");
            } else {
                map.put("changePwd", "NO");
            }
        } else {
            map.put("firstLogin", "NO");
            map.put("changePwd", "NO");
        }
        return ApiResponse.success(map);
    }

    public ApiResponse<Map<String, Object>> getShow() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("totp", this.hussarProperties.getTotpOpen());
        map.put("kaptcha", this.hussarProperties.getKaptchaOpen());
        map.put("indexKaptcha", this.globalProperties.isLoginViewKaptcha());
        map.put("tenant", this.globalProperties.isTenantOpen());
        map.put("tenantModel", this.globalProperties.getTenantUserModel());
        return ApiResponse.success(map);
    }

    public ApiResponse<LoginUserInfoVo> queryLoginUserInfo(AuthcDto authcDto) {
        LoginUserInfoVo loginUserInfoVo = new LoginUserInfoVo();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (ToolUtil.isNotEmpty((Object)securityUser)) {
            loginUserInfoVo.setUserId(securityUser.getId());
            loginUserInfoVo.setUserName(securityUser.getName());
            loginUserInfoVo.setDeptId(securityUser.getDeptId());
            loginUserInfoVo.setDeptName(securityUser.getDeptName());
            List roleList = securityUser.getRolesList();
            loginUserInfoVo.setRoles(roleList);
            loginUserInfoVo.setGradeAdmin(Boolean.valueOf(securityUser.isGradeadmin()));
            loginUserInfoVo.setTenantCode(securityUser.getTenantCode());
            loginUserInfoVo.setTenantName(securityUser.getTenantName());
            loginUserInfoVo.setShowTenant(Boolean.valueOf(this.showTenantInfo(securityUser)));
            loginUserInfoVo.setSecurityLevel(securityUser.getSecurityLevel());
            loginUserInfoVo.setBpmTenantId(securityUser.getTenantId());
            loginUserInfoVo.setBpmTenantCipher(securityUser.getTenantCipher());
            String clientType = authcDto.getClientType();
            if (!ToolUtil.isNotEmpty((Object)clientType) || !"mobile".equalsIgnoreCase(clientType) && !"ios".equalsIgnoreCase(clientType)) {
                List permissionList = new ArrayList();
                if (ToolUtil.isNotEmpty((Object)roleList)) {
                    permissionList = this.iSysResourcesService.queryPermissionsByRoleIds(roleList);
                }
                loginUserInfoVo.setPermissions(permissionList);
                loginUserInfoVo.setTheme(this.themeService.queryUserTheme());
                ArrayList<Long> rolesList = new ArrayList<Long>(roleList);
                rolesList.add(securityUser.getId());
                loginUserInfoVo.setWelcomeUrl(this.sysWelcomeService.getUserIndex(rolesList));
            }
        }
        return ApiResponse.success((Object)loginUserInfoVo);
    }
}

