/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.util;

import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.utils.PlaceholderFormatUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.mail.util.HussarMailUtils;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.mail.MailException;

@DependsOn(value={"springContextHolder"})
public class LoginExceptionMailUtil {
    private static Logger logger = LoggerFactory.getLogger(LoginExceptionMailUtil.class);
    private static ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
    private static HussarThreadPoolConfiguration hussarThreadPoolConfiguration = (HussarThreadPoolConfiguration)SpringContextHolder.getBean(HussarThreadPoolConfiguration.class);

    private LoginExceptionMailUtil() {
    }

    public static void sendLockMail(String userAccount) {
        String emails = iSysBaseConfigService.getSysBaseConfigCom("fail_email_box").getConfigValue();
        if (emails != null && !"".equals(emails)) {
            List<String> tos = Arrays.asList(emails.split(","));
            String mailSubject = iSysBaseConfigService.getSysBaseConfigCom("fail_email_title").getConfigValue();
            String content = iSysBaseConfigService.getSysBaseConfigCom("fail_email").getConfigValue();
            String failNumber = iSysBaseConfigService.getSysBaseConfigCom("fail_number").getConfigValue();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("user_account", userAccount);
            map.put("fail_number", failNumber);
            content = PlaceholderFormatUtils.format((String)content, map);
            Executor threadExecutor = hussarThreadPoolConfiguration.getAsyncExecutor();
            if (null != threadExecutor) {
                String finalContent = content;
                threadExecutor.execute(() -> HussarMailUtils.send((Collection)tos, (String)mailSubject, (String)finalContent, (boolean)true, (File[])new File[0]));
            }
        }
    }

    public static void sendIPLimitMail(String userName, String userAccount, String ip) {
        String emails = iSysBaseConfigService.getSysBaseConfigCom("ip_warn_email_box").getConfigValue();
        if (emails != null && !"".equals(emails)) {
            List<String> tos = Arrays.asList(emails.split(","));
            String mailSubject = iSysBaseConfigService.getSysBaseConfigCom("ip_warn_email_title").getConfigValue();
            String content = iSysBaseConfigService.getSysBaseConfigCom("ip_warn_email").getConfigValue();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("user_account", userAccount);
            map.put("user_name", userName);
            map.put("ip_address", ip);
            content = PlaceholderFormatUtils.format((String)content, map);
            try {
                HussarMailUtils.send(tos, (String)mailSubject, (String)content, (boolean)true, (File[])new File[0]);
            }
            catch (MailException e) {
                logger.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25->{}", (Object)e.getMessage());
            }
        }
    }
}

