/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.audit.cloud.transdict.transable;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.vo.AuditStaffVo;
import com.jxdinfo.hussar.authorization.menu.model.SysMenuAudit;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuAuditBoService;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageBoService;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganTypeAudit;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganTypeBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseSysStruBoService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganAuditBoService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeAuditBoService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruAuditBoService;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionsAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysResourcesAudit;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRoleSetBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionAuditBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceTypeBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesAuditBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStaffAuditBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersAuditBoService;
import com.jxdinfo.hussar.authorization.post.model.SysPostAudit;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostBoService;
import com.jxdinfo.hussar.authorization.post.service.ISysPostAuditBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigBoService;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.cloud.support.transdict.feign.RemoteTransDictService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.map.MapUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteHussarTransMapping
implements RemoteTransDictService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteHussarTransMapping.class);
    @Resource
    private IHussarBaseOrganizationBoService organizationBoService;
    @Resource
    private IHussarBaseSysStruBoService hussarBaseSysStruBoService;
    @Resource
    private IHussarBaseStaffBoService staffBoService;
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private ISysMenuManageBoService sysMenuManageBoService;
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    @Resource
    private IHussarBasePostBoService postBoService;
    @Resource
    private ISysResourceTypeBoService resourceTypeBoService;
    @Resource
    private ISysRolesExternalService sysRolesExternalService;
    @Resource
    private IHussarBaseOrganTypeBoService hussarBaseOrganTypeBoService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ISysFunctionModulesBoService sysFunctionModulesBoService;
    @Resource
    private ISysRoleGroupBoService sysRoleGroupBoService;
    @Resource
    private ISysResourceMosulesBoService sysResourceMosulesBoService;
    @Resource
    private IHussarBaseResourceService resourceService;
    @Resource
    private ISysConfRoleSetBoService sysConfRoleSetBoServic;
    @Resource
    private ISysAuditConfigBoService auditConfigBoService;
    @Resource
    private ISysUsersAuditBoService sysUsersAuditBoService;
    @Resource
    private ISysStaffAuditBoService sysStaffAuditBoService;
    @Resource
    private ISysPostAuditBoService sysPostAuditBoService;
    @Resource
    private ISysMenuAuditBoService sysMenuAuditBoService;
    @Autowired
    private ISysStruAuditBoService sysStruAuditBoService;
    @Autowired
    private ISysResourcesAuditBoService sysResourcesAuditService;
    @Autowired
    private ISysOrganTypeAuditBoService sysOrganTypeAuditBoService;
    @Autowired
    private ISysOrganAuditBoService sysOrganAuditBoService;
    @Autowired
    private ISysFunctionAuditBoService functionAuditBoService;
    private static String TRANSLATE_ORGANIZATION = "TranslateOrganization";
    private static String TRANSLATE_STAFF = "TranslateStaff";
    private static String TRANSLATE_STRU = "TranslateStru";
    private static String TRANSLATE_USER = "TranslateUser";
    private static String TRANSLATE_DICT = "TranslateDict";
    private static String TRANSLATE_FUNCTION = "TranslateFunction";
    private static String TRANSLATE_FUNCTION_MODULE = "TranslateFunctionModule";
    private static String TRANSLATE_MENU = "TranslateMenu";
    private static String TRANSLATE_POST = "TranslatePost";
    private static String TRANSLATE_RESOURCE_TYPE = "TranslateResourceType";
    private static String TRANSLATE_DICT_SINGLE = "TranslateDictSingle";
    private static String TRANSLATE_ORGAN_STRU = "TranslateOrganStru";
    private static String TRANSLATE_ROLE = "TranslateRole";
    private static String TRANSLATE_ORGAN_TYPE = "TranslateOrganType";
    private static String TRANSLATE_RESOURCE_MODULE = "TranslateResourceModule";
    private static String TRANSLATE_RESOURCES = "TranslateResources";
    private static String TRANSLATE_ROLE_GROUP = "TranslateRoleGroup";
    private static String TRANSLATE_CONF_ROLE_SET = "TranslateConfRoleSet";

    public Object getById(Map<String, Object> map) {
        LOGGER.info("getById\uff1a{}", (Object)JSON.toJSONString(map));
        String namespace = (String)map.get("namespace");
        Long id = HussarUtils.toLong((Object)map.get("id"));
        if (TRANSLATE_ORGANIZATION.equals(namespace)) {
            return this.organizationBoService.findOrganizationByOrganId(id);
        }
        if (TRANSLATE_USER.equals(namespace)) {
            SysUsersAudit sysUsersAudit;
            if (this.auditConfigBoService.isCriticalOperationsAudit() && this.auditConfigBoService.isUserAudit() && HussarUtils.isNotEmpty((Object)(sysUsersAudit = this.sysUsersAuditBoService.getUsersAuditByUserId(Long.valueOf(HussarUtils.toLong((Object)id)))))) {
                return sysUsersAudit;
            }
            return this.userBoService.getUserAndStaffInfo(Long.valueOf(HussarUtils.toLong((Object)id)));
        }
        if (TRANSLATE_STAFF.equals(namespace)) {
            AuditStaffVo auditStaffVo;
            if (this.auditConfigBoService.isCriticalOperationsAudit() && this.auditConfigBoService.isStaffAudit() && HussarUtils.isNotEmpty((Object)(auditStaffVo = this.sysStaffAuditBoService.getStaffAuditByStaffId(Long.valueOf(HussarUtils.toLong((Object)id)))))) {
                return auditStaffVo;
            }
            return this.staffBoService.findStaffByStaffId(Long.valueOf(HussarUtils.toLong((Object)id)));
        }
        if (TRANSLATE_STRU.equals(namespace)) {
            SysStruAudit sysStruAudit;
            if (this.auditConfigBoService.isCriticalOperationsAudit() && this.auditConfigBoService.isStruAudit() && HussarUtils.isNotEmpty((Object)(sysStruAudit = this.sysStruAuditBoService.getByStruId(Long.valueOf(HussarUtils.toLong((Object)id)))))) {
                return sysStruAudit;
            }
            return this.hussarBaseSysStruBoService.findStruById(Long.valueOf(HussarUtils.toLong((Object)id)));
        }
        if (TRANSLATE_FUNCTION.equals(namespace)) {
            SysFunctionsAudit sysFunctionsAudit;
            if (this.auditConfigBoService.isCriticalOperationsAudit() && this.auditConfigBoService.isFunctionAudit() && HussarUtils.isNotEmpty((Object)(sysFunctionsAudit = this.functionAuditBoService.getByFunctionId(Long.valueOf(HussarUtils.toLong((Object)id)))))) {
                return sysFunctionsAudit;
            }
            return this.sysFunctionsBoService.getOneById(Long.valueOf(HussarUtils.toLong((Object)id)));
        }
        if (TRANSLATE_MENU.equals(namespace)) {
            SysMenuAudit sysMenuAudit;
            if (this.auditConfigBoService.isCriticalOperationsAudit() && this.auditConfigBoService.isMenuAudit() && HussarUtils.isNotEmpty((Object)(sysMenuAudit = this.sysMenuAuditBoService.getMenuAuditByMenuId(Long.valueOf(HussarUtils.toLong((Object)id)))))) {
                return sysMenuAudit;
            }
            return this.sysMenuManageBoService.getMenuById(Long.valueOf(HussarUtils.toLong((Object)id)));
        }
        if (TRANSLATE_POST.equals(namespace)) {
            SysPostAudit sysPostAudit;
            if (this.auditConfigBoService.isCriticalOperationsAudit() && this.auditConfigBoService.isPostAudit() && HussarUtils.isNotEmpty((Object)(sysPostAudit = this.sysPostAuditBoService.getPostAuditByPostId(Long.valueOf(HussarUtils.toLong((Object)id)))))) {
                return sysPostAudit;
            }
            return this.postBoService.findPostById(Long.valueOf(HussarUtils.toLong((Object)id)));
        }
        if (TRANSLATE_RESOURCE_TYPE.equals(namespace)) {
            return this.resourceTypeBoService.getResourceTypeById(id);
        }
        if (TRANSLATE_ORGAN_STRU.equals(namespace)) {
            SysOrganAudit sysOrganAudit;
            if (this.auditConfigBoService.isCriticalOperationsAudit() && this.auditConfigBoService.isOrganAudit() && HussarUtils.isNotEmpty((Object)(sysOrganAudit = this.sysOrganAuditBoService.getByOrganId(Long.valueOf(HussarUtils.toLong((Object)id)))))) {
                return sysOrganAudit;
            }
            return this.organizationBoService.findOrganizationById(Long.valueOf(HussarUtils.toLong((Object)id)));
        }
        if (TRANSLATE_ROLE.equals(namespace)) {
            return this.sysRolesExternalService.getById(id);
        }
        if (TRANSLATE_ORGAN_TYPE.equals(namespace)) {
            SysOrganTypeAudit sysOrganTypeAudit;
            if (this.auditConfigBoService.isCriticalOperationsAudit() && this.auditConfigBoService.isOrganTypeAudit() && HussarUtils.isNotEmpty((Object)(sysOrganTypeAudit = this.sysOrganTypeAuditBoService.getByTypeId(HussarUtils.toStr((Object)id))))) {
                return sysOrganTypeAudit;
            }
            return this.hussarBaseOrganTypeBoService.findOrganizationTypeByOrganType(id.toString());
        }
        if (TRANSLATE_DICT_SINGLE.equals(namespace)) {
            return this.sysDicRefService.getDicSingleById(id);
        }
        if (TRANSLATE_FUNCTION_MODULE.equals(namespace)) {
            return this.sysFunctionModulesBoService.getOneById(id);
        }
        if (TRANSLATE_RESOURCE_MODULE.equals(namespace)) {
            return this.sysResourceMosulesBoService.getResourceModulesById(id);
        }
        if (TRANSLATE_RESOURCES.equals(namespace)) {
            if (this.auditConfigBoService.isCriticalOperationsAudit() && this.auditConfigBoService.isResourceAudit()) {
                SysResourcesAudit sysResourcesAudit = this.sysResourcesAuditService.getByResourceId(Long.valueOf(HussarUtils.toLong((Object)id)));
                if (HussarUtils.isNotEmpty((Object)sysResourcesAudit)) {
                    return sysResourcesAudit;
                }
                return this.sysResourcesAuditService.getByResourceId(Long.valueOf(HussarUtils.toLong((Object)id)));
            }
            return this.resourceService.getResourcesById(Long.valueOf(HussarUtils.toLong((Object)id)));
        }
        if (TRANSLATE_ROLE_GROUP.equals(namespace)) {
            return this.sysRoleGroupBoService.getRoleGroupInfoById(id);
        }
        if (TRANSLATE_CONF_ROLE_SET.equals(namespace)) {
            return this.sysConfRoleSetBoServic.getSysConfRolesById(id);
        }
        LOGGER.info("getById\u672a\u627e\u5230\u547d\u540d\u7a7a\u95f4\uff0c{}", (Object)namespace);
        return null;
    }

    public <T> List<T> listByMap(Map<String, Object> map) {
        LOGGER.info("listByMap\uff1a{}", (Object)JSON.toJSONString(map));
        String namespace = (String)map.get("namespace");
        if (TRANSLATE_DICT.equals(namespace)) {
            String label = this.sysDicRefService.getDictLabel((String)map.get("type"), (String)map.get("value"));
            if (label != null) {
                return Collections.singletonList(MapUtil.of((Object)"label", (Object)label));
            }
            return null;
        }
        LOGGER.info("listByMap\u672a\u627e\u5230\u547d\u540d\u7a7a\u95f4\uff0c{}", (Object)namespace);
        return null;
    }
}

