/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static int BUFFERSIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(List<String> paths, String fileName) throws IOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(fileName));
            for (String filePath : paths) {
                File file = new File(filePath);
                String relativePath = file.getName();
                if (file.isDirectory()) {
                    relativePath = relativePath + File.separator;
                }
                ZipUtil.zipFile(file, relativePath, zos);
            }
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File file, String relativePath, ZipOutputStream zos) throws IOException {
        InputStream is = null;
        try {
            if (!file.isDirectory()) {
                ZipEntry zp = new ZipEntry(relativePath);
                zos.putNextEntry(zp);
                is = new FileInputStream(file);
                byte[] buffer = new byte[BUFFERSIZE];
                int length = 0;
                while ((length = is.read(buffer)) >= 0) {
                    zos.write(buffer, 0, length);
                }
                zos.flush();
                zos.closeEntry();
            } else {
                String tempPath = null;
                for (File f : file.listFiles()) {
                    tempPath = relativePath + f.getName();
                    if (f.isDirectory()) {
                        tempPath = tempPath + File.separator;
                    }
                    ZipUtil.zipFile(f, tempPath, zos);
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> unzip(String fileName, String path) throws IOException {
        FileOutputStream fos = null;
        InputStream is = null;
        ArrayList<String> filePaths = new ArrayList<String>();
        try {
            ZipFile zf = new ZipFile(new File(fileName));
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry zn = en.nextElement();
                if (zn.isDirectory()) continue;
                is = zf.getInputStream(zn);
                File f = new File(path + zn.getName());
                File file = f.getParentFile();
                file.mkdirs();
                fos = new FileOutputStream(path + zn.getName());
                int len = 0;
                byte[] bufer = new byte[BUFFERSIZE];
                while (-1 != (len = is.read(bufer))) {
                    fos.write(bufer, 0, len);
                }
                fos.close();
                filePaths.add(path + zn.getName());
            }
            zf.close();
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return filePaths;
    }
}

