/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.util;

import com.jxdinfo.hussar.application.properties.MavenProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenUtil {
    private static final Logger logger = LoggerFactory.getLogger(MavenUtil.class);
    private static final MavenProperties mavenProperties = (MavenProperties)SpringContextHolder.getBean(MavenProperties.class);

    public static void modulePackage(File pom) throws MavenInvocationException {
        String mavenHome = mavenProperties.getHome();
        String userSettingFile = mavenProperties.getUserSettingFile();
        String localRepository = mavenProperties.getLocalRepository();
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setLocalRepositoryDirectory(new File(localRepository));
        request.setUserSettingsFile(new File(userSettingFile));
        request.setPomFile(pom);
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("clean");
        goals.add("install");
        goals.add("package");
        request.setGoals(goals);
        request.setMavenOpts(" -DskipTests=true -Dfile.encoding=UTF-8");
        request.setOffline(true);
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(mavenHome));
        MavenIOManager ioManager = new MavenIOManager();
        invoker.setInputStream(ioManager.getStdin());
        invoker.setOutputHandler(ioManager.getStdout());
        invoker.setErrorHandler(ioManager.getStderr());
        try {
            logger.info("*** \u5f00\u59cb Maven \u6253\u5305: {} ***", (Object)pom);
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new MavenInvocationException(ioManager.toString());
            }
        }
        catch (MavenInvocationException e) {
            throw new MavenInvocationException(e.getMessage());
        }
        finally {
            logger.info("*** \u7ed3\u675f Maven \u6253\u5305: {} ***", (Object)pom);
        }
    }

    private static class MavenIOManager {
        private final StringBuffer logs = new StringBuffer();

        private MavenIOManager() {
        }

        public InputStream getStdin() {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            };
        }

        public InvocationOutputHandler getStdout() {
            return line -> {
                this.logs.append(line).append('\n');
                logger.info("{}", (Object)line);
            };
        }

        public InvocationOutputHandler getStderr() {
            return line -> {
                this.logs.append(line).append('\n');
                logger.error("{}", (Object)line);
            };
        }

        public String toString() {
            return this.logs.toString();
        }
    }
}

