/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.util;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileInspectUtil {
    private static String fileSum = "";

    public String traverseFolder(File file) {
        return this.traverseFolder(file, "");
    }

    public String traverseFolder(File file, String suffix) {
        if (file == null) {
            throw new NullPointerException("\u904d\u5386\u8def\u5f84\u4e3a\u7a7a\u8def\u5f84\u6216\u975e\u6cd5\u8def\u5f84");
        }
        if (ToolUtil.isEmpty((Object)suffix)) {
            suffix = ".";
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files == null || files.length == 0) {
                    return null;
                }
                for (File f : files) {
                    if (f.isDirectory()) {
                        if (f.getName().endsWith(suffix)) continue;
                        this.traverseFolder(f, suffix);
                        continue;
                    }
                    String string = FileInspectUtil.checkMd5(f);
                    fileSum = fileSum + string;
                }
            } else if (!file.getName().endsWith(suffix)) {
                fileSum = FileInspectUtil.checkMd5(file);
            }
        } else {
            return null;
        }
        return fileSum;
    }

    private static String checkMd5(File file) {
        if (!file.isFile()) {
            throw new NumberFormatException("\u53c2\u6570\u9519\u8bef\uff01\u8bf7\u8f93\u5165\u6821\u51c6\u6587\u4ef6\u3002");
        }
        byte[] rb = null;
        DigestInputStream digestInputStream = null;
        try (FileInputStream fis = new FileInputStream(file);){
            MessageDigest md5 = MessageDigest.getInstance("md5");
            digestInputStream = new DigestInputStream(fis, md5);
            byte[] buffer = new byte[4096];
            while (digestInputStream.read(buffer) > 0) {
                md5 = digestInputStream.getMessageDigest();
                rb = md5.digest();
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        if (rb != null) {
            for (int i = 0; i < rb.length; ++i) {
                String a = Integer.toHexString(0xFF & rb[i]);
                if (a.length() < 2) {
                    a = '0' + a;
                }
                sb.append(a);
            }
        }
        return sb.toString();
    }
}

