/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.application.dao.FormdesignAppInfoMapper;
import com.jxdinfo.hussar.application.dao.FormdesignAppUserMappingMapper;
import com.jxdinfo.hussar.application.model.FormdesignAppInfo;
import com.jxdinfo.hussar.application.model.FormdesignAppUserMapping;
import com.jxdinfo.hussar.bsp.tenant.model.SysTenant;
import com.jxdinfo.hussar.bsp.tenant.service.SysTenantService;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.speedcode.app.FormDesignAppInfo;
import com.jxdinfo.speedcode.app.IApp;
import com.jxdinfo.speedcode.datasource.FormDesignDataSource;
import com.jxdinfo.speedcode.datasource.IDataSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="IAppImpl2")
public class IAppImpl
implements IApp {
    private final FormdesignAppInfoMapper formdesignAppInfoMapper;
    private final FormdesignAppUserMappingMapper userMappingMapper;
    private final IDataSource dataSourceService;
    @Autowired
    private SysTenantService sysTenantService;

    @Autowired
    public IAppImpl(FormdesignAppInfoMapper formdesignAppInfoMapper, FormdesignAppUserMappingMapper userMappingMapper, IDataSource dataSourceService) {
        this.formdesignAppInfoMapper = formdesignAppInfoMapper;
        this.userMappingMapper = userMappingMapper;
        this.dataSourceService = dataSourceService;
    }

    @Cacheable(value={"appInfo"}, key="#appId")
    public FormDesignAppInfo getAppInfo(String appId) {
        FormdesignAppInfo info = this.getTenantAppInfo(appId);
        if (info == null && (info = this.getMasterAppInfo(appId)) == null) {
            return null;
        }
        FormDesignAppInfo result = new FormDesignAppInfo();
        result.setObjId(info.getObjId());
        result.setName(info.getName());
        result.setAppDescribe(info.getAppDescribe());
        result.setEnglishName(info.getEnglishName());
        result.setCreateTime(info.getCreateTime());
        result.setTenantName(info.getTenantName());
        result.setTenantId(info.getTenantId());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormdesignAppInfo getTenantAppInfo(String appId) {
        ShiroUser currentUser = null;
        try {
            currentUser = BaseShiroKit.getUser();
        }
        catch (Exception e) {
            return this.getAppinfoWithoutUserInfo(appId);
        }
        if (currentUser == null) {
            return this.getAppinfoWithoutUserInfo(appId);
        }
        String dbName = this.dataSourceService.getDefaultByTenantCode(currentUser.getTenantCode()).getDbName();
        try {
            DataSourceUtil.changeTempDs((String)dbName);
            FormdesignAppInfo formdesignAppInfo = (FormdesignAppInfo)((Object)this.formdesignAppInfoMapper.selectById((Serializable)((Object)appId)));
            return formdesignAppInfo;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FormdesignAppInfo getAppinfoWithoutUserInfo(String appId) {
        FormdesignAppInfo formdesignAppInfo = null;
        List tenantlist = this.sysTenantService.list();
        for (int i = 0; i < tenantlist.size(); ++i) {
            SysTenant sysTenantTemp = (SysTenant)tenantlist.get(i);
            String tenantCode = sysTenantTemp.getTenantCode();
            FormDesignDataSource defaultByTenantCode = this.dataSourceService.getDefaultByTenantCode(tenantCode);
            if (!ToolUtil.isNotEmpty((Object)defaultByTenantCode)) continue;
            String dbName = defaultByTenantCode.getDbName();
            try {
                DataSourceUtil.changeTempDs((String)dbName);
                FormdesignAppInfo formdesignAppInfoTemp = (FormdesignAppInfo)((Object)this.formdesignAppInfoMapper.selectById((Serializable)((Object)appId)));
                if (!ToolUtil.isNotEmpty((Object)((Object)formdesignAppInfoTemp))) continue;
                formdesignAppInfo = formdesignAppInfoTemp;
                break;
            }
            finally {
                DataSourceUtil.poll();
            }
        }
        return formdesignAppInfo;
    }

    public FormdesignAppInfo getMasterAppInfo(String appId) {
        try {
            DataSourceUtil.changeTempDs((String)"master");
            FormdesignAppInfo formdesignAppInfo = (FormdesignAppInfo)((Object)this.formdesignAppInfoMapper.selectById((Serializable)((Object)appId)));
            return formdesignAppInfo;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    public String getDBNameByAppId(String appId) {
        FormDesignAppInfo appInfo = this.getAppInfo(appId);
        if (appInfo == null || appInfo.getTenantId() == null) {
            return null;
        }
        FormDesignDataSource dataSource = this.dataSourceService.getDefaultByTenantCode(appInfo.getTenantId());
        if (dataSource == null) {
            return null;
        }
        return dataSource.getDbName();
    }

    public List<FormDesignAppInfo> listAppInfo(String userId) {
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId);
        List formdesignAppUserMappings = this.userMappingMapper.selectList((Wrapper)queryWrapper);
        return this.listAppInfoByAppId(formdesignAppUserMappings);
    }

    public FormDesignDataSource getDefaultByAppId(String appId) {
        FormdesignAppInfo info = this.getTenantAppInfo(appId);
        if (info == null && (info = this.getMasterAppInfo(appId)) == null) {
            return null;
        }
        String tenantCode = info.getTenantId();
        return this.dataSourceService.getDefaultByTenantCode(tenantCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormDesignAppInfo> listAllAppInfo(String userId) {
        List<FormDesignAppInfo> formDesignAppInfos;
        QueryWrapper queryWrapper = null;
        List formdesignAppUserMappings = null;
        ArrayList<FormDesignAppInfo> result = new ArrayList<FormDesignAppInfo>();
        if (!DataSourceUtil.currentDsName().equals("master") && (formDesignAppInfos = this.listAppInfoByAppId(formdesignAppUserMappings = this.userMappingMapper.selectList((Wrapper)(queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId))))) != null) {
            result.addAll(formDesignAppInfos);
        }
        try {
            DataSourceUtil.changeTempDs((String)"master");
            queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId);
            formdesignAppUserMappings = this.userMappingMapper.selectList((Wrapper)queryWrapper);
            formDesignAppInfos = this.listAppInfoByAppId(formdesignAppUserMappings);
            if (formDesignAppInfos != null) {
                result.addAll(formDesignAppInfos);
            }
            ArrayList<FormDesignAppInfo> arrayList = result;
            return arrayList;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    private List<FormDesignAppInfo> listAppInfoByAppId(List<FormdesignAppUserMapping> list) {
        if (ToolUtil.isEmpty(list)) {
            return null;
        }
        List appIds = list.stream().map(FormdesignAppUserMapping::getAppId).collect(Collectors.toList());
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().in((Object)"OBJ_ID", appIds);
        return this.conversion(this.formdesignAppInfoMapper.selectList((Wrapper)queryWrapper));
    }

    private List<FormDesignAppInfo> conversion(List<FormdesignAppInfo> list) {
        ArrayList<FormDesignAppInfo> result = new ArrayList<FormDesignAppInfo>();
        for (FormdesignAppInfo info : list) {
            FormDesignAppInfo appInfo = new FormDesignAppInfo();
            appInfo.setObjId(info.getObjId());
            appInfo.setName(info.getName());
            appInfo.setAppDescribe(info.getAppDescribe());
            appInfo.setEnglishName(info.getEnglishName());
            appInfo.setCreateTime(info.getCreateTime());
            appInfo.setTenantName(info.getTenantName());
            appInfo.setTenantId(info.getTenantId());
            result.add(appInfo);
        }
        return result;
    }
}

