/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.jxdinfo.hussar.application.model.EyImportAppmsg1dbd;
import com.jxdinfo.hussar.application.service.AppFileService;
import com.jxdinfo.hussar.application.service.AppImportCtrlService;
import com.jxdinfo.hussar.application.service.EyImportAppmsg1dbdService;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.speedcode.common.util.FileUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppImportCtrlServiceImpl
implements AppImportCtrlService {
    private Logger logger = LoggerFactory.getLogger(AppImportCtrlServiceImpl.class);
    @Autowired
    private EyImportAppmsg1dbdService eyImportAppmsg1dbdService;
    @Autowired
    private AppFileService appFileService;
    @Value(value="${cluster.importFile:0}")
    private String importFile;

    @Override
    public void doJob() {
        this.logger.info("======================+++++++++++++++++++++=========================================+++++++++++++++++++++===================");
        this.logger.info("======================+++++++++++++++++++\u5f00\u59cb\u6267\u884c\u5e94\u7528\u5bfc\u5165\u63a7\u5236\u5b9a\u65f6\u4efb\u52a1\uff01\uff01\uff01\uff01\uff01======================+++++++++=====================");
        if (this.isImportStatusExpect45Only0()) {
            this.getAndImoprtApplication();
        } else {
            this.logger.info("======================+++++++++++++++++++\u68c0\u6d4b\u5b8c\u6210\uff0c\u6ca1\u6709\u5f85\u5bfc\u5165\u7684\u5e94\u7528\uff01\uff01\uff01\uff01\uff01======================+++++++++=====================");
            this.logger.info("======================+++++++++++++++++++++=========================================+++++++++++++++++++++===================");
        }
    }

    @Override
    public void checkAppImportMsg() {
        this.eyImportAppmsg1dbdService.checkAppImportMsg();
    }

    private boolean isImportStatusExpect45Only0() {
        return this.eyImportAppmsg1dbdService.isImportStatusExpect45Only0();
    }

    private void getAndImoprtApplication() {
        EyImportAppmsg1dbd eyImportAppmsg1dbd = this.eyImportAppmsg1dbdService.getEyImportAppMsg();
        boolean flag = this.eyImportAppmsg1dbdService.setImportStatusOne(eyImportAppmsg1dbd.getId());
        if (flag) {
            try {
                boolean importEyAppFlag = this.importEyApp(eyImportAppmsg1dbd);
                if (!importEyAppFlag) {
                    this.eyImportAppmsg1dbdService.setImportStatusFive(eyImportAppmsg1dbd.getId());
                }
            }
            catch (Exception e) {
                this.eyImportAppmsg1dbdService.setFailReason(eyImportAppmsg1dbd.getId(), e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importEyApp(EyImportAppmsg1dbd eyImportAppmsg1dbd) {
        boolean flag;
        block7: {
            flag = false;
            String importFileBackUpPath = FileUtil.posixPath((String[])new String[]{this.importFile, File.separator, eyImportAppmsg1dbd.getTenantId(), File.separator, eyImportAppmsg1dbd.getAppId(), File.separator, eyImportAppmsg1dbd.getId()});
            try {
                String dsName = this.appFileService.getAppDsName(eyImportAppmsg1dbd.getTenantId());
                if (!ToolUtil.isNotEmpty((Object)dsName)) break block7;
                try {
                    DataSourceUtil.changeTempDs((String)dsName);
                    this.appFileService.importAndCompileApp(importFileBackUpPath, eyImportAppmsg1dbd.getTenantId(), eyImportAppmsg1dbd.getAppId(), eyImportAppmsg1dbd.getSql(), Arrays.asList(eyImportAppmsg1dbd.getKeys().split(",")), eyImportAppmsg1dbd.getId());
                    flag = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    DataSourceUtil.poll();
                }
            }
            catch (Exception e) {
                this.eyImportAppmsg1dbdService.setFailReason(eyImportAppmsg1dbd.getId(), e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
        return flag;
    }
}

