/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.timejob;

import com.jxdinfo.hussar.application.service.AppImportCtrlService;
import com.jxdinfo.hussar.application.timejob.AppImportCtrlJob;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.quartz.service.IJobTriggerService;
import java.util.HashMap;
import javax.annotation.Resource;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class AppImportCtrlFirstJob
implements ApplicationRunner {
    private Logger logger = LoggerFactory.getLogger(AppImportCtrlFirstJob.class);
    @Autowired
    private AppImportCtrlService appImportCtrlService;
    @Resource
    private IJobTriggerService iJobTriggerService;
    @Resource
    @Qualifier(value="Scheduler")
    private Scheduler scheduler;
    @Value(value="${spring.profiles.active}")
    private String active;

    public void run(ApplicationArguments args) throws Exception {
        if ("produce".equals(this.active)) {
            this.appImportCtrlService.checkAppImportMsg();
            this.deletePlan();
            this.addPlan();
        }
    }

    private void deletePlan() {
        try {
            this.scheduler.start();
            this.scheduler.pauseTrigger(TriggerKey.triggerKey((String)"AppImportCtrlJob", (String)"AppImportCtrlJob"));
            this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)"AppImportCtrlJob", (String)"AppImportCtrlJob"));
            this.scheduler.deleteJob(JobKey.jobKey((String)"AppImportCtrlJob", (String)"AppImportCtrlJob"));
            this.iJobTriggerService.deleteJobExtend("AppImportCtrlJob", "AppImportCtrlJob");
        }
        catch (SchedulerException e) {
            this.logger.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            e.printStackTrace();
        }
        catch (HussarException e) {
            this.logger.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            e.printStackTrace();
        }
    }

    private void addPlan() {
        try {
            this.scheduler.start();
            if (!this.scheduler.checkExists(JobKey.jobKey((String)"AppImportCtrlJob", (String)"AppImportCtrlJob")) || !this.scheduler.checkExists(TriggerKey.triggerKey((String)"AppImportCtrlJob", (String)"AppImportCtrlJob"))) {
                JobDetail jobDetail = JobBuilder.newJob(AppImportCtrlJob.class).withIdentity("AppImportCtrlJob", "AppImportCtrlJob").withDescription("\u5e94\u7528\u5bfc\u5165\u63a7\u5236\u5668").build();
                CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)"0 0/5 * * * ?");
                scheduleBuilder = scheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("AppImportCtrlJob", "AppImportCtrlJob").withDescription("\u5e94\u7528\u5bfc\u5165\u63a7\u5236\u5668").withSchedule((ScheduleBuilder)scheduleBuilder).build();
                this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("jobName", "AppImportCtrlJob");
                map.put("jobGroup", "AppImportCtrlJob");
                map.put("misfirePolicy", "1");
                this.iJobTriggerService.addJobExtend(map);
            }
        }
        catch (SchedulerException e) {
            this.logger.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            e.printStackTrace();
        }
        catch (HussarException e) {
            this.logger.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            e.printStackTrace();
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            e.printStackTrace();
        }
    }
}

