/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.application.dao.FormdesignAppFileMapper;
import com.jxdinfo.hussar.application.model.FormdesignAppFile;
import com.jxdinfo.hussar.application.service.FormdesignAppFileService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FormdesignAppFileServiceImpl
extends ServiceImpl<FormdesignAppFileMapper, FormdesignAppFile>
implements FormdesignAppFileService {
    private final FormdesignAppFileMapper appFileMapper;

    @Autowired
    public FormdesignAppFileServiceImpl(FormdesignAppFileMapper formdesignAppFileMapper) {
        this.appFileMapper = formdesignAppFileMapper;
    }

    @Override
    public String getAppFileDownloadPath(String appId, String importType) {
        String path = this.appFileMapper.getDownloadPath(appId, importType);
        if (ToolUtil.isEmpty((Object)path)) {
            return null;
        }
        return path;
    }

    @Override
    public Integer isExportingByAppId(String appId, String importType) {
        Integer num = this.appFileMapper.getExportingByAppId(appId, importType);
        if (num == null) {
            return 0;
        }
        return num;
    }

    @Override
    public List<Map<String, Object>> getExportInfo(String[] appIds) {
        ArrayList<Map<String, Object>> infoList = new ArrayList<Map<String, Object>>();
        for (String appId : appIds) {
            FormdesignAppFile formdesignAppFile;
            String[] idAndType = appId.split("_");
            if (idAndType.length == 1 || (formdesignAppFile = this.appFileMapper.getNewExportInfo(idAndType[0], idAndType[1])) == null || "0".equals(formdesignAppFile.getFileStatus())) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("appId", appId);
            map.put("appName", formdesignAppFile.getAppName());
            map.put("result", "1".equals(formdesignAppFile.getFileStatus()));
            map.put("errorMsg", formdesignAppFile.getErrorMsg());
            infoList.add(map);
        }
        return infoList;
    }

    @Override
    public List<FormdesignAppFile> getAppFileByImportType(String appId, String importType) {
        return this.appFileMapper.getAppFileByImportType(appId, importType);
    }
}

