/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.jxdinfo.hussar.application.service.IAppUsersStruServive;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class AppUsersStruServive
implements IAppUsersStruServive {
    @Resource
    JdbcTemplate jdbcTemplate;

    @Override
    @DS(value="master")
    public Map<String, String> getUserIdsByStruId(List<String> struIds) {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("ids", this.removeDuplicate(struIds));
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
        List result = jdbcTemplate.query("select EMPLOYEE_ID, USER_ID from sys_users where EMPLOYEE_ID in(:ids)", paramMap, (RowMapper)new BeanPropertyRowMapper(SysUsers.class));
        return result.stream().collect(Collectors.toMap(SysUsers::getEmployeeId, SysUsers::getUserId));
    }

    @Override
    @DS(value="master")
    public List<JSTreeModel> getEmployeeTreeById() {
        String sql = "SELECT org.ORGAN_NAME AS text, org.ORGAN_CODE AS code, str.STRU_ID AS id, str.PARENT_ID AS parent, str.ORGAN_ID AS organid,str.STRU_TYPE AS strutype, str.STRU_LEVEL AS strulevel, str.IS_EMPLOYEE AS isemployee, str.STRU_TYPE AS type, str.GLOBAL_ORDER AS globalorder,str.STRU_ORDER AS struorder, org.PARENT_TYPE_CODE AS parenttypecode FROM SYS_STRU str LEFT JOIN SYS_ORGAN org ON str.ORGAN_ID = org.ORGAN_ID WHERE str.IN_USE='1'  AND NOT EXISTS (SELECT EMPLOYEE_ID FROM SYS_USERS WHERE EMPLOYEE_ID != ' ' AND str.STRU_ID = EMPLOYEE_ID AND IS_SYS = '1') ORDER BY str.IS_EMPLOYEE, str.STRU_ORDER, str.GLOBAL_ORDER";
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(JSTreeModel.class));
    }

    private List<String> removeDuplicate(List<String> list) {
        if (!(list instanceof ArrayList)) {
            return new ArrayList<String>();
        }
        HashSet<String> h = new HashSet<String>(list);
        list.clear();
        list.addAll(h);
        return list;
    }
}

