/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.application.dao.FormdesignAppInfoMapper;
import com.jxdinfo.hussar.application.model.CodeGenerator;
import com.jxdinfo.hussar.application.model.FormdesignAppInfo;
import com.jxdinfo.hussar.application.qo.FormdesignAppInfoFormdesignappinfodataset1;
import com.jxdinfo.hussar.application.qo.FormdesignAppInfoNameid;
import com.jxdinfo.hussar.application.service.AcademyFormdesignAppInfoService;
import com.jxdinfo.hussar.application.service.FormdesignAppUserMappingService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.speedcode.common.util.AppContextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@DS(value="master")
public class AcademyFormdesignAppInfoServiceImpl
extends ServiceImpl<FormdesignAppInfoMapper, FormdesignAppInfo>
implements AcademyFormdesignAppInfoService {
    @Autowired
    private FormdesignAppInfoMapper formdesignAppInfoMapper;
    @Autowired
    private FormdesignAppUserMappingService appUserMappingService;
    @Value(value="${plugin.pluginPrefix:}")
    private String pluginPrefix;
    @Value(value="${plugin.modulePath:}")
    private String modulePath;
    @Value(value="${plugin.prefixName:}")
    private String prefixName;
    @Value(value="${plugin.appPrefixName:}")
    private String appPrefixName;
    @Value(value="${plugin.pluginParentName:}")
    private String pluginParentName;
    @Value(value="${hussar-formdesign.open-plugin:false}")
    private String openPlugin;
    @Value(value="${spring.profiles.active}")
    private String active;

    @Override
    public List<FormdesignAppInfo> hussarQuery() {
        return this.formdesignAppInfoMapper.hussarQuery();
    }

    @Override
    public List<FormdesignAppInfo> hussarQueryPage(Page page) {
        return this.formdesignAppInfoMapper.hussarQueryPage(page);
    }

    @Override
    public boolean insertOrUpdate(FormdesignAppInfo formdesignAppInfo) {
        String insertFlag = formdesignAppInfo.getObjId();
        this.saveOrUpdate((Object)formdesignAppInfo);
        if ("true".equals(this.openPlugin) && ToolUtil.isEmpty((Object)insertFlag)) {
            String environment = "";
            Integer type = LicenseInfo.getLicenseType();
            environment = "dev".equals(this.active) && type == 1 ? "1" : ("produce".equals(this.active) && type == 1 ? "3" : "2");
            if ("2".equals(environment)) {
                return this.addChildModule(formdesignAppInfo.getEnglishName(), formdesignAppInfo.getName());
            }
        }
        return true;
    }

    @Override
    public List<FormdesignAppInfo> hussarQueryformdesignAppInfoCondition_1Page(Page page, FormdesignAppInfoFormdesignappinfodataset1 formdesignAppInfoDataSet_1) {
        List<FormdesignAppInfo> appInfoList = this.formdesignAppInfoMapper.hussarQueryformdesignAppInfoCondition_1Page(page, formdesignAppInfoDataSet_1);
        if (ToolUtil.isNotEmpty(appInfoList)) {
            for (int i = 0; i < appInfoList.size(); ++i) {
                List<String> userMappingList = this.appUserMappingService.hussarQueryByAppId(appInfoList.get(i).getObjId());
                String userMemName = "";
                if (!ToolUtil.isNotEmpty(userMappingList)) continue;
                for (int j = 0; j < userMappingList.size(); ++j) {
                    userMemName = j != userMappingList.size() - 1 ? userMemName + userMappingList.get(j).toString() + "," : userMemName + userMappingList.get(j).toString();
                }
                appInfoList.get(i).setTeamMemberName(userMemName);
            }
        }
        return appInfoList;
    }

    @Override
    public boolean del(List<String> ids) {
        if (null != ids && ids.size() > 0) {
            this.removeByIds(ids);
        }
        return true;
    }

    @Override
    public FormdesignAppInfo formQuery(String id) {
        FormdesignAppInfo formdesignAppInfo = (FormdesignAppInfo)((Object)this.getById((Serializable)((Object)id)));
        return formdesignAppInfo;
    }

    @Override
    public List<FormdesignAppInfo> getOneByName(FormdesignAppInfoNameid nameid) {
        return this.formdesignAppInfoMapper.getOneByName(nameid);
    }

    @Override
    public boolean addChildModule(String applicationName, String chineseName) {
        if (this.pluginPrefix != null && this.modulePath != null) {
            String absolutePath = this.modulePath;
            int end = absolutePath.lastIndexOf(File.separator);
            if (end != absolutePath.length() - 1) {
                absolutePath = absolutePath + File.separator;
            }
            String prefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)this.prefixName) ? this.prefixName : "hussar-plugin");
            String appPrefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)this.appPrefixName) ? this.appPrefixName : "hussar-web");
            File module = new File(prefixPath);
            if (module.exists()) {
                String userCode = ShiroKit.getUser().getTenantCode();
                String tenantCode = AppContextUtil.asIdentifier((String)userCode);
                String applicationCode = AppContextUtil.asIdentifier((String)applicationName);
                String account = ShiroKit.getUser().getAccount();
                String tenantPath = prefixPath + File.separator + this.pluginPrefix + tenantCode;
                String tenAndApp = AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)applicationName);
                String applicationPath = tenantPath + File.separator + this.pluginPrefix + tenAndApp;
                File application = new File(applicationPath);
                if (!application.exists()) {
                    application.mkdirs();
                    String relativeRPath = "src.main.resources";
                    String resourcePath = appPrefixPath + File.separator + relativeRPath.replace(".", File.separator);
                    String relativeMainPath = "src.main";
                    String mainPath = applicationPath + File.separator + relativeMainPath.replace(".", File.separator);
                    String templatePath = resourcePath + File.separator + "templates";
                    String tenantCodeLow = tenantCode.toLowerCase();
                    String applicationCodeLow = applicationCode.toLowerCase();
                    String relativeConfigPath = "java.com.jxdinfo.hussar." + tenantCodeLow + "." + applicationCodeLow + ".config";
                    String configPath = mainPath + File.separator + relativeConfigPath.replace(".", File.separator);
                    String configTName = "PluginMybatisPlusConfiguration.ftl";
                    String configFName = "PluginMybatisPlusConfiguration.java";
                    String appPath = tenantCodeLow + "/" + applicationCodeLow;
                    HashMap<String, Object> configParam = new HashMap<String, Object>();
                    configParam.put("applicationPath", appPath);
                    configParam.put("tenantCode", tenantCodeLow);
                    configParam.put("applicationCode", applicationCodeLow);
                    CodeGenerator configGen = new CodeGenerator(configTName, configParam, templatePath, configPath, configFName);
                    configGen.gen();
                    String configBeanTName = "ConfigBean.ftl";
                    String configBeanFName = "ConfigBean.java";
                    HashMap<String, Object> configParams = new HashMap<String, Object>();
                    configParams.put("tenantCode", tenantCodeLow);
                    configParams.put("applicationCode", applicationCodeLow);
                    CodeGenerator configBeanGen = new CodeGenerator(configBeanTName, configParams, templatePath, configPath, configBeanFName);
                    configBeanGen.gen();
                    String relativeLogPath = "java.com.jxdinfo.hussar." + tenantCodeLow + "." + applicationCodeLow + ".log";
                    String logPath = mainPath + File.separator + relativeLogPath.replace(".", File.separator);
                    HashMap<String, Object> logParam = new HashMap<String, Object>();
                    logParam.put("tenantCode", tenantCodeLow);
                    logParam.put("applicationCode", applicationCodeLow);
                    String logAopName = "LogAop.ftl";
                    String logAopFName = "LogAop.java";
                    CodeGenerator logAopGen = new CodeGenerator(logAopName, logParam, templatePath, logPath, logAopFName);
                    logAopGen.gen();
                    String relativeParamsPath = "java.com.jxdinfo.hussar." + tenantCodeLow + "." + applicationCodeLow;
                    String paramsPath = mainPath + File.separator + relativeParamsPath.replace(".", File.separator);
                    String newAppName = applicationName;
                    Pattern p = Pattern.compile("[a-zA-z]");
                    String appFirst = applicationName.substring(0, 1);
                    if (p.matcher(appFirst).find()) {
                        newAppName = appFirst.toUpperCase() + applicationName.substring(1);
                    }
                    String tenantUp = tenantCode;
                    String tenantFist = tenantCode.substring(0, 1);
                    if (!"_".equals(tenantFist)) {
                        tenantUp = tenantFist.toUpperCase() + tenantCode.substring(1);
                    }
                    String className = tenantUp + newAppName + "ParamsPlugin";
                    String paramsTName = "ParamsPlugin.ftl";
                    String paramsFName = className + ".java";
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("className", className);
                    params.put("tenantCode", tenantCodeLow);
                    params.put("applicationCode", applicationCodeLow);
                    CodeGenerator paramsGen = new CodeGenerator(paramsTName, params, templatePath, paramsPath, paramsFName);
                    paramsGen.gen();
                    String pluginPath = mainPath + File.separator + "resources";
                    String pluginTName = "plugin.ftl";
                    String pluginFName = "plugin.properties";
                    String classPath = "com.jxdinfo.hussar." + tenantCodeLow + "." + applicationCodeLow + "." + className;
                    HashMap<String, Object> pluginParam = new HashMap<String, Object>();
                    pluginParam.put("id", tenAndApp);
                    pluginParam.put("class", classPath);
                    pluginParam.put("provider", account);
                    pluginParam.put("description", chineseName);
                    CodeGenerator pluginGen = new CodeGenerator(pluginTName, pluginParam, templatePath, pluginPath, pluginFName);
                    pluginGen.gen();
                    pluginParam.put("artifactId", this.pluginPrefix + tenAndApp);
                    pluginParam.put("pluginParentName", ToolUtil.isNotEmpty((Object)this.pluginParentName) ? this.pluginParentName : "hussar-plugin-parent");
                    String appPomTName = "appPom.ftl";
                    String appPomFName = "pom.xml";
                    CodeGenerator appPomGen = new CodeGenerator(appPomTName, pluginParam, templatePath, applicationPath, appPomFName);
                    appPomGen.gen();
                    String pomUrl = absolutePath + "hussar-plugin" + "\\" + "pom.xml";
                    String moduleName = this.pluginPrefix + tenantCode + File.separator + this.pluginPrefix + tenAndApp;
                    this.editPomXml(pomUrl, moduleName);
                }
                return true;
            }
        }
        this.log.warn("\u6587\u4ef6\u6a21\u5757\u751f\u6210\u5931\u8d25");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editPomXml(String pomUrl, String moudleName) {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(pomUrl));
            Model model = reader.read((InputStream)fis);
            List modules = model.getModules();
            modules.add(moudleName);
            model.setModules(modules);
            MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
            mavenXpp3Writer.write((Writer)new FileWriter(pomUrl), model);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void copyFolder(String oldPath, String newPath) {
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    int len;
                    FileInputStream input = new FileInputStream(temp);
                    FileOutputStream output = new FileOutputStream(newPath + File.separator + temp.getName().toString());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                }
                if (!temp.isDirectory()) continue;
                this.copyFolder(oldPath + File.separator + file[i], newPath + File.separator + file[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

