/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.runnable;

import com.jxdinfo.hussar.application.model.DequeItem;
import com.jxdinfo.hussar.application.service.AppFileService;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import java.io.IOException;
import java.util.ArrayDeque;

public class ImportRunnable
implements Runnable {
    public static ArrayDeque<DequeItem> deque = new ArrayDeque();

    @Override
    public void run() {
        this.dequeTask();
    }

    private synchronized void dequeTask() {
        AppFileService appFileService = (AppFileService)SpringUtil.getBean((String)"appFileServiceImpl");
        while (deque.peek() != null) {
            DequeItem dequeItem = deque.poll();
            this.dequeTask(appFileService, dequeItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeTask(AppFileService appFileService, DequeItem dequeItem) {
        String dsName = null;
        if (ToolUtil.isNotEmpty((Object)dequeItem.getTenantId())) {
            dsName = appFileService.getAppDsName(dequeItem.getTenantId());
        }
        if (ToolUtil.isNotEmpty(dsName)) {
            try {
                DataSourceUtil.changeTempDs((String)dsName);
                appFileService.importAndCompileApp(dequeItem.getTempPath(), dequeItem.getTenantId(), dequeItem.getAppId(), dequeItem.getSql(), dequeItem.getCoverList(), dequeItem.getCompileId());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                DataSourceUtil.poll();
            }
        }
    }
}

