/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.application.model.DequeItem;
import com.jxdinfo.hussar.application.model.EyImportAppmsg1dbd;
import com.jxdinfo.hussar.application.model.FormdesignAppInfo;
import com.jxdinfo.hussar.application.runnable.ExportRunnable;
import com.jxdinfo.hussar.application.runnable.ImportRunnable;
import com.jxdinfo.hussar.application.service.AppFileService;
import com.jxdinfo.hussar.application.service.FormdesignAppFileService;
import com.jxdinfo.hussar.application.service.FormdesignAppInfoService;
import com.jxdinfo.hussar.bsp.tenant.service.SysTenantService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.speedcode.common.pool.service.SpeedcodeThreadPoolService;
import com.jxdinfo.speedcode.common.util.AppContextUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/application/appFile"})
public class AppFileController
extends BaseController {
    private final AppFileService appFileService;
    private final SpeedcodeThreadPoolService speedcodeThreadPoolService;
    private final FormdesignAppInfoService formdesignAppInfoService;
    private final FormdesignAppFileService formdesignAppFileService;
    @Autowired
    private SysTenantService sysTenantService;

    @Autowired
    public AppFileController(AppFileService appFileService, SpeedcodeThreadPoolService speedcodeThreadPoolService, FormdesignAppInfoService formdesignAppInfoService, FormdesignAppFileService formdesignAppFileService) {
        this.appFileService = appFileService;
        this.speedcodeThreadPoolService = speedcodeThreadPoolService;
        this.formdesignAppInfoService = formdesignAppInfoService;
        this.formdesignAppFileService = formdesignAppFileService;
    }

    @PostMapping(value={"/download"})
    public void downloadFile(HttpServletResponse response) {
        String appId = super.getPara("appId") == null ? "" : super.getPara("appId");
        String importType = super.getPara("type") == null ? "" : super.getPara("type");
        this.appFileService.downloadFile(appId, importType, response);
    }

    @PostMapping(value={"/onlineExport"})
    public ApiResponse<String> onlineExport(String appId, String type, String flowPer) {
        FormdesignAppInfo appInfo = (FormdesignAppInfo)((Object)this.formdesignAppInfoService.getById((Serializable)((Object)appId)));
        if (ToolUtil.isEmpty((Object)((Object)appInfo))) {
            return ApiResponse.fail((String)"\u5bfc\u51fa\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        Integer num = this.formdesignAppFileService.isExportingByAppId(appId, type);
        if (num != 0) {
            return ApiResponse.fail((String)"\u5f53\u524d\u5e94\u7528\u6b63\u5728\u5bfc\u51fa\u4e2d");
        }
        AppContextUtil.setAppId((String)appId);
        ArrayList<String> perList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)flowPer)) {
            perList = Arrays.asList(flowPer.split(","));
        }
        this.speedcodeThreadPoolService.submit((Runnable)new ExportRunnable(appInfo, type, DataSourceUtil.currentDsName(), perList));
        return ApiResponse.success((String)"\u5e94\u7528\u5f00\u59cb\u5bfc\u51fa");
    }

    @GetMapping(value={"/getWorkFlowList"})
    public ApiResponse<List<JSTreeModel>> getWorkFlowList(String appId) {
        try {
            return ApiResponse.data(this.appFileService.getWorkFlowList(appId));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u83b7\u53d6\u5de5\u4f5c\u6d41\u4fe1\u606f\u5f02\u5e38");
        }
    }

    @PostMapping(value={"/checkExportStatus"})
    public ApiResponse<Object> checkExportStatus(@RequestBody Map<String, Object> map) {
        String ids = map.get("ids").toString();
        if (ToolUtil.isEmpty((Object)ids)) {
            return ApiResponse.fail((String)"\u5e94\u7528id\u96c6\u5408\u548c\u5bfc\u51fa\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.data(this.formdesignAppFileService.getExportInfo(ids.split(",")));
    }

    @PostMapping(value={"/importApp"})
    public ApiResponse<Object> importApp(MultipartFile file, String appId, String type) {
        FormdesignAppInfo appInfo = (FormdesignAppInfo)((Object)this.formdesignAppInfoService.getById((Serializable)((Object)appId)));
        AppContextUtil.setAppId((String)appId);
        if (ToolUtil.isEmpty((Object)((Object)appInfo))) {
            return ApiResponse.fail((String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        try {
            Map<String, Object> data = this.appFileService.importApp(file, appId, type);
            boolean flag = (Boolean)data.get("status");
            if (flag) {
                return ApiResponse.data(data);
            }
            return ApiResponse.fail((String)data.get("msg").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5e94\u7528\u5bfc\u5165\u5931\u8d25");
        }
    }

    @PostMapping(value={"/executeSql"})
    public ApiResponse<Object> executeSql(@RequestBody Map<String, Object> map) {
        String sql = map.get("sql").toString();
        String appId = map.get("appId").toString();
        if (ToolUtil.isNotEmpty((Object)sql)) {
            JSONObject jsonObject = JSONObject.parseObject((String)sql);
            try {
                if (ToolUtil.isNotEmpty((Object)jsonObject)) {
                    this.appFileService.executeSql(jsonObject, appId);
                }
                return ApiResponse.success((String)"sql\u6267\u884c\u6210\u529f");
            }
            catch (Exception e) {
                return ApiResponse.fail((String)e.getMessage());
            }
        }
        return ApiResponse.fail((String)"sql\u6267\u884c\u5931\u8d25");
    }

    @PostMapping(value={"/compileFront"})
    public ApiResponse<Object> compileFront() {
        try {
            boolean flag = this.appFileService.isCompiling();
            if (flag) {
                this.appFileService.compileFront();
                return ApiResponse.data((Object)true);
            }
            return ApiResponse.fail((String)"\u6709\u6b63\u5728\u7f16\u8bd1\u4e2d\u7684\u4efb\u52a1");
        }
        catch (IOException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"checkCompile"})
    public ApiResponse<Object> checkCompile() {
        try {
            return ApiResponse.data(this.appFileService.checkCompile());
        }
        catch (IOException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/importWorkFlow"})
    public ApiResponse<Object> importWorkFlow(@RequestBody Map<String, Object> map) {
        String workFlowPath = ToolUtil.isNotEmpty((Object)map.get("workFlowPath")) ? map.get("workFlowPath").toString() : "";
        String keys = ToolUtil.isNotEmpty((Object)map.get("keys")) ? map.get("keys").toString() : "";
        String tenantId = this.getTenantIdByCode(map);
        try {
            this.appFileService.importWorkFlowInfo(workFlowPath, tenantId, Arrays.asList(keys.split(",")));
            return ApiResponse.status((boolean)true);
        }
        catch (IOException e) {
            return ApiResponse.fail((String)"\u5de5\u4f5c\u6d41\u5bfc\u5165\u5931\u8d25");
        }
    }

    public String getTenantIdByCode(Map<String, Object> map) {
        return this.sysTenantService.getTenantIdByCode(map);
    }

    @PostMapping(value={"/importProduceApp"})
    public ApiResponse<Object> importProduceApp(MultipartFile file, String appId) {
        FormdesignAppInfo appInfo = (FormdesignAppInfo)((Object)this.formdesignAppInfoService.getById((Serializable)((Object)appId)));
        AppContextUtil.setAppId((String)appId);
        if (ToolUtil.isEmpty((Object)((Object)appInfo))) {
            return ApiResponse.fail((String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        try {
            Map<String, Object> data = this.appFileService.importProduceApp(file, appId);
            boolean flag = (Boolean)data.get("status");
            if (flag) {
                return ApiResponse.data(data);
            }
            return ApiResponse.fail((String)data.get("msg").toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5e94\u7528\u5bfc\u5165\u5931\u8d25");
        }
    }

    @PostMapping(value={"/beforeImportAndCompile"})
    public ApiResponse<Object> beforeImportAndCompile(@RequestBody Map<String, Object> map) {
        String compileId;
        boolean importMsgFlag = false;
        String tempPath = ToolUtil.isNotEmpty((Object)map.get("tempPath")) ? map.get("tempPath").toString() : "";
        String appId = ToolUtil.isNotEmpty((Object)map.get("appId")) ? map.get("appId").toString() : "";
        String appName = ToolUtil.isNotEmpty((Object)map.get("appName")) ? map.get("appName").toString() : "";
        String sql = ToolUtil.isNotEmpty((Object)map.get("sql")) ? map.get("sql").toString() : "";
        String keys = ToolUtil.isNotEmpty((Object)map.get("keys")) ? map.get("keys").toString() : "";
        String tenantId = ToolUtil.isNotEmpty((Object)map.get("tenantId")) ? map.get("tenantId").toString() : "";
        boolean saveTempPathFileFlag = this.appFileService.saveTempPathFile(appId, tenantId, tempPath, compileId = this.appFileService.addWaitingCompileTask(appId));
        if (saveTempPathFileFlag) {
            File temp = new File(tempPath);
            if (ToolUtil.isNotEmpty((Object)temp) && temp.exists()) {
                try {
                    FileUtils.forceDelete((File)temp);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            EyImportAppmsg1dbd appImportMsg = new EyImportAppmsg1dbd();
            appImportMsg.setId(compileId);
            appImportMsg.setAppId(appId);
            appImportMsg.setImportAppName(appName);
            appImportMsg.setSql(sql);
            appImportMsg.setKeys(keys);
            appImportMsg.setTenantId(tenantId);
            appImportMsg.setImportStartTime(new Date());
            appImportMsg.setImportStatus("0");
            appImportMsg.setLoadFlag("0");
            appImportMsg.setImportUserId(ShiroKit.getUser().getId());
            appImportMsg.setImportUserName(ShiroKit.getUser().getName());
            importMsgFlag = this.appFileService.saveImportMsgToTable(appImportMsg);
        }
        return ApiResponse.status((boolean)importMsgFlag);
    }

    @PostMapping(value={"/importAndCompile"})
    public ApiResponse<Object> importAndCompile(@RequestBody Map<String, Object> map) {
        String tempPath = ToolUtil.isNotEmpty((Object)map.get("tempPath")) ? map.get("tempPath").toString() : "";
        String appId = ToolUtil.isNotEmpty((Object)map.get("appId")) ? map.get("appId").toString() : "";
        String sql = ToolUtil.isNotEmpty((Object)map.get("sql")) ? map.get("sql").toString() : "";
        String keys = ToolUtil.isNotEmpty((Object)map.get("keys")) ? map.get("keys").toString() : "";
        String tenantId = ToolUtil.isNotEmpty((Object)map.get("tenantId")) ? map.get("tenantId").toString() : "";
        String compileId = this.appFileService.addWaitingCompileTask(appId);
        DequeItem dequeItem = new DequeItem(tempPath, appId, sql, Arrays.asList(keys.split(",")), tenantId, compileId);
        this.importAndCompileTask(dequeItem);
        return ApiResponse.status((boolean)true);
    }

    private synchronized void importAndCompileTask(DequeItem dequeItem) {
        if (ImportRunnable.deque.peek() == null) {
            ImportRunnable.deque.push(dequeItem);
            this.speedcodeThreadPoolService.submit((Runnable)new ImportRunnable());
        } else {
            ImportRunnable.deque.addLast(dequeItem);
        }
    }

    @RequestMapping(value={"/compileList"})
    public ApiResponse<Object> compileList(@RequestBody Map<String, Object> body) {
        String page = body.get("current") == null ? null : body.get("current").toString();
        String limit = body.get("size") == null ? null : body.get("size").toString();
        Object result = this.appFileService.getCompileList(page, limit, body);
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(value={"/queueMsgList"})
    public ApiResponse<Object> getQueueMsgList() {
        Object result = this.appFileService.getQueueMsgList();
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(value={"/getExportState"})
    public ApiResponse<Object> getExportState(@RequestParam(value="appId") String appId) {
        return ApiResponse.data(this.appFileService.getExportState(appId));
    }

    @PostMapping(value={"/synchronousImport"})
    public ApiResponse<Object> synchronousImport(String shareJarName, String appEnglisName, String tenantId, String compileId) {
        Map<String, Object> map = this.appFileService.synchronousImport(shareJarName, appEnglisName, tenantId, compileId);
        if ("true".equals(String.valueOf(map.get("success")))) {
            return ApiResponse.success((String)String.valueOf(map.get("msg")));
        }
        return ApiResponse.fail((String)String.valueOf(map.get("msg")));
    }

    @GetMapping(value={"/checkExportFile"})
    public Boolean checkExportFile(String tempPath) {
        boolean flag = false;
        if (tempPath == null) {
            return flag;
        }
        File file = new File(tempPath);
        if (file.exists()) {
            flag = true;
        }
        return flag;
    }

    @PostMapping(value={"/downloadOffline"})
    public void downloadOffline(HttpServletResponse response) {
        String tempPath = super.getPara("tempPath") == null ? "" : super.getPara("tempPath");
        String filePath = super.getPara("filePath") == null ? "" : super.getPara("filePath");
        this.appFileService.downloadOffline(tempPath, filePath, response);
    }
}

