/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.util;

import com.jxdinfo.hussar.application.properties.MavenProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class MavenUtil {
    private static MavenProperties mavenProperties = (MavenProperties)SpringContextHolder.getBean(MavenProperties.class);

    public static void modulePackage(File pom) throws MavenInvocationException {
        String mavenHome = mavenProperties.getHome();
        String userSettingFile = mavenProperties.getUserSettingFile();
        String localRepository = mavenProperties.getLocalRepository();
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setLocalRepositoryDirectory(new File(localRepository));
        request.setUserSettingsFile(new File(userSettingFile));
        request.setPomFile(pom);
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("clean");
        goals.add("package");
        request.setGoals(goals);
        request.setMavenOpts(" -DskipTests=true -Dfile.encoding=UTF-8");
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(mavenHome));
        final StringBuilder sb = new StringBuilder();
        InvocationOutputHandler invocationOutputHandler = new InvocationOutputHandler(){

            public void consumeLine(String s) throws IOException {
                System.out.println(s);
                sb.append(s).append("\n");
            }
        };
        invoker.setOutputHandler(invocationOutputHandler);
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new MavenInvocationException(sb.toString());
            }
        }
        catch (MavenInvocationException e) {
            throw new MavenInvocationException(e.getMessage());
        }
    }
}

