/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.util;

import com.jxdinfo.engine.compile.util.classloader.ClassLoaderUtil;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.speedcode.common.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class CompileUtil {
    private int num = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(String filePath, String targetPath, String targetDir) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new IOException("file doesn't exist,path:" + filePath);
        }
        File target = new File(targetPath);
        if (!target.exists()) {
            target.mkdirs();
        }
        ArrayList<File> compileList = new ArrayList<File>();
        try {
            CompileUtil.getCompileFile(compileList, file);
            this.compileJava(compileList, targetPath);
        }
        catch (Throwable throwable) {
            File appTarget = new File(FileUtil.posixPath((String[])new String[]{ClassLoaderUtil.getClassdoptions(), targetDir}));
            if (appTarget.exists()) {
                FileUtils.forceDelete((File)appTarget);
            }
            throw throwable;
        }
        File appTarget = new File(FileUtil.posixPath((String[])new String[]{ClassLoaderUtil.getClassdoptions(), targetDir}));
        if (appTarget.exists()) {
            FileUtils.forceDelete((File)appTarget);
        }
    }

    private static void getCompileFile(List<File> compileList, File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                if (f.isDirectory()) {
                    CompileUtil.getCompileFile(compileList, f);
                    continue;
                }
                if (!f.getName().endsWith(".java")) continue;
                compileList.add(f);
            }
        } else if (file.getName().endsWith(".java")) {
            compileList.add(file);
        }
    }

    private void compileJava(List<File> compileList, String targetPath) throws IOException {
        ArrayList<File> compileFailList = new ArrayList<File>();
        HashMap<String, String> msgMap = new HashMap<String, String>();
        for (File compile : compileList) {
            File file = new File(compile.getAbsolutePath());
            String filePath = compile.getAbsolutePath().replace(targetPath, "").substring(1);
            String name = filePath.replace(File.separator, ".").replace(".java", "");
            msgMap.put(name, filePath);
            String javaCode = CompileUtil.loadClassCode(file);
            try {
                Map map = ClassLoaderUtil.compileJavaCode((String)name, (String)javaCode, (boolean)true);
                if ("1".equals(map.get("result"))) {
                    try {
                        Class.forName(name);
                        String classPath = filePath.replace(".java", ".class");
                        String path = ClassLoaderUtil.getClassdoptions() + classPath;
                        File classFile = new File(path);
                        msgMap.remove(name, filePath);
                        FileUtils.copyFile((File)classFile, (File)new File(targetPath, classPath));
                        FileUtils.forceDelete((File)compile);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("\u7c7b\u52a0\u8f7d\u5931\u8d25");
                    }
                }
                compileFailList.add(compile);
            }
            catch (EngineException e) {
                e.printStackTrace();
            }
        }
        if (ToolUtil.isNotEmpty(compileFailList) && this.num < 10) {
            ++this.num;
            this.compileJava(compileFailList, targetPath);
        }
        if (this.num == 10 && ToolUtil.isNotEmpty(msgMap)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String s : msgMap.keySet()) {
                String clazz = (String)msgMap.get(s);
                stringBuffer.append(clazz).append(";");
            }
            throw new IOException(stringBuffer.toString() + "\u7f16\u8bd1\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u6709\u65e0\u95ee\u9898");
        }
    }

    private static String loadClassCode(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (String)"UTF-8");
    }
}

