/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.alibaba.druid.pool.ha.PropertiesUtils;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.AddTableResult;
import com.jxdinfo.engine.metadata.model.GenerateSqlResult;
import com.jxdinfo.engine.metadata.model.ModifyTableResult;
import com.jxdinfo.engine.metadata.model.TableStructure;
import com.jxdinfo.engine.metadata.service.ExportTableStructureService;
import com.jxdinfo.hussar.application.model.CodeGenerator;
import com.jxdinfo.hussar.application.model.FormdesignAppFile;
import com.jxdinfo.hussar.application.model.FormdesignAppInfo;
import com.jxdinfo.hussar.application.model.FormdesignAppPackage;
import com.jxdinfo.hussar.application.properties.ProduceProperties;
import com.jxdinfo.hussar.application.service.AppFileService;
import com.jxdinfo.hussar.application.service.FormdesignAppFileService;
import com.jxdinfo.hussar.application.service.FormdesignAppInfoService;
import com.jxdinfo.hussar.application.service.FormdesignAppPackageService;
import com.jxdinfo.hussar.application.util.CompileUtil;
import com.jxdinfo.hussar.application.util.MavenUtil;
import com.jxdinfo.hussar.application.util.TarUtil;
import com.jxdinfo.hussar.bpm.model.service.SysBpmService;
import com.jxdinfo.hussar.common.exception.DataSourceException;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.plugin.integration.operator.PluginOperator;
import com.jxdinfo.hussar.support.plugin.integration.operator.module.PluginInfo;
import com.jxdinfo.hussar.support.plugin.utils.GlobalRegistryInfo;
import com.jxdinfo.hussar.support.plugin.utils.PluginOperatorInfo;
import com.jxdinfo.speedcode.codegenerator.core.publish.model.ResultVO;
import com.jxdinfo.speedcode.codegenerator.core.publish.service.ExportService;
import com.jxdinfo.speedcode.codegenerator.core.publish.service.PublishService;
import com.jxdinfo.speedcode.codegenerator.core.publish.util.RestTemplateHttpUtil;
import com.jxdinfo.speedcode.common.constant.ExportResourceConstant;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.file.StorageDumpLoadService;
import com.jxdinfo.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.common.util.AppContextUtil;
import com.jxdinfo.speedcode.common.util.FileUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.datasource.FormDesignDataSource;
import com.jxdinfo.speedcode.datasource.IDataSource;
import com.jxdinfo.speedcode.external.base.params.ExportApplicationSource;
import com.jxdinfo.speedcode.external.base.params.ImportApplicationSource;
import com.jxdinfo.speedcode.external.base.params.ProjectCodeArgs;
import com.jxdinfo.speedcode.external.base.params.ProjectStoreArgs;
import com.jxdinfo.speedcode.external.base.params.ProjectWorkflowArgs;
import com.jxdinfo.speedcode.external.base.service.BaseExternalService;
import com.jxdinfo.speedcode.file.fileoperate.util.ZipUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.pf4j.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AppFileServiceImpl
implements AppFileService {
    private static Logger logger = LoggerFactory.getLogger(AppFileServiceImpl.class);
    @Value(value="${plugin.pluginPrefix}")
    private String pluginPrefix;
    @Value(value="${plugin.modulePath}")
    private String modulePath;
    @Value(value="${hussar-formdesign.open-plugin:false}")
    private boolean openPlugin;
    @Value(value="${plugin.pluginPath}")
    private String pluginPath;
    private static Pattern p = Pattern.compile("[a-zA-z]");
    private final StorageDumpLoadService storageDumpLoadService;
    private final HussarProperties hussarProperties;
    private final FormdesignAppFileService formdesignAppFileService;
    private final FormdesignAppInfoService formdesignAppInfoService;
    private final IDataSource dataSourceService;
    private final ExportService exportService;
    private final PublishService publishService;
    private final SysBpmService sysBpmService;
    private final ExportTableStructureService exportTableStructureService;
    private final SpeedCodeProperties speedCodeProperties;
    private final ProduceProperties produceProperties;
    private final FormdesignAppPackageService appPackageService;
    private final BaseExternalService baseExternalService;
    private PluginOperator pluginOperator;

    @Autowired
    public AppFileServiceImpl(StorageDumpLoadService storageDumpLoadService, HussarProperties hussarProperties, FormdesignAppFileService formdesignAppFileService, FormdesignAppInfoService formdesignAppInfoService, IDataSource dataSourceService, ExportService exportService, PublishService publishService, SysBpmService sysBpmService, ExportTableStructureService exportTableStructureService, SpeedCodeProperties speedCodeProperties, ProduceProperties produceProperties, FormdesignAppPackageService appPackageService, BaseExternalService baseExternalService, PluginOperator pluginOperator) {
        this.storageDumpLoadService = storageDumpLoadService;
        this.hussarProperties = hussarProperties;
        this.formdesignAppFileService = formdesignAppFileService;
        this.formdesignAppInfoService = formdesignAppInfoService;
        this.dataSourceService = dataSourceService;
        this.exportService = exportService;
        this.publishService = publishService;
        this.sysBpmService = sysBpmService;
        this.exportTableStructureService = exportTableStructureService;
        this.speedCodeProperties = speedCodeProperties;
        this.produceProperties = produceProperties;
        this.appPackageService = appPackageService;
        this.baseExternalService = baseExternalService;
        this.pluginOperator = pluginOperator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onlineExport(FormdesignAppInfo appInfo, String type) {
        File file = null;
        FormdesignAppFile formdesignAppFile = new FormdesignAppFile();
        try {
            List tableInfoList;
            String appId = appInfo.getObjId();
            file = Files.createTempDirectory("appExport" + appId, new FileAttribute[0]).toFile();
            HashMap<String, String> metaMap = new HashMap<String, String>();
            ShiroUser user = ShiroKit.getUser();
            String exportPath = this.getExportPath(appId);
            String environmentPath = "0".equals(type) ? "offline" : "production";
            String zipPath = exportPath + File.separator + environmentPath + File.separator + appInfo.getTenantId() + "_" + appInfo.getEnglishName() + "_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMddHHmmss") + ExportResourceConstant._HUSSAR;
            File zip = new File(zipPath);
            File zipParent = zip.getParentFile();
            if (!zipParent.exists()) {
                zipParent.mkdirs();
            }
            metaMap.put("tenantId", appInfo.getTenantId());
            metaMap.put("appName", appInfo.getEnglishName());
            metaMap.put("importType", type);
            formdesignAppFile.setCreateTime(new Date());
            formdesignAppFile.setAppId(appId);
            formdesignAppFile.setAppName(appInfo.getEnglishName());
            formdesignAppFile.setImportType(type);
            formdesignAppFile.setDownloadPath(zipPath);
            formdesignAppFile.setFileStatus("0");
            formdesignAppFile.setCreatorId(user.getId());
            this.formdesignAppFileService.save((Object)formdesignAppFile);
            File axe = new File(file.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE);
            this.storageDumpLoadService.dump(appId, axe);
            SpeedCodeResponse response = this.publishService.vueBatch(appId);
            int code = response.getErrorCode();
            if (code == 500) {
                throw new LcdpException(LcdpExceptionEnum.ERROR, "\u53d1\u5e03\u5931\u8d25");
            }
            this.exportCode(file, type, appInfo.getEnglishName(), appInfo.getTenantId());
            List keyList = this.exportService.getWorkflowKeys(appId);
            if (ToolUtil.isNotEmpty((Object)keyList)) {
                this.exportWorkflow(keyList, appInfo.getTenantId(), file);
            }
            if (ToolUtil.isNotEmpty((Object)(tableInfoList = this.exportService.getTableInfo(appId)))) {
                this.exportData(tableInfoList, appInfo.getTenantId(), file);
            }
            File[] files = file.listFiles();
            ArrayList<String> tarList = new ArrayList<String>();
            for (File f : files) {
                String path = f.getAbsolutePath();
                tarList.add(path);
            }
            String tarPath = file.getAbsolutePath() + File.separator + appInfo.getEnglishName() + ExportResourceConstant._TAR;
            TarUtil.execute(tarList, tarPath);
            File tar = new File(tarPath);
            String md5 = ZipUtil.getMd5((String)tar.getAbsolutePath());
            metaMap.put("sign", md5);
            byte[] meta = SerializeUtils.serialize(metaMap);
            String metaPath = file.getAbsolutePath() + File.separator + ExportResourceConstant.META_JSON;
            FileUtils.writeByteArrayToFile((File)new File(metaPath), (byte[])meta);
            ArrayList<String> zipList = new ArrayList<String>();
            zipList.add(tarPath);
            zipList.add(metaPath);
            com.jxdinfo.hussar.application.util.ZipUtil.zip(zipList, zipPath);
            formdesignAppFile.setFileStatus("1");
            this.formdesignAppFileService.updateById((Object)formdesignAppFile);
        }
        catch (Exception e) {
            if (formdesignAppFile.getId() != null) {
                formdesignAppFile.setFileStatus("2");
                if (e instanceof LcdpException) {
                    formdesignAppFile.setErrorMsg("\u9875\u9762\u81ea\u52a8\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u5148\u53d1\u5e03\u9875\u9762");
                } else if (e instanceof IOException) {
                    formdesignAppFile.setErrorMsg("\u5bfc\u51fa\u5305\u751f\u6210\u5931\u8d25");
                }
                this.formdesignAppFileService.updateById((Object)formdesignAppFile);
            }
            e.printStackTrace();
        }
        finally {
            String speedCodePath;
            File speedFile;
            if (file != null && file.exists()) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((speedFile = new File(speedCodePath = this.speedCodeProperties.getWorkspace() + ExportResourceConstant.PUBLISH_CACHE)).exists()) {
                try {
                    FileUtils.forceDelete((File)speedFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public Map<String, Object> importApp(MultipartFile multipartFile, String appId, String type) throws Exception {
        Map<String, Object> returnMap;
        File temp;
        block11: {
            Map<String, Object> map;
            Map metaMap;
            block10: {
                File metaFile;
                block9: {
                    temp = null;
                    returnMap = new HashMap<String, Object>();
                    InputStream inputStream = multipartFile.getInputStream();
                    temp = Files.createTempDirectory("appImport" + appId, new FileAttribute[0]).toFile();
                    File tempFile = new File(temp.getAbsolutePath() + File.separator + appId + ".zip");
                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
                    com.jxdinfo.hussar.application.util.ZipUtil.unzip(tempFile.getAbsolutePath(), temp.getAbsolutePath() + File.separator);
                    metaFile = new File(temp + File.separator + ExportResourceConstant.META_JSON);
                    if (metaFile.exists()) break block9;
                    returnMap.put("status", false);
                    returnMap.put("msg", "\u521d\u59cb\u5316\u5305\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u5b58\u5728meta.json\u6587\u4ef6");
                    HashMap<String, Object> hashMap = returnMap;
                    this.deleteTempFileWithoutWorkFlow(temp);
                    return hashMap;
                }
                byte[] meta = FileUtils.readFileToByteArray((File)metaFile);
                metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
                if (metaMap != null) break block10;
                returnMap.put("status", false);
                returnMap.put("msg", "meta.json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                HashMap<String, Object> hashMap = returnMap;
                this.deleteTempFileWithoutWorkFlow(temp);
                return hashMap;
            }
            try {
                String importType;
                String string = importType = metaMap.get("importType") == null ? "" : metaMap.get("importType").toString();
                if ("0".equals(importType)) {
                    returnMap = this.initAppFromOnline(appId, type, metaMap, importType, temp, returnMap);
                    break block11;
                }
                if ("2".equals(importType)) {
                    returnMap = this.initAppFromOffline(appId, temp, metaMap, returnMap);
                    break block11;
                }
                returnMap.put("status", false);
                returnMap.put("msg", "\u521d\u59cb\u5316\u5305\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u5f53\u524d\u73af\u5883\u9700\u8981\u7684\u5305\uff01");
                map = returnMap;
            }
            catch (Exception e) {
                try {
                    if (ToolUtil.isNotEmpty(temp) && temp.exists()) {
                        FileUtils.forceDelete((File)temp);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    this.deleteTempFileWithoutWorkFlow(temp);
                    throw throwable;
                }
            }
            this.deleteTempFileWithoutWorkFlow(temp);
            return map;
        }
        this.deleteTempFileWithoutWorkFlow(temp);
        return returnMap;
    }

    private Map<String, Object> initAppFromOnline(String appId, String type, Map<String, Object> metaMap, String importType, File temp, Map<String, Object> returnMap) throws Exception {
        String appName = metaMap.get("appName") == null ? "" : metaMap.get("appName").toString();
        String tenantId = metaMap.get("tenantId") == null ? "" : metaMap.get("tenantId").toString();
        String sign = metaMap.get("sign") == null ? "" : metaMap.get("sign").toString();
        FormdesignAppInfo appInfo = (FormdesignAppInfo)((Object)this.formdesignAppInfoService.getById((Serializable)((Object)appId)));
        if (!type.equals(importType)) {
            returnMap.put("status", false);
            returnMap.put("msg", "\u521d\u59cb\u5316\u5305\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u5f53\u524d\u73af\u5883\u9700\u8981\u7684\u5305\uff01");
            return returnMap;
        }
        if (!appInfo.getTenantId().equals(tenantId)) {
            returnMap.put("status", false);
            returnMap.put("msg", "\u5e94\u7528\u79df\u6237ID\u4e0e\u521d\u59cb\u5316\u5305\u7684\u79df\u6237ID\u4e0d\u4e00\u81f4\uff01");
            return returnMap;
        }
        if (!appInfo.getEnglishName().equals(appName)) {
            returnMap.put("status", false);
            returnMap.put("msg", "\u5e94\u7528\u540d\u79f0\u4e0e\u521d\u59cb\u5316\u5305\u7684\u5e94\u7528\u540d\u79f0\u4e0d\u4e00\u81f4\uff01");
            return returnMap;
        }
        File tar = new File(temp + File.separator + appName + ".tar");
        String md5 = ZipUtil.getMd5((String)tar.getAbsolutePath());
        if (!md5.equals(sign)) {
            returnMap.put("status", false);
            returnMap.put("msg", "\u521d\u59cb\u5316\u5305\u5df2\u88ab\u4fee\u6539\uff01");
            return returnMap;
        }
        TarUtil.unTar(tar, temp.getAbsolutePath() + File.separator);
        File axe = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE);
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        replaceMap.put("filePath", axe.getAbsolutePath());
        replaceMap.put("appId", appId);
        this.exportService.replaceDataSourceType(replaceMap);
        this.storageDumpLoadService.load(appId, axe);
        Map<String, Object> workFlowResult = this.importWorkFlow(temp, tenantId);
        this.importCode(temp, appName, tenantId, true);
        returnMap = this.importData(temp, tenantId);
        returnMap.put("status", true);
        returnMap.put("workFlowInfos", workFlowResult.get("workFlowInfos"));
        returnMap.put("workFlowPath", workFlowResult.get("workFlowPath"));
        returnMap.put("tenantId", workFlowResult.get("tenantId"));
        this.publishService.resourceBatch(appId);
        appInfo.setIsInit("1");
        this.formdesignAppInfoService.updateById((Object)appInfo);
        return returnMap;
    }

    private Map<String, Object> initAppFromOffline(String appId, File temp, Map<String, Object> metaMap, Map<String, Object> returnMap) throws Exception {
        String appName = metaMap.get("appName") == null ? "" : metaMap.get("appName").toString();
        String tenantId = metaMap.get("tenantId") == null ? "" : metaMap.get("tenantId").toString();
        String javaPath = metaMap.get("javaPath") == null ? "" : metaMap.get("javaPath").toString();
        String sign = metaMap.get("sign") == null ? "" : metaMap.get("sign").toString();
        String dsName = metaMap.get("ds") == null ? "" : metaMap.get("ds").toString();
        FormdesignAppInfo appInfo = (FormdesignAppInfo)((Object)this.formdesignAppInfoService.getById((Serializable)((Object)appId)));
        File tar = new File(temp + File.separator + appName + ".tar");
        String md5 = ZipUtil.getMd5((String)tar.getAbsolutePath());
        if (!md5.equals(sign)) {
            returnMap.put("status", false);
            returnMap.put("msg", "\u521d\u59cb\u5316\u5305\u5df2\u88ab\u4fee\u6539\uff01");
            return returnMap;
        }
        TarUtil.unTar(tar, temp.getAbsolutePath() + File.separator);
        File axe = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE);
        ExportApplicationSource exportApplicationSource = this.getExportApplicationSource(appName, tenantId, javaPath, dsName);
        ImportApplicationSource importApplicationSource = this.getImportApplicationSource(appInfo.getEnglishName(), appInfo.getTenantId());
        HashMap<String, Object> storeReserveMap = new HashMap<String, Object>();
        storeReserveMap.put("appId", appId);
        ProjectStoreArgs projectStoreArgs = this.getProjectStoreArgs(exportApplicationSource, importApplicationSource, axe, storeReserveMap);
        this.baseExternalService.handlerProjectStore(projectStoreArgs);
        this.storageDumpLoadService.load(appId, axe);
        File workflowDir = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.WORKFLOW);
        ProjectWorkflowArgs projectWorkflowArgs = this.getProjectWorkflowArgs(exportApplicationSource, importApplicationSource, workflowDir, null);
        this.baseExternalService.handlerWorkflow(projectWorkflowArgs);
        Map<String, Object> workFlowResult = this.importWorkFlow(temp, ShiroKit.getUser().getTenantCode());
        ProjectCodeArgs projectCodeArgs = this.getProjectCodeArgs(exportApplicationSource, importApplicationSource, temp, null);
        this.baseExternalService.handlerProjectCode(projectCodeArgs);
        returnMap = this.importData(temp, tenantId);
        returnMap.put("status", true);
        returnMap.put("workFlowInfos", workFlowResult.get("workFlowInfos"));
        returnMap.put("workFlowPath", workFlowResult.get("workFlowPath"));
        returnMap.put("tenantId", workFlowResult.get("tenantId"));
        this.publishService.resourceBatch(appId);
        appInfo.setIsInit("1");
        this.formdesignAppInfoService.updateById((Object)appInfo);
        return returnMap;
    }

    private ExportApplicationSource getExportApplicationSource(String appName, String tenantId, String javaPath, String dsName) {
        ExportApplicationSource exportApplicationSource = new ExportApplicationSource();
        exportApplicationSource.setAppName(appName);
        exportApplicationSource.setTenantId(tenantId);
        exportApplicationSource.setJavaPath(javaPath);
        exportApplicationSource.setDsName(dsName);
        return exportApplicationSource;
    }

    private ImportApplicationSource getImportApplicationSource(String appName, String tenantId) {
        ImportApplicationSource importApplicationSource = new ImportApplicationSource();
        importApplicationSource.setAppName(appName);
        importApplicationSource.setTenantId(tenantId);
        importApplicationSource.setJavaPath(this.speedCodeProperties.getJavaPath());
        importApplicationSource.setDsName(this.getAppDsName(tenantId));
        return importApplicationSource;
    }

    private ProjectStoreArgs getProjectStoreArgs(ExportApplicationSource exportApplicationSource, ImportApplicationSource importApplicationSource, File axe, Map<String, Object> reserveMap) {
        ProjectStoreArgs projectStoreArgs = new ProjectStoreArgs();
        projectStoreArgs.setAxeDir(axe);
        projectStoreArgs.setExportApplicationSource(exportApplicationSource);
        projectStoreArgs.setImportApplicationSource(importApplicationSource);
        projectStoreArgs.setReserveMap(reserveMap);
        return projectStoreArgs;
    }

    private ProjectCodeArgs getProjectCodeArgs(ExportApplicationSource exportApplicationSource, ImportApplicationSource importApplicationSource, File zipDir, Map<String, Object> reserveMap) {
        ProjectCodeArgs projectCodeArgs = new ProjectCodeArgs();
        projectCodeArgs.setZipDir(zipDir);
        projectCodeArgs.setExportApplicationSource(exportApplicationSource);
        projectCodeArgs.setImportApplicationSource(importApplicationSource);
        projectCodeArgs.setReserveMap(reserveMap);
        return projectCodeArgs;
    }

    private ProjectWorkflowArgs getProjectWorkflowArgs(ExportApplicationSource exportApplicationSource, ImportApplicationSource importApplicationSource, File workflowDir, Map<String, Object> reserveMap) {
        ProjectWorkflowArgs projectWorkflowArgs = new ProjectWorkflowArgs();
        projectWorkflowArgs.setWorkflowDir(workflowDir);
        projectWorkflowArgs.setExportApplicationSource(exportApplicationSource);
        projectWorkflowArgs.setImportApplicationSource(importApplicationSource);
        projectWorkflowArgs.setReserveMap(reserveMap);
        return projectWorkflowArgs;
    }

    private void deleteTempFileWithoutWorkFlow(File temp) throws IOException {
        File[] childFiles;
        if (ToolUtil.isNotEmpty((Object)temp) && temp.exists() && ToolUtil.isNotEmpty((Object)(childFiles = temp.listFiles()))) {
            File workflow = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.WORKFLOW);
            for (File file : childFiles) {
                if (workflow.getAbsolutePath().equals(file.getAbsolutePath())) continue;
                FileUtils.forceDelete((File)file);
            }
        }
    }

    @Override
    public void downloadFile(String appId, String importType, HttpServletResponse response) {
        String path = this.formdesignAppFileService.getAppFileDownloadPath(appId, importType);
        if (path == null) {
            response.setContentType("no export");
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            response.setContentType("no file");
            return;
        }
        try {
            String newFileName = URLEncoder.encode(file.getName(), "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + newFileName);
            response.setContentType("multipart/form-data");
            try (BufferedInputStream bism = new BufferedInputStream(new FileInputStream(file), 10240);
                 BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                int len = 0;
                int i = bism.available();
                byte[] buff = new byte[i];
                while ((len = bism.read(buff)) > 0) {
                    bos.write(buff, 0, len);
                    bos.flush();
                }
            }
        }
        catch (IOException e) {
            logger.error("\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath={}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }

    @Override
    public void executeSql(JSONObject jsonObject, String appId) throws EngineException, IOException, LcdpException {
        for (String dataSourceName : jsonObject.keySet()) {
            String sql = jsonObject.getString(dataSourceName);
            if (!ToolUtil.isNotEmpty((Object)sql)) continue;
            this.exportTableStructureService.excuteSql(sql, dataSourceName);
        }
        this.exportService.addBatchModelToLr(appId);
    }

    @Override
    public void compileFront() throws IOException {
        String staticPath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getStaticPath()});
        String distPath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getWebPath(), "dist"});
        File staticDir = new File(staticPath);
        FileUtils.forceMkdir((File)staticDir);
        File distDir = new File(distPath);
        FileUtils.forceMkdir((File)distDir);
        FileUtils.copyDirectory((File)staticDir, (File)distDir);
        FormdesignAppPackage formdesignAppPackage = new FormdesignAppPackage();
        formdesignAppPackage.setStatus("0");
        formdesignAppPackage.setCreateTime(new Date());
        formdesignAppPackage.setCreatorId(ShiroKit.getUser().getId());
        this.appPackageService.save((Object)formdesignAppPackage);
        String url = this.produceProperties.getPackagePath() + "compile";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("compileId", formdesignAppPackage.getId());
        RestTemplateHttpUtil.sendPostRequest((String)url, params);
    }

    @Override
    public Map<String, Object> checkCompile() throws IOException {
        List<FormdesignAppPackage> formdesignAppPackageList = this.appPackageService.getCompileTask();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty(formdesignAppPackageList)) {
            FormdesignAppPackage formdesignAppPackage = formdesignAppPackageList.get(0);
            String url = this.produceProperties.getPackagePath() + "compilingCheck";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("compileId", formdesignAppPackage.getId());
            ResultVO resultVO = RestTemplateHttpUtil.sendPostRequest((String)url, params);
            Map data = (Map)resultVO.getData();
            Boolean finished = (Boolean)data.get("finished");
            if (finished.booleanValue()) {
                map.put("success", resultVO.isSucceed());
                if (resultVO.isSucceed()) {
                    formdesignAppPackage.setStatus("1");
                } else {
                    formdesignAppPackage.setStatus("2");
                    formdesignAppPackage.setErrorMsg(data.get("msg").toString());
                    map.put("msg", data.get("msg"));
                    String staticPath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getStaticPath()});
                    String distPath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getWebPath(), "dist"});
                    File staticFile = new File(staticPath);
                    if (staticFile.exists()) {
                        FileUtils.forceDelete((File)staticFile);
                    }
                    FileUtils.copyDirectory((File)new File(distPath), (File)new File(staticPath));
                }
                this.appPackageService.updateById((Object)formdesignAppPackage);
            } else {
                map.put("success", false);
            }
        } else {
            map.put("success", false);
        }
        return map;
    }

    @Override
    public boolean isCompiling() {
        List<FormdesignAppPackage> formdesignAppPackageList = this.appPackageService.getCompileTask();
        return !ToolUtil.isNotEmpty(formdesignAppPackageList) || !"0".equals(formdesignAppPackageList.get(0).getStatus());
    }

    private String getExportPath(String appId) {
        String uploadPath = FileUtil.posixPath((String[])new String[]{this.hussarProperties.getFileUploadPath(), "appExport", appId});
        File loadPath = new File(uploadPath);
        if (!loadPath.exists()) {
            loadPath.mkdirs();
        }
        return uploadPath;
    }

    @Override
    public String getAppDsName(String tenantId) {
        return Optional.ofNullable(tenantId).flatMap(tenantCode -> Optional.ofNullable(this.dataSourceService.getDefaultByTenantCode(tenantCode)).map(FormDesignDataSource::getDbName)).orElse(null);
    }

    private void exportWorkflow(List<String> keyList, String tenantId, File path) throws IOException {
        byte[] meta;
        List actFormAuthList;
        List assigneeList;
        StringBuffer key = new StringBuffer();
        for (String k : keyList) {
            key.append(k).append(",");
        }
        File workflow = new File(path.getAbsolutePath() + File.separator + ExportResourceConstant.WORKFLOW);
        FileUtils.forceMkdir((File)workflow);
        String appNameDs = this.getAppDsName(tenantId);
        if (appNameDs != null) {
            try {
                DataSourceUtil.changeTempDs((String)appNameDs);
                this.sysBpmService.exportAllFileModel(tenantId, key.toString().substring(0, key.length() - 1), workflow);
                assigneeList = Optional.ofNullable(this.sysBpmService.actAssigneeExportData(keyList)).orElseGet(ArrayList::new);
                actFormAuthList = Optional.ofNullable(this.sysBpmService.actFormAuthExportData(keyList)).orElseGet(ArrayList::new);
            }
            catch (Exception e) {
                throw new DataSourceException(e.getMessage());
            }
            finally {
                DataSourceUtil.poll();
            }
        } else {
            this.sysBpmService.exportAllFileModel(tenantId, key.toString().substring(0, key.length() - 1), workflow);
            assigneeList = Optional.ofNullable(this.sysBpmService.actAssigneeExportData(keyList)).orElseGet(ArrayList::new);
            actFormAuthList = Optional.ofNullable(this.sysBpmService.actFormAuthExportData(keyList)).orElseGet(ArrayList::new);
        }
        if (ToolUtil.isNotEmpty((Object)assigneeList)) {
            meta = SerializeUtils.serialize((Object)assigneeList);
            String assignee = workflow + File.separator + ExportResourceConstant.SYS_ACT_ASSIGNEES;
            FileUtils.writeByteArrayToFile((File)new File(assignee), (byte[])meta);
        }
        if (ToolUtil.isNotEmpty((Object)actFormAuthList)) {
            meta = SerializeUtils.serialize((Object)actFormAuthList);
            String formAuth = workflow + File.separator + ExportResourceConstant.SYS_ACT_FORMAUTHS;
            FileUtils.writeByteArrayToFile((File)new File(formAuth), (byte[])meta);
        }
    }

    private Map<String, Object> importWorkFlow(File temp, String tenantId) throws IOException {
        File workflow = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.WORKFLOW);
        HashMap<String, Object> workFlowResult = new HashMap<String, Object>();
        List<Object> workFlowInfos = new ArrayList();
        if (workflow.exists()) {
            File assignee = FileUtils.getFile((File)workflow, (String[])new String[]{ExportResourceConstant.SYS_ACT_ASSIGNEES});
            File formAuth = FileUtils.getFile((File)workflow, (String[])new String[]{ExportResourceConstant.SYS_ACT_FORMAUTHS});
            String appNameDs = this.getAppDsName(tenantId);
            if (appNameDs != null) {
                try {
                    byte[] bytes;
                    DataSourceUtil.changeTempDs((String)appNameDs);
                    if (assignee.exists()) {
                        bytes = FileUtils.readFileToByteArray((File)assignee);
                        List assigneeList = (List)SerializeUtils.deserialize((byte[])bytes);
                        this.sysBpmService.actAssigneeBatchImport(assigneeList);
                        FileUtils.forceDelete((File)assignee);
                    }
                    if (formAuth.exists()) {
                        bytes = FileUtils.readFileToByteArray((File)formAuth);
                        List actFormAuthList = (List)SerializeUtils.deserialize((byte[])bytes);
                        this.sysBpmService.actFormAuthBatchImport(actFormAuthList);
                        FileUtils.forceDelete((File)formAuth);
                    }
                    List<String> names = this.getWorkFlowDir(workflow);
                    workFlowInfos = this.getWorkFlowInfos(names);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new DataSourceException(e.getMessage());
                }
                finally {
                    DataSourceUtil.poll();
                }
            } else {
                byte[] bytes;
                if (assignee.exists()) {
                    bytes = FileUtils.readFileToByteArray((File)assignee);
                    List assigneeList = (List)SerializeUtils.deserialize((byte[])bytes);
                    this.sysBpmService.actAssigneeBatchImport(assigneeList);
                    FileUtils.forceDelete((File)assignee);
                }
                if (formAuth.exists()) {
                    bytes = FileUtils.readFileToByteArray((File)formAuth);
                    List actFormAuthList = (List)SerializeUtils.deserialize((byte[])bytes);
                    this.sysBpmService.actFormAuthBatchImport(actFormAuthList);
                    FileUtils.forceDelete((File)formAuth);
                }
                List<String> names = this.getWorkFlowDir(workflow);
                workFlowInfos = this.getWorkFlowInfos(names);
            }
        }
        workFlowResult.put("workFlowPath", workflow.getAbsolutePath());
        workFlowResult.put("workFlowInfos", workFlowInfos);
        workFlowResult.put("tenantId", tenantId);
        return workFlowResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportCode(File path, String type, String appName, String tenantId) throws IOException {
        SpeedCodeProperties speedCodeProperties = (SpeedCodeProperties)SpringUtil.getBean((String)"speedCodeProperties");
        String speedCodePath = speedCodeProperties.getWorkspace() + ExportResourceConstant.PUBLISH_CACHE;
        File file = new File(speedCodePath);
        if (file.exists()) {
            try {
                File java = new File(speedCodePath, ExportResourceConstant.JAVA);
                File api = new File(speedCodePath, ExportResourceConstant.API);
                File vue = new File(speedCodePath, ExportResourceConstant.VUE);
                if (java.exists()) {
                    if ("1".equals(type) && !this.openPlugin) {
                        String targetDir = FileUtil.posixPath((String[])new String[]{speedCodeProperties.getJavaPath(), AppContextUtil.asIdentifier((String)(tenantId + appName))});
                        new CompileUtil().compile(java.getAbsolutePath(), java.getAbsolutePath(), targetDir);
                    }
                    File javaTemp = new File(path, ExportResourceConstant.JAVA);
                    FileUtils.copyDirectory((File)java, (File)javaTemp);
                }
                if (api.exists()) {
                    File apiTemp = new File(path, ExportResourceConstant.API);
                    FileUtils.copyDirectory((File)api, (File)apiTemp);
                }
                if (vue.exists()) {
                    File vueTemp = new File(path, ExportResourceConstant.VUE);
                    FileUtils.copyDirectory((File)vue, (File)vueTemp);
                }
            }
            finally {
                FileUtils.forceDelete((File)file);
            }
        }
    }

    private void exportData(List<Map<String, Object>> tableInfoList, String tenantId, File temp) throws IOException {
        HashMap<String, TableStructure> tableStructures = new HashMap<String, TableStructure>();
        for (Map<String, Object> tableInfo : tableInfoList) {
            String dbName = tableInfo.get("dataSourceName").toString();
            List tableList = (List)tableInfo.get("tableNames");
            try {
                TableStructure tableStructure = this.exportTableStructureService.exportTableStructure(dbName, tenantId, tableList);
                if (!ToolUtil.isNotEmpty((Object)tableStructure)) continue;
                tableStructures.put(dbName, tableStructure);
            }
            catch (EngineException e) {
                e.printStackTrace();
            }
        }
        File tableInfo = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.TABLEINFO + File.separator + ExportResourceConstant.TABLE_INFO_JSON);
        byte[] bytes = SerializeUtils.serialize(tableStructures);
        FileUtils.writeByteArrayToFile((File)tableInfo, (byte[])bytes);
    }

    private Map<String, Object> importData(File file, String tenantId) throws IOException {
        byte[] bytes;
        Map tableStructures;
        File dataFile = new File(file.getAbsolutePath(), ExportResourceConstant.TABLEINFO + File.separator + ExportResourceConstant.TABLE_INFO_JSON);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        ArrayList<AddTableResult> addTableResultList = new ArrayList<AddTableResult>();
        ArrayList<ModifyTableResult> modifyTableResults = new ArrayList<ModifyTableResult>();
        if (dataFile.exists() && (tableStructures = (Map)SerializeUtils.deserialize((byte[])(bytes = FileUtils.readFileToByteArray((File)dataFile)))) != null) {
            for (String s : tableStructures.keySet()) {
                TableStructure tableStructure = (TableStructure)tableStructures.get(s);
                GenerateSqlResult generateSqlResult = null;
                try {
                    generateSqlResult = this.exportTableStructureService.generateSql(tableStructure, s, tenantId);
                    if (!ToolUtil.isNotEmpty((Object)generateSqlResult)) continue;
                    if (ToolUtil.isNotEmpty((Object)generateSqlResult.getResultSql())) {
                        sqlMap.put(s, generateSqlResult.getResultSql());
                    }
                    if (ToolUtil.isNotEmpty((Object)generateSqlResult.getAddTableResult())) {
                        addTableResultList.add(generateSqlResult.getAddTableResult());
                    }
                    if (!ToolUtil.isNotEmpty((Object)generateSqlResult.getEditTableResults())) continue;
                    modifyTableResults.add(generateSqlResult.getEditTableResults());
                }
                catch (EngineException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
        dataMap.put("sql", sqlMap);
        dataMap.put("createTables", addTableResultList);
        dataMap.put("alterTables", modifyTableResults);
        return dataMap;
    }

    private void importCode(File temp, String appName, String tenantId, boolean offline) throws IOException, XmlPullParserException {
        String vuePath;
        String apiPath;
        String javaPath;
        File java = new File(temp, ExportResourceConstant.JAVA);
        File vue = new File(temp, ExportResourceConstant.VUE);
        File api = new File(temp, ExportResourceConstant.API);
        if (offline) {
            javaPath = FileUtil.posixPath((String[])new String[]{this.speedCodeProperties.getBackProjectPath(), this.speedCodeProperties.getJavaCodePath()});
            apiPath = FileUtil.posixPath((String[])new String[]{this.speedCodeProperties.getFrontProjectPath(), this.speedCodeProperties.getFrontApiPath()});
            vuePath = FileUtil.posixPath((String[])new String[]{this.speedCodeProperties.getFrontProjectPath(), this.speedCodeProperties.getVueCodePath()});
        } else {
            javaPath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getWebPath(), this.produceProperties.getJavaPath()});
            vuePath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getFrontPath(), this.speedCodeProperties.getVueCodePath()});
            apiPath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getFrontPath(), this.speedCodeProperties.getFrontApiPath()});
        }
        if (java.exists()) {
            if (offline) {
                if (!this.openPlugin) {
                    FileUtils.copyDirectory((File)java, (File)new File(javaPath));
                } else {
                    this.importJavaCode(java, appName, tenantId);
                }
            } else {
                this.importPlugin(java, appName, tenantId);
            }
        }
        if (vue.exists()) {
            FileUtils.copyDirectory((File)vue, (File)new File(vuePath));
        }
        if (api.exists()) {
            FileUtils.copyDirectory((File)api, (File)new File(apiPath));
        }
    }

    private void importJavaCode(File java, String appName, String tenantId) throws IOException {
        String pluginName;
        File pluginModule;
        File parentModule = new File(this.modulePath, this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId));
        if (!parentModule.exists()) {
            parentModule.mkdirs();
        }
        if (!(pluginModule = new File(parentModule, pluginName = this.pluginPrefix + AppContextUtil.asIdentifier((String)(tenantId + appName)))).exists()) {
            parentModule.mkdirs();
        }
        String javaPath = FileUtil.posixPath((String[])new String[]{pluginModule.getAbsolutePath(), this.speedCodeProperties.getJavaCodePath()});
        FileUtils.copyDirectory((File)java, (File)new File(javaPath));
    }

    private void importPlugin(File java, String appName, String tenantId) throws IOException, XmlPullParserException {
        String modulePath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getPluginPath(), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId), this.pluginPrefix + AppContextUtil.asIdentifier((String)(tenantId + appName))});
        File module = new File(modulePath);
        this.updatePluinFile(java, module, appName, tenantId);
        FileUtils.copyDirectory((File)java, (File)module);
    }

    private void updatePluinFile(File java, File module, String appName, String tenantId) throws IOException, XmlPullParserException {
        boolean isExist = module.exists();
        File pom = new File(java, "pom.xml");
        if (!pom.exists()) {
            this.createPluginFile(java, appName, tenantId);
            return;
        }
        if (isExist) {
            this.updateConfigFile(java, module, pom);
        }
    }

    private void updateConfigFile(File java, File module, File pom) throws IOException, XmlPullParserException {
        block39: {
            File modulePom = FileUtils.getFile((File)module, (String[])new String[]{"pom.xml"});
            File moduleProperties = FileUtils.getFile((File)module, (String[])new String[]{"src/main/resources", "plugin.properties"});
            File importProperties = FileUtils.getFile((File)java, (String[])new String[]{"src/main/resources", "plugin.properties"});
            if (moduleProperties.exists() && modulePom.exists()) {
                Properties properties = PropertiesUtils.loadProperties((String)moduleProperties.getAbsolutePath());
                String oldVersion = properties.getProperty("plugin.version");
                int index = oldVersion.lastIndexOf(".");
                int version = Integer.parseInt(oldVersion.substring(index + 1)) + 1;
                String newVersion = oldVersion.substring(0, index + 1) + version;
                this.updateProperty(importProperties, "plugin.version", newVersion);
                MavenXpp3Reader reader = new MavenXpp3Reader();
                try (FileInputStream oldFis = new FileInputStream(modulePom);
                     FileInputStream newFis = new FileInputStream(pom);){
                    Model oldModel = reader.read((InputStream)oldFis);
                    Model newModel = reader.read((InputStream)newFis);
                    Properties pomProperties = newModel.getProperties();
                    pomProperties.setProperty("plugin.version", newVersion);
                    String oldPomVersion = oldModel.getVersion();
                    if (ToolUtil.isEmpty((Object)oldPomVersion)) {
                        newModel.setVersion("1.0.0-RELEASE");
                    } else {
                        int pomIndex = oldPomVersion.indexOf(".");
                        int pomVersion = Integer.parseInt(oldPomVersion.substring(0, pomIndex)) + 1;
                        String newPomVersion = pomVersion + oldPomVersion.substring(pomIndex);
                        newModel.setVersion(newPomVersion);
                    }
                    MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                    try (FileWriter writer = new FileWriter(pom);){
                        mavenXpp3Writer.write((Writer)writer, newModel);
                        break block39;
                    }
                }
            }
            this.updateProperty(importProperties, "plugin.version", "v1.0.0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPluginFile(File java, String appName, String tenantId) throws IOException {
        String tempPath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getWebPath(), this.produceProperties.getJavaPath(), "templates"});
        File temp = Files.createTempDirectory("java" + tenantId + appName, new FileAttribute[0]).toFile();
        try {
            String tempJavaPath = FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), this.speedCodeProperties.getJavaCodePath()});
            FileUtils.copyDirectory((File)java, (File)new File(tempJavaPath));
            FileUtils.forceDelete((File)java);
            java.mkdirs();
            String appEnglishName = AppContextUtil.asIdentifier((String)appName);
            String tenantCode = AppContextUtil.asIdentifier((String)tenantId);
            String appNameLow = appEnglishName.toLowerCase();
            String tenantCodeLow = tenantCode.toLowerCase();
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            paramMap.put("tenantCode", tenantCodeLow);
            paramMap.put("applicationCode", appNameLow);
            String javaPath = FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), this.speedCodeProperties.getJavaCodePath(), this.speedCodeProperties.getJavaPath(), tenantCodeLow, appNameLow});
            String configPath = FileUtil.posixPath((String[])new String[]{javaPath, "config"});
            CodeGenerator configBeanGen = new CodeGenerator("ConfigBean.ftl", paramMap, tempPath, configPath, "ConfigBean.java");
            configBeanGen.gen();
            String appPath = tenantCodeLow + "/" + appNameLow;
            paramMap.put("applicationPath", appPath);
            CodeGenerator mybatisConfigGen = new CodeGenerator("PluginMybatisPlusConfiguration.ftl", paramMap, tempPath, configPath, "PluginMybatisPlusConfiguration.java");
            mybatisConfigGen.gen();
            String newAppName = appEnglishName;
            String appFirst = appEnglishName.substring(0, 1);
            if (p.matcher(appFirst).find()) {
                newAppName = appFirst.toUpperCase() + appEnglishName.substring(1);
            }
            String tenantUp = tenantCode;
            String tenantFist = tenantCode.substring(0, 1);
            if (!"_".equals(tenantFist)) {
                tenantUp = tenantFist.toUpperCase() + tenantCode.substring(1);
            }
            String className = tenantUp + newAppName + "ParamsPlugin";
            paramMap.put("className", className);
            CodeGenerator basePluginGen = new CodeGenerator("ParamsPlugin.ftl", paramMap, tempPath, javaPath, className + ".java");
            basePluginGen.gen();
            String propertiesPath = FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), "src/main/resources"});
            String pluginId = tenantCode + appName;
            String provider = ShiroKit.getUser().getAccount();
            String pluginClass = FileUtil.posixPath((String[])new String[]{this.speedCodeProperties.getJavaPath(), tenantCodeLow, appNameLow, className}).replace("/", ".");
            if (pluginClass.startsWith(".")) {
                pluginClass = pluginClass.substring(1);
            }
            paramMap.put("id", pluginId);
            paramMap.put("class", pluginClass);
            paramMap.put("provider", provider);
            paramMap.put("description", "");
            CodeGenerator propertiesGen = new CodeGenerator("plugin.ftl", paramMap, tempPath, propertiesPath, "plugin.properties");
            propertiesGen.gen();
            paramMap.put("artifactId", this.pluginPrefix + tenantCode + appName);
            CodeGenerator pomGen = new CodeGenerator("appPom.ftl", paramMap, tempPath, java.getAbsolutePath(), "pom.xml");
            pomGen.gen();
            FileUtils.copyDirectory((File)temp, (File)java);
        }
        finally {
            FileUtils.forceDelete((File)temp);
        }
    }

    private File mavenPackage(String tenantId, String appName) throws IOException, MavenInvocationException, XmlPullParserException {
        Object fileWriter;
        MavenXpp3Reader reader;
        String modulePath;
        block40: {
            modulePath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getPluginPath(), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId), this.pluginPrefix + AppContextUtil.asIdentifier((String)(tenantId + appName))});
            String parentPom = this.produceProperties.getPluginPath() + "pom.xml";
            reader = new MavenXpp3Reader();
            try (FileInputStream fis = new FileInputStream(new File(parentPom));){
                Model model = reader.read((InputStream)fis);
                List modules = model.getModules();
                String moduleName = AppContextUtil.asIdentifier((String)tenantId) + File.separator + this.pluginPrefix + AppContextUtil.asIdentifier((String)(tenantId + appName));
                if (modules.contains(moduleName)) break block40;
                modules.add(moduleName);
                MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                fileWriter = new FileWriter(parentPom);
                Throwable throwable = null;
                try {
                    mavenXpp3Writer.write((Writer)fileWriter, model);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileWriter != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStreamWriter)fileWriter).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStreamWriter)fileWriter).close();
                        }
                    }
                }
            }
        }
        String pom = FileUtil.posixPath((String[])new String[]{modulePath, "pom.xml"});
        MavenUtil.modulePackage(new File(pom));
        try (FileInputStream fis = new FileInputStream(new File(pom));){
            String finalName;
            Model model = reader.read((InputStream)fis);
            Build build = model.getBuild();
            String string = finalName = build == null ? "" : build.getFinalName();
            if (ToolUtil.isNotEmpty((Object)finalName)) {
                fileWriter = new File(new File(modulePath, "target"), finalName + ".jar");
                return fileWriter;
            }
            String moduleId = model.getArtifactId();
            String version = model.getVersion();
            File file = new File(new File(modulePath, "target"), moduleId + "-" + version + ".jar");
            return file;
        }
    }

    private List<String> getWorkFlowDir(File file) {
        File[] childFiles;
        ArrayList<String> dirNames = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)file) && ToolUtil.isNotEmpty((Object)(childFiles = file.listFiles()))) {
            for (File childFile : childFiles) {
                if (!childFile.isDirectory()) continue;
                dirNames.add(childFile.getName());
            }
        }
        return dirNames;
    }

    private List<Map<String, Object>> getWorkFlowInfos(List<String> names) {
        ArrayList<Map<String, Object>> workFlowInfos = new ArrayList<Map<String, Object>>();
        for (String name : names) {
            int split = name.lastIndexOf("_");
            if (split <= 0) continue;
            String workFlowName = name.substring(0, split);
            String workFlowKey = name.substring(split + 1);
            HashMap<String, Object> workFlowInfo = new HashMap<String, Object>();
            workFlowInfo.put("key", workFlowKey);
            workFlowInfo.put("label", workFlowName);
            workFlowInfo.put("disabled", false);
            workFlowInfos.add(workFlowInfo);
        }
        return workFlowInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importWorkFlowInfo(String workFlowPath, String tenantId, List<String> coverList) throws IOException {
        block10: {
            File workflow = new File(workFlowPath);
            try {
                if (!workflow.exists()) break block10;
                String appNameDs = this.getAppDsName(tenantId);
                if (appNameDs != null) {
                    try {
                        DataSourceUtil.changeTempDs((String)appNameDs);
                        this.sysBpmService.importModel(tenantId, workflow, coverList);
                        break block10;
                    }
                    catch (Exception e) {
                        throw new DataSourceException(e.getMessage());
                    }
                    finally {
                        DataSourceUtil.poll();
                    }
                }
                this.sysBpmService.importModel(tenantId, workflow, coverList);
            }
            finally {
                if (ToolUtil.isNotEmpty((Object)workflow) && ToolUtil.isNotEmpty((Object)workflow.getParentFile())) {
                    File parentFile = workflow.getParentFile();
                    FileUtils.forceDelete((File)parentFile);
                }
            }
        }
    }

    @Override
    public Map<String, Object> importProduceApp(MultipartFile multipartFile, String appId) throws IOException {
        Map<String, Object> returnMap;
        block8: {
            returnMap = new HashMap<String, Object>();
            String msg = "\u5bfc\u5165\u5305";
            InputStream inputStream = multipartFile.getInputStream();
            File temp = Files.createTempDirectory("appImport" + appId, new FileAttribute[0]).toFile();
            try {
                File tempFile = new File(temp.getAbsolutePath() + File.separator + appId + ".zip");
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
                com.jxdinfo.hussar.application.util.ZipUtil.unzip(tempFile.getAbsolutePath(), temp.getAbsolutePath() + File.separator);
                File metaFile = new File(temp + File.separator + ExportResourceConstant.META_JSON);
                if (!metaFile.exists()) {
                    returnMap.put("status", false);
                    returnMap.put("msg", msg + "\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u5b58\u5728meta.json\u6587\u4ef6");
                    return returnMap;
                }
                byte[] meta = FileUtils.readFileToByteArray((File)metaFile);
                Map metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
                if (metaMap == null) {
                    returnMap.put("status", false);
                    returnMap.put("msg", "meta.json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                    return returnMap;
                }
                String appName = metaMap.get("appName") == null ? "" : metaMap.get("appName").toString();
                String tenantId = metaMap.get("tenantId") == null ? "" : metaMap.get("tenantId").toString();
                String importType = metaMap.get("importType") == null ? "" : metaMap.get("importType").toString();
                String sign = metaMap.get("sign") == null ? "" : metaMap.get("sign").toString();
                FormdesignAppInfo appInfo = (FormdesignAppInfo)((Object)this.formdesignAppInfoService.getById((Serializable)((Object)appId)));
                if (!"1".equals(importType)) {
                    returnMap.put("status", false);
                    returnMap.put("msg", msg + "\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u5f53\u524d\u73af\u5883\u9700\u8981\u7684\u5305\uff01");
                    return returnMap;
                }
                if (!appInfo.getTenantId().equals(tenantId)) {
                    returnMap.put("status", false);
                    returnMap.put("msg", "\u5e94\u7528\u79df\u6237ID\u4e0e" + msg + "\u7684\u79df\u6237ID\u4e0d\u4e00\u81f4\uff01");
                    return returnMap;
                }
                if (!appInfo.getEnglishName().equals(appName)) {
                    returnMap.put("status", false);
                    returnMap.put("msg", "\u5e94\u7528\u540d\u79f0\u4e0e" + msg + "\u7684\u5e94\u7528\u540d\u79f0\u4e0d\u4e00\u81f4\uff01");
                    return returnMap;
                }
                File tar = new File(temp + File.separator + appName + ".tar");
                String md5 = ZipUtil.getMd5((String)tar.getAbsolutePath());
                if (!md5.equals(sign)) {
                    returnMap.put("status", false);
                    returnMap.put("msg", msg + "\u5df2\u88ab\u4fee\u6539\uff01");
                    return returnMap;
                }
                TarUtil.unTar(tar, temp.getAbsolutePath() + File.separator);
                Map<String, Object> workFlowResult = this.importWorkFlow(temp, tenantId);
                returnMap = this.importData(temp, tenantId);
                returnMap.put("status", true);
                returnMap.put("workFlowInfos", workFlowResult.get("workFlowInfos"));
                returnMap.put("tempPath", temp.getAbsolutePath());
                returnMap.put("tenantId", workFlowResult.get("tenantId"));
            }
            catch (Exception e) {
                if (!temp.exists()) break block8;
                FileUtils.forceDelete((File)temp);
            }
        }
        return returnMap;
    }

    private void backUpAppFiles(String appId, String tenantId) throws IOException {
        Map<String, String> pathMap = this.getAppFilePath(appId, tenantId);
        String vuePath = pathMap.get("vuePath");
        String apiPath = pathMap.get("apiPath");
        String pluginPath = pathMap.get("pluginPath");
        File vue = new File(vuePath);
        File api = new File(apiPath);
        File plugin = new File(pluginPath);
        String vueBackUpPath = pathMap.get("vueBackUpPath");
        String apiBackUpPath = pathMap.get("apiBackUpPath");
        String pluginBackUpPath = pathMap.get("pluginBackUpPath");
        if (vue.exists()) {
            FileUtils.copyDirectory((File)vue, (File)new File(vueBackUpPath));
        }
        if (api.exists()) {
            FileUtils.copyDirectory((File)api, (File)new File(apiBackUpPath));
        }
        if (plugin.exists()) {
            FileUtils.copyDirectory((File)plugin, (File)new File(pluginBackUpPath));
        }
    }

    private Map<String, String> getAppFilePath(String appId, String tenantId) {
        FormdesignAppInfo appInfo = (FormdesignAppInfo)((Object)this.formdesignAppInfoService.getById((Serializable)((Object)appId)));
        String tenantDir = AppContextUtil.asIdentifier((String)tenantId);
        String enName = AppContextUtil.asIdentifier((String)appInfo.getEnglishName());
        String appPath = tenantDir + File.separator + enName;
        String vuePath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getFrontPath(), this.speedCodeProperties.getVueCodePath(), appPath});
        String apiPath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getFrontPath(), this.speedCodeProperties.getFrontApiPath(), appPath});
        String pluginPath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getPluginPath(), this.pluginPrefix + tenantDir, this.pluginPrefix + tenantDir + appInfo.getEnglishName()});
        String frontBackUpPath = FileUtil.posixPath((String[])new String[]{this.produceProperties.getWebPath(), "frontBackUp" + enName});
        String vueBackUpPath = FileUtil.posixPath((String[])new String[]{frontBackUpPath, this.speedCodeProperties.getVueCodePath(), appPath});
        String apiBackUpPath = FileUtil.posixPath((String[])new String[]{frontBackUpPath, this.speedCodeProperties.getFrontApiPath(), appPath});
        String pluginParentPath = new File(this.produceProperties.getPluginPath()).getParent();
        String pluginBackUpPath = FileUtil.posixPath((String[])new String[]{pluginParentPath, "hussar-plugin-back", this.pluginPrefix + tenantDir, this.pluginPrefix + tenantDir + appInfo.getEnglishName()});
        HashMap<String, String> pathMap = new HashMap<String, String>();
        pathMap.put("vuePath", vuePath);
        pathMap.put("apiPath", apiPath);
        pathMap.put("frontBackUpPath", frontBackUpPath);
        pathMap.put("vueBackUpPath", vueBackUpPath);
        pathMap.put("apiBackUpPath", apiBackUpPath);
        pathMap.put("pluginPath", pluginPath);
        pathMap.put("pluginBackUpPath", pluginBackUpPath);
        return pathMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importAndCompileApp(String tempPath, String tenantId, String appId, String sql, List<String> coverList, String compileId) throws IOException {
        File temp = new File(tempPath);
        try {
            JSONObject jsonObject;
            this.backUpAppFiles(appId, tenantId);
            File axe = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE);
            HashMap<String, String> replaceMap = new HashMap<String, String>();
            replaceMap.put("filePath", axe.getAbsolutePath());
            replaceMap.put("appId", appId);
            this.exportService.replaceDataSourceType(replaceMap);
            this.storageDumpLoadService.load(appId, axe);
            FormdesignAppInfo appInfo = (FormdesignAppInfo)((Object)this.formdesignAppInfoService.getById((Serializable)((Object)appId)));
            this.importCode(temp, appInfo.getEnglishName(), tenantId, false);
            if (ToolUtil.isNotEmpty((Object)sql) && ToolUtil.isNotEmpty((Object)(jsonObject = JSONObject.parseObject((String)sql)))) {
                this.executeSql(jsonObject, appId);
            }
            this.importWorkFlowInfo(temp.getAbsolutePath() + File.separator + ExportResourceConstant.WORKFLOW, tenantId, coverList);
            this.compileQueue(0, appId, tenantId, compileId);
            File jar = this.mavenPackage(tenantId, appInfo.getEnglishName());
            if (jar.exists()) {
                String pluginId = AppContextUtil.asIdentifier((String)(tenantId + appInfo.getEnglishName()));
                this.loadPluginJar(pluginId, jar);
                FileUtils.forceDelete((File)jar.getParentFile());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.updateCompileStatus(compileId, "2", this.getErrorInfoFromException(e));
            this.rollbackPluginFile(appId, tenantId);
            this.rollbackOrDeleteAppFile(appId, tenantId, true);
        }
        finally {
            if (ToolUtil.isNotEmpty((Object)temp) && temp.exists()) {
                FileUtils.forceDelete((File)temp);
            }
        }
    }

    private void loadPluginJar(String pluginId, File jar) throws Exception {
        boolean isRevert = false;
        Path backUpPath = null;
        try {
            PluginInfo pluginInfo = this.pluginOperator.getPluginInfo(pluginId);
            if (ToolUtil.isNotEmpty((Object)pluginInfo)) {
                isRevert = true;
                this.pluginOperator.uninstall(pluginId, false);
            }
            this.uploadPluginAndStart(jar);
        }
        catch (Exception e) {
            PluginInfo pluginInfo = this.pluginOperator.getPluginInfo(pluginId);
            if (ToolUtil.isEmpty((Object)pluginInfo) && isRevert) {
                this.revertPlugin(backUpPath);
            }
            throw e;
        }
    }

    private synchronized void uploadPluginAndStart(File jar) throws Exception {
        Path jarPath = jar.toPath();
        String pluginId = null;
        try {
            PluginInfo pluginInfo = this.pluginOperator.load(jarPath);
            if (pluginInfo == null) {
                logger.error("Plugin '{}' install failure, this pluginInfo id is empty.", pluginId);
                throw new NullPointerException("Plugin " + pluginId + " install failure, this pluginInfo id is empty");
            }
            PluginDescriptor pluginDescriptor = pluginInfo.getPluginDescriptor();
            if (pluginDescriptor == null) {
                logger.error("Plugin install failure.");
                throw new NullPointerException("Plugin install failure");
            }
            pluginId = pluginDescriptor.getPluginId();
            GlobalRegistryInfo.addOperatorPluginInfo((String)pluginId, (PluginOperatorInfo.OperatorType)PluginOperatorInfo.OperatorType.INSTALL, (boolean)true);
            if (!this.pluginOperator.start(pluginId)) {
                this.pluginOperator.uninstall(pluginId, false);
                throw new Exception("Plugin" + pluginId + " start failure");
            }
            logger.info("Plugin '{}' install success", (Object)pluginId);
        }
        catch (Exception var2) {
            try {
                logger.error("Plugin '{}' install failure. {}", pluginId, (Object)var2);
                if (!ObjectUtils.isEmpty(pluginId)) {
                    try {
                        this.pluginOperator.uninstall(pluginId, false);
                    }
                    catch (Exception var3) {
                        logger.error("Plugin '{}' uninstall failure. {}", (Object)pluginId, (Object)var3.getMessage());
                    }
                }
                throw var2;
            }
            catch (Throwable throwable) {
                if (!ObjectUtils.isEmpty(pluginId)) {
                    GlobalRegistryInfo.setOperatorPluginInfo(pluginId, (boolean)false);
                }
                throw throwable;
            }
        }
        if (!ObjectUtils.isEmpty((Object)pluginId)) {
            GlobalRegistryInfo.setOperatorPluginInfo((String)pluginId, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertPlugin(Path backUpPath) throws Exception {
        File backUpJar = backUpPath.toFile();
        if (backUpJar.exists()) {
            String[] names = backUpJar.getName().split("_");
            StringBuffer sb = new StringBuffer();
            for (int i = 2; i < names.length; ++i) {
                sb.append(names[i]);
            }
            File jar = new File(backUpJar.getParentFile(), sb.toString());
            try {
                FileUtils.copyFile((File)backUpJar, (File)jar);
                this.uploadPluginAndStart(jar);
            }
            finally {
                FileUtils.forceDelete((File)jar);
            }
        }
    }

    private String getErrorInfoFromException(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "\r\n" + sw.toString() + "\r\n";
        }
        catch (Exception e2) {
            return "bad getErrorInfoFromException";
        }
    }

    private void compileQueue(int count, String appId, String tenantId, String compileId) throws IOException, InterruptedException {
        if (this.isCompiling()) {
            this.preCompileFront(appId, tenantId, compileId);
        } else if (count < 20) {
            Thread.sleep(6000L);
            this.compileQueue(++count, appId, tenantId, compileId);
        } else {
            this.updateCompileStatus(compileId, "4", null);
        }
    }

    private void updateCompileStatus(String compileId, String status, String msg) {
        FormdesignAppPackage formdesignAppPackage = (FormdesignAppPackage)((Object)this.appPackageService.getById((Serializable)((Object)compileId)));
        if (ToolUtil.isNotEmpty((Object)((Object)formdesignAppPackage))) {
            formdesignAppPackage.setStatus(status);
            if (ToolUtil.isNotEmpty((Object)msg)) {
                formdesignAppPackage.setErrorMsg(msg);
            }
            this.appPackageService.updateById((Object)formdesignAppPackage);
        }
    }

    @Override
    public void preCompileFront(String appId, String tenantId, String compileId) throws IOException, InterruptedException {
        FormdesignAppPackage formdesignAppPackage = (FormdesignAppPackage)((Object)this.appPackageService.getById((Serializable)((Object)compileId)));
        if (ToolUtil.isEmpty((Object)((Object)formdesignAppPackage))) {
            this.rollbackOrDeleteAppFile(appId, tenantId, true);
            return;
        }
        formdesignAppPackage.setStatus("0");
        this.appPackageService.updateById((Object)formdesignAppPackage);
        File compileTemp = Files.createTempDirectory("output" + formdesignAppPackage.getId(), new FileAttribute[0]).toFile();
        try {
            String url = this.produceProperties.getPackagePath() + "compile";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("compileId", formdesignAppPackage.getId());
            params.put("output", compileTemp.getAbsolutePath());
            RestTemplateHttpUtil.sendPostRequest((String)url, params);
        }
        catch (ResourceAccessException e) {
            if (ToolUtil.isNotEmpty((Object)compileTemp) && compileTemp.exists()) {
                FileUtils.forceDelete((File)compileTemp);
            }
            throw e;
        }
        while (true) {
            block9: {
                try {
                    Map<String, Object> checkResult = this.preCheckCompile(appId, tenantId, compileId);
                    if (((Boolean)checkResult.get("success")).booleanValue()) {
                        FileUtils.forceDelete((File)compileTemp);
                        break;
                    }
                    if (ToolUtil.isNotEmpty((Object)checkResult.get("msg"))) {
                        FileUtils.forceDelete((File)compileTemp);
                    }
                    break block9;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    formdesignAppPackage.setStatus("2");
                    this.appPackageService.updateById((Object)formdesignAppPackage);
                    this.rollbackOrDeleteAppFile(appId, tenantId, true);
                    FileUtils.forceDelete((File)compileTemp);
                }
                break;
            }
            Thread.sleep(5000L);
        }
    }

    @Override
    public Map<String, Object> preCheckCompile(String appId, String tenantId, String compileId) throws IOException {
        FormdesignAppPackage formdesignAppPackage = (FormdesignAppPackage)((Object)this.appPackageService.getById((Serializable)((Object)compileId)));
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)((Object)formdesignAppPackage))) {
            String url = this.produceProperties.getPackagePath() + "compilingCheck";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("compileId", formdesignAppPackage.getId());
            ResultVO resultVO = RestTemplateHttpUtil.sendPostRequest((String)url, params);
            Map data = (Map)resultVO.getData();
            Boolean finished = (Boolean)data.get("finished");
            if (finished.booleanValue()) {
                map.put("success", resultVO.isSucceed());
                if (resultVO.isSucceed()) {
                    formdesignAppPackage.setStatus("1");
                    this.rollbackOrDeleteAppFile(appId, tenantId, false);
                } else {
                    formdesignAppPackage.setStatus("2");
                    formdesignAppPackage.setErrorMsg(data.get("msg").toString());
                    map.put("msg", data.get("msg"));
                    this.rollbackOrDeleteAppFile(appId, tenantId, true);
                }
                this.appPackageService.updateById((Object)formdesignAppPackage);
            } else {
                map.put("success", false);
            }
        } else {
            map.put("success", true);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackOrDeleteAppFile(String appId, String tenantId, boolean isRollback) throws IOException {
        Map<String, String> pathMap = this.getAppFilePath(appId, tenantId);
        String vuePath = pathMap.get("vuePath");
        String apiPath = pathMap.get("apiPath");
        String vueBackUpPath = pathMap.get("vueBackUpPath");
        String apiBackUpPath = pathMap.get("apiBackUpPath");
        File vueFile = new File(vuePath);
        File apiFile = new File(apiPath);
        File vueBackFile = new File(vueBackUpPath);
        File apiBackFile = new File(apiBackUpPath);
        try {
            if (isRollback) {
                if (vueFile.exists()) {
                    FileUtils.forceDelete((File)vueFile);
                }
                if (apiFile.exists()) {
                    FileUtils.forceDelete((File)apiFile);
                }
                if (vueBackFile.exists()) {
                    FileUtils.copyDirectory((File)vueBackFile, (File)new File(vuePath));
                }
                if (apiBackFile.exists()) {
                    FileUtils.copyDirectory((File)apiBackFile, (File)new File(apiPath));
                }
            }
        }
        finally {
            File frontBackUpFile = new File(pathMap.get("frontBackUpPath"));
            if (frontBackUpFile.exists()) {
                FileUtils.forceDelete((File)frontBackUpFile);
            }
        }
    }

    private void rollbackPluginFile(String appId, String tenantId) throws IOException {
        Map<String, String> pathMap = this.getAppFilePath(appId, tenantId);
        String pluginPath = pathMap.get("pluginPath");
        String pluginBackUpPath = pathMap.get("pluginBackUpPath");
        File pluginFile = new File(pluginPath);
        File pluginBackUpFile = new File(pluginBackUpPath);
        if (pluginFile.exists()) {
            FileUtils.forceDelete((File)pluginFile);
        }
        if (pluginBackUpFile.exists()) {
            FileUtils.copyDirectory((File)pluginBackUpFile, (File)new File(pluginPath));
        }
    }

    @Override
    public Object getCompileList(String page, String limit, Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
            List<FormdesignAppPackage> list = this.appPackageService.getCompileList(pages, map);
            resultMap.put("count", pages.getTotal());
            resultMap.put("data", list);
            resultMap.put("code", 0);
            return resultMap;
        }
        resultMap.put("data", null);
        resultMap.put("code", "500");
        resultMap.put("msg", "\u53c2\u6570\u4e0d\u7b26");
        resultMap.put("count", null);
        return resultMap;
    }

    @Override
    public String addWaitingCompileTask(String appId) {
        FormdesignAppPackage formdesignAppPackage = new FormdesignAppPackage();
        formdesignAppPackage.setStatus("3");
        formdesignAppPackage.setAppId(appId);
        formdesignAppPackage.setCreateTime(new Date());
        this.appPackageService.save((Object)formdesignAppPackage);
        return formdesignAppPackage.getId();
    }

    @Override
    public Map<String, Object> getExportState(String appId) {
        List<FormdesignAppFile> offlineAppFileList = this.formdesignAppFileService.getAppFileByImportType(appId, "0");
        List<FormdesignAppFile> prodAppFileList = this.formdesignAppFileService.getAppFileByImportType(appId, "1");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty(offlineAppFileList)) {
            result.put("offlineExportStatus", offlineAppFileList.get(0).getFileStatus());
            result.put("offlineExportTime", offlineAppFileList.get(0).getCreateTime());
        }
        if (ToolUtil.isNotEmpty(prodAppFileList)) {
            result.put("prodExportStatus", prodAppFileList.get(0).getFileStatus());
            result.put("prodExportTime", prodAppFileList.get(0).getCreateTime());
        }
        return result;
    }

    private void updateProperty(File properties, String key, String value) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (FileInputStream fis = new FileInputStream(properties);
             InputStreamReader inputReader = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
             BufferedReader bf = new BufferedReader(inputReader);){
            String str;
            while ((str = bf.readLine()) != null) {
                String name;
                if (!str.contains("#") && str.contains("=") && key.equals(name = str.substring(0, str.indexOf("=")).trim())) {
                    arrayList.add(key + "=" + value);
                    continue;
                }
                arrayList.add(str);
            }
            try (FileOutputStream fos = new FileOutputStream(properties);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                 BufferedWriter bw = new BufferedWriter(osw);){
                for (String s : arrayList) {
                    bw.write(s);
                    bw.newLine();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

