/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.application.constant.UserEnvStatus;
import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.model.SysApplicationRecord;
import com.jxdinfo.hussar.application.model.UserDevEnv;
import com.jxdinfo.hussar.application.service.IHussarAppCallBackService;
import com.jxdinfo.hussar.application.service.IHussarApplicationService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.service.ISysApplicationRecordService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.service.IUserDevEnvService;
import com.jxdinfo.hussar.application.service.IUserEnvPortService;
import com.jxdinfo.hussar.application.tool.annotation.ExportProgressCache;
import com.jxdinfo.hussar.application.tool.annotation.ImportProgressCache;
import com.jxdinfo.hussar.application.tool.aspect.ProgressCacheAspect;
import com.jxdinfo.hussar.application.tool.threadHolder.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.impl.SysMenuManageServiceImpl;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.code.plus.model.SysCodeRule;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.common.base.HussarBaseMultipartFile;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.deploy.dto.DeployGitDto;
import com.jxdinfo.hussar.deploy.service.IHussarDeployService;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.model.GitDto;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.GitlabUtil;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.service.impl.TenantApplicationServiceImpl")
public class TenantApplicationServiceImpl
implements IHussarAppCallBackService,
IHussarApplicationService {
    private static Logger logger = LoggerFactory.getLogger(TenantApplicationServiceImpl.class);
    private static final String SRC_PATH = "/src/main/java/com/jxdinfo/hussar/cloud/module/example";
    private static final String DEPEN_TAG = "</dependencies>";
    private static final String MODULE_TAG = "</modules>";
    @Value(value="${template-file.tenantPath:/home/tempfile/app-env/{tenantCode}}")
    private String TENANT_PATH;
    @Value(value="${template-file.branch:develop}")
    private String branch;
    @Value(value="${template-file.template-file-path:/home/tempfile/app-env}")
    private String TEMPLATE_FILE_PATH;
    @Value(value="${template-file.template-front:/{tenantCode}-front}")
    private String TEMPLATE_FRONT;
    @Value(value="${template-file.template-back:/{tenantCode}-web}")
    private String TEMPLATE_BACK;
    @Value(value="${template-file.front-start-module:/front-main}")
    private String FRONT_START_MODULE;
    @Value(value="${spring.cloud.nacos.discovery.server-addr:localhost:8848}")
    private String serverAddr;
    @Value(value="${spring.cloud.nacos.discovery.namespace:public}")
    private String namespace;
    @Resource
    private ISysResourceMosulesService resourceMosulesService;
    @Resource
    private ISysFunctionModulesService functionModulesService;
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicTypeService sysDicTypeService;
    @Resource
    private ISysDicSingleService sysDicSingleService;
    @Resource
    private ISysRoleGroupService roleGroupService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysCodeRuleService sysCodeRuleService;
    @Resource
    private SysMenuManageServiceImpl sysMenuService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private ISysResourceMosulesService sysResourceModulesService;
    @Resource
    private OssService ossService;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private IHussarBaseTenantService hussarBaseTenantService;
    @Resource
    private ISysApplicationRecordService sysApplicationRecordService;
    @Resource
    private ISysUserRoleService userRoleService;
    @Resource
    private IUserDevEnvService userDevEnvService;
    @Resource
    private IHussarDeployService hussarDeployService;
    @Resource
    private IUserEnvPortService userEnvPortService;
    @Resource
    private ISysTenantService sysTenantService;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private ISysAppDevelopTeamService appDevelopTeamService;
    @Resource
    private ISysAppDevelopTeamMemberService appDevelopTeamMemberService;
    @Autowired
    private ISysAppDevelopTeamService developTeamService;
    @Autowired
    private ISysAppOperationLogService sysAppOperationLogService;
    @Autowired
    private ISysAppRecycleService sysAppRecycleService;

    public String getAppType() {
        return "20";
    }

    public void addApp(SysApplication app) {
        this.createAppGroup(app);
        SysUserRole userRole = new SysUserRole();
        Long userId = HussarSecurityUtils.getLoginUserDetails().getUserId();
        SysUserRole record = (SysUserRole)this.userRoleService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)TenantConstant.APP_ADMIN_ROLE));
        if (HussarUtils.isEmpty((Object)record)) {
            userRole.setUserId(userId);
            userRole.setGrantedRole(TenantConstant.APP_ADMIN_ROLE);
            userRole.setAdminOption("1");
            userRole.setCreateTime(LocalDateTime.now());
            userRole.setCreator(userId);
            userRole.setLastTime(LocalDateTime.now());
            userRole.setLastEditor(userId);
            this.userRoleService.save((Object)userRole);
        }
        this.pushAppToGit(app);
    }

    public void pushAppToGit(SysApplication app) {
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        String tenantCode = userDetails.getTenantCode();
        this.initFormDesignServer(app, tenantCode);
        String localRepPath = this.TENANT_PATH;
        localRepPath = localRepPath.replace("{tenantCode}", tenantCode);
        GitDto gitDto = new GitDto();
        gitDto.setBranch(this.branch);
        gitDto.setCommitMsg("\u65b0\u5efa\u5e94\u7528\uff0c\u66f4\u65b0\u76ee\u5f55");
        gitDto.setPath(localRepPath);
        gitDto.setTenantCode(tenantCode);
        HussarTenantDefinition tenantByTenantCode = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
        gitDto.setAccessToken(tenantByTenantCode.getGitToken());
        gitDto.setGitUri(tenantByTenantCode.getGitUrl());
        GitlabUtil.pushToGit((GitDto)gitDto);
    }

    public void createAppGroup(SysApplication app) {
        Integer resourceModulesSeq = ((LambdaQueryChainWrapper)this.resourceMosulesService.lambdaQuery().eq(SysResourceModules::getParentModuleId, (Object)1L)).list().stream().max(Comparator.comparing(SysResourceModules::getSeq)).map(SysResourceModules::getSeq).orElse(9);
        SysResourceModules resourceModules = new SysResourceModules();
        resourceModules.setModuleName(app.getAppName());
        resourceModules.setApplicationId(app.getId());
        resourceModules.setModuleCode(app.getAppCode());
        resourceModules.setParentModuleId(Long.valueOf(1L));
        resourceModules.setSeq(Integer.valueOf(resourceModulesSeq + 1));
        this.resourceMosulesService.save((Object)resourceModules);
        Integer functionModulesSeq = ((LambdaQueryChainWrapper)this.functionModulesService.lambdaQuery().eq(SysFunctionModules::getParentModuleId, (Object)1L)).list().stream().max(Comparator.comparing(SysFunctionModules::getSeq)).map(SysFunctionModules::getSeq).orElse(12);
        SysFunctionModules functionModules = new SysFunctionModules();
        functionModules.setApplicationId(app.getId());
        functionModules.setFunctionModuleName(app.getAppName());
        functionModules.setFunctionModuleCode(app.getAppCode());
        functionModules.setParentModuleId(Long.valueOf(1L));
        functionModules.setSeq(Integer.valueOf(functionModulesSeq + 1));
        this.functionModulesService.save((Object)functionModules);
        DicGroup dicGroup = new DicGroup();
        dicGroup.setRangeType("dict");
        dicGroup.setParentId(Long.valueOf(11L));
        dicGroup.setGroupDescription(app.getAppName());
        dicGroup.setAppId(app.getId());
        DicGroup lastOne = (DicGroup)this.dicGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicGroup::getParentId, (Object)dicGroup.getParentId())).orderByDesc(DicGroup::getSort), false);
        if (ToolUtil.isEmpty((Object)lastOne)) {
            dicGroup.setSort(Integer.valueOf(3));
        } else {
            dicGroup.setSort(Integer.valueOf(lastOne.getSort() + 1));
        }
        this.dicGroupService.save((Object)dicGroup);
        Integer roleGroupSeq = ((LambdaQueryChainWrapper)this.roleGroupService.lambdaQuery().eq(SysRoleGroup::getParentId, (Object)1L)).list().stream().max(Comparator.comparing(SysRoleGroup::getGroupOrder)).map(SysRoleGroup::getGroupOrder).orElse(4);
        SysRoleGroup roleGroup = new SysRoleGroup();
        roleGroup.setGroupName(app.getAppName());
        roleGroup.setGroupAlias(app.getAppName());
        roleGroup.setAppId(app.getId());
        roleGroup.setParentId(Long.valueOf(1L));
        roleGroup.setGroupOrder(Integer.valueOf(roleGroupSeq + 1));
        roleGroup.setIsSys("0");
        this.roleGroupService.save((Object)roleGroup);
        Integer sysMenuSeq = ((LambdaQueryChainWrapper)this.sysMenuService.lambdaQuery().eq(SysMenu::getParentId, (Object)1L)).list().stream().max(Comparator.comparing(SysMenu::getSeq)).map(SysMenu::getSeq).orElse(11);
        SysMenu sysMenu = new SysMenu();
        sysMenu.setId(app.getId());
        sysMenu.setText(app.getAppName());
        sysMenu.setMenuAlias(app.getAppName());
        sysMenu.setParentId(Long.valueOf(1L));
        sysMenu.setSeq(Integer.valueOf(sysMenuSeq + 1));
        sysMenu.setIsLeaf("0");
        sysMenu.setIcons("caidan-1Jmoren");
        sysMenu.setOpenType("inside");
        sysMenu.setMenuType("1");
        sysMenu.setCreateTime(LocalDateTime.now());
        sysMenu.setLastTime(LocalDateTime.now());
        sysMenu.setOpenMode("0");
        this.sysMenuService.save((BaseEntity)sysMenu);
    }

    public void deleteApp(SysApplication app) {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        SecurityUser user = BaseSecurityUtil.getUser();
        Executor asyncExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        this.deleteAllAppRelatedTableData(app);
        this.deleteTeamMember(app);
        this.userDevEnvService.remove((Wrapper)new LambdaQueryWrapper().eq(UserDevEnv::getAppId, (Object)app.getId()));
        asyncExecutor.execute(() -> {
            HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
            DeployGitDto deployGitDto = new DeployGitDto();
            deployGitDto.setAccessToken(tenant.getGitToken());
            deployGitDto.setGitUri(tenant.getGitUrl());
            deployGitDto.setBranch(user.getAccount());
            deployGitDto.setTenantCode(tenantCode);
            deployGitDto.setUserId(user.getUserId());
            deployGitDto.setAppCode(app.getAppCode());
            deployGitDto.setCommitMsg("\u66f4\u65b0application\u7684Pom\u6587\u4ef6\uff0c\u5220\u9664\u5e94\u7528\u4f9d\u8d56");
            try {
                this.hussarDeployService.deleteAppDependenceInPom(deployGitDto);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String localRepPath = this.TENANT_PATH + this.TEMPLATE_BACK;
            localRepPath = localRepPath.replace("{tenantCode}", tenantCode);
            String localRepPathOfApp = localRepPath + File.separator + app.getAppCode();
            String localRepPathOfAppFront = this.TENANT_PATH + this.TEMPLATE_FRONT + File.separator + "apps" + File.separator + app.getAppCode();
            localRepPathOfAppFront = localRepPathOfAppFront.replace("{tenantCode}", tenantCode);
            String viewJsPath = this.TENANT_PATH + this.TEMPLATE_FRONT + this.FRONT_START_MODULE + File.separator + "src" + File.separator + "views" + File.separator + "views.js";
            viewJsPath = viewJsPath.replace("{tenantCode}", tenantCode);
            String pomPath = this.TENANT_PATH + this.TEMPLATE_BACK + File.separator + "pom.xml";
            pomPath = pomPath.replace("{tenantCode}", tenantCode);
            try {
                this.deleteDirectory(localRepPathOfApp);
                this.deleteDirectory(localRepPathOfAppFront);
                String frontPath = this.TENANT_PATH + this.TEMPLATE_FRONT + this.FRONT_START_MODULE + File.separator + "package.json";
                frontPath = frontPath.replace("{tenantCode}", tenantCode);
                try {
                    this.deleteDependencyFromPackageJson(frontPath, app.getAppCode());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.deleteAppView(app.getAppCode(), viewJsPath);
                this.removeDependencyAndModule(app.getAppCode(), pomPath);
                System.out.println("Directory deleted successfully.");
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Failed to delete directory: " + localRepPathOfApp);
            }
            GitDto gitDto = new GitDto();
            gitDto.setBranch(this.branch);
            gitDto.setCommitMsg("\u5220\u9664\u5e94\u7528\uff0c\u66f4\u65b0\u76ee\u5f55");
            gitDto.setPath(this.TENANT_PATH.replace("{tenantCode}", tenantCode));
            gitDto.setTenantCode(tenantCode);
            HussarTenantDefinition tenantByTenantCode = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
            gitDto.setAccessToken(tenantByTenantCode.getGitToken());
            gitDto.setGitUri(tenantByTenantCode.getGitUrl());
            GitlabUtil.pushToGit((GitDto)gitDto);
        });
    }

    public void revertRecycleApp(SysAppRecycle appRecycle) {
        LocalDateTime now = LocalDateTime.now();
        Long appId = appRecycle.getId();
        SysAppDevelopTeam appDevelopTeam = (SysAppDevelopTeam)this.appDevelopTeamService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (null != appDevelopTeam) {
            List teamMemberVos = this.appDevelopTeamMemberService.listAppDevelopTeamMember(appDevelopTeam.getId());
            teamMemberVos.forEach(vo -> {
                SysUserRole sysUserRole;
                List record;
                Long userId = vo.getId();
                if (vo.getMemberType() == 1) {
                    record = this.userRoleService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)TenantConstant.APP_ADMIN_ROLE));
                    if (CollectionUtils.isEmpty((Collection)record)) {
                        sysUserRole = new SysUserRole();
                        sysUserRole.setUserId(userId);
                        sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                        sysUserRole.setCreator(userId);
                        sysUserRole.setLastEditor(userId);
                        sysUserRole.setLastTime(now);
                        sysUserRole.setCreateTime(now);
                        sysUserRole.setGrantedRole(TenantConstant.APP_ADMIN_ROLE);
                        this.sysRolesService.delAuthCacheInfo(userId);
                        this.userRoleService.save((Object)sysUserRole);
                    }
                } else {
                    record = this.userRoleService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)TenantConstant.APP_DEVELOP_ROLE));
                    if (CollectionUtils.isEmpty((Collection)record)) {
                        sysUserRole = new SysUserRole();
                        sysUserRole.setUserId(userId);
                        sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                        sysUserRole.setCreator(userId);
                        sysUserRole.setLastEditor(userId);
                        sysUserRole.setLastTime(now);
                        sysUserRole.setCreateTime(now);
                        sysUserRole.setGrantedRole(TenantConstant.APP_DEVELOP_ROLE);
                        this.sysRolesService.delAuthCacheInfo(userId);
                        this.userRoleService.save((Object)sysUserRole);
                    }
                }
                record = this.userRoleService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.DEVELOP_ROLE.getValue()));
                if (CollectionUtils.isEmpty((Collection)record)) {
                    sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(userId);
                    sysUserRole.setGrantedRole(SysUserAndRole.DEVELOP_ROLE.getValue());
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    sysUserRole.setCreator(userId);
                    sysUserRole.setLastEditor(userId);
                    sysUserRole.setLastTime(now);
                    sysUserRole.setCreateTime(now);
                    this.sysRolesService.delAuthCacheInfo(userId);
                    this.userRoleService.save((Object)sysUserRole);
                }
            });
        }
    }

    private void deleteTeamMember(SysApplication app) {
        Long appId = app.getId();
        SysAppDevelopTeam appDevelopTeam = (SysAppDevelopTeam)this.appDevelopTeamService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (null != appDevelopTeam) {
            List teamMemberVos = this.appDevelopTeamMemberService.listAppDevelopTeamMember(appDevelopTeam.getId());
            teamMemberVos.forEach(vo -> {
                long count = this.appDevelopTeamMemberService.count((Wrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeamMember::getUserId, (Object)vo.getId()));
                if (count < 2L) {
                    this.userRoleService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)vo.getId())).in(SysUserRole::getGrantedRole, new Object[]{TenantConstant.APP_DEVELOP_ROLE, TenantConstant.APP_ADMIN_ROLE}));
                    SysUsers sysUser = this.usersService.getById(vo.getId());
                    if (!"1".equals(sysUser.getIsSys()) && !Objects.equals(12L, sysUser.getDepartmentId())) {
                        this.userRoleService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)vo.getId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.DEVELOP_ROLE.getValue()));
                    }
                }
            });
        }
    }

    public void deleteAppView(String appCode, String filePath) {
        try {
            List<String> lines = Files.readAllLines(Paths.get(filePath, new String[0]));
            List filteredLines = lines.stream().filter(line -> !line.contains(appCode)).collect(Collectors.toList());
            Files.write(Paths.get(filePath, new String[0]), filteredLines, new OpenOption[0]);
            System.out.println("File view.js successfully.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeDependencyAndModule(String appCode, String pomPath) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document pomDocument = builder.parse(new File(pomPath));
            NodeList dependencies = pomDocument.getElementsByTagName("dependency");
            for (int i = dependencies.getLength() - 1; i >= 0; --i) {
                Node dependencyNode = dependencies.item(i);
                if (!this.isDependencyForAppCode(dependencyNode, appCode)) continue;
                dependencyNode.getParentNode().removeChild(dependencyNode);
            }
            NodeList modules = pomDocument.getElementsByTagName("module");
            for (int i = modules.getLength() - 1; i >= 0; --i) {
                Node moduleNode = modules.item(i);
                if (!moduleNode.getTextContent().equals(appCode)) continue;
                moduleNode.getParentNode().removeChild(moduleNode);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(pomDocument);
            StreamResult result = new StreamResult(new File(pomPath));
            transformer.transform(source, result);
            System.out.println("Removed dependency and module for appCode '" + appCode + "' in pom file at " + pomPath);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new RuntimeException("Failed to edit pom file", e);
        }
    }

    private boolean isDependencyForAppCode(Node dependencyNode, String appCode) {
        Element dependencyElement = (Element)dependencyNode;
        NodeList artifactIdNodes = dependencyElement.getElementsByTagName("artifactId");
        if (artifactIdNodes.getLength() == 1) {
            Node artifactIdNode = artifactIdNodes.item(0);
            return artifactIdNode.getTextContent().equals(appCode);
        }
        return false;
    }

    private void deleteAllAppRelatedTableData(SysApplication sysApplication) {
        Long appId = sysApplication.getId();
        this.sysApplicationService.removeById((Serializable)appId);
        List sysResources = this.sysResourcesService.list((Wrapper)new LambdaQueryWrapper().eq(SysResources::getApplicationId, (Object)appId));
        List resourceIds = sysResources.stream().map(SysResources::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(resourceIds)) {
            this.sysResourcesService.removeByIds(resourceIds);
        }
        this.sysResourceModulesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getApplicationId, (Object)appId));
        List sysFunctions = this.sysFunctionsService.list((Wrapper)new LambdaQueryWrapper().eq(SysFunctions::getApplicationId, (Object)appId));
        List functionIds = sysFunctions.stream().map(SysFunctions::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(functionIds)) {
            this.sysFunctionsService.removeByIds(functionIds);
            this.sysFunctionResourcesService.remove((Wrapper)new LambdaQueryWrapper().in(SysFunctionResources::getFunctionId, functionIds));
            this.sysMenuService.remove((Wrapper)new LambdaQueryWrapper().in(SysMenu::getFunctionId, functionIds));
        }
        List functionModules = this.sysFunctionModulesService.list((Wrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getApplicationId, (Object)appId));
        List functionModulesIds = functionModules.stream().map(SysFunctionModules::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty((Object)functionModules)) {
            this.sysFunctionModulesService.removeByIds(functionModulesIds);
            this.sysMenuService.remove((Wrapper)new LambdaQueryWrapper().in(SysMenu::getFunctionModuleId, functionModulesIds));
        }
        this.sysMenuService.deleteMenus(String.valueOf(appId));
        List sysRoles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getAppId, (Object)appId));
        List roleIds = sysRoles.stream().map(SysRoles::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(roleIds)) {
            this.sysRolesService.removeByIds(roleIds);
            this.sysRoleResourceService.remove((Wrapper)new LambdaQueryWrapper().in(SysRoleResource::getRoleId, roleIds));
            this.sysRoleFunctionsService.remove((Wrapper)new LambdaQueryWrapper().in(SysRoleFunctions::getRoleId, roleIds));
        }
        this.sysRoleGroupService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getAppId, (Object)appId));
        this.sysCodeRuleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysCodeRule::getAppId, (Object)appId));
        this.sysDicTypeService.remove((Wrapper)new LambdaQueryWrapper().eq(DicType::getAppId, (Object)appId));
        this.sysDicSingleService.remove((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getAppId, (Object)appId));
        this.dicGroupService.remove((Wrapper)new LambdaQueryWrapper().eq(DicGroup::getAppId, (Object)appId));
    }

    private void initFormDesignServer(SysApplication app, String tenantCode) {
        String appCode = app.getAppCode();
        String envPath = this.TENANT_PATH + this.TEMPLATE_BACK;
        envPath = envPath.replace("{tenantCode}", tenantCode);
        String serverPath = envPath + File.separator + appCode;
        File dir = new File(serverPath);
        dir.mkdirs();
        String frontPath = this.TENANT_PATH + this.TEMPLATE_FRONT;
        String frontServerPath = frontPath.replace("{tenantCode}", tenantCode);
        frontServerPath = frontServerPath + File.separator + "apps" + File.separator + appCode;
        File frontDir = new File(frontServerPath);
        frontDir.mkdirs();
        String templateDir = this.TEMPLATE_FILE_PATH + this.TEMPLATE_BACK + File.separator + "${appCode}";
        String frontTemplateDir = this.TEMPLATE_FILE_PATH + this.TEMPLATE_FRONT + File.separator + "apps" + File.separator + "${appCode}";
        String placeholder = "${appCode}";
        try {
            File src = new File(templateDir);
            File frontTemplate = new File(frontTemplateDir);
            this.copyFolder(frontTemplate, frontDir);
            this.copyFolder(src, dir);
            this.renameFilesAndDirectories(Paths.get(serverPath, new String[0]), placeholder, appCode);
            this.renameFilesAndDirectories(Paths.get(frontServerPath, new String[0]), placeholder, appCode);
        }
        catch (IOException e) {
            logger.info("\u590d\u5236\u6587\u4ef6\u51fa\u9519:{}", (Object)e.getMessage());
        }
        this.replaceAppCodeInFiles(serverPath, placeholder, appCode);
        this.replaceAppCodeInFiles(serverPath, "${tenantCode}", tenantCode);
        this.replaceAppCodeInFiles(frontServerPath + File.separator + "package.json", placeholder, appCode);
        String appCodeLower = appCode.toLowerCase();
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(File.separator).append("${appCode}-server").append(File.separator).append("src").append(File.separator).append("main").append(File.separator).append("java").append(File.separator).append("com").append(File.separator).append("jxdinfo").append(File.separator).append("hussar").append(File.separator).append("cloud").append(File.separator).append("module");
        String longPath = pathBuilder.toString();
        StringBuilder pathBuilder2 = new StringBuilder();
        pathBuilder2.append(File.separator).append("${appCode}-server").append(File.separator).append("src").append(File.separator).append("main").append(File.separator).append("resources").append(File.separator).append("META-INF").append(File.separator).append("spring.factories");
        String longPath2 = pathBuilder2.toString();
        String modulePathServer = (serverPath + longPath).replace("${appCode}", appCode);
        String springPath = (serverPath + longPath2).replace("${appCode}", appCode);
        this.replaceAppCodeInFiles(springPath, appCode, appCodeLower);
        this.replaceAppCodeInFiles(modulePathServer + File.separator + appCode, appCode, appCodeLower);
        this.processFile(Paths.get(modulePathServer + File.separator + appCode, new String[0]), appCode, "${appCode}");
        this.processFile(Paths.get(modulePathServer + File.separator + "${appCode}", new String[0]), "${appCode}", appCodeLower);
        String modulePathFeign = (serverPath + longPath.replace("server", "feign")).replace("${appCode}", appCode);
        this.replaceAppCodeInFiles(modulePathFeign + File.separator + appCode, appCode, appCodeLower);
        this.processFile(Paths.get(modulePathFeign + File.separator + appCode, new String[0]), appCode, "${appCode}");
        this.processFile(Paths.get(modulePathFeign + File.separator + "${appCode}", new String[0]), "${appCode}", appCodeLower);
        frontPath = frontPath + this.FRONT_START_MODULE + File.separator + "package.json";
        frontPath = frontPath.replace("{tenantCode}", tenantCode);
        try {
            this.addDependencyToPackageJson(frontPath, appCode, "1.0.0-alpha.1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String viewJsPath = this.TENANT_PATH + this.TEMPLATE_FRONT + this.FRONT_START_MODULE + File.separator + "src" + File.separator + "views" + File.separator + "views.js";
        viewJsPath = viewJsPath.replace("{tenantCode}", tenantCode);
        this.insertAppView(appCode, viewJsPath);
        String workSpacePomPath = envPath + File.separator + "pom.xml";
        String pomVersion = this.getPomVersion(workSpacePomPath);
        Map<String, String> contentMap = this.getPomContent(pomVersion, appCode);
        this.updatePomContent(workSpacePomPath, contentMap.get("depen"), DEPEN_TAG);
        this.updatePomContent(workSpacePomPath, contentMap.get("module"), MODULE_TAG);
    }

    public void insertAppView(String appCode, String jsFilePath) {
        try (BufferedReader reader = new BufferedReader(new FileReader(jsFilePath));){
            int endIndex;
            String line;
            StringBuilder sb = new StringBuilder();
            sb.append("import { allViews as ").append(appCode).append(" } from '").append(appCode).append("';\n\n");
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            int exportIndex = sb.indexOf("export default {");
            if (exportIndex != -1) {
                endIndex = sb.indexOf("}", exportIndex);
                if (endIndex == -1) {
                    throw new RuntimeException("Cannot find closing brace for export default object.");
                }
            } else {
                throw new RuntimeException("Cannot find export default statement in the file.");
            }
            sb.insert(endIndex - 1, "\n  ..." + appCode + ",");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(jsFilePath));){
                writer.write(sb.toString());
            }
            System.out.println("File updated successfully.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addDependencyToPackageJson(String packageJsonFilePath, String appCode, String version) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode root = objectMapper.readTree(new File(packageJsonFilePath));
        JsonNode dependenciesNode = root.get("dependencies");
        if (dependenciesNode == null || !dependenciesNode.isObject()) {
            ((ObjectNode)root).put("dependencies", (JsonNode)objectMapper.createObjectNode());
            dependenciesNode = root.get("dependencies");
        }
        ((ObjectNode)dependenciesNode).put(appCode, version);
        objectMapper.writerWithDefaultPrettyPrinter().writeValue(new File(packageJsonFilePath), (Object)root);
    }

    public void deleteDependencyFromPackageJson(String packageJsonFilePath, String appCode) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode root = objectMapper.readTree(new File(packageJsonFilePath));
        JsonNode dependenciesNode = root.get("dependencies");
        if (dependenciesNode == null || !dependenciesNode.isObject()) {
            ((ObjectNode)root).put("dependencies", (JsonNode)objectMapper.createObjectNode());
            dependenciesNode = root.get("dependencies");
        }
        ((ObjectNode)dependenciesNode).remove(appCode);
        objectMapper.writerWithDefaultPrettyPrinter().writeValue(new File(packageJsonFilePath), (Object)root);
    }

    public void copyFolder(File src, File des) throws IOException {
        if (src.isDirectory()) {
            if (!des.exists()) {
                des.mkdir();
            }
            String[] children = src.list();
            assert (children != null);
            for (String child : children) {
                this.copyFolder(new File(src, child), new File(des, child));
            }
        } else {
            TenantApplicationServiceImpl.copyFile(src, des);
        }
    }

    private static void copyFile(File src, File des) throws IOException {
        try (InputStream in = Files.newInputStream(src.toPath(), new OpenOption[0]);
             OutputStream out = Files.newOutputStream(des.toPath(), new OpenOption[0]);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
        }
    }

    private void renameFilesAndDirectories(Path directory, String placeholder, String appCode) {
        try (Stream<Path> files = Files.list(directory);){
            files.forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    path = this.processFile((Path)path, placeholder, appCode);
                    this.renameFilesAndDirectories((Path)path, placeholder, appCode);
                } else {
                    this.processFile((Path)path, placeholder, appCode);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Path processFile(Path file, String placeholder, String replacement) {
        String newName;
        String oldName = file.getFileName().toString();
        Pattern pattern = Pattern.compile(Pattern.quote(placeholder));
        Matcher matcher = pattern.matcher(oldName);
        if (matcher.find() && !oldName.equals(newName = matcher.replaceAll(Matcher.quoteReplacement(replacement)))) {
            Path newPath = file.getParent().resolve(newName);
            try {
                Files.move(file, newPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to rename file: " + file, e);
            }
            System.out.println("Renamed: " + oldName + " to " + newName);
            return newPath;
        }
        return file;
    }

    public void replaceAppCodeInFiles(String directoryPath, final String placeholder, final String appCode) {
        Path directory = Paths.get(directoryPath, new String[0]);
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        String content = new String(Files.readAllBytes(file));
                        String newContent = content.replace(placeholder, appCode);
                        if (!content.equals(newContent)) {
                            Files.write(file, newContent.getBytes(), new OpenOption[0]);
                            System.out.println("Updated file: " + file);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updatePomContent(String pomPath, String content, String tag) {
        try {
            String line;
            File file = new File(pomPath);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.contains(tag)) {
                    stringBuilder.append(content).append("\n");
                }
                stringBuilder.append(line).append("\n");
            }
            reader.close();
            FileWriter writer = new FileWriter(file);
            writer.write(stringBuilder.toString());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> getPomContent(String version, String appCode) {
        HashMap xmlContentMap = Maps.newHashMap();
        String dependencyContent = "<dependency>\n            <groupId>com.jxdinfo.hussar.cloud." + appCode + "</groupId>\n            <artifactId>" + appCode + "</artifactId>\n            <version>" + version + "</version>\n        </dependency>";
        xmlContentMap.put("depen", dependencyContent);
        String moduleContent = "<module>" + appCode + "</module>";
        xmlContentMap.put("module", moduleContent);
        return xmlContentMap;
    }

    private String getPomVersion(String path) {
        try {
            File pomFile = new File(path);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(pomFile);
            doc.getDocumentElement().normalize();
            NodeList versionList = doc.getElementsByTagName("version");
            String version = versionList.item(0).getTextContent();
            System.out.println("POM Version: " + version);
            return version;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public String exportAppData(Long recordId, Long appId, HttpServletResponse response) {
        String exportCacheKey;
        if (appId == null) {
            throw new BaseException("\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String tenantCode = user.getTenantCode();
        String appCode = ((SysApplication)this.sysApplicationService.getById((Serializable)appId)).getAppCode();
        String branch = user.getAccount();
        ProgressCacheAspect.EXPORT_CACHE_KEY = "app_export_Progress";
        ProgressCacheAspect.EXPORT_CACHE_KEY = exportCacheKey = ProgressCacheAspect.EXPORT_CACHE_KEY + "_" + recordId;
        TransmittableThreadLocalHolder.set((String)"exportCacheKey", (Object)exportCacheKey);
        HussarCacheUtil.put((String)"app_export_Progress", (Object)ProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)1, (String)"", (Long)0L, (boolean)false));
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            IHussarApplicationService sysMenuManageService = (IHussarApplicationService)SpringContextHolder.getBean(IHussarApplicationService.class);
            sysMenuManageService.exportAppData(recordId, appId, tenantCode, branch, userId, appCode, response);
        });
        return exportCacheKey;
    }

    private Map<String, Object> getAppmetaHussarData(Long recordId) {
        SysApplicationRecord record = (SysApplicationRecord)this.sysApplicationRecordService.getById((Serializable)recordId);
        HashMap<String, Object> appmetaMap = new HashMap<String, Object>();
        appmetaMap.put("password", record.getRecordFilePassword());
        Long appId = record.getAppId();
        SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
        appmetaMap.put("appId", appId);
        appmetaMap.put("appCode", application.getAppCode());
        appmetaMap.put("appName", application.getAppName());
        appmetaMap.put("appGroup", application.getAppGroupId());
        appmetaMap.put("appIcon", application.getAppIcon());
        appmetaMap.put("appIconColor", application.getAppIconColor());
        appmetaMap.put("appIconType", application.getAppIconType());
        appmetaMap.put("appType", application.getAppType());
        return appmetaMap;
    }

    @ExportProgressCache(status=1, msg="\u6b63\u5728\u83b7\u53d6\u5e94\u7528\u57fa\u7840\u4fe1\u606f")
    private Map<String, Object> getHussarData(Long appId) {
        SysMenu appMenuModule;
        HussarCacheUtil.put((String)"app_export_Progress", (Object)ProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)1, (String)"\u6b63\u5728\u83b7\u53d6\u5e94\u7528\u57fa\u7840\u4fe1\u606f", (Long)0L, (boolean)false));
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)appId));
        List sysFunctions = this.sysFunctionsService.list((Wrapper)new LambdaQueryWrapper().eq(SysFunctions::getApplicationId, (Object)appId));
        List sysFunctionModules = this.sysFunctionModulesService.list((Wrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getApplicationId, (Object)appId));
        List sysResources = this.sysResourcesService.list((Wrapper)new LambdaQueryWrapper().eq(SysResources::getApplicationId, (Object)appId));
        List sysResourceModules = this.sysResourceModulesService.list((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getApplicationId, (Object)appId));
        List functionIds = sysFunctions.stream().map(SysFunctions::getId).collect(Collectors.toList());
        List resourceIds = sysResources.stream().map(SysResources::getId).collect(Collectors.toList());
        List sysFunctionResources = Lists.newArrayList();
        if (functionIds.size() > 0 && resourceIds.size() > 0) {
            sysFunctionResources = this.sysFunctionResourcesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysFunctionResources::getFunctionId, functionIds)).in(SysFunctionResources::getResourceId, resourceIds));
        }
        List sysRoles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getAppId, (Object)appId));
        List roleIds = sysRoles.stream().map(SysRoles::getId).collect(Collectors.toList());
        List sysRoleFunctions = Lists.newArrayList();
        if (roleIds.size() > 0 && functionIds.size() > 0) {
            sysRoleFunctions = this.sysRoleFunctionsService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysRoleFunctions::getRoleId, roleIds)).in(SysRoleFunctions::getFunctionId, functionIds));
        }
        List sysRoleResources = Lists.newArrayList();
        if (roleIds.size() > 0 && resourceIds.size() > 0) {
            sysRoleResources = this.sysRoleResourceService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysRoleResource::getRoleId, roleIds)).in(SysRoleResource::getResourceId, resourceIds));
        }
        SysRoleGroup sysRoleGroup = (SysRoleGroup)this.roleGroupService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getAppId, (Object)appId));
        List sysCodeRules = this.sysCodeRuleService.list((Wrapper)new LambdaQueryWrapper().eq(SysCodeRule::getAppId, (Object)appId));
        List sysDictTypes = this.sysDicTypeService.list((Wrapper)new LambdaQueryWrapper().eq(DicType::getAppId, (Object)appId));
        List sysDictSingles = this.sysDicSingleService.list((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getAppId, (Object)appId));
        List sysDictGroups = this.dicGroupService.list((Wrapper)new LambdaQueryWrapper().eq(DicGroup::getAppId, (Object)appId));
        List<Object> functionsIds = new ArrayList();
        List<Object> sysMenus = new ArrayList<SysMenu>();
        if (sysFunctions.size() > 0) {
            functionsIds = sysFunctions.stream().map(SysFunctions::getId).collect(Collectors.toList());
            sysMenus = this.sysMenuService.list((Wrapper)new LambdaQueryWrapper().in(SysMenu::getFunctionId, functionsIds));
        }
        if (HussarUtils.isNotEmpty((Object)(appMenuModule = (SysMenu)this.sysMenuService.getById((Serializable)appId)))) {
            sysMenus.add(appMenuModule);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sysApplication", sysApplication);
        data.put("sysFunctions", sysFunctions);
        data.put("sysFunctionModules", sysFunctionModules);
        data.put("sysResources", sysResources);
        data.put("sysResourceModules", sysResourceModules);
        data.put("sysFunctionResources", sysFunctionResources);
        data.put("sysRoles", sysRoles);
        data.put("sysRoleFunctions", sysRoleFunctions);
        data.put("sysRoleResources", sysRoleResources);
        data.put("sysRoleGroup", sysRoleGroup);
        data.put("sysCodeRules", sysCodeRules);
        data.put("sysDictTypes", sysDictTypes);
        data.put("sysDictSingles", sysDictSingles);
        data.put("sysDictGroups", sysDictGroups);
        data.put("sysMenus", sysMenus);
        data.put("export_type", "app");
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportProgressCache(status=2, msg="\u6b63\u5728\u5bfc\u51fa\u5e94\u7528\u57fa\u7840\u4fe1\u606f\u52a0\u5bc6\u6587\u4ef6")
    private String makeHussarFile(Map<String, Object> data) throws Exception {
        HussarCacheUtil.put((String)"app_export_Progress", (Object)ProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)2, (String)"\u6b63\u5728\u5bfc\u51fa\u5e94\u7528\u57fa\u7840\u4fe1\u606f\u52a0\u5bc6\u6587\u4ef6", (Long)0L, (boolean)false));
        byte[] serializeData = new byte[]{};
        serializeData = SerializeUtils.serialize(data);
        String newFileName = DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        HussarConfig hussarConfig = (HussarConfig)SpringContextHolder.getBean(HussarConfig.class);
        String filePath = hussarConfig.getFileUploadPath() + newFileName;
        File file = new File(filePath);
        File path = file.getParentFile();
        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(serializeData));
             FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream output = new BufferedOutputStream(fos);){
            if (!path.exists()) {
                logger.info("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u3002path={}", (Object)path);
                boolean isCreated = path.mkdirs();
                if (!isCreated) {
                    logger.error("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff0cpath={}", (Object)path);
                }
            }
            byte[] buffer = new byte[1024];
            int length = bis.read(buffer);
            while (length != -1) {
                output.write(buffer, 0, length);
                length = bis.read(buffer);
            }
            output.flush();
        }
        catch (Exception e) {
            logger.error("\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath={}", (Object)filePath, (Object)e);
        }
        return file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeAppmetaHussarFile(Map<String, Object> data) throws Exception {
        byte[] serializeData = new byte[]{};
        serializeData = SerializeUtils.serialize(data);
        String newFileName = DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".appmeta";
        HussarConfig hussarConfig = (HussarConfig)SpringContextHolder.getBean(HussarConfig.class);
        String filePath = hussarConfig.getFileUploadPath() + newFileName;
        File file = new File(filePath);
        File path = file.getParentFile();
        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(serializeData));
             FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream output = new BufferedOutputStream(fos);){
            if (!path.exists()) {
                logger.info("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u3002path={}", (Object)path);
                boolean isCreated = path.mkdirs();
                if (!isCreated) {
                    logger.error("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff0cpath={}", (Object)path);
                }
            }
            byte[] buffer = new byte[1024];
            int length = bis.read(buffer);
            while (length != -1) {
                output.write(buffer, 0, length);
                length = bis.read(buffer);
            }
            output.flush();
        }
        catch (Exception e) {
            logger.error("\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath={}", (Object)filePath, (Object)e);
        }
        return file.getPath();
    }

    @ExportProgressCache(status=3, msg="\u6b63\u5728\u83b7\u53d6\u5e94\u7528\u4ee3\u7801")
    private ApiResponse<String> pullFileToLocal(String branch, String localGitFilePath, String tenantCode, Long userId) {
        try {
            HussarCacheUtil.put((String)"app_export_Progress", (Object)ProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)3, (String)"\u6b63\u5728\u83b7\u53d6\u5e94\u7528\u4ee3\u7801", (Long)0L, (boolean)false));
            HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
            DeployGitDto gitDto = new DeployGitDto();
            gitDto.setAccessToken(tenant.getGitToken());
            gitDto.setGitUri(tenant.getGitUrl());
            gitDto.setTenantCode(tenantCode);
            gitDto.setBranch(branch);
            gitDto.setUserId(userId);
            ApiResponse response = GitlabUtil.branchExist((GitDto)gitDto);
            if (!((Boolean)response.getData()).booleanValue()) {
                String refName = this.branch;
                gitDto.setRefName(refName);
                GitlabUtil.createRemoteBranch((GitDto)gitDto);
            }
            gitDto.setSourceBranch("develop");
            gitDto.setTargetBranch(branch);
            gitDto.setTitle("\u5c06develop\u5408\u5e76\u5230\u4e2a\u4eba\u5206\u652f");
            try {
                logger.info("\u5c06develop\u5408\u5e76\u5230\u4e2a\u4eba\u5206\u652f");
                ApiResponse remoteMergeResponse = GitlabUtil.remoteMerge((GitDto)gitDto);
                System.out.println("-------------------------------------remoteMergeResponse = " + remoteMergeResponse.getData());
            }
            catch (Exception e) {
                logger.info("\u5c06develop\u5408\u5e76\u5230\u4e2a\u4eba\u5206\u652f\u5931\u8d25:{}", (Object)e.getMessage());
            }
            gitDto.setPath(localGitFilePath);
            ApiResponse pullResponse = GitlabUtil.pullToLocal((GitDto)gitDto);
            if (!pullResponse.isSuccess()) {
                throw new BaseException("git\u62c9\u53d6\u5931\u8d25");
            }
            return pullResponse;
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }

    @ExportProgressCache(status=4, msg="\u6b63\u5728\u5236\u4f5c\u538b\u7f29\u5305\u6587\u4ef6")
    private String makeAppDataZip(String appCode, String zipParentPath, String appmetaHussarFilePath, String hussarFilePath, String appFrontCodePath, String appBackCodePath, String appBackWebMainPath) throws Exception {
        HussarCacheUtil.put((String)"app_export_Progress", (Object)ProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)4, (String)"\u6b63\u5728\u5236\u4f5c\u538b\u7f29\u5305\u6587\u4ef6", (Long)0L, (boolean)false));
        String zipNewFolderName = appCode + "-Folder";
        Path parentPath = Paths.get(zipParentPath, new String[0]);
        Path zipNewFolderPath = parentPath.resolve(zipNewFolderName);
        try {
            Files.createDirectories(zipNewFolderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BaseException("\u521b\u5efa\u6587\u4ef6\u5939\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
        }
        if (zipNewFolderPath != null) {
            Path appmetaPath = Paths.get(appmetaHussarFilePath, new String[0]);
            Path appmetaTargetPath = zipNewFolderPath.resolve(appmetaPath.getFileName());
            Path hussarPath = Paths.get(hussarFilePath, new String[0]);
            Path hussarTargetPath = zipNewFolderPath.resolve(hussarPath.getFileName());
            try {
                Files.copy(appmetaPath, appmetaTargetPath, StandardCopyOption.REPLACE_EXISTING);
                Files.copy(hussarPath, hussarTargetPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new BaseException("\u590d\u5236\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
            }
        }
        String gitFolderName = "gitFolder";
        Path gitFolderPath = zipNewFolderPath.resolve(gitFolderName);
        try {
            Files.createDirectories(gitFolderPath, new FileAttribute[0]);
            Path appFrontPath = gitFolderPath.resolve(appCode + "-front");
            Files.createDirectories(appFrontPath, new FileAttribute[0]);
            Path appWebPath = gitFolderPath.resolve(appCode + "-web");
            Files.createDirectories(appWebPath, new FileAttribute[0]);
            String appWebMainFolderName = "web-main";
            Path appWebMainFolderPath = appWebPath.resolve(appWebMainFolderName);
            Files.createDirectories(appWebMainFolderPath, new FileAttribute[0]);
            TenantApplicationServiceImpl.copyDirectory(Paths.get(appBackWebMainPath, new String[0]), appWebMainFolderPath);
            String hussarCloudModuleFolderName = appCode;
            Path hussarCloudModuleFolderPath = appWebPath.resolve(hussarCloudModuleFolderName);
            Files.createDirectories(hussarCloudModuleFolderPath, new FileAttribute[0]);
            TenantApplicationServiceImpl.copyDirectory(Paths.get(appBackCodePath, new String[0]), hussarCloudModuleFolderPath);
            String frontFolderName = appCode;
            Path frontFolderPath = appFrontPath.resolve(frontFolderName);
            Files.createDirectories(frontFolderPath, new FileAttribute[0]);
            TenantApplicationServiceImpl.copyDirectory(Paths.get(appFrontCodePath, new String[0]), frontFolderPath);
        }
        catch (IOException e) {
            throw new BaseException(e.getMessage());
        }
        Path zipPath = this.zipDirectory(zipNewFolderPath);
        return zipPath.toString();
    }

    private static void copyDirectory(final Path source, final Path dest) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(dest.resolve(source.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, dest.resolve(source.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public Path zipDirectory(Path sourceFolderPath) {
        if (!Files.exists(sourceFolderPath, new LinkOption[0]) || !Files.isDirectory(sourceFolderPath, new LinkOption[0])) {
            throw new IllegalArgumentException("\u6e90\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff01");
        }
        Path parentDir = sourceFolderPath.getParent();
        if (parentDir == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u83b7\u53d6\u6e90\u6587\u4ef6\u5939\u7684\u7236\u76ee\u5f55\uff01");
        }
        String zipFileName = sourceFolderPath.getFileName().toString() + ".zip";
        Path zipFilePath = parentDir.resolve(zipFileName);
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zipFilePath, new OpenOption[0]));){
            this.zipFolder(sourceFolderPath, "", zos);
        }
        catch (IOException e) {
            throw new RuntimeException("\u538b\u7f29\u6587\u4ef6\u5939\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage(), e);
        }
        return zipFilePath;
    }

    private void zipFolder(Path folder, String prefix, ZipOutputStream zos) throws IOException {
        Files.walk(folder, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
            try {
                Path relativePath = folder.relativize((Path)path);
                String entryName = prefix + relativePath.toString();
                ZipEntry zipEntry = new ZipEntry(entryName);
                zos.putNextEntry(zipEntry);
                byte[] buffer = new byte[1024];
                try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);){
                    int length;
                    while ((length = fis.read(buffer)) >= 0) {
                        zos.write(buffer, 0, length);
                    }
                }
                zos.closeEntry();
            }
            catch (IOException e) {
                throw new RuntimeException("\u5904\u7406\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage(), e);
            }
        });
    }

    public void downloadAppExportFile(Long fileId, HttpServletResponse response) {
        ApiResponse apiResponse = this.ossService.backgroundDownload(fileId);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysApplicationRecord::getRecordFileId, (Object)fileId);
        SysApplicationRecord sysApplicationRecord = (SysApplicationRecord)this.sysApplicationRecordService.getOne((Wrapper)wrapper);
        if (apiResponse == null || !apiResponse.isSuccess()) {
            throw new BaseException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01");
        }
        try (ServletOutputStream os = response.getOutputStream();){
            String fileName = sysApplicationRecord.getRecordFileName();
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart" + File.separator + "form-data");
            IOUtils.write((byte[])((byte[])apiResponse.getData()), (OutputStream)os);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, Object> unpackImportFile(MultipartFile file) {
        String zipFileName = file.getOriginalFilename();
        if (!zipFileName.endsWith(".zip")) {
            throw new BaseException("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u4e0d\u5bf9\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u538b\u7f29\u6587\u4ef6\uff01");
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String importZipFileInTempPath = null;
        try {
            Path filePath = Paths.get(tempDir, zipFileName);
            File uploadFile = filePath.toFile();
            Files.copy(file.getInputStream(), filePath, StandardCopyOption.REPLACE_EXISTING);
            importZipFileInTempPath = uploadFile.getAbsolutePath();
            String parentFolderPath = uploadFile.getParent();
            String newFolderName = zipFileName.substring(0, zipFileName.lastIndexOf(46));
            Path parentFolder = Paths.get(parentFolderPath, new String[0]);
            Path newFolder = parentFolder.resolve(newFolderName);
            try {
                Files.createDirectories(newFolder, new FileAttribute[0]);
                System.out.println("\u89e3\u538b\u6587\u4ef6\u5939\u5df2\u6210\u529f\u521b\u5efa\u5728: " + newFolder.toAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("\u521b\u5efa\u6587\u4ef6\u5939\u65f6\u51fa\u9519");
            }
            String newFolderPath = newFolder.toString() + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss");
            Map<String, String> filePaths = this.unzip(importZipFileInTempPath, newFolderPath);
            String appmetaHussarFilePath = filePaths.get(".appmeta");
            String hussarFilePath = filePaths.get(".hussar");
            String appCodeFilePath = filePaths.get("gitFolder");
            if (HussarUtils.isEmpty((Object)appmetaHussarFilePath) || HussarUtils.isEmpty((Object)hussarFilePath) || HussarUtils.isEmpty((Object)appCodeFilePath)) {
                throw new BaseException("\u5bfc\u5165\u6587\u4ef6\u9519\u8bef\uff0c\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e\u6587\u4ef6");
            }
            Map<String, Object> appmetaData = this.analyzeFileData(appmetaHussarFilePath);
            String password = (String)appmetaData.get("password");
            if (HussarUtils.isEmpty((Object)password)) {
                resultMap.put("encryptFlag", false);
            } else {
                resultMap.put("encryptFlag", true);
            }
            Long appId = (Long)appmetaData.get("appId");
            SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
            SysAppRecycle sysAppRecycle = (SysAppRecycle)this.sysAppRecycleService.getById((Serializable)appId);
            if (HussarUtils.isNotEmpty((Object)application) || HussarUtils.isNotEmpty((Object)sysAppRecycle)) {
                resultMap.put("existFlag", true);
            } else {
                resultMap.put("existFlag", false);
            }
            resultMap.put("inputFileName", file.getOriginalFilename());
            resultMap.put("appId", appmetaData.get("appId"));
            resultMap.put("appCode", appmetaData.get("appCode"));
            resultMap.put("appName", appmetaData.get("appName"));
            resultMap.put("appGroup", appmetaData.get("appGroup"));
            resultMap.put("appIcon", appmetaData.get("appIcon"));
            resultMap.put("appIconColor", appmetaData.get("appIconColor"));
            resultMap.put("appIconType", appmetaData.get("appIconType"));
            resultMap.put("appmetaHussarFilePath", appmetaHussarFilePath);
            resultMap.put("hussarFilePath", hussarFilePath);
            resultMap.put("appCodeFilePath", appCodeFilePath);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        return resultMap;
    }

    public Boolean checkAppImportPassword(String password, String appmetaHussarFilePath) {
        if (HussarUtils.isEmpty((Object)password) || HussarUtils.isEmpty((Object)appmetaHussarFilePath)) {
            throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Map<String, Object> appmetaData = this.analyzeFileData(appmetaHussarFilePath);
            String appmetaPassword = (String)appmetaData.get("password");
            if (password.equals(appmetaPassword)) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String importAppData(MultipartFile file, String fileName, String filePassword, String hussarFilePath, String appCodeFilePath, Boolean ifExist, Long appId, String appCode, Long appGroupId, String appIconType, String appIconColor, String appIcon, Long recordId) {
        String importCacheKey;
        Long userId = HussarSecurityUtils.getLoginUserDetails().getUserId();
        try {
            InputStream input = file.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ApiResponse fileResponse = this.ossService.backgroundUpload(file);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        SysApplicationRecord record = new SysApplicationRecord();
        record.setRecordId(recordId);
        record.setRecordFileName(fileName);
        if (HussarUtils.isNotBlank((CharSequence)filePassword)) {
            record.setRecordFilePassword(filePassword);
        }
        record.setRecordStatus("1");
        record.setRecordFileId((Long)fileResponse.getData());
        this.sysApplicationRecordService.updateById((Object)record);
        SecurityUser user = BaseSecurityUtil.getUser();
        String branch = "develop";
        ProgressCacheAspect.IMPORT_CACHE_KEY = "app_import_Progress";
        ProgressCacheAspect.IMPORT_CACHE_KEY = importCacheKey = ProgressCacheAspect.IMPORT_CACHE_KEY + "_" + recordId;
        TransmittableThreadLocalHolder.set((String)"importCacheKey", (Object)importCacheKey);
        HussarCacheUtil.put((String)"app_import_progress", (Object)ProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)1, (String)"\u5f00\u59cb\u5bfc\u5165", (boolean)false, (boolean)false));
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            IHussarApplicationService sysMenuManageService = (IHussarApplicationService)SpringContextHolder.getBean(IHussarApplicationService.class);
            sysMenuManageService.importAppFileData(ifExist, appId, appCode, appGroupId, appIconType, appIconColor, appIcon, tenantCode, record, hussarFilePath, appCodeFilePath, branch, userId);
        });
        return importCacheKey;
    }

    public void importAppFileData(Boolean ifExist, Long appId, String appCode, Long newAppGroupId, String appIconType, String appIconColor, String appIcon, String tenantCode, SysApplicationRecord record, String hussarFilePath, String appCodeFilePath, String branch, Long userId) {
        try {
            Map<String, Object> hussarData = this.analyzeHussarFileData(hussarFilePath);
            this.importHussarData(ifExist, appId, hussarData, newAppGroupId, appIconType, appIconColor, appIcon, userId);
            this.pushCodeFileToGit(branch, "\u5e94\u7528\u5bfc\u5165", appCodeFilePath, tenantCode, appCode, userId);
            HussarCacheUtil.put((String)"app_import_progress", (Object)ProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)5, (String)"\u5bfc\u5165\u5b8c\u6210", (boolean)true, (boolean)false));
            record.setRecordStatus("2");
            this.sysApplicationRecordService.updateById((Object)record);
        }
        catch (Exception e) {
            HussarCacheUtil.put((String)"app_import_progress", (Object)ProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)0, (String)("\u5bfc\u5165\u5f02\u5e38" + e.getMessage()), (boolean)true, (boolean)true));
            record.setRecordStatus("3");
            this.sysApplicationRecordService.updateById((Object)record);
            throw new BaseException((Throwable)e);
        }
        finally {
            try {
                this.deleteDirectory(new File(hussarFilePath).getParent());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @ImportProgressCache(status=2, msg="\u6b63\u5728\u89e3\u6790\u57fa\u7840\u6570\u636e")
    private Map<String, Object> analyzeHussarFileData(String husssarFilePath) {
        HussarCacheUtil.put((String)"app_import_progress", (Object)ProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)2, (String)"\u6b63\u5728\u89e3\u6790\u57fa\u7840\u6570\u636e", (boolean)false, (boolean)false));
        Map<String, Object> data = this.analyzeFileData(husssarFilePath);
        return data;
    }

    @HussarTransactional
    @ImportProgressCache(status=3, msg="\u6b63\u5728\u5bfc\u5165\u57fa\u7840\u6570\u636e")
    private Boolean importHussarData(Boolean ifExist, Long appId, Map<String, Object> data, Long newAppGroupId, String appIconType, String appIconColor, String appIcon, Long userId) {
        HussarCacheUtil.put((String)"app_import_progress", (Object)ProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)3, (String)"\u6b63\u5728\u5bfc\u5165\u57fa\u7840\u6570\u636e", (boolean)false, (boolean)false));
        if (ifExist.booleanValue()) {
            SysAppRecycle sysAppRecycle;
            SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
            if (HussarUtils.isNotEmpty((Object)application)) {
                this.sysApplicationService.deleteApp(appId);
            }
            if (HussarUtils.isNotEmpty((Object)(sysAppRecycle = (SysAppRecycle)this.sysAppRecycleService.getById((Serializable)appId)))) {
                this.sysAppRecycleService.deleteRecycleApp(sysAppRecycle.getId());
            }
        }
        SysApplication sysApplication = (SysApplication)data.get("sysApplication");
        SysApplicationDto applicationDto = new SysApplicationDto();
        BeanUtil.copy((Object)sysApplication, (Object)applicationDto);
        applicationDto.setAppGroupId(newAppGroupId);
        applicationDto.setAppIconType(appIconType);
        applicationDto.setAppIconColor(appIconColor);
        applicationDto.setAppIcon(appIcon);
        applicationDto.setCreator(userId);
        List sysFunctions = (List)data.get("sysFunctions");
        List sysFunctionModules = (List)data.get("sysFunctionModules");
        List sysResources = (List)data.get("sysResources");
        List sysResourceModules = (List)data.get("sysResourceModules");
        List sysFunctionResources = (List)data.get("sysFunctionResources");
        List sysRoles = (List)data.get("sysRoles");
        List sysRoleFunctions = (List)data.get("sysRoleFunctions");
        List sysRoleResources = (List)data.get("sysRoleResources");
        SysRoleGroup roleGroup = (SysRoleGroup)data.get("sysRoleGroup");
        List sysCodeRules = (List)data.get("sysCodeRules");
        List sysDictTypes = (List)data.get("sysDictTypes");
        List sysDictSingles = (List)data.get("sysDictSingles");
        List sysDictGroups = (List)data.get("sysDictGroups");
        List sysMenus = (List)data.get("sysMenus");
        this.sysApplicationService.save((Object)applicationDto);
        this.sysAppOperationLogService.saveAppOperation(appId, "2");
        this.saveApplicationDevelopTeam(applicationDto);
        this.sysResourcesService.saveBatch((Collection)sysResources);
        this.sysResourceModulesService.saveBatch((Collection)sysResourceModules);
        this.sysFunctionsService.saveBatch((Collection)sysFunctions);
        this.sysFunctionModulesService.saveBatch((Collection)sysFunctionModules);
        this.sysFunctionResourcesService.saveBatch((Collection)sysFunctionResources);
        this.sysMenuService.saveBatch((Collection)sysMenus);
        this.sysRolesService.saveBatch((Collection)sysRoles);
        this.sysRoleResourceService.saveBatch((Collection)sysRoleResources);
        this.sysRoleFunctionsService.saveBatch((Collection)sysRoleFunctions);
        this.roleGroupService.save((Object)roleGroup);
        this.sysCodeRuleService.saveBatch((Collection)sysCodeRules);
        this.sysDicTypeService.saveBatch((Collection)sysDictTypes);
        this.sysDicSingleService.saveBatch((Collection)sysDictSingles);
        this.dicGroupService.saveBatch((Collection)sysDictGroups);
        return true;
    }

    private void saveApplicationDevelopTeam(SysApplicationDto sysApplicationDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        Long appId = sysApplicationDto.getId();
        SysAppDevelopTeam team = (SysAppDevelopTeam)this.developTeamService.getOne((Wrapper)wrapper.eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)team)) {
            String teamName = sysApplicationDto.getAppName() + "\u5f00\u53d1\u56e2\u961f";
            AppDevelopTeamDto developTeamDto = new AppDevelopTeamDto();
            developTeamDto.setAppId(appId);
            developTeamDto.setTeamName(teamName);
            ArrayList<Long> userLists = new ArrayList<Long>();
            userLists.add(sysApplicationDto.getCreator());
            developTeamDto.setUserIds(userLists);
            developTeamDto.setOpenTeam(sysApplicationDto.getOpenTeam());
            this.developTeamService.saveAppDevelopTeam(developTeamDto);
        }
    }

    @ImportProgressCache(status=4, msg="\u6b63\u5728\u4e0a\u4f20\u4ee3\u7801\u6587\u4ef6\u5230Git")
    private void pushCodeFileToGit(String branch, String commitMsg, String appCodeFilePath, String tenantCode, String appCode, Long userId) {
        HussarCacheUtil.put((String)"app_import_progress", (Object)ProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)4, (String)"\u6b63\u5728\u4e0a\u4f20\u4ee3\u7801\u6587\u4ef6\u5230Git", (boolean)false, (boolean)false));
        String localRepPath = this.TENANT_PATH;
        localRepPath = localRepPath.replace("{tenantCode}", tenantCode);
        try {
            List<String> dbdFilePaths;
            String appFrontCodePath = localRepPath + File.separator + tenantCode + "-front" + File.separator + "apps" + File.separator + appCode;
            String appBackCodePath = localRepPath + File.separator + tenantCode + "-web" + File.separator + appCode;
            this.deleteFilesInDirectory(appFrontCodePath);
            this.deleteFilesInDirectory(appBackCodePath);
            String pushFrontFolderPath = appCodeFilePath + File.separator + appCode + "-front" + File.separator + appCode;
            String pushBackFolderPath = appCodeFilePath + File.separator + appCode + "-web" + File.separator + appCode;
            this.copyChildrenToFolder(pushFrontFolderPath, appFrontCodePath);
            this.copyChildrenToFolder(pushBackFolderPath, appBackCodePath);
            String frontPath = localRepPath + File.separator + tenantCode + "-front" + File.separator + "front-main" + File.separator + "package.json";
            try {
                this.addDependencyToPackageJson(frontPath, appCode, "1.0.0-alpha.1");
                logger.info("\u524d\u7aef\u6dfb\u52a0\u4f9d\u8d56\u6210\u529f\uff0c\u5730\u5740\uff1a{},\u4f9d\u8d56\u540d\u79f0\uff1a{}", (Object)frontPath, (Object)appCode);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String viewJsPath = localRepPath + File.separator + tenantCode + "-front" + File.separator + "front-main" + File.separator + "src" + File.separator + "views" + File.separator + "views.js";
            this.insertAppView(appCode, viewJsPath);
            String currentDbName = ((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasourceName();
            String projectStorePath = appBackCodePath + File.separator + appCode + "-server" + File.separator + appCode + File.separator + ".project-store";
            File folder = new File(projectStorePath);
            if (folder.exists() && folder.isDirectory() && HussarUtils.isNotEmpty(dbdFilePaths = this.findDbdFiles(projectStorePath))) {
                for (String dbdFilePath : dbdFilePaths) {
                    this.changeDbNameForDataModel(dbdFilePath, currentDbName);
                }
            }
            String pomFilePath = localRepPath + File.separator + tenantCode + "-web" + File.separator + appCode + File.separator + "pom.xml";
            this.changeParentArtifactId(pomFilePath, tenantCode + "-web");
            HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
            DeployGitDto gitDto = new DeployGitDto();
            gitDto.setAccessToken(tenant.getGitToken());
            gitDto.setGitUri(tenant.getGitUrl());
            gitDto.setTenantCode(tenantCode);
            gitDto.setBranch(branch);
            gitDto.setUserId(userId);
            gitDto.setPath(localRepPath);
            gitDto.setCommitMsg(commitMsg);
            GitlabUtil.pushToGit((GitDto)gitDto);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void copyChildrenToFolder(String parentFolderPath, String targetFolderPath) {
        Path sourceDir = Paths.get(parentFolderPath, new String[0]);
        Path targetDir = Paths.get(targetFolderPath, new String[0]);
        try {
            Files.walk(sourceDir, new FileVisitOption[0]).forEach(source -> {
                try {
                    Path targetPath = targetDir.resolve(sourceDir.relativize((Path)source));
                    TenantApplicationServiceImpl.copy(source, targetPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copy(Path source, Path target) throws IOException {
        if (Files.isDirectory(source, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(source);){
                for (Path file : stream) {
                    TenantApplicationServiceImpl.copy(file, target.resolve(source.relativize(file).toString()));
                }
            }
        } else {
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private Map<String, String> unzip(String zipFilePath, String newFolderPath) {
        HashMap<String, String> filePaths = new HashMap<String, String>();
        File newFolder = new File(newFolderPath);
        if (!newFolder.exists()) {
            newFolder.mkdirs();
        }
        try (FileInputStream fis = new FileInputStream(zipFilePath);
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry zipEntry = zis.getNextEntry();
            ArrayList<String> gitFolderFilePaths = new ArrayList<String>();
            while (zipEntry != null) {
                String path = zipEntry.getName();
                CharSequence[] paths = path.split("/|\\\\");
                path = String.join((CharSequence)System.getProperty("file.separator"), paths);
                String filePath = newFolderPath + File.separator + path;
                if (filePath.endsWith(".hussar")) {
                    this.extractFile(zis, filePath);
                    filePaths.put(".hussar", filePath);
                } else if (filePath.endsWith(".appmeta")) {
                    this.extractFile(zis, filePath);
                    filePaths.put(".appmeta", filePath);
                } else {
                    String parentFolderPath = filePath.substring(0, filePath.lastIndexOf(File.separator));
                    this.createParentDirectoriesIfNotExists(parentFolderPath);
                    this.extractFile(zis, filePath);
                    gitFolderFilePaths.add(filePath);
                    System.out.println("\u6dfb\u52a0\u6587\u4ef6\u5939: " + filePath);
                }
                zipEntry = zis.getNextEntry();
            }
            String gitFolderPath = TenantApplicationServiceImpl.findCommonDirectory(gitFolderFilePaths);
            System.out.println("\u5171\u540c\u4e0a\u7ea7\u4e3a: " + gitFolderPath);
            filePaths.put("gitFolder", gitFolderPath);
            zis.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filePaths;
    }

    private void createParentDirectoriesIfNotExists(String folderPath) {
        ArrayList<String> directoryPaths = new ArrayList<String>();
        if (folderPath.endsWith(File.separator)) {
            folderPath = folderPath.substring(0, folderPath.length() - 1);
        }
        File file = new File(folderPath);
        directoryPaths.add(folderPath);
        for (File parentDir = file.getParentFile(); parentDir != null && !parentDir.getAbsolutePath().equals(File.separator); parentDir = parentDir.getParentFile()) {
            directoryPaths.add(parentDir.getAbsolutePath());
        }
        Collections.reverse(directoryPaths);
        for (String path : directoryPaths) {
            File dir = new File(path);
            if (dir.exists()) continue;
            if (dir.mkdirs()) {
                System.out.println("\u6587\u4ef6\u5939\u521b\u5efa\u6210\u529f: " + dir.getAbsolutePath());
                continue;
            }
            System.err.println("\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25: " + dir.getAbsolutePath());
        }
    }

    private static String findCommonDirectory(List<String> paths) {
        ArrayList<Path> absolutePaths = new ArrayList<Path>();
        for (String path : paths) {
            Path absolutePath = Paths.get(path, new String[0]).toAbsolutePath().normalize();
            absolutePaths.add(absolutePath);
        }
        Path commonParent = (Path)absolutePaths.get(0);
        for (int i = 1; i < absolutePaths.size(); ++i) {
            Path currentPath = (Path)absolutePaths.get(i);
            while (!currentPath.startsWith(commonParent)) {
                if ((commonParent = commonParent.getParent()) != null) continue;
                throw new IllegalArgumentException("No common parent directory found for the given paths.");
            }
        }
        return commonParent.toAbsolutePath().toString();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    private Map<String, Object> analyzeFileData(String filePath) {
        FileInputStream fileInputStream = null;
        HashMap<String, Object> data = new HashMap();
        try {
            fileInputStream = new FileInputStream(filePath);
            HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(filePath, filePath, "application" + File.separator + "octet-stream", (InputStream)fileInputStream);
            byte[] fileContent = multipartFile.getBytes();
            data = (Map)SerializeUtils.deserialize((byte[])fileContent);
        }
        catch (Exception e) {
            throw new BaseException("\u53cd\u5e8f\u5217\u5316\u6570\u636e\u51fa\u9519\uff0c\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        if (ToolUtil.isEmpty(data)) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        return data;
    }

    private List<String> findDbdFiles(String folderPath) {
        File folder = new File(folderPath);
        ArrayList<String> dbdFiles = new ArrayList<String>();
        if (!folder.exists() || !folder.isDirectory()) {
            throw new IllegalArgumentException("The given path is not a directory or does not exist.");
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    dbdFiles.addAll(this.findDbdFiles(file.getAbsolutePath()));
                    continue;
                }
                if (!file.isFile() || !file.getName().endsWith(".dbd")) continue;
                dbdFiles.add(file.getAbsolutePath());
            }
        }
        return dbdFiles;
    }

    private void changeDbNameForDataModel(String dbdFilePath, String newDbName) {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(new String(Files.readAllBytes(Paths.get(dbdFilePath, new String[0]))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (FileReader reader = new FileReader(dbdFilePath);
             FileWriter writer = new FileWriter(dbdFilePath);){
            this.modifyDataSourceName(jsonObject, newDbName);
            writer.write(jsonObject.toString(4));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void modifyDataSourceName(JSONObject jsonObject, String newValue) {
        for (String key : jsonObject.keySet()) {
            Object value = jsonObject.get(key);
            if (value instanceof JSONObject) {
                this.modifyDataSourceName((JSONObject)value, newValue);
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Object arrayItem = jsonArray.get(i);
                    if (!(arrayItem instanceof JSONObject)) continue;
                    this.modifyDataSourceName((JSONObject)arrayItem, newValue);
                }
                continue;
            }
            if (!key.equals("dataSourceName")) continue;
            jsonObject.put("dataSourceName", (Object)newValue);
        }
    }

    private String[] unzipFile(File zipFilePath, String[] destDirectories) throws IOException {
        if (destDirectories == null || destDirectories.length < 3) {
            throw new BaseException("\u76ee\u6807\u76ee\u5f55\u8bbe\u7f6e\u9519\u8bef");
        }
        String[] filePaths = new String[3];
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry zipEntry;
            int i = 0;
            while ((zipEntry = zis.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                String tempFilePath = null;
                if (zipEntry.isDirectory()) continue;
                tempFilePath = entryName.endsWith("hussar") ? destDirectories[0] : (entryName.startsWith(".projectstore" + File.separator) ? destDirectories[1] : destDirectories[2]);
                File tempFile = new File(tempFilePath, entryName);
                this.extractFile(zis, tempFile);
                filePaths[i] = tempFile.getPath();
                if (entryName.startsWith(".projectstore" + File.separator)) {
                    File targetFile = new File(destDirectories[1], entryName);
                    this.moveFile(tempFile, targetFile);
                }
                ++i;
                zis.closeEntry();
            }
        }
        return filePaths;
    }

    private void moveFile(File sourceFile, File targetFile) throws IOException {
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        Files.move(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void extractFile(ZipInputStream zis, File destFile) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));){
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = zis.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    private void copyFileToDirectory(String sourceFilePath, String destDir) throws IOException {
        File sourceFile = new File(sourceFilePath);
        File destFile = new File(destDir, sourceFile.getName());
        Files.copy(sourceFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void zipDirectory(String sourceDir, String zipFilePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            File sourceDirFile = new File(sourceDir);
            this.zipFile(sourceDirFile, sourceDirFile, zos);
        }
    }

    private void zipFile(File directory, File fileToZip, ZipOutputStream zos) throws IOException {
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            zos.putNextEntry(new ZipEntry(fileToZip.getName() + File.separator));
            zos.closeEntry();
            for (File childFile : children = fileToZip.listFiles()) {
                this.zipFile(directory, childFile, zos);
            }
            return;
        }
        try (FileInputStream fis = new FileInputStream(fileToZip);){
            int length;
            ZipEntry zipEntry = new ZipEntry(this.getPathRelativeTo(directory, fileToZip));
            zos.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zos.write(bytes, 0, length);
            }
            zos.closeEntry();
        }
    }

    private String getPathRelativeTo(File directory, File file) {
        try {
            Path directoryPath = directory.toPath();
            Path filePath = file.toPath();
            return directoryPath.relativize(filePath).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void deleteDirectory(String path) throws IOException {
        File directory = new File(path);
        if (directory.exists()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.deleteDirectory(file.getAbsolutePath());
                        continue;
                    }
                    file.delete();
                }
            }
            directory.delete();
        }
    }

    private void deleteFilesInDirectory(String path) throws IOException {
        File[] files;
        File directory = new File(path);
        if (directory.exists() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file.getAbsolutePath());
                    continue;
                }
                file.delete();
            }
        }
    }

    private void changeParentArtifactId(String pomFilePath, String newArtifactId) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new File(pomFilePath));
            NodeList parentNodes = doc.getElementsByTagName("parent");
            if (parentNodes.getLength() > 0) {
                Element parentElement = (Element)parentNodes.item(0);
                NodeList artifactIdNodes = parentElement.getElementsByTagName("artifactId");
                if (artifactIdNodes.getLength() > 0) {
                    Element artifactIdElement = (Element)artifactIdNodes.item(0);
                    artifactIdElement.setTextContent(newArtifactId);
                } else {
                    System.err.println("<artifactId> element not found under <parent>");
                }
            } else {
                System.err.println("<parent> element not found in pom.xml");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(pomFilePath));
            transformer.transform(source, result);
            System.out.println("pom.xml updated successfully!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Long sendFileToOss(String fileName) {
        FileInputStream fileInputStream = null;
        try {
            Long ossId;
            fileInputStream = new FileInputStream(fileName);
            HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(fileName, fileName, "application" + File.separator + "octet-stream", (InputStream)fileInputStream);
            ApiResponse ossResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
            Long l = ossId = (Long)ossResponse.getData();
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileInputStream != null) {
                HussarUtils.closeQuietly((Closeable)fileInputStream);
            }
        }
    }

    private void putEnvCache(String val) {
        HussarCacheUtil.put((String)"hussar_application", (Object)("user_env_states" + BaseSecurityUtil.getUser().getUserId()), (Object)val);
    }

    public void startDevelop(String appId) {
        SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)((Object)appId));
        SecurityUser loginUser = BaseSecurityUtil.getUser();
        HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(loginUser.getTenantCode());
        DeployGitDto gitDto = new DeployGitDto();
        gitDto.setAccessToken(tenant.getGitToken());
        gitDto.setGitUri(tenant.getGitUrl());
        gitDto.setTenantCode(tenant.getTenantCode());
        gitDto.setBranch(loginUser.getAccount());
        gitDto.setUserId(loginUser.getUserId());
        ApiResponse response = GitlabUtil.branchExist((GitDto)gitDto);
        UserDevEnv devEnv = (UserDevEnv)this.userDevEnvService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserDevEnv::getUserId, (Object)loginUser.getUserId())).eq(UserDevEnv::getAppId, (Object)appId));
        Map userEnvPortByUserId = this.userEnvPortService.addUserEnvPort(Boolean.valueOf(true));
        if (((Boolean)response.getData()).booleanValue()) {
            if (devEnv == null) {
                this.putEnvCache(UserEnvStatus.ENV_STATUS_RESTART.getDesc());
                this.hussarDeployService.stop(String.valueOf(userEnvPortByUserId.get("back")));
                this.hussarDeployService.stop(String.valueOf(userEnvPortByUserId.get("front")));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                UserDevEnv insert = new UserDevEnv();
                insert.setAppName(application.getAppName());
                insert.setUserId(loginUser.getUserId());
                insert.setAppId(Long.valueOf(Long.parseLong(appId)));
                insert.setCreator(loginUser.getUserId());
                insert.setLastEditor(loginUser.getUserId());
                insert.setCreateTime(LocalDateTime.now());
                insert.setLastTime(LocalDateTime.now());
                this.userDevEnvService.save((Object)insert);
                gitDto.setSourceBranch("develop");
                gitDto.setTargetBranch(loginUser.getAccount());
                gitDto.setTitle("\u5c06develop\u5408\u5e76\u5230\u4e2a\u4eba\u5206\u652f");
                try {
                    logger.info("\u5c06develop\u5408\u5e76\u5230\u4e2a\u4eba\u5206\u652f");
                    ApiResponse remoteMergeResponse = GitlabUtil.remoteMerge((GitDto)gitDto);
                    System.out.println("-------------------------------------remoteMergeResponse = " + remoteMergeResponse.getData());
                }
                catch (Exception e) {
                    logger.info("\u5c06develop\u5408\u5e76\u5230\u4e2a\u4eba\u5206\u652f\u5931\u8d25:{}", (Object)e.getMessage());
                }
                this.hussarDeployService.initWorkSpace(gitDto);
                gitDto.setAppCode(application.getAppCode());
                gitDto.setCommitMsg("\u66f4\u65b0applicant\u7684pom\u6587\u4ef6\uff0c\u6dfb\u52a0\u5e94\u7528\u4f9d\u8d56");
                try {
                    this.hussarDeployService.addAppDependenceInPom(gitDto);
                }
                catch (Exception e) {
                    logger.info("\u66f4\u65b0applicant\u7684pom\u6587\u4ef6\uff0c\u6dfb\u52a0\u5e94\u7528\u4f9d\u8d56\u5931\u8d25:{}", (Object)e.getMessage());
                }
                ApiResponse start = this.hussarDeployService.start(loginUser.getTenantCode(), loginUser.getUserId(), String.valueOf(userEnvPortByUserId.get("back")), String.valueOf(userEnvPortByUserId.get("front")), this.getAppCodes(loginUser));
                if (!((Boolean)start.getData()).booleanValue()) {
                    this.putEnvCache(UserEnvStatus.ENV_STATUS_ERROR.getDesc());
                }
            } else {
                ApiResponse envStatus;
                Long userId = loginUser.getUserId();
                String tenantCode = loginUser.getTenantCode();
                if (!((Boolean)this.hussarDeployService.isInit(tenantCode, userId).getData()).booleanValue()) {
                    gitDto.setUserId(loginUser.getUserId());
                    gitDto.setBranch(loginUser.getAccount());
                    this.hussarDeployService.initWorkSpace(gitDto);
                }
                if (!((Boolean)(envStatus = this.hussarDeployService.getEnvStatus((Integer)userEnvPortByUserId.get("front"), (Integer)userEnvPortByUserId.get("back"))).getData()).booleanValue()) {
                    this.putEnvCache(UserEnvStatus.ENV_STATUS_STARTING.getDesc());
                    ApiResponse start = this.hussarDeployService.start(loginUser.getTenantCode(), loginUser.getUserId(), String.valueOf(userEnvPortByUserId.get("back")), String.valueOf(userEnvPortByUserId.get("front")), this.getAppCodes(loginUser));
                    if (!((Boolean)start.getData()).booleanValue()) {
                        this.putEnvCache(UserEnvStatus.ENV_STATUS_ERROR.getDesc());
                    }
                }
            }
        } else {
            String tenantCode = loginUser.getTenantCode();
            String refName = this.branch;
            gitDto.setRefName(refName);
            GitlabUtil.createRemoteBranch((GitDto)gitDto);
            if (null == devEnv) {
                UserDevEnv userDevEnv = new UserDevEnv();
                userDevEnv.setUserId(loginUser.getUserId());
                userDevEnv.setAppId(Long.valueOf(appId));
                userDevEnv.setAppName(application.getAppName());
                userDevEnv.setCreator(loginUser.getUserId());
                userDevEnv.setCreateTime(LocalDateTime.now());
                userDevEnv.setLastEditor(loginUser.getUserId());
                userDevEnv.setLastTime(LocalDateTime.now());
                this.userDevEnvService.save((Object)userDevEnv);
            }
            DeployGitDto deployGitDto = new DeployGitDto();
            deployGitDto.setUserId(loginUser.getUserId());
            deployGitDto.setTenantCode(gitDto.getTenantCode());
            deployGitDto.setBranch(gitDto.getBranch());
            deployGitDto.setGitUri(gitDto.getGitUri());
            deployGitDto.setAccessToken(gitDto.getAccessToken());
            deployGitDto.setAppCode(application.getAppCode());
            try {
                this.hussarDeployService.initWorkSpace(deployGitDto);
                deployGitDto.setCommitMsg("\u66f4\u65b0applicant\u7684pom\u6587\u4ef6\uff0c\u6dfb\u52a0\u5e94\u7528\u4f9d\u8d56");
                this.hussarDeployService.addAppDependenceInPom(deployGitDto);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.putEnvCache(UserEnvStatus.ENV_STATUS_STARTING.getDesc());
            ApiResponse start = this.hussarDeployService.start(tenantCode, loginUser.getUserId(), String.valueOf(userEnvPortByUserId.get("back")), String.valueOf(userEnvPortByUserId.get("front")), this.getAppCodes(loginUser));
            if (!((Boolean)start.getData()).booleanValue()) {
                this.putEnvCache(UserEnvStatus.ENV_STATUS_ERROR.getDesc());
            }
        }
    }

    public List<Instance> nacosInstanceInfo(String serverName) {
        try {
            Properties properties = new Properties();
            properties.put("serverAddr", this.serverAddr);
            properties.put("namespace", this.namespace);
            NamingService naming = NamingFactory.createNamingService((Properties)properties);
            return naming.getAllInstances(serverName);
        }
        catch (NacosException e) {
            return Lists.newArrayList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportAppData(Long recordId, Long appId, String tenantCode, String branch, Long userId, String appCode, HttpServletResponse response) {
        SysUsers user = this.usersService.getUser(userId);
        SysApplicationRecord sysApplicationRecord = new SysApplicationRecord();
        sysApplicationRecord.setRecordId(recordId);
        sysApplicationRecord.setRecordStatus("1");
        this.sysApplicationRecordService.updateById((Object)sysApplicationRecord);
        String zipFilePath = null;
        String appmetaHussarFilePath = null;
        String hussarFilePath = null;
        String localGitFilePath = null;
        try {
            Map<String, Object> appmetaData = this.getAppmetaHussarData(recordId);
            Map<String, Object> data = this.getHussarData(appId);
            appmetaHussarFilePath = this.makeAppmetaHussarFile(appmetaData);
            hussarFilePath = this.makeHussarFile(data);
            Path path = Paths.get(hussarFilePath, new String[0]);
            Path parentPath = path.getParent();
            localGitFilePath = parentPath.toString();
            ApiResponse<String> gitResponse = this.pullFileToLocal(branch, localGitFilePath, tenantCode, userId);
            if (!gitResponse.isSuccess()) {
                throw new BaseException("git\u62c9\u53d6\u5931\u8d25");
            }
            String appFrontCodePath = localGitFilePath + File.separator + tenantCode + "-front" + File.separator + "apps" + File.separator + appCode;
            String appBackCodePath = localGitFilePath + File.separator + tenantCode + "-web" + File.separator + appCode;
            String appBackWebMainPath = localGitFilePath + File.separator + tenantCode + "-web" + File.separator + "web-main";
            String zipParentPath = localGitFilePath;
            zipFilePath = this.makeAppDataZip(appCode, zipParentPath, appmetaHussarFilePath, hussarFilePath, appFrontCodePath, appBackCodePath, appBackWebMainPath);
            Long ossId = this.sendFileToOss(zipFilePath);
            sysApplicationRecord.setRecordFileId(ossId);
            SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
            String fileName = application.getAppName();
            String newFileName = fileName + "-" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".zip";
            sysApplicationRecord.setRecordFileName(newFileName);
            sysApplicationRecord.setRecordStatus("2");
            this.sysApplicationRecordService.updateById((Object)sysApplicationRecord);
            HussarCacheUtil.put((String)"app_export_Progress", (Object)ProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)5, (String)"\u5bfc\u51fa\u5b8c\u6210", (Long)ossId, (boolean)false));
        }
        catch (Exception e) {
            try {
                HussarCacheUtil.put((String)"app_export_Progress", (Object)ProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)0, (String)("\u5bfc\u51fa\u5f02\u5e38" + e.getMessage()), (Long)0L, (boolean)true));
                sysApplicationRecord.setRecordStatus("3");
                this.sysApplicationRecordService.updateById((Object)sysApplicationRecord);
                throw new BaseException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (localGitFilePath != null) {
                        this.deleteDirectory(localGitFilePath);
                    }
                    if (hussarFilePath != null) {
                        this.deleteDirectory(hussarFilePath);
                    }
                    if (appmetaHussarFilePath != null) {
                        this.deleteDirectory(appmetaHussarFilePath);
                    }
                    if (zipFilePath == null) throw throwable;
                    this.deleteDirectory(zipFilePath);
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        try {
            if (localGitFilePath != null) {
                this.deleteDirectory(localGitFilePath);
            }
            if (hussarFilePath != null) {
                this.deleteDirectory(hussarFilePath);
            }
            if (appmetaHussarFilePath != null) {
                this.deleteDirectory(appmetaHussarFilePath);
            }
            if (zipFilePath == null) return;
            this.deleteDirectory(zipFilePath);
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getTenantOrAppName(Long appId, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysTenant::getTenantCode, (Object)tenantCode);
            SysTenant tenant = (SysTenant)this.sysTenantService.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isEmpty((Object)tenant)) {
                throw new BaseException("\u79df\u6237\u4e0d\u5b58\u5728");
            }
            map.put("tenantName", tenant.getTenantName());
            map.put("tenantIconType", tenant.getTenantIconType());
            map.put("tenantIcon", tenant.getTenantIcon());
            map.put("tenantIconColor", tenant.getTenantIconColor());
        }
        if (HussarUtils.isNotEmpty((Object)appId)) {
            SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
            if (HussarUtils.isEmpty((Object)application)) {
                throw new BaseException("\u5e94\u7528\u4e0d\u5b58\u5728");
            }
            String appName = application.getAppName();
            map.put("appName", appName);
            map.put("appIconType", application.getAppIconType());
            map.put("appIcon", application.getAppIcon());
            map.put("appIconColor", application.getAppIconColor());
        }
        return map;
    }

    private String getAppCodes(SecurityUser loginUser) {
        List userDevEnvList = this.userDevEnvService.list((Wrapper)Wrappers.lambdaQuery().eq(UserDevEnv::getUserId, (Object)loginUser.getUserId()));
        if (CollectionUtils.isNotEmpty((Collection)userDevEnvList)) {
            List appIds = userDevEnvList.stream().map(UserDevEnv::getAppId).collect(Collectors.toList());
            List appCodeList = this.sysApplicationService.list((Wrapper)Wrappers.lambdaQuery().in(SysApplication::getId, appIds)).stream().map(SysApplication::getAppCode).collect(Collectors.toList());
            return String.join((CharSequence)",", appCodeList);
        }
        return "";
    }
}

