/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.controller;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.jxdinfo.hussar.application.service.IHussarAppTeamCallBackService;
import com.jxdinfo.hussar.application.service.IHussarApplicationService;
import com.jxdinfo.hussar.application.service.ISysApplicationRecordService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="com.jxdinfo.hussar.application.controller.TenantApplicationController")
@AuditLog(moduleName="\u79df\u6237-\u5e94\u7528\u7ba1\u7406")
@RequestMapping(value={"/hussarBase/tenantApplication"})
public class TenantApplicationController {
    @Resource(name="com.jxdinfo.hussar.application.service.impl.TenantApplicationTeamServiceImpl")
    private IHussarAppTeamCallBackService hussarAppTeamCallBackService;
    @Resource(name="com.jxdinfo.hussar.application.service.impl.TenantApplicationServiceImpl")
    private IHussarApplicationService hussarApplicationService;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private ISysApplicationRecordService sysApplicationRecordService;
    private static Logger logger = LoggerFactory.getLogger(TenantApplicationController.class);

    @ApiOperation(value="\u5e94\u7528\u5bfc\u51fa", notes="\u5e94\u7528\u5bfc\u51fa")
    @GetMapping(value={"/exportAppDataFile"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u5e94\u7528\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> exportAppDataFile(@ApiParam(value="recordId") @RequestParam Long recordId, @ApiParam(value="appId") @RequestParam Long appId, HttpServletResponse response) {
        return ApiResponse.success((String)this.hussarApplicationService.exportAppData(recordId, appId, response));
    }

    @GetMapping(value={"/downloadAppExportFile"})
    @ApiOperation(value="\u5e94\u7528\u5bfc\u51fa\u6587\u4ef6\u4e0b\u8f7d", notes="\u5e94\u7528\u5bfc\u51fa\u6587\u4ef6\u4e0b\u8f7d")
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u5e94\u7528\u5bfc\u51fa\u6587\u4ef6\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void downloadAppExportFile(@ApiParam(value="\u6587\u4ef6id") @RequestParam Long fileId, HttpServletResponse response) {
        this.hussarApplicationService.downloadAppExportFile(fileId, response);
    }

    @PostMapping(value={"/unpackImportFile"})
    @ApiOperation(value="\u89e3\u538b\u5bfc\u5165\u7684\u5e94\u7528\u538b\u7f29\u5305", notes="\u89e3\u538b\u5bfc\u5165\u7684\u5e94\u7528\u538b\u7f29\u5305")
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u89e3\u538b\u5bfc\u5165\u7684\u5e94\u7528\u538b\u7f29\u5305", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<Map<String, Object>> unpackImportFile(@RequestParam(value="file") MultipartFile file) {
        return ApiResponse.success((Object)this.hussarApplicationService.unpackImportFile(file));
    }

    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u5bfc\u5165\u5bc6\u7801\u662f\u5426\u6b63\u786e", notes="\u67e5\u8be2\u5e94\u7528\u5bfc\u5165\u5bc6\u7801\u662f\u5426\u6b63\u786e")
    @GetMapping(value={"/checkAppImportPassword"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u67e5\u8be2\u5e94\u7528\u5bfc\u5165\u5bc6\u7801\u662f\u5426\u6b63\u786e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> checkAppImportPassword(String password, String appmetaHussarFilePath) {
        return ApiResponse.success((Object)this.hussarApplicationService.checkAppImportPassword(password, appmetaHussarFilePath));
    }

    @ApiOperation(value="\u5e94\u7528\u5bfc\u5165", notes="\u5e94\u7528\u5bfc\u5165")
    @PostMapping(path={"/importAppData"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u5e94\u7528\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<String> importAppData(@RequestParam MultipartFile file, @RequestParam String fileName, @RequestParam(required=false) String filePassword, @RequestParam String hussarFilePath, @RequestParam String appCodeFilePath, @RequestParam Boolean ifExist, @RequestParam Long appId, @RequestParam String appCode, @RequestParam Long appGroupId, @RequestParam String appIconType, @RequestParam String appIconColor, @RequestParam String appIcon, @RequestParam Long recordId) throws Exception {
        return ApiResponse.success((String)this.hussarApplicationService.importAppData(file, fileName, filePassword, hussarFilePath, appCodeFilePath, ifExist, appId, appCode, appGroupId, appIconType, appIconColor, appIcon, recordId));
    }

    @GetMapping(value={"startDevelop"})
    public void startDevelop(@RequestParam String appId) {
        this.hussarApplicationService.startDevelop(appId);
    }

    @GetMapping(value={"nacosInstanceInfo"})
    public ApiResponse<List<Instance>> nacosInstanceInfo(@RequestParam(value="serverName") String serverName) {
        return ApiResponse.success((Object)this.hussarApplicationService.nacosInstanceInfo(serverName));
    }

    @GetMapping(value={"getTenantOrAppName"})
    public ApiResponse<Map<String, String>> getTenantOrAppName(@RequestParam(value="appId", required=false) Long appId, @RequestParam(value="tenantCode", required=false) String tenantCode) {
        return ApiResponse.success((Object)this.hussarApplicationService.getTenantOrAppName(appId, tenantCode));
    }
}

