/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.constant.UserEnvStatus;
import com.jxdinfo.hussar.application.dao.UserDevEnvMapper;
import com.jxdinfo.hussar.application.dto.UserAppEnvDto;
import com.jxdinfo.hussar.application.dto.UserDevEnvDto;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.model.UserDevEnv;
import com.jxdinfo.hussar.application.model.UserEnvPort;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.service.IUserDevEnvService;
import com.jxdinfo.hussar.application.service.IUserEnvPortService;
import com.jxdinfo.hussar.application.vo.HussarApplicationVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserAppDevEnvDto;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.deploy.dto.DeployGitDto;
import com.jxdinfo.hussar.deploy.service.IHussarDeployService;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.model.GitDto;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.GitlabUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class UserDevEnvServiceImpl
extends HussarServiceImpl<UserDevEnvMapper, UserDevEnv>
implements IUserDevEnvService {
    private static final Logger logger = LoggerFactory.getLogger(UserDevEnvServiceImpl.class);
    @Resource
    private ISysAppDevelopTeamMemberService appDevelopTeamMemberService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysAppDevelopTeamService appDevelopTeamService;
    @Resource
    private IHussarDeployService hussarDeployService;
    @Resource
    private IUserDevEnvService userDevEnvService;
    @Resource
    private IHussarBaseTenantService hussarBaseTenantService;
    @Resource
    private UserDevEnvMapper userDevEnvMapper;
    @Resource
    private IUserEnvPortService userEnvPortService;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private IUserEnvPortService iUserEnvPortService;
    @Value(value="${template-file.branch:develop}")
    private String branch;

    public List<HussarApplicationVo> addAppDropdown() {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null) {
            throw new BaseException(ResultCode.UN_AUTHORIZED.getMessage());
        }
        List teamIdList = this.appDevelopTeamMemberService.list((Wrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeamMember::getUserId, (Object)user.getUserId())).stream().map(SysAppDevelopTeamMember::getTeamId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(teamIdList)) {
            return Lists.newArrayList();
        }
        List appIdList = this.appDevelopTeamService.list((Wrapper)Wrappers.lambdaQuery().in(SysAppDevelopTeam::getId, teamIdList)).stream().map(SysAppDevelopTeam::getAppId).collect(Collectors.toList());
        List userDevEnvList = this.list((Wrapper)Wrappers.lambdaQuery().eq(UserDevEnv::getUserId, (Object)user.getUserId()));
        List list = this.applicationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CollectionUtils.isNotEmpty(appIdList), SysApplication::getId, appIdList)).eq(SysApplication::getAppType, (Object)20));
        ArrayList<HussarApplicationVo> voList = new ArrayList<HussarApplicationVo>();
        list.forEach(item -> {
            HussarApplicationVo vo = new HussarApplicationVo();
            vo.setSelectFlag(Boolean.valueOf(true));
            if (userDevEnvList.stream().anyMatch(item1 -> item1.getAppId().equals(item.getId()))) {
                vo.setSelectFlag(Boolean.valueOf(false));
            }
            BeanUtils.copyProperties((Object)item, (Object)vo);
            voList.add(vo);
        });
        return voList;
    }

    public ApiResponse<String> addAppToEnv(List<UserAppEnvDto> userAppEnvList) throws Exception {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null) {
            throw new BaseException(ResultCode.UN_AUTHORIZED.getMessage());
        }
        String tenantCode = user.getTenantCode();
        HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
        DeployGitDto deployGitDto = new DeployGitDto();
        deployGitDto.setAccessToken(tenant.getGitToken());
        deployGitDto.setGitUri(tenant.getGitUrl());
        deployGitDto.setBranch(user.getAccount());
        deployGitDto.setTenantCode(tenantCode);
        deployGitDto.setUserId(user.getUserId());
        ApiResponse response = GitlabUtil.branchExist((GitDto)deployGitDto);
        if (!((Boolean)response.getData()).booleanValue()) {
            deployGitDto.setRefName(this.branch);
            GitlabUtil.createRemoteBranch((GitDto)deployGitDto);
        }
        deployGitDto.setSourceBranch("develop");
        deployGitDto.setTargetBranch(user.getAccount());
        deployGitDto.setTitle("\u5c06develop\u5408\u5e76\u5230\u4e2a\u4eba\u5206\u652f");
        try {
            logger.info("\u5c06develop\u5408\u5e76\u5230\u4e2a\u4eba\u5206\u652f");
            ApiResponse remoteMergeResponse = GitlabUtil.remoteMerge((GitDto)deployGitDto);
            System.out.println("-------------------------------------remoteMergeResponse = " + remoteMergeResponse.getData());
        }
        catch (Exception e) {
            logger.info("\u5c06develop\u5408\u5e76\u5230\u4e2a\u4eba\u5206\u652f\u5931\u8d25:{}", (Object)e.getMessage());
        }
        ArrayList<UserDevEnv> userDevEnvList = new ArrayList<UserDevEnv>();
        ArrayList<String> appCodeList = new ArrayList<String>();
        for (UserAppEnvDto dto : userAppEnvList) {
            UserDevEnv record = (UserDevEnv)((UserDevEnvMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserDevEnv::getUserId, (Object)dto.getUserId())).eq(UserDevEnv::getAppId, (Object)dto.getAppId()));
            if (null != record) continue;
            UserDevEnv userDevEnv = new UserDevEnv();
            userDevEnv.setAppId(dto.getAppId());
            userDevEnv.setAppName(dto.getAppName());
            userDevEnv.setCreator(user.getUserId());
            userDevEnv.setLastEditor(user.getUserId());
            userDevEnv.setCreateTime(LocalDateTime.now());
            userDevEnv.setLastTime(LocalDateTime.now());
            userDevEnv.setUserId(user.getUserId());
            userDevEnvList.add(userDevEnv);
            SysApplication application = (SysApplication)this.applicationService.getById((Serializable)dto.getAppId());
            appCodeList.add(application.getAppCode());
        }
        this.saveBatch(userDevEnvList);
        deployGitDto.setAppCodeList(appCodeList);
        deployGitDto.setCommitMsg("\u66f4\u65b0application\u7684Pom\u6587\u4ef6\uff0c\u6279\u91cf\u6dfb\u52a0\u5e94\u7528\u4f9d\u8d56");
        return this.hussarDeployService.addAppDependencesInPomBatch(deployGitDto);
    }

    public ApiResponse<String> delAppFromEnv(String id) throws Exception {
        UserDevEnv userDevEnv = (UserDevEnv)((UserDevEnvMapper)this.baseMapper).selectById((Serializable)((Object)id));
        if (null == userDevEnv) {
            throw new BaseException("\u4e0d\u5b58\u5728\u7684\u8bb0\u5f55!");
        }
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)userDevEnv.getAppId());
        ((UserDevEnvMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null) {
            throw new BaseException(ResultCode.UN_AUTHORIZED.getMessage());
        }
        String tenantCode = user.getTenantCode();
        HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
        DeployGitDto deployGitDto = new DeployGitDto();
        deployGitDto.setAccessToken(tenant.getGitToken());
        deployGitDto.setGitUri(tenant.getGitUrl());
        deployGitDto.setBranch(user.getAccount());
        deployGitDto.setTenantCode(tenantCode);
        deployGitDto.setUserId(user.getUserId());
        ApiResponse response = GitlabUtil.branchExist((GitDto)deployGitDto);
        if (!((Boolean)response.getData()).booleanValue()) {
            deployGitDto.setRefName(this.branch);
            GitlabUtil.createRemoteBranch((GitDto)deployGitDto);
        }
        if (!((Boolean)this.hussarDeployService.isInit(tenantCode, user.getUserId()).getData()).booleanValue()) {
            this.hussarDeployService.initWorkSpace(deployGitDto);
        }
        deployGitDto.setAppCode(application.getAppCode());
        deployGitDto.setCommitMsg("\u66f4\u65b0application\u7684Pom\u6587\u4ef6\uff0c\u5220\u9664\u5e94\u7528\u4f9d\u8d56");
        return this.hussarDeployService.deleteAppDependenceInPom(deployGitDto);
    }

    public Page<UserDevEnvDto> getList(Integer current, Integer size) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null) {
            throw new BaseException(ResultCode.UN_AUTHORIZED.getMessage());
        }
        Page page = new Page((long)current.intValue(), (long)size.intValue());
        List<UserDevEnvDto> list = this.userDevEnvMapper.selectUserDevEnvWithUserName(user.getUserId());
        page.setTotal((long)list.size());
        return page.setRecords(list);
    }

    public ApiResponse<String> gitOperation(Integer type) throws Exception {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null) {
            throw new BaseException(ResultCode.UN_AUTHORIZED.getMessage());
        }
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        HussarTenantDefinition tenantByTenantCode = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
        if (0 == type) {
            DeployGitDto dto = new DeployGitDto();
            dto.setTenantCode(tenantCode);
            dto.setUserId(user.getUserId());
            dto.setBranch(user.getAccount());
            dto.setGitUri(tenantByTenantCode.getGitUrl());
            dto.setAccessToken(tenantByTenantCode.getGitToken());
            return this.hussarDeployService.initWorkSpace(dto);
        }
        String commitMessage = "\u63a8\u9001\u7528\u6237" + user.getAccount() + "\u7684\u9879\u76ee\u4ee3\u7801";
        DeployGitDto dto = new DeployGitDto();
        dto.setTenantCode(tenantCode);
        dto.setUserId(user.getUserId());
        dto.setBranch(user.getAccount());
        dto.setGitUri(tenantByTenantCode.getGitUrl());
        dto.setAccessToken(tenantByTenantCode.getGitToken());
        dto.setCommitMsg(commitMessage);
        return this.hussarDeployService.pushToGit(dto);
    }

    public ApiResponse<Boolean> stopEnv() {
        this.putEnvCache(UserEnvStatus.ENV_STATUS_STOPPING.getDesc());
        Map record = this.iUserEnvPortService.addUserEnvPort(Boolean.valueOf(false));
        this.hussarDeployService.stop(String.valueOf(record.get("back")));
        this.hussarDeployService.stop(String.valueOf(record.get("back")));
        this.hussarDeployService.stop(String.valueOf(record.get("front")));
        this.hussarDeployService.stop(String.valueOf(record.get("mobile")));
        this.putEnvCache(UserEnvStatus.ENV_STATUS_STOP.getDesc());
        return ApiResponse.success();
    }

    private void putEnvCache(String val) {
        HussarCacheUtil.put((String)"hussar_application", (Object)("user_env_states" + BaseSecurityUtil.getUser().getUserId()), (Object)val);
    }

    private String getEnvCache() {
        return (String)HussarCacheUtil.get((String)"hussar_application", (Object)("user_env_states" + BaseSecurityUtil.getUser().getUserId()));
    }

    public ApiResponse<Boolean> isInit() {
        SecurityUser loginUser = BaseSecurityUtil.getUser();
        assert (loginUser != null);
        HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(loginUser.getTenantCode());
        DeployGitDto gitDto = new DeployGitDto();
        gitDto.setAccessToken(tenant.getGitToken());
        gitDto.setGitUri(tenant.getGitUrl());
        gitDto.setTenantCode(tenant.getTenantCode());
        gitDto.setBranch(loginUser.getAccount());
        return GitlabUtil.branchExist((GitDto)gitDto);
    }

    public String getIfEnvIp(Long userId) {
        SysUsers user = (SysUsers)this.usersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getId, (Object)userId));
        if (HussarUtils.isNotEmpty((Object)user)) {
            String userDevEnvSwitch = user.getAppDevEnvIpSwitch();
            if (HussarUtils.isNotEmpty((Object)userDevEnvSwitch)) {
                return userDevEnvSwitch;
            }
            return "0";
        }
        throw new BaseException("\u672a\u627e\u5230\u7528\u6237\u5bf9\u5e94\u73af\u5883\u5f00\u5173\u914d\u7f6e");
    }

    public Boolean changeIfEnvIp(UserAppDevEnvDto userAppDevEnvDto) {
        SysUsers user;
        this.stopEnv();
        String appDevEnvIpSwitch = userAppDevEnvDto.getAppDevEnvIpSwitch();
        Long userId = userAppDevEnvDto.getUserId();
        if (HussarUtils.isEmpty((Object)appDevEnvIpSwitch)) {
            throw new BaseException("\u53c2\u6570\u672a\u4f20\u9012");
        }
        SecurityUser securityuser = BaseSecurityUtil.getUser();
        securityuser.getExtendUserMap().put("ifEnvIp", appDevEnvIpSwitch);
        if (appDevEnvIpSwitch.equals("0")) {
            HussarCacheUtil.evict((String)"gary_regular", (Object)("hussar-deploy:" + userId));
        }
        if (HussarUtils.isNotEmpty((Object)(user = (SysUsers)this.usersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getId, (Object)userId))))) {
            user.setAppDevEnvIpSwitch(appDevEnvIpSwitch);
            return this.usersService.updateById((Object)user);
        }
        return false;
    }

    public String getUserDevEnvIp(Long userId) {
        boolean isExist = HussarCacheUtil.containKey((String)"gary_regular", (Object)("hussar-deploy:" + userId));
        if (!isExist) {
            return null;
        }
        String userDevEnvIp = (String)HussarCacheUtil.get((String)"gary_regular", (Object)("hussar-deploy:" + userId));
        return userDevEnvIp.substring(0, userDevEnvIp.lastIndexOf(":"));
    }

    public boolean changeUserDevEnvIp(UserDevEnvDto userDevEnvDto) {
        String userDevEnvIp = userDevEnvDto.getUserDevEnvIp();
        if (HussarUtils.isBlank((CharSequence)userDevEnvIp)) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u6307\u5b9aip\u53c2\u6570");
        }
        Long userId = userDevEnvDto.getUserId();
        if (HussarUtils.isEmpty((Object)userId)) {
            throw new BaseException("\u7528\u6237ID\u53c2\u6570\u4e3a\u7a7a");
        }
        HussarCacheUtil.put((String)"gary_regular", (Object)("hussar-deploy:" + userId), (Object)(userDevEnvIp + ":6789"));
        return true;
    }

    public ApiResponse<String> initEnv() throws Exception {
        SecurityUser loginUser = BaseSecurityUtil.getUser();
        assert (loginUser != null);
        HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(loginUser.getTenantCode());
        DeployGitDto gitDto = new DeployGitDto();
        gitDto.setAccessToken(tenant.getGitToken());
        gitDto.setGitUri(tenant.getGitUrl());
        gitDto.setTenantCode(tenant.getTenantCode());
        gitDto.setBranch(loginUser.getAccount());
        gitDto.setRefName("develop");
        GitlabUtil.createRemoteBranch((GitDto)gitDto);
        SecurityUser user = BaseSecurityUtil.getUser();
        DeployGitDto deployGitDto = new DeployGitDto();
        deployGitDto.setUserId(user.getUserId());
        deployGitDto.setTenantCode(user.getTenantCode());
        deployGitDto.setBranch(loginUser.getAccount());
        HussarTenantDefinition tenantByTenantCode = this.hussarBaseTenantService.getTenantByTenantCode(user.getTenantCode());
        deployGitDto.setGitUri(tenantByTenantCode.getGitUrl());
        deployGitDto.setAccessToken(tenantByTenantCode.getGitToken());
        return this.hussarDeployService.initWorkSpace(deployGitDto);
    }

    public ApiResponse<Boolean> startEnv() {
        ApiResponse start = null;
        this.putEnvCache(UserEnvStatus.ENV_STATUS_STARTING.getDesc());
        try {
            SecurityUser loginUser = BaseSecurityUtil.getUser();
            Map portMap = this.userEnvPortService.addUserEnvPort(Boolean.valueOf(true));
            HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(loginUser.getTenantCode());
            DeployGitDto gitDto = new DeployGitDto();
            gitDto.setAccessToken(tenant.getGitToken());
            gitDto.setGitUri(tenant.getGitUrl());
            gitDto.setTenantCode(tenant.getTenantCode());
            gitDto.setBranch(loginUser.getAccount());
            gitDto.setUserId(loginUser.getUserId());
            ApiResponse response = GitlabUtil.branchExist((GitDto)gitDto);
            if (!((Boolean)response.getData()).booleanValue()) {
                gitDto.setRefName("develop");
                GitlabUtil.createRemoteBranch((GitDto)gitDto);
            }
            if (!((Boolean)this.hussarDeployService.isInit(loginUser.getTenantCode(), loginUser.getUserId()).getData()).booleanValue()) {
                DeployGitDto deployGitDto = new DeployGitDto();
                deployGitDto.setUserId(loginUser.getUserId());
                deployGitDto.setTenantCode(loginUser.getTenantCode());
                deployGitDto.setBranch(loginUser.getAccount());
                deployGitDto.setGitUri(tenant.getGitUrl());
                deployGitDto.setAccessToken(tenant.getGitToken());
                this.hussarDeployService.initWorkSpace(deployGitDto);
            }
            String appCodes = "";
            List userDevEnvList = this.userDevEnvService.list((Wrapper)Wrappers.lambdaQuery().eq(UserDevEnv::getUserId, (Object)loginUser.getUserId()));
            if (CollectionUtils.isNotEmpty((Collection)userDevEnvList)) {
                List appIds = userDevEnvList.stream().map(UserDevEnv::getAppId).collect(Collectors.toList());
                List appCodeList = this.applicationService.list((Wrapper)Wrappers.lambdaQuery().in(SysApplication::getId, appIds)).stream().map(SysApplication::getAppCode).collect(Collectors.toList());
                appCodes = String.join((CharSequence)",", appCodeList);
            }
            start = this.hussarDeployService.start(loginUser.getTenantCode(), loginUser.getUserId(), String.valueOf(portMap.get("back")), String.valueOf(portMap.get("front")), String.valueOf(portMap.get("mobile")), appCodes);
        }
        catch (HussarException e) {
            this.putEnvCache(UserEnvStatus.ENV_STATUS_ERROR.getDesc());
            return start;
        }
        if (!((Boolean)start.getData()).booleanValue()) {
            this.putEnvCache(UserEnvStatus.ENV_STATUS_ERROR.getDesc());
            return start;
        }
        return start;
    }

    public ApiResponse<Boolean> restartEnv() {
        ApiResponse apiResponse = null;
        this.putEnvCache(UserEnvStatus.ENV_STATUS_RESTART.getDesc());
        try {
            SecurityUser loginUser = BaseSecurityUtil.getUser();
            HussarCacheUtil.put((String)"hussar_application", (Object)("user_env_states" + loginUser.getUserId()), (Object)"restarting");
            this.userDevEnvService.stopEnv();
            Map portMap = this.userEnvPortService.addUserEnvPort(Boolean.valueOf(true));
            HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(loginUser.getTenantCode());
            DeployGitDto gitDto = new DeployGitDto();
            gitDto.setAccessToken(tenant.getGitToken());
            gitDto.setGitUri(tenant.getGitUrl());
            gitDto.setTenantCode(tenant.getTenantCode());
            gitDto.setBranch(loginUser.getAccount());
            gitDto.setUserId(loginUser.getUserId());
            ApiResponse response = GitlabUtil.branchExist((GitDto)gitDto);
            if (!((Boolean)response.getData()).booleanValue()) {
                gitDto.setRefName("develop");
                GitlabUtil.createRemoteBranch((GitDto)gitDto);
            }
            if (!((Boolean)this.hussarDeployService.isInit(loginUser.getTenantCode(), loginUser.getUserId()).getData()).booleanValue()) {
                DeployGitDto deployGitDto = new DeployGitDto();
                deployGitDto.setUserId(loginUser.getUserId());
                deployGitDto.setTenantCode(loginUser.getTenantCode());
                deployGitDto.setBranch(loginUser.getAccount());
                deployGitDto.setGitUri(tenant.getGitUrl());
                deployGitDto.setAccessToken(tenant.getGitToken());
                this.hussarDeployService.initWorkSpace(deployGitDto);
            }
            String appCodes = "";
            List userDevEnvList = this.userDevEnvService.list((Wrapper)Wrappers.lambdaQuery().eq(UserDevEnv::getUserId, (Object)loginUser.getUserId()));
            if (CollectionUtils.isNotEmpty((Collection)userDevEnvList)) {
                List appIds = userDevEnvList.stream().map(UserDevEnv::getAppId).collect(Collectors.toList());
                List appCodeList = this.applicationService.list((Wrapper)Wrappers.lambdaQuery().in(SysApplication::getId, appIds)).stream().map(SysApplication::getAppCode).collect(Collectors.toList());
                appCodes = String.join((CharSequence)",", appCodeList);
            }
            apiResponse = this.hussarDeployService.start(loginUser.getTenantCode(), loginUser.getUserId(), String.valueOf(portMap.get("back")), String.valueOf(portMap.get("front")), String.valueOf(portMap.get("mobile")), appCodes);
        }
        catch (HussarException e) {
            this.putEnvCache(UserEnvStatus.ENV_STATUS_ERROR.getDesc());
            return apiResponse;
        }
        if (!((Boolean)apiResponse.getData()).booleanValue()) {
            this.putEnvCache(UserEnvStatus.ENV_STATUS_ERROR.getDesc());
            return apiResponse;
        }
        return apiResponse;
    }

    public ApiResponse<Boolean> stopEnv(String backPort, String frontPort) {
        this.putEnvCache(UserEnvStatus.ENV_STATUS_STOPPING.getDesc());
        this.hussarDeployService.stop(backPort);
        this.hussarDeployService.stop(backPort);
        this.hussarDeployService.stop(frontPort);
        this.putEnvCache(UserEnvStatus.ENV_STATUS_STOP.getDesc());
        return ApiResponse.success();
    }

    public ApiResponse<String> getEnvStatus() {
        SecurityUser loginUser = BaseSecurityUtil.getUser();
        UserEnvPort record = (UserEnvPort)this.iUserEnvPortService.getOne((Wrapper)Wrappers.lambdaQuery().eq(UserEnvPort::getUserId, (Object)loginUser.getUserId()));
        if (null == record) {
            return ApiResponse.success((Object)UserEnvStatus.ENV_STATUS_STOP.getCode(), (String)UserEnvStatus.ENV_STATUS_STOP.getDesc());
        }
        String states = this.getEnvCache();
        ApiResponse envStatusResponse = this.hussarDeployService.getEnvStatus(record.getFrontPort(), record.getBackPort(), record.getMobilePort());
        if (!envStatusResponse.isSuccess()) {
            this.putEnvCache(UserEnvStatus.ENV_STATUS_NOT_FOUND.getDesc());
            return ApiResponse.success((Object)UserEnvStatus.ENV_STATUS_NOT_FOUND.getCode(), (String)UserEnvStatus.ENV_STATUS_NOT_FOUND.getDesc());
        }
        if (envStatusResponse.isSuccess() && UserEnvStatus.ENV_STATUS_NOT_FOUND.eq(states)) {
            states = "";
            this.putEnvCache(states);
        }
        if (((Boolean)envStatusResponse.getData()).booleanValue()) {
            this.putEnvCache(UserEnvStatus.ENV_STATUS_RUNNING.getDesc());
            return ApiResponse.success((Object)UserEnvStatus.ENV_STATUS_RUNNING.getCode(), (String)UserEnvStatus.ENV_STATUS_RUNNING.getDesc());
        }
        List runnerStatus = this.hussarDeployService.runnerStatus(loginUser.getTenantCode(), String.valueOf(loginUser.getUserId()));
        if (HussarUtils.isEmpty((Object)runnerStatus) || runnerStatus.isEmpty()) {
            if (HussarUtils.isEmpty((Object)states) || UserEnvStatus.ENV_STATUS_RUNNING.eq(states)) {
                states = UserEnvStatus.ENV_STATUS_STOP.getDesc();
            }
            return ApiResponse.success((Object)UserEnvStatus.code(states), (String)states);
        }
        for (Map status : runnerStatus) {
            if (!"failed".equals(status.get("status"))) continue;
            this.putEnvCache(UserEnvStatus.ENV_STATUS_ERROR.getDesc());
            return ApiResponse.success((Object)UserEnvStatus.ENV_STATUS_ERROR.getCode(), (String)((String)status.get("exception")));
        }
        if (HussarUtils.isEmpty((Object)states) || UserEnvStatus.ENV_STATUS_RUNNING.eq(states)) {
            states = UserEnvStatus.ENV_STATUS_STOP.getDesc();
        }
        return ApiResponse.success((Object)UserEnvStatus.code(states), (String)states);
    }
}

