/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.TransferMemberTypeDto;
import com.jxdinfo.hussar.application.dto.UpdateMemberTypeDto;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.service.IHussarAppTeamCallBackService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.application.service.impl.NoCodeApplicationTeamServiceImpl")
public class NoCodeApplicationTeamServiceImpl
implements IHussarAppTeamCallBackService {
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysAppDevelopTeamMemberService developTeamMemberService;
    @Resource
    private ISysUsersService usersService;
    @Autowired
    private ISysAppDevelopTeamMemberService appDevelopTeamMemberService;

    public String getAppType() {
        return "1";
    }

    public void saveAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto) {
        this.setApplicationRole(appDevelopTeamDto, TenantConstant.APP_ADMIN_ROLE);
    }

    private void setApplicationRole(AppDevelopTeamDto appDevelopTeamDto, Long roleId) {
        List userIds = appDevelopTeamDto.getUserIds();
        Map<Long, List<SysUserRole>> roleListMap = this.sysUserRoleService.getUserRolesByUserIds(userIds).stream().collect(Collectors.groupingBy(SysUserRole::getUserId));
        ArrayList userRoleList = Lists.newArrayList();
        for (Long userId : userIds) {
            SysUserRole sysUserRole;
            List rolesList = roleListMap.get(userId).stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList());
            LocalDateTime now = LocalDateTime.now();
            if (!TenantConstant.ADMIN_USER.equals(userId) && !rolesList.contains(roleId)) {
                sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setCreator(userId);
                sysUserRole.setLastEditor(userId);
                sysUserRole.setLastTime(now);
                sysUserRole.setCreateTime(now);
                userRoleList.add(sysUserRole);
                this.sysRolesService.delAuthCacheInfo(userId);
            }
            if (TenantConstant.ADMIN_USER.equals(userId) || rolesList.contains(SysUserAndRole.DEVELOP_ROLE.getValue())) continue;
            sysUserRole = new SysUserRole();
            sysUserRole.setUserId(userId);
            sysUserRole.setGrantedRole(SysUserAndRole.DEVELOP_ROLE.getValue());
            sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            sysUserRole.setCreator(userId);
            sysUserRole.setLastEditor(userId);
            sysUserRole.setLastTime(now);
            sysUserRole.setCreateTime(now);
            userRoleList.add(sysUserRole);
        }
        this.sysUserRoleService.saveOrUpdateBatch((Collection)userRoleList);
    }

    public void updateAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto, String appType) {
        List existUserIds = this.developTeamMemberService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeamMember::getTeamId, (Object)appDevelopTeamDto.getTeamId())).eq(SysAppDevelopTeamMember::getMemberType, (Object)0)).stream().map(SysAppDevelopTeamMember::getUserId).collect(Collectors.toList());
        appDevelopTeamDto.setUserIds(existUserIds);
        this.setApplicationRole(appDevelopTeamDto, TenantConstant.APP_DEVELOP_ROLE);
    }

    public void updateMember(UpdateMemberTypeDto updateDto) {
        Long userId = updateDto.getUserId();
        List rolesIdList = this.sysUserRoleService.getRolesByUserId(userId);
        Integer type = updateDto.getType();
        if (0 == type) {
            if (!rolesIdList.contains(TenantConstant.APP_DEVELOP_ROLE)) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(TenantConstant.APP_DEVELOP_ROLE);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setCreator(userId);
                sysUserRole.setLastEditor(userId);
                LocalDateTime now = LocalDateTime.now();
                sysUserRole.setLastTime(now);
                sysUserRole.setCreateTime(now);
                this.sysRolesService.delAuthCacheInfo(userId);
                long count = this.appDevelopTeamMemberService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeamMember::getUserId, (Object)userId)).eq(SysAppDevelopTeamMember::getMemberType, (Object)1));
                if (count < 1L) {
                    this.sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)TenantConstant.APP_ADMIN_ROLE));
                }
                this.sysUserRoleService.save((Object)sysUserRole);
            }
        } else if (!rolesIdList.contains(TenantConstant.APP_ADMIN_ROLE)) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(userId);
            sysUserRole.setGrantedRole(TenantConstant.APP_ADMIN_ROLE);
            sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            sysUserRole.setCreator(userId);
            sysUserRole.setLastEditor(userId);
            LocalDateTime now = LocalDateTime.now();
            sysUserRole.setLastTime(now);
            sysUserRole.setCreateTime(now);
            this.sysRolesService.delAuthCacheInfo(userId);
            long count = this.appDevelopTeamMemberService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeamMember::getUserId, (Object)userId)).eq(SysAppDevelopTeamMember::getMemberType, (Object)0));
            if (count < 1L) {
                this.sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)TenantConstant.APP_DEVELOP_ROLE));
            }
            this.sysUserRoleService.save((Object)sysUserRole);
        }
    }

    public void removeMembers(Long appId, Long userId) {
        long count = this.developTeamMemberService.count((Wrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeamMember::getUserId, (Object)userId));
        if (count < 1L) {
            this.sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).in(SysUserRole::getGrantedRole, new Object[]{TenantConstant.APP_DEVELOP_ROLE, TenantConstant.APP_ADMIN_ROLE}));
            SysUsers sysUser = this.usersService.getById(userId);
            if (!"1".equals(sysUser.getIsSys()) && !Objects.equals(12L, sysUser.getDepartmentId())) {
                this.sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.DEVELOP_ROLE.getValue()));
            }
        } else {
            long count3;
            long count2 = this.appDevelopTeamMemberService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeamMember::getUserId, (Object)userId)).eq(SysAppDevelopTeamMember::getMemberType, (Object)0));
            if (count2 < 1L) {
                this.sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)TenantConstant.APP_DEVELOP_ROLE));
            }
            if ((count3 = this.appDevelopTeamMemberService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAppDevelopTeamMember::getUserId, (Object)userId)).eq(SysAppDevelopTeamMember::getMemberType, (Object)1))) < 1L) {
                this.sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)TenantConstant.APP_ADMIN_ROLE));
            }
        }
    }

    public void transferAdministrator(TransferMemberTypeDto transferDto) {
        SysUserRole record2;
        SecurityUser securityUser;
        List list;
        List memberTypeList;
        Long userId = transferDto.getTargetUserId();
        SysUserRole record = (SysUserRole)this.sysUserRoleService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)TenantConstant.APP_ADMIN_ROLE));
        if (null == record) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(userId);
            sysUserRole.setGrantedRole(TenantConstant.APP_ADMIN_ROLE);
            sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            sysUserRole.setCreator(userId);
            sysUserRole.setLastEditor(userId);
            LocalDateTime now = LocalDateTime.now();
            sysUserRole.setLastTime(now);
            sysUserRole.setCreateTime(now);
            this.sysRolesService.delAuthCacheInfo(userId);
            this.sysUserRoleService.save((Object)sysUserRole);
        }
        if ((memberTypeList = (list = this.appDevelopTeamMemberService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getUserId, (Object)(securityUser = BaseSecurityUtil.getUser()).getUserId()))).stream().map(SysAppDevelopTeamMember::getMemberType).collect(Collectors.toList())).stream().allMatch(memberType -> memberType.equals(0)) && HussarUtils.isNotEmpty((Object)(record2 = (SysUserRole)this.sysUserRoleService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, (Object)securityUser.getUserId())).eq(SysUserRole::getGrantedRole, (Object)TenantConstant.APP_ADMIN_ROLE))))) {
            this.sysUserRoleService.removeById((Object)record2);
        }
    }
}

