/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.form.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.application.form.dao.SysFormGroupMapper;
import com.jxdinfo.hussar.application.form.dto.SysFormGroupDto;
import com.jxdinfo.hussar.application.form.model.SysForm;
import com.jxdinfo.hussar.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.application.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.application.form.service.ISysFormService;
import com.jxdinfo.hussar.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.application.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.form.service.impl.sysFormGroupServiceImpl")
public class SysFormGroupServiceImpl
extends HussarServiceImpl<SysFormGroupMapper, SysFormGroup>
implements ISysFormGroupService {
    @Resource
    private ISysFormService sysFormService;

    public ApiResponse<Boolean> addFormGroup(SysFormGroupDto sysFormGroupDto) {
        boolean flag = this.save((BaseEntity)sysFormGroupDto);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public ApiResponse<Boolean> editFormGroup(SysFormGroupDto sysFormGroupDto) {
        boolean flag = this.updateById((BaseEntity)sysFormGroupDto);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<Boolean> deleteFormGroup(Long groupId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysForm::getFormGroupId, (Object)groupId);
        wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)0);
        if (HussarUtils.isNotEmpty((Object)this.sysFormService.getOne((Wrapper)wrapper))) {
            throw new BaseException("\u5206\u7ec4\u4e0b\u5b58\u5728\u8868\u5355\u65e0\u6cd5\u5220\u9664");
        }
        boolean flag = this.removeById(groupId);
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse<List<SysFormGroup>> getFormGroupList(Long appId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysFormGroup::getAppId, (Object)appId);
        wrapper.orderBy(true, true, SysFormGroup::getSeq);
        return ApiResponse.success((Object)this.list((Wrapper)wrapper));
    }

    @HussarTransactional
    public ApiResponse<Boolean> editGroupAndForm(SysSiftGroupList sysSiftGroupList) {
        List haveGroupList = sysSiftGroupList.getHaveGroupList();
        for (int i = 0; i < haveGroupList.size(); ++i) {
            ((SysFormGroupVo)haveGroupList.get(i)).setSeq(i);
            for (int j = 0; j < ((SysFormGroupVo)haveGroupList.get(i)).getSysFormList().size(); ++j) {
                ((SysForm)((SysFormGroupVo)haveGroupList.get(i)).getSysFormList().get(j)).setSeq(j);
                ((SysForm)((SysFormGroupVo)haveGroupList.get(i)).getSysFormList().get(j)).setFormGroupId(((SysFormGroupVo)haveGroupList.get(i)).getId());
            }
        }
        List formGroups = haveGroupList.stream().map(entity -> {
            SysFormGroup sysFormGroup = new SysFormGroup();
            BeanUtils.copyProperties((Object)entity, (Object)sysFormGroup);
            return sysFormGroup;
        }).collect(Collectors.toList());
        this.updateBatchById(formGroups);
        List noGroupList = sysSiftGroupList.getNoGroupList();
        for (int i = 0; i < noGroupList.size(); ++i) {
            ((SysForm)noGroupList.get(i)).setSeq(i);
        }
        ArrayList needUpdateSysForm = new ArrayList(noGroupList);
        for (SysFormGroupVo sysFormGroupVo : haveGroupList) {
            needUpdateSysForm.addAll(sysFormGroupVo.getSysFormList());
        }
        return ApiResponse.success((Object)this.sysFormService.updateBatchById(needUpdateSysForm));
    }

    public ApiResponse<Boolean> sortGroup(List<Long> groupIdList) {
        ArrayList<SysFormGroup> sysFormGroups = new ArrayList<SysFormGroup>();
        for (int i = 0; i < groupIdList.size(); ++i) {
            SysFormGroup sysFormGroup = new SysFormGroup();
            sysFormGroup.setId(groupIdList.get(i));
            sysFormGroup.setSeq(i);
            sysFormGroups.add(sysFormGroup);
        }
        return ApiResponse.success((Object)this.updateBatchById(sysFormGroups));
    }
}

