/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.application.authority.dto.ButtonAuthoritiesDto;
import com.jxdinfo.hussar.application.authority.dto.ButtonDto;
import com.jxdinfo.hussar.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.application.authority.vo.ButtonVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.authority.service.impl.sysAppVisitRoleButtonServiceImpl")
public class SysAppVisitRoleButtonServiceImpl
extends HussarServiceImpl<SysAppVisitRoleButtonMapper, SysAppVisitRoleButton>
implements ISysAppVisitRoleButtonService {
    @Resource
    private SysAppVisitRoleButtonMapper sysAppVisitRoleButtonMapper;

    public ApiResponse<Boolean> addButtonAuthorityRoles(ButtonAuthoritiesDto buttonAuthoritiesDto) {
        this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getFormId, (Object)buttonAuthoritiesDto.getFormId())).eq(SysAppVisitRoleButton::getRoleId, (Object)buttonAuthoritiesDto.getRoleId()));
        ArrayList<SysAppVisitRoleButton> sysAppVisitRoleButtons = new ArrayList<SysAppVisitRoleButton>();
        List buttonDtoList = buttonAuthoritiesDto.getButtonDtoList();
        for (ButtonDto buttonDto : buttonDtoList) {
            SysAppVisitRoleButton sysAppVisitRoleButton = new SysAppVisitRoleButton();
            sysAppVisitRoleButton.setAppId(buttonAuthoritiesDto.getAppId());
            sysAppVisitRoleButton.setRoleId(buttonAuthoritiesDto.getRoleId());
            sysAppVisitRoleButton.setFormId(buttonAuthoritiesDto.getFormId());
            sysAppVisitRoleButton.setButtonName(buttonDto.getButtonName());
            sysAppVisitRoleButton.setButtonCode(buttonDto.getButtonCode());
            sysAppVisitRoleButtons.add(sysAppVisitRoleButton);
        }
        return ApiResponse.success((Object)this.saveBatch(sysAppVisitRoleButtons));
    }

    public ApiResponse<List<ButtonVo>> getButtonAuthorityRolesList(Long formId, Long roleId) {
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(SysAppVisitRoleButton::getFormId, (Object)formId);
        ew.eq(SysAppVisitRoleButton::getRoleId, (Object)roleId);
        List roleButtonList = this.list((Wrapper)ew);
        ArrayList<ButtonVo> buttonVos = new ArrayList<ButtonVo>();
        for (SysAppVisitRoleButton sysAppVisitRoleButton : roleButtonList) {
            ButtonVo buttonVo = new ButtonVo();
            buttonVo.setButtonCode(sysAppVisitRoleButton.getButtonCode());
            buttonVo.setButtonName(sysAppVisitRoleButton.getButtonName());
            buttonVos.add(buttonVo);
        }
        return ApiResponse.success(buttonVos);
    }

    public ApiResponse<List<ButtonVo>> formAuthorityButton(Long formId) {
        if (HussarUtils.isNotEmpty((Object)formId)) {
            List rolesList;
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            if (HussarUtils.isNotEmpty((Object)shiroUser) && HussarUtils.isNotEmpty((Object)(rolesList = shiroUser.getRolesList()))) {
                return ApiResponse.success(this.sysAppVisitRoleButtonMapper.selectByFromId(formId, rolesList));
            }
            return ApiResponse.success();
        }
        throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
    }
}

