/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.application.application.dao.SysAppAuthorizeMapper;
import com.jxdinfo.hussar.application.application.dao.SysAppDevelopTeamMapper;
import com.jxdinfo.hussar.application.application.dao.SysAppGroupMapper;
import com.jxdinfo.hussar.application.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.application.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.application.enums.SysUserRoleEnum;
import com.jxdinfo.hussar.application.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.application.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.application.model.SysApplication;
import com.jxdinfo.hussar.application.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.application.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.application.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.application.form.model.SysForm;
import com.jxdinfo.hussar.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.application.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.application.form.service.ISysFormService;
import com.jxdinfo.hussar.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.UnifyPermissionProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.application.service.impl.SysApplicationServiceImpl")
public class SysApplicationServiceImpl
extends HussarServiceImpl<SysApplicationMapper, SysApplication>
implements ISysApplicationService {
    private static final String TEAMNAME_SUFFIX = "\u5f00\u53d1\u56e2\u961f";
    @Resource
    private ISysIdtableService sysIdTableService;
    @Resource
    private ISysAppRecycleService sysAppRecycleService;
    @Resource
    private ISysAppGroupService sysAppGroupService;
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private SysAppGroupMapper sysAppGroupMapper;
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysFormGroupService sysFormGroupService;
    @Resource
    private ISysFormService formService;
    @Autowired
    private UnifyPermissionProperties appProperties;
    @Autowired
    private ISysResourceMosulesService sysResourceMosulesService;
    @Autowired
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysAppAuthorizeService sysAppAuthorizeService;
    @Resource
    private ISysAppDevelopTeamService developTeamService;
    @Resource
    private SysAppDevelopTeamMapper developTeamMapper;
    @Resource
    private SysAppAuthorizeMapper appAuthorizeMapper;
    @Resource
    private ISysRolesExternalService rolesExternalService;

    public List<SysAppGroupVo> getAppList(String appName) {
        List<Long> appIds = this.getCurrentUserAuthorityApp();
        if (HussarUtils.isEmpty(appIds)) {
            return null;
        }
        List<Object> appList = new ArrayList();
        ArrayList<Long> groupIds = new ArrayList<Long>();
        appList = this.sysApplicationMapper.getAppList(appName, appIds);
        for (SysApplicationVo sysApplicationVo : appList) {
            groupIds.add(sysApplicationVo.getAppGroupId());
        }
        ArrayList<SysAppGroup> sysAppGroups = new ArrayList();
        if (HussarUtils.isNotEmpty(groupIds)) {
            sysAppGroups = this.sysAppGroupMapper.getAppGroupByIds(groupIds);
        }
        ArrayList<SysApplicationVo> arrayList = new ArrayList<SysApplicationVo>();
        for (SysApplicationVo sysApplicationVo : appList) {
            SysApplicationVo vo = new SysApplicationVo();
            BeanUtils.copyProperties((Object)sysApplicationVo, (Object)vo);
            arrayList.add(vo);
        }
        return this.combinedData(arrayList, sysAppGroups);
    }

    public List<SysAppGroupVo> getManageAppList(Long appGroupId, String appName, String appStatus) {
        List<Long> appIds;
        ArrayList appListVo = Lists.newArrayListWithCapacity((int)10);
        SecurityUser user = BaseSecurityUtil.getUser();
        List<SysApplicationVo> appList = null;
        List<Object> sysAppGroups = new ArrayList();
        if (user.isSuperAdmin() || user.getRolesList().contains(SysUserRoleEnum.APPLICATIONADMIN.getValue()) || user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue())) {
            appList = this.sysApplicationMapper.getAppListManage(appGroupId, appName, appStatus, null);
            if (HussarUtils.isEmpty((Object)appGroupId) && HussarUtils.isEmpty((Object)appName) && HussarUtils.isEmpty((Object)appStatus)) {
                LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
                wrapper.orderByDesc(HussarBaseEntity::getCreateTime);
                sysAppGroups = this.sysAppGroupService.list((Wrapper)wrapper);
            } else {
                LinkedHashSet groupIds = Sets.newLinkedHashSetWithExpectedSize((int)10);
                for (SysApplication sysApplication : appList) {
                    groupIds.add(sysApplication.getAppGroupId());
                }
                if (HussarUtils.isNotEmpty((Object)appGroupId)) {
                    groupIds.add(appGroupId);
                }
                if (HussarUtils.isNotEmpty((Object)groupIds)) {
                    sysAppGroups = this.sysAppGroupMapper.getAppGroup(null, new ArrayList<Long>(groupIds));
                }
            }
        } else {
            appIds = this.developTeamService.selectAppListByCurrentUser();
            if (HussarUtils.isEmpty((Object)appIds)) {
                if (HussarUtils.isNotEmpty((Object)appGroupId)) {
                    sysAppGroups = this.sysAppGroupMapper.getAppGroupById(appGroupId);
                    return this.combinedData(appListVo, sysAppGroups);
                }
                return Lists.newArrayListWithCapacity((int)0);
            }
            appList = this.sysApplicationMapper.getAppListManage(appGroupId, appName, appStatus, appIds);
            if (HussarUtils.isEmpty(appList)) {
                if (HussarUtils.isNotEmpty((Object)appGroupId)) {
                    sysAppGroups = this.sysAppGroupMapper.getAppGroupById(appGroupId);
                    return this.combinedData(appListVo, sysAppGroups);
                }
                return Lists.newArrayListWithCapacity((int)0);
            }
            Set groupIds = appList.stream().map(SysApplication::getAppGroupId).collect(Collectors.toSet());
            if (HussarUtils.isNotEmpty((Object)appGroupId) || HussarUtils.isNotEmpty((Object)appName) || HussarUtils.isNotEmpty((Object)appStatus)) {
                if (HussarUtils.isNotEmpty((Object)appGroupId)) {
                    groupIds.add(appGroupId);
                }
                sysAppGroups = this.sysAppGroupMapper.getAppGroupByIds(new ArrayList<Long>(groupIds));
            } else {
                sysAppGroups = this.sysAppGroupMapper.getAppGroup(BaseSecurityUtil.getUser().getUserId(), new ArrayList<Long>(groupIds));
            }
        }
        appIds = appList.stream().map(SysApplication::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(appIds)) {
            List<SysAppDevelopTeam> sysAppDevelopTeams = this.developTeamMapper.selectAppDevelopTeamList(appIds);
            Map map = sysAppDevelopTeams.stream().collect(Collectors.toMap(SysAppDevelopTeam::getAppId, Function.identity()));
            for (SysApplicationVo app : appList) {
                SysApplicationVo vo = new SysApplicationVo();
                BeanUtils.copyProperties((Object)app, (Object)vo);
                if (null != map.get(vo.getId())) {
                    vo.setTeamId(((SysAppDevelopTeam)map.get(vo.getId())).getId());
                }
                appListVo.add(vo);
            }
        }
        return this.combinedData(appListVo, sysAppGroups);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean addApp(SysApplicationDto sysApplicationDto) {
        List appName = this.list((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)sysApplicationDto.getAppName()));
        if (HussarUtils.isNotEmpty((Object)appName)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01(\u5e94\u7528\u540d\u79f0\u5df2\u5b58\u5728\uff01)");
        }
        Long appId = IdWorker.getId((Object)new SysApplicationDto());
        sysApplicationDto.setId(appId);
        sysApplicationDto.setAppStatus("1");
        sysApplicationDto.setReleaseStatus("1");
        sysApplicationDto.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        if (HussarUtils.isEmpty((Object)sysApplicationDto.getAppCode())) {
            String currentCode = this.sysIdTableService.getCurrentCode("APP_CODE", "SYS_APPLICATION");
            sysApplicationDto.setAppCode(currentCode);
        }
        String teamName = sysApplicationDto.getAppName() + TEAMNAME_SUFFIX;
        AppDevelopTeamDto developTeamDto = new AppDevelopTeamDto();
        developTeamDto.setAppId(appId);
        developTeamDto.setTeamName(teamName);
        developTeamDto.setUserIds(Arrays.asList(BaseSecurityUtil.getUser().getId()));
        this.developTeamService.saveAppDevelopTeam(developTeamDto);
        if ("1".equals(sysApplicationDto.getAppType())) {
            this.initDevelopRole(sysApplicationDto);
        }
        this.save((BaseEntity)sysApplicationDto);
        if (HussarUtils.isNotEmpty((Object)sysApplicationDto.getDevelopRoleId())) {
            UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
            Map extendUserMap = userDetails.getExtendUserMap();
            ArrayList<Long> roleIds = new ArrayList<Long>();
            Object rolesList = extendUserMap.get("rolesList");
            if (HussarUtils.isNotEmpty(rolesList)) {
                roleIds.addAll((List)rolesList);
            }
            roleIds.add(sysApplicationDto.getDevelopRoleId());
            userDetails.addExtendUserMap("rolesList", roleIds);
            SecurityUtil.getTokenSession().addUserDetailToTokenSession(userDetails, userDetails.getTokenValue());
            HussarCacheUtil.evict((String)"login_user_info", (Object)userDetails.getAccessToken());
        }
        return Boolean.TRUE;
    }

    private void initDevelopRole(SysApplicationDto sysApplicationDto) {
        ApiResponse result = this.rolesExternalService.addAppDevRole(sysApplicationDto.getAppName());
        if (!result.isSuccess()) {
            throw new BaseException("\u521b\u5efa\u5e94\u7528\u5f00\u53d1\u8005\u89d2\u8272\u5931\u8d25");
        }
        Long developRoleId = (Long)result.getData();
        sysApplicationDto.setDevelopRoleId(developRoleId);
        RoleUserDto userDto = new RoleUserDto();
        userDto.setRoleId(developRoleId);
        ArrayList userVos = Lists.newArrayListWithCapacity((int)1);
        RoleOrgUserVo u = new RoleOrgUserVo();
        u.setId(BaseSecurityUtil.getUser().getId());
        userVos.add(u);
        userDto.setAdds((List)userVos);
        this.rolesExternalService.addOrDelAppDevRoleUser(userDto);
        SysAppAuthorize authorize = new SysAppAuthorize();
        authorize.setId(Long.valueOf(IdWorker.getId((Object)new SysAppAuthorize())));
        authorize.setAppId(sysApplicationDto.getId());
        authorize.setRoleId(developRoleId);
        this.appAuthorizeMapper.insert(authorize);
    }

    public Boolean updateApp(SysApplicationDto sysApplicationDto) {
        List appName;
        SysApplication sysApplication = (SysApplication)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)sysApplicationDto.getId()));
        if (!Objects.equals(sysApplication.getAppName(), sysApplicationDto.getAppName()) && HussarUtils.isNotEmpty((Object)(appName = this.list((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)sysApplicationDto.getAppName()))))) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01(\u5e94\u7528\u540d\u79f0\u5df2\u5b58\u5728\uff01)");
        }
        return this.updateById((BaseEntity)sysApplicationDto);
    }

    @HussarTransactional
    public Boolean deleteApp(Long appId) {
        SysApplication appInfo = (SysApplication)this.getById(appId);
        SysAppRecycle sysAppRecycle = new SysAppRecycle();
        BeanUtils.copyProperties((Object)appInfo, (Object)sysAppRecycle);
        sysAppRecycle.setDeleteUser(BaseSecurityUtil.getUser().getUserId());
        sysAppRecycle.setCreateUser(BaseSecurityUtil.getUser().getUserId());
        sysAppRecycle.setDeleteTime(LocalDateTime.now());
        this.sysAppRecycleService.save((Object)sysAppRecycle);
        return this.removeById(appId);
    }

    public ApiResponse<SysApplicationVo> getAppDetail(Long appId) {
        return ApiResponse.success((Object)this.sysApplicationMapper.getAppDetailContainUserName(appId));
    }

    public SysApplicationVo getAuthorityAppDetail(Long appId) {
        List dataFormGroup;
        SecurityUser user = BaseSecurityUtil.getUser();
        Boolean authorityFlag = this.validateAuthorityByAppId(appId);
        if (!authorityFlag.booleanValue()) {
            throw new BaseException("\u60a8\u6ca1\u6709\u8be5\u5e94\u7528\u7684\u8bbf\u95ee\u6743\u9650");
        }
        boolean designedOrNotFlag = false;
        List dataForm = (List)this.formService.getSysFormByAppId(appId).getData();
        if (HussarUtils.isNotEmpty((Object)dataForm)) {
            designedOrNotFlag = true;
        }
        if (!designedOrNotFlag && HussarUtils.isNotEmpty((Object)(dataFormGroup = (List)this.sysFormGroupService.getFormGroupList(appId).getData()))) {
            designedOrNotFlag = true;
        }
        Boolean hasAuthorityCreateForm = user.isSuperAdmin() || user.getRolesList().contains(SysUserRoleEnum.APPLICATIONADMIN.getValue()) || user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue()) ? Boolean.valueOf(true) : this.developTeamService.checkCurrentUserInTeam(appId);
        SysApplicationVo appDetail = this.sysApplicationMapper.getAppDetail(appId);
        appDetail.setDesignedOrNot(Boolean.valueOf(designedOrNotFlag));
        appDetail.setHasAuthorityCreateForm(hasAuthorityCreateForm);
        return appDetail;
    }

    public Boolean updateSecretKey(Long appId) {
        SysApplication sysApplication = new SysApplication();
        sysApplication.setId(appId);
        sysApplication.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        return this.updateById((BaseEntity)sysApplication);
    }

    public String getCurrentCode() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    private List<SysAppGroupVo> combinedData(List<SysApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, sysAppGroupVo -> sysAppGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysApplicationVo sysApplication : appList) {
            SysAppGroupVo sysAppGroupVo2 = (SysAppGroupVo)resultCollect.get(sysApplication.getAppGroupId());
            if (HussarUtils.isEmpty((Object)sysAppGroupVo2)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo2.getSysApplicationList())) {
                sysAppGroupVo2.getSysApplicationList().add(sysApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysAppGroupVo2.getSysApplicationList())) continue;
            ArrayList<SysApplicationVo> sysApplicationList = new ArrayList<SysApplicationVo>();
            sysApplicationList.add(sysApplication);
            sysAppGroupVo2.setSysApplicationList(sysApplicationList);
        }
        return new ArrayList<SysAppGroupVo>(resultCollect.values());
    }

    public List<JSTreeModel> getAppTree(String type) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        Long appId = this.appProperties.getApplicationId();
        List applications = HussarUtils.isNotEmpty((Object)appId) ? this.list((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)appId)) : this.list();
        List<Object> relationAppIds = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)applications)) {
            List appIds = applications.stream().map(SysApplication::getId).collect(Collectors.toList());
            if (HussarUtils.equals((Object)"res", (Object)type)) {
                List resourceModules = this.sysResourceMosulesService.list((Wrapper)new LambdaQueryWrapper().in(SysResourceModules::getApplicationId, appIds));
                if (HussarUtils.isNotEmpty((Object)resourceModules)) {
                    relationAppIds = resourceModules.stream().map(SysResourceModules::getApplicationId).collect(Collectors.toList());
                }
            } else {
                List functionModules = this.sysFunctionModulesService.list((Wrapper)new LambdaQueryWrapper().in(SysFunctionModules::getApplicationId, appIds));
                if (HussarUtils.isNotEmpty((Object)functionModules)) {
                    relationAppIds = functionModules.stream().map(SysFunctionModules::getApplicationId).collect(Collectors.toList());
                }
            }
            for (SysApplication application : applications) {
                JSTreeModel treeModel = new JSTreeModel();
                treeModel.setId(application.getId());
                treeModel.setText(application.getAppName());
                treeModel.setCode(application.getAppCode());
                treeModel.setType("app");
                treeModel.setChildren(relationAppIds.contains(application.getId()) ? "true" : "false");
                result.add(treeModel);
            }
        }
        return result;
    }

    public Boolean validateAuthorityByAppId(Long appId) {
        List currentUserRoleList;
        HashSet currentUserRoleSet;
        ApiResponse appRoleList = this.sysAppAuthorizeService.getAppRoleList(appId);
        List roleVoList = (List)appRoleList.getData();
        if (HussarUtils.isEmpty((Object)roleVoList)) {
            return false;
        }
        Set authorityRoleSet = roleVoList.stream().map(RoleVo::getId).collect(Collectors.toSet());
        Sets.SetView intersectionSet = Sets.intersection(authorityRoleSet, currentUserRoleSet = new HashSet(currentUserRoleList = BaseSecurityUtil.getUser().getRolesList()));
        if (HussarUtils.isEmpty((Object)intersectionSet)) {
            return false;
        }
        return true;
    }

    public List<Long> getCurrentUserAuthorityApp() {
        return this.sysAppAuthorizeService.getCurrentUserAuthorityApp();
    }

    public List<SysApplicationVo> getAppContainFormInfoList() {
        ArrayList resultApps = Lists.newArrayListWithCapacity((int)10);
        List appIds = this.developTeamService.selectAppListByCurrentUser();
        if (HussarUtils.isEmpty((Object)appIds)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        List<SysApplicationVo> appList = this.sysApplicationMapper.getAppListManage(null, null, null, appIds);
        for (SysApplicationVo applicationVo : appList) {
            ApiResponse formGroupList;
            List noGroupList;
            SysApplicationVo aT = new SysApplicationVo();
            aT.setId(applicationVo.getId());
            aT.setAppName(applicationVo.getAppName());
            ApiResponse sysFormByApps = this.sysFormService.getSysFormByAppId(aT.getId());
            if (HussarUtils.isNotEmpty((Object)sysFormByApps.getData()) && HussarUtils.isNotEmpty(noGroupList = ((List)sysFormByApps.getData()).stream().filter(s -> HussarUtils.isEmpty((Object)s.getFormGroupId())).collect(Collectors.toList()))) {
                aT.setNoGroupList(noGroupList);
            }
            if (HussarUtils.isNotEmpty((Object)(formGroupList = this.sysFormGroupService.getFormGroupList(aT.getId())).getData())) {
                ArrayList sysFormGroups = Lists.newArrayListWithCapacity((int)10);
                for (SysFormGroup sysFormGroup : (List)formGroupList.getData()) {
                    SysFormGroupVo gT = new SysFormGroupVo();
                    gT.setId(sysFormGroup.getId());
                    gT.setGroupName(sysFormGroup.getGroupName());
                    gT.setAppId(aT.getId());
                    List sysFormList = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysForm::getFormGroupId, (Object)gT.getId()));
                    gT.setSysFormList(sysFormList);
                    sysFormGroups.add(gT);
                }
                aT.setSysFormGroupVos((List)sysFormGroups);
            }
            resultApps.add(aT);
        }
        return resultApps;
    }

    public Boolean checkSameAppName(Long appId, String appName) {
        if (HussarUtils.isEmpty((Object)appId)) {
            List list = this.sysApplicationMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)appName));
            if (HussarUtils.isEmpty((Object)list)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        List list = this.sysApplicationMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysApplication::getId, (Object)appId)).like(SysApplication::getAppName, (Object)appName));
        if (HussarUtils.isEmpty((Object)list)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

