/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.application.application.dao.SysAppDevelopTeamMapper;
import com.jxdinfo.hussar.application.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.application.model.SysApplication;
import com.jxdinfo.hussar.application.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.application.vo.AppDevelopTeamDetailVo;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.application.service.impl.sysAppDevelopTeamServiceImpl")
public class SysAppDevelopTeamServiceImpl
extends HussarServiceImpl<SysAppDevelopTeamMapper, SysAppDevelopTeam>
implements ISysAppDevelopTeamService {
    @Autowired
    private ISysAppDevelopTeamMemberService appDevelopTeamMemberService;
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Autowired
    private ISysRolesExternalService sysRolesExternalService;
    @Resource
    private SysAppDevelopTeamMapper sysAppDevelopTeamMapper;

    @HussarTransactional
    public Boolean saveAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto) {
        SysAppDevelopTeam sysAppDevelopTeam = new SysAppDevelopTeam();
        BeanUtils.copyProperties((Object)appDevelopTeamDto, (Object)sysAppDevelopTeam);
        long id = IdWorker.getId((Object)sysAppDevelopTeam);
        List userIds = appDevelopTeamDto.getUserIds();
        if (HussarUtils.isNotEmpty((Object)userIds)) {
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            ArrayList<SysAppDevelopTeamMember> memberList = new ArrayList<SysAppDevelopTeamMember>();
            for (Long userId : userIds) {
                SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
                member.setTeamId(Long.valueOf(id));
                member.setUserId(userId);
                memberList.add(member);
            }
            this.appDevelopTeamMemberService.saveBatch(memberList);
        }
        sysAppDevelopTeam.setId(Long.valueOf(id));
        return this.save((BaseEntity)sysAppDevelopTeam);
    }

    @HussarTransactional
    public Boolean updateAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto) {
        SysAppDevelopTeam sysAppDevelopTeam = new SysAppDevelopTeam();
        BeanUtils.copyProperties((Object)appDevelopTeamDto, (Object)sysAppDevelopTeam);
        Long teamId = appDevelopTeamDto.getTeamId();
        List newUserIds = appDevelopTeamDto.getUserIds();
        List oldUserVoList = this.appDevelopTeamMemberService.listAppDevelopTeamMember(teamId);
        this.appDevelopTeamMemberService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId));
        if (HussarUtils.isNotEmpty((Object)newUserIds)) {
            newUserIds = newUserIds.stream().distinct().collect(Collectors.toList());
            ArrayList<SysAppDevelopTeamMember> memberList = new ArrayList<SysAppDevelopTeamMember>();
            for (Long userId2 : newUserIds) {
                SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
                member.setTeamId(teamId);
                member.setUserId(userId2);
                memberList.add(member);
            }
            this.appDevelopTeamMemberService.saveBatch(memberList);
        }
        sysAppDevelopTeam.setId(teamId);
        boolean updateFlag = this.updateById((BaseEntity)sysAppDevelopTeam);
        SysAppDevelopTeam team = (SysAppDevelopTeam)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getId, (Object)teamId));
        SysApplication app = (SysApplication)this.sysApplicationService.getById((Serializable)team.getAppId());
        if ("1".equals(app.getAppType())) {
            Long developRoleId = app.getDevelopRoleId();
            RoleUserDto roleUserDto = new RoleUserDto();
            roleUserDto.setRoleId(developRoleId);
            List removeList = oldUserVoList.stream().map(userVo -> {
                RoleOrgUserVo roleOrgUserVo = new RoleOrgUserVo();
                roleOrgUserVo.setId(userVo.getId());
                return roleOrgUserVo;
            }).collect(Collectors.toList());
            roleUserDto.setDels(removeList);
            List addList = newUserIds.stream().map(userId -> {
                RoleOrgUserVo roleOrgUserVo = new RoleOrgUserVo();
                roleOrgUserVo.setId(userId);
                return roleOrgUserVo;
            }).collect(Collectors.toList());
            roleUserDto.setAdds(addList);
            Boolean roleUserFlag = (Boolean)this.sysRolesExternalService.addOrDelAppDevRoleUser(roleUserDto).getData();
            return updateFlag && roleUserFlag != false;
        }
        return updateFlag;
    }

    public ApiResponse<AppDevelopTeamDetailVo> getAppDevelopTeamDetail(Long appId) {
        AppDevelopTeamDetailVo teamDetailVo = new AppDevelopTeamDetailVo();
        SysAppDevelopTeam team = (SysAppDevelopTeam)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)team)) {
            throw new BaseException("\u8be5\u5e94\u7528\u6ca1\u6709\u5e94\u7528\u5f00\u53d1\u56e2\u961f\uff01");
        }
        BeanUtils.copyProperties((Object)team, (Object)teamDetailVo);
        teamDetailVo.setTeamId(team.getId());
        List userVoList = this.appDevelopTeamMemberService.listAppDevelopTeamMember(team.getId());
        teamDetailVo.setUserList(userVoList);
        return ApiResponse.success((Object)teamDetailVo);
    }

    public List<Long> selectAppListByCurrentUser() {
        Long userId = BaseSecurityUtil.getUser().getId();
        return this.sysAppDevelopTeamMapper.selectAppListByCurrentUser(userId);
    }

    public Boolean checkCurrentUserInTeam(Long appId) {
        List<Long> appIdList = this.selectAppListByCurrentUser();
        return appIdList.contains(appId);
    }
}

