/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitDataLogicFilterMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitDataLogicMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitFormAuthorizeRolesMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitRoleOrganDataAuthorityMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.base.portal.authority.dto.SysAppVisitFormAuthorizeRolesDto;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.base.portal.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.base.portal.authority.vo.FormRoleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.base.portal.authority.service.impl.sysAppVisitFormAuthorizeRolesServiceImpl")
public class SysAppVisitFormAuthorizeRolesServiceImpl
extends HussarServiceImpl<SysAppVisitFormAuthorizeRolesMapper, SysAppVisitFormAuthorizeRoles>
implements ISysAppVisitFormAuthorizeRolesService {
    @Resource
    private SysAppVisitFormAuthorizeRolesMapper appVisitFormAuthorizeRolesMapper;
    @Resource
    private SysAppVisitRoleButtonMapper sysAppVisitRoleButtonMapper;
    @Autowired
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    @Resource
    private SysUpAppVisitRoleFieldMapper sysUpAppVisitRoleFieldMapper;
    @Autowired
    private ISysAppVisitDataLogicService sysAppVisitDataLogicService;
    @Resource
    private SysAppVisitRoleButtonMapper roleButtonMapper;
    @Resource
    private SysAppVisitRoleOrganDataAuthorityMapper roleOrganDataAuthorityMapper;
    @Resource
    private SysAppVisitDataLogicMapper dataLogicMapper;
    @Resource
    private SysAppVisitDataLogicFilterMapper dataLogicFilterMapper;

    @HussarTransactional
    public ApiResponse<Boolean> addFormAuthorizeRoles(SysAppVisitFormAuthorizeRolesDto sysAppVisitFormAuthorizeRolesDto) {
        ArrayList<SysAppVisitFormAuthorizeRoles> rolesList = new ArrayList<SysAppVisitFormAuthorizeRoles>();
        for (int i = 0; i < sysAppVisitFormAuthorizeRolesDto.getRoleIdList().size(); ++i) {
            this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getFormId, (Object)sysAppVisitFormAuthorizeRolesDto.getFormId())).eq(SysAppVisitFormAuthorizeRoles::getRoleId, sysAppVisitFormAuthorizeRolesDto.getRoleIdList().get(i)));
            SysAppVisitFormAuthorizeRoles authorizeRoles = new SysAppVisitFormAuthorizeRoles();
            BeanUtils.copyProperties((Object)sysAppVisitFormAuthorizeRolesDto, (Object)authorizeRoles);
            authorizeRoles.setRoleId((Long)sysAppVisitFormAuthorizeRolesDto.getRoleIdList().get(i));
            rolesList.add(authorizeRoles);
        }
        boolean flag = this.saveBatch(rolesList);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> deleteFormAuthorizeRoles(List<Long> formRoleId) {
        this.deleteFormOtherAuthorityInfo(formRoleId);
        return ApiResponse.success((Object)this.removeByIds(formRoleId));
    }

    private void deleteFormOtherAuthorityInfo(List<Long> formRoleId) {
        List sysAppVisitFormAuthorizeRoles = this.appVisitFormAuthorizeRolesMapper.selectBatchIds(formRoleId);
        Long formId = ((SysAppVisitFormAuthorizeRoles)sysAppVisitFormAuthorizeRoles.get(0)).getFormId();
        List roleIds = sysAppVisitFormAuthorizeRoles.stream().map(SysAppVisitFormAuthorizeRoles::getRoleId).collect(Collectors.toList());
        this.roleButtonMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getFormId, (Object)formId)).in(SysAppVisitRoleButton::getRoleId, roleIds));
        this.sysUpAppVisitRoleFieldMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getFormId, (Object)formId)).in(SysUpAppVisitRoleField::getRoleId, roleIds));
        this.roleOrganDataAuthorityMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).in(SysAppVisitRoleOrganDataAuthority::getRoleId, roleIds));
        List sysAppVisitDataLogics = this.dataLogicMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)formId)).in(SysAppVisitDataLogic::getRoleId, roleIds));
        if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogics)) {
            List logicIds = sysAppVisitDataLogics.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            this.dataLogicMapper.deleteBatchIds(logicIds);
            this.dataLogicFilterMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysAppVisitDataLogicFilter::getRoleDataLogicId, logicIds));
        }
    }

    public ApiResponse<List<FormRoleVo>> getFormAuthorizeRolesList(Long appId, Long formId) {
        return ApiResponse.success(this.appVisitFormAuthorizeRolesMapper.getFormAuthorizeRolesList(appId, formId));
    }

    public ApiResponse<List<Long>> getAuthorityFormList(Long appId) {
        return ApiResponse.success(this.appVisitFormAuthorizeRolesMapper.getAuthorityFormList(BaseSecurityUtil.getUser().getRolesList(), appId));
    }

    @HussarTransactional
    public ApiResponse<Boolean> roleCancel(SysAppVisitFormAuthorizeRolesDto formAuthorizeRolesDto) {
        if (HussarUtils.isNotEmpty((Object)formAuthorizeRolesDto.getFormId()) && HussarUtils.isNotEmpty((Object)formAuthorizeRolesDto.getRoleId())) {
            Long formId = formAuthorizeRolesDto.getFormId();
            Long roleId = formAuthorizeRolesDto.getRoleId();
            this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getFormId, (Object)formId)).eq(SysAppVisitFormAuthorizeRoles::getRoleId, (Object)roleId));
            this.sysAppVisitRoleButtonMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getFormId, (Object)formId)).eq(SysAppVisitRoleButton::getRoleId, (Object)roleId));
            this.roleOrganDataAuthorityService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)roleId));
            this.sysUpAppVisitRoleFieldMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getFormId, (Object)formId)).eq(SysUpAppVisitRoleField::getRoleId, (Object)roleId));
            this.sysAppVisitDataLogicService.dataLogicAuthorityCancel(formId, roleId);
            return ApiResponse.success((Object)Boolean.TRUE);
        }
        throw new BaseException("\u8868\u5355id\u6216\u89d2\u8272id\u4e3a\u7a7a");
    }
}

