/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserInfoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.service.SysPostRoleService;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppAuthorizeMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDevelopTeamMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDevelopTeamMemberMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppRecycleMapper;
import com.jxdinfo.hussar.base.portal.application.enums.SysUserRoleEnum;
import com.jxdinfo.hussar.base.portal.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.base.portal.application.model.SysAppRecycle;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppRecycleVo;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitDataLogicFilterMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitDataLogicMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitFormAuthorizeRolesMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitRoleOrganDataAuthorityMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.base.portal.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.base.portal.form.dao.SysFormGroupMapper;
import com.jxdinfo.hussar.base.portal.form.dao.SysFormMapper;
import com.jxdinfo.hussar.base.portal.form.model.SysForm;
import com.jxdinfo.hussar.base.portal.form.model.SysFormGroup;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppRecycleServiceImpl")
public class SysAppRecycleServiceImpl
extends HussarServiceImpl<SysAppRecycleMapper, SysAppRecycle>
implements ISysAppRecycleService {
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private SysAppRecycleMapper sysAppRecycleMapper;
    @Resource
    private ISysAppGroupService sysAppGroupService;
    @Resource
    private SysAppAuthorizeMapper appAuthorizeMapper;
    @Resource
    private SysAppVisitFormAuthorizeRolesMapper formAuthorizeRolesMapper;
    @Resource
    private SysAppVisitRoleButtonMapper roleButtonMapper;
    @Resource
    private SysUpAppVisitRoleFieldMapper roleFieldMapper;
    @Resource
    private SysAppVisitRoleOrganDataAuthorityMapper roleOrganDataAuthorityMapper;
    @Resource
    private SysAppVisitDataLogicMapper dataLogicMapper;
    @Resource
    private SysAppVisitDataLogicFilterMapper dataLogicFilterMapper;
    @Resource
    private SysAppDevelopTeamMapper developTeamMapper;
    @Resource
    private SysAppDevelopTeamMemberMapper developTeamMemberMapper;
    @Resource
    private SysFormMapper formMapper;
    @Resource
    private SysFormGroupMapper formGroupMapper;
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysStruRoleService sysStruRoleService;
    @Autowired
    private SysPostRoleService sysPostRoleService;
    @Autowired
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Autowired
    private ISysRoleResourceService sysRoleResourceService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private IHussarBaseUserInfoService userInfoService;

    public Page<SysAppRecycleVo> getRecycleList(PageInfo pageInfo, String appName) {
        Page<SysAppRecycleVo> result;
        List appRecycleVoList;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = null;
        if (!(user.isSuperAdmin() || user.getRolesList().contains(SysUserRoleEnum.APPLICATIONADMIN.getValue()) || user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue()))) {
            userId = user.getUserId();
        }
        if (HussarUtils.isNotEmpty((Object)(appRecycleVoList = (result = this.sysAppRecycleMapper.getRecycleList((Page<SysAppRecycleVo>)page, userId, appName)).getRecords()))) {
            List userIdList = appRecycleVoList.stream().map(SysAppRecycleVo::getUserId).collect(Collectors.toList());
            Map usersMap = this.userInfoService.getUserInfo(userIdList);
            for (SysAppRecycleVo item : appRecycleVoList) {
                SysUsers sysUsers = (SysUsers)usersMap.get(item.getUserId());
                if (!HussarUtils.isNotEmpty((Object)sysUsers)) continue;
                item.setUserName(sysUsers.getUserName());
            }
        }
        return result;
    }

    @HussarTransactional
    public Boolean revertApp(Long appId) {
        SysAppRecycle revertApp = (SysAppRecycle)this.getById(appId);
        if (HussarUtils.isEmpty((Object)this.sysAppGroupService.getById((Serializable)revertApp.getAppGroupId()))) {
            revertApp.setAppGroupId(Long.valueOf(1L));
        }
        SysApplication sysApplication = new SysApplication();
        BeanUtils.copyProperties((Object)revertApp, (Object)sysApplication);
        sysApplication.setAppStatus("1");
        sysApplication.setReleaseStatus("0");
        sysApplication.setCreator(revertApp.getCreateUser());
        sysApplication.setLastEditor(revertApp.getCreateUser());
        this.sysApplicationService.save((Object)sysApplication);
        return this.removeById(appId);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean deleteRecycleApp(Long appId) {
        this.formMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
        this.formGroupMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysFormGroup::getAppId, (Object)appId));
        SysAppRecycle sysAppRecycle = (SysAppRecycle)this.sysAppRecycleMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppRecycle::getId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)sysAppRecycle)) {
            Long developRoleId = sysAppRecycle.getDevelopRoleId();
            this.sysRolesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getId, (Object)developRoleId));
            this.sysStruRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getGrantedRole, (Object)developRoleId));
            this.sysPostRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getRoleId, (Object)developRoleId));
            this.sysRoleFunctionsService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getRoleId, (Object)developRoleId));
            this.sysRoleResourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getId, (Object)developRoleId));
            this.sysUserRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)developRoleId));
        }
        this.appAuthorizeMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppAuthorize::getAppId, (Object)appId));
        this.formAuthorizeRolesMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getAppId, (Object)appId));
        this.roleButtonMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getAppId, (Object)appId));
        this.roleFieldMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getAppId, (Object)appId));
        this.roleOrganDataAuthorityMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getAppId, (Object)appId));
        List sysAppVisitDataLogics = this.dataLogicMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogics)) {
            List logicIds = sysAppVisitDataLogics.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            this.dataLogicMapper.deleteBatchIds(logicIds);
            this.dataLogicFilterMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysAppVisitDataLogicFilter::getRoleDataLogicId, logicIds));
        }
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.developTeamMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        this.developTeamMapper.deleteById(sysAppDevelopTeam.getId());
        this.developTeamMemberMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)sysAppDevelopTeam.getId()));
        return this.removeById(appId);
    }
}

