/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.staff.service.StaffService;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitRoleOrganDataAuthorityMapper;
import com.jxdinfo.hussar.base.portal.authority.dto.OrganDataAuthorityDto;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.base.portal.authority.vo.OrganDataAuthorityFeignVo;
import com.jxdinfo.hussar.base.portal.authority.vo.OrganDataAuthorityVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.authority.service.impl.sysAppVisitRoleServiceImpl")
public class SysAppVisitRoleOrganDataAuthorityServiceImpl
extends HussarServiceImpl<SysAppVisitRoleOrganDataAuthorityMapper, SysAppVisitRoleOrganDataAuthority>
implements ISysAppVisitRoleOrganDataAuthorityService {
    @Autowired
    private StaffService staffService;
    @Autowired
    private ISysUsersService sysUsersService;

    @HussarTransactional
    public ApiResponse<Boolean> organDataAuthoritySave(OrganDataAuthorityDto organDataAuthorityDto) {
        SysAppVisitRoleOrganDataAuthority organDataAuthority = new SysAppVisitRoleOrganDataAuthority();
        StringBuilder organIdBuilder = new StringBuilder();
        StringBuilder userIdBuilder = new StringBuilder();
        BeanUtil.copy((Object)organDataAuthorityDto, (Object)organDataAuthority);
        organDataAuthority.setOnlySupOrgan(organDataAuthorityDto.getSupOrgan());
        if (HussarUtils.isNotEmpty((Object)organDataAuthorityDto.getOrganIds())) {
            for (Long organId : organDataAuthorityDto.getOrganIds()) {
                if (organIdBuilder.length() > 0) {
                    organIdBuilder.append(",");
                }
                organIdBuilder.append(organId);
            }
        }
        organDataAuthority.setOrganIdList(organIdBuilder.toString());
        if (HussarUtils.isNotEmpty((Object)organDataAuthorityDto.getUserIds())) {
            for (Long userId : organDataAuthorityDto.getUserIds()) {
                if (userIdBuilder.length() > 0) {
                    userIdBuilder.append(",");
                }
                userIdBuilder.append(userId);
            }
        }
        organDataAuthority.setUserIdList(userIdBuilder.toString());
        this.saveOrUpdate(organDataAuthority, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)organDataAuthorityDto.getRoleId())).eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)organDataAuthorityDto.getFormId()));
        return ApiResponse.success((Object)Boolean.TRUE, (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    public ApiResponse<OrganDataAuthorityVo> organDataAuthorityList(Long formId, Long roleId) {
        if (HussarUtils.isEmpty((Object)formId) || HussarUtils.isEmpty((Object)roleId)) {
            throw new BaseException("\u8868\u5355id\u6216\u89d2\u8272id\u4e3a\u7a7a");
        }
        OrganDataAuthorityVo organDataAuthorityVo = new OrganDataAuthorityVo();
        SysAppVisitRoleOrganDataAuthority organDataAuthority = (SysAppVisitRoleOrganDataAuthority)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)roleId));
        if (HussarUtils.isEmpty((Object)organDataAuthority)) {
            return ApiResponse.success((Object)organDataAuthorityVo);
        }
        BeanUtil.copy((Object)organDataAuthority, (Object)organDataAuthorityVo);
        organDataAuthorityVo.setSupOrgan(organDataAuthority.getOnlySupOrgan());
        if (HussarUtils.isNotEmpty((Object)organDataAuthority.getOrganIdList())) {
            String[] organIds = organDataAuthority.getOrganIdList().split(",");
            List organIdList = Arrays.stream(organIds).map(Long::valueOf).collect(Collectors.toList());
            organDataAuthorityVo.setSimpleOrganVos(this.staffService.getSimpleOrgan(organIdList));
        }
        if (HussarUtils.isNotEmpty((Object)organDataAuthority.getUserIdList())) {
            ArrayList<UserVo> userVos = new ArrayList<UserVo>();
            String[] userIds = organDataAuthority.getUserIdList().split(",");
            List userIdList = Arrays.stream(userIds).map(Long::valueOf).collect(Collectors.toList());
            List users = this.sysUsersService.listByIds(userIdList);
            if (HussarUtils.isNotEmpty((Object)users)) {
                for (SysUsers user : users) {
                    UserVo vo = new UserVo();
                    vo.setId(user.getId());
                    vo.setUserName(user.getUserName());
                    userVos.add(vo);
                }
            }
            organDataAuthorityVo.setSimpleUserVos(userVos);
        }
        return ApiResponse.success((Object)organDataAuthorityVo);
    }

    public ApiResponse<OrganDataAuthorityFeignVo> formAuthorityOrganData(Long formId) {
        if (HussarUtils.isEmpty((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException("\u5f53\u524d\u65e0\u767b\u5f55\u7528\u6237");
        }
        OrganDataAuthorityFeignVo organDataAuthorityFeignVo = new OrganDataAuthorityFeignVo();
        List rolesList = user.getRolesList();
        List roleOrganDataAuthorities = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).in(SysAppVisitRoleOrganDataAuthority::getRoleId, (Collection)rolesList));
        if (HussarUtils.isEmpty((Object)roleOrganDataAuthorities)) {
            return ApiResponse.success((Object)organDataAuthorityFeignVo);
        }
        List allOrgan = roleOrganDataAuthorities.stream().filter(roleOrganData -> Objects.equals("1", roleOrganData.getAllOrgan())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(allOrgan)) {
            return ApiResponse.success((Object)organDataAuthorityFeignVo);
        }
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> organIds = new HashSet<Long>();
        for (SysAppVisitRoleOrganDataAuthority roleOrganDataAuthority : roleOrganDataAuthorities) {
            if (Objects.equals("1", roleOrganDataAuthority.getOnlyIndividuals())) {
                Long userId = user.getId();
                userIds.add(userId);
                continue;
            }
            if (Objects.equals("1", roleOrganDataAuthority.getOnlySupOrgan())) {
                Object organId = user.getExtendUserMap().get("deptId");
                if (!HussarUtils.isNotEmpty(organId)) continue;
                organIds.add(Long.valueOf(organId.toString()));
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)roleOrganDataAuthority.getOrganIdList())) {
                String[] organIdString = roleOrganDataAuthority.getOrganIdList().split(",");
                Set organIdList = Arrays.stream(organIdString).map(Long::valueOf).collect(Collectors.toSet());
                organIds.addAll(organIdList);
            }
            if (!HussarUtils.isNotEmpty((Object)roleOrganDataAuthority.getUserIdList())) continue;
            String[] userIdString = roleOrganDataAuthority.getUserIdList().split(",");
            Set userIdList = Arrays.stream(userIdString).map(Long::valueOf).collect(Collectors.toSet());
            userIds.addAll(userIdList);
        }
        organDataAuthorityFeignVo.setOrganIds(organIds);
        organDataAuthorityFeignVo.setUserIds(userIds);
        return ApiResponse.success((Object)organDataAuthorityFeignVo);
    }
}

