/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.staff.service.StaffService;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitRoleOrganDataAuthorityMapper;
import com.jxdinfo.hussar.base.portal.authority.dto.OrganDataAuthorityDto;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.base.portal.authority.vo.OrganDataAuthorityFeignVo;
import com.jxdinfo.hussar.base.portal.authority.vo.OrganDataAuthorityVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.authority.service.impl.sysAppVisitRoleServiceImpl")
public class SysAppVisitRoleOrganDataAuthorityServiceImpl
extends HussarServiceImpl<SysAppVisitRoleOrganDataAuthorityMapper, SysAppVisitRoleOrganDataAuthority>
implements ISysAppVisitRoleOrganDataAuthorityService {
    @Autowired
    private StaffService staffService;

    @HussarTransactional
    public ApiResponse<Boolean> organDataAuthoritySave(OrganDataAuthorityDto organDataAuthorityDto) {
        SysAppVisitRoleOrganDataAuthority organDataAuthority = new SysAppVisitRoleOrganDataAuthority();
        StringBuilder organIdBuilder = new StringBuilder();
        StringBuilder staffIdBuilder = new StringBuilder();
        BeanUtil.copy((Object)organDataAuthorityDto, (Object)organDataAuthority);
        organDataAuthority.setOnlySupOrgan(organDataAuthorityDto.getSupOrgan());
        if (HussarUtils.isNotEmpty((Object)organDataAuthorityDto.getOrganIds())) {
            for (Long organId : organDataAuthorityDto.getOrganIds()) {
                if (organIdBuilder.length() > 0) {
                    organIdBuilder.append(",");
                }
                organIdBuilder.append(organId);
            }
        }
        organDataAuthority.setOrganIdList(organIdBuilder.toString());
        if (HussarUtils.isNotEmpty((Object)organDataAuthorityDto.getStaffIds())) {
            for (Long staffId : organDataAuthorityDto.getStaffIds()) {
                if (staffIdBuilder.length() > 0) {
                    staffIdBuilder.append(",");
                }
                staffIdBuilder.append(staffId);
            }
        }
        organDataAuthority.setStaffIdList(staffIdBuilder.toString());
        this.saveOrUpdate(organDataAuthority, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)organDataAuthorityDto.getRoleId())).eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)organDataAuthorityDto.getFormId()));
        return ApiResponse.success((Object)Boolean.TRUE, (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    public ApiResponse<OrganDataAuthorityVo> organDataAuthorityList(Long formId, Long roleId) {
        if (HussarUtils.isNotEmpty((Object)formId) && HussarUtils.isNotEmpty((Object)roleId)) {
            OrganDataAuthorityVo organDataAuthorityVo = new OrganDataAuthorityVo();
            SysAppVisitRoleOrganDataAuthority organDataAuthority = (SysAppVisitRoleOrganDataAuthority)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)roleId));
            if (HussarUtils.isNotEmpty((Object)organDataAuthority)) {
                BeanUtil.copy((Object)organDataAuthority, (Object)organDataAuthorityVo);
                organDataAuthorityVo.setSupOrgan(organDataAuthority.getOnlySupOrgan());
                if (HussarUtils.isNotEmpty((Object)organDataAuthority.getOrganIdList())) {
                    String[] organIds = organDataAuthority.getOrganIdList().split(",");
                    List organIdList = Arrays.stream(organIds).map(Long::valueOf).collect(Collectors.toList());
                    organDataAuthorityVo.setSimpleOrganVos(this.staffService.getSimpleOrgan(organIdList));
                }
                if (HussarUtils.isNotEmpty((Object)organDataAuthority.getStaffIdList())) {
                    String[] staffIds = organDataAuthority.getStaffIdList().split(",");
                    List staffIdList = Arrays.stream(staffIds).map(Long::valueOf).collect(Collectors.toList());
                    organDataAuthorityVo.setSimpleStaffVos(this.staffService.getByStaffId(staffIdList));
                }
            }
            return ApiResponse.success((Object)organDataAuthorityVo);
        }
        throw new BaseException("\u8868\u5355id\u6216\u89d2\u8272id\u4e3a\u7a7a");
    }

    public ApiResponse<OrganDataAuthorityFeignVo> formAuthorityOrganData(Long formId) {
        if (HussarUtils.isNotEmpty((Object)formId)) {
            List roleOrganDataAuthorities;
            List rolesList;
            SecurityUser user = BaseSecurityUtil.getUser();
            OrganDataAuthorityFeignVo organDataAuthorityFeignVo = new OrganDataAuthorityFeignVo();
            if (HussarUtils.isNotEmpty((Object)user) && HussarUtils.isNotEmpty((Object)(rolesList = user.getRolesList())) && HussarUtils.isNotEmpty((Object)(roleOrganDataAuthorities = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).in(SysAppVisitRoleOrganDataAuthority::getRoleId, (Collection)rolesList))))) {
                List allOrgan = roleOrganDataAuthorities.stream().filter(roleOrganData -> Objects.equals("1", roleOrganData.getAllOrgan())).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty(allOrgan)) {
                    return ApiResponse.success((Object)organDataAuthorityFeignVo);
                }
                HashSet<Long> staffIds = new HashSet<Long>();
                HashSet<Long> organIds = new HashSet<Long>();
                for (SysAppVisitRoleOrganDataAuthority roleOrganDataAuthority : roleOrganDataAuthorities) {
                    if (Objects.equals("1", roleOrganDataAuthority.getOnlyIndividuals())) {
                        Object staffId = user.getExtendUserMap().get("staffId");
                        if (!HussarUtils.isNotEmpty(staffId)) continue;
                        staffIds.add(Long.valueOf(staffId.toString()));
                        continue;
                    }
                    if (Objects.equals("1", roleOrganDataAuthority.getOnlySupOrgan())) {
                        Object organId = user.getExtendUserMap().get("deptId");
                        if (!HussarUtils.isNotEmpty(organId)) continue;
                        organIds.add(Long.valueOf(organId.toString()));
                        continue;
                    }
                    if (HussarUtils.isNotEmpty((Object)roleOrganDataAuthority.getOrganIdList())) {
                        String[] organIdString = roleOrganDataAuthority.getOrganIdList().split(",");
                        Set organIdList = Arrays.stream(organIdString).map(Long::valueOf).collect(Collectors.toSet());
                        organIds.addAll(organIdList);
                    }
                    if (!HussarUtils.isNotEmpty((Object)roleOrganDataAuthority.getStaffIdList())) continue;
                    String[] staffIdString = roleOrganDataAuthority.getStaffIdList().split(",");
                    Set staffIdList = Arrays.stream(staffIdString).map(Long::valueOf).collect(Collectors.toSet());
                    staffIds.addAll(staffIdList);
                }
                organDataAuthorityFeignVo.setOrganIds(organIds);
                organDataAuthorityFeignVo.setStaffIds(staffIds);
            }
            return ApiResponse.success((Object)organDataAuthorityFeignVo);
        }
        throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
    }
}

