/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.authority.service.impl;

import com.jxdinfo.hussar.base.portal.authority.dto.AuthorityDto;
import com.jxdinfo.hussar.base.portal.authority.service.AuthoritySaveService;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.base.portal.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.base.portal.authority.service.impl.authoritySaveServiceImpl")
public class AuthoritySaveServiceImpl
implements AuthoritySaveService {
    @Autowired
    private ISysAppVisitRoleButtonService roleButtonService;
    @Autowired
    private ISysUpAppVisitRoleFieldService roleFieldService;
    @Autowired
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    @Autowired
    private ISysAppVisitDataLogicService dataLogicService;

    @HussarTransactional
    public ApiResponse<Boolean> authoritySave(List<AuthorityDto> authorityDtos) {
        if (HussarUtils.isEmpty(authorityDtos)) {
            throw new BaseException("\u6743\u9650\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (AuthorityDto authorityDto : authorityDtos) {
            if (HussarUtils.isNotEmpty((Object)authorityDto.getButtonAuthoritiesDto())) {
                this.roleButtonService.addButtonAuthorityRoles(authorityDto.getButtonAuthoritiesDto());
            }
            if (HussarUtils.isNotEmpty((Object)authorityDto.getFormRoleFieldAuthoritiesDto())) {
                this.roleFieldService.saveFieldAuthority(authorityDto.getFormRoleFieldAuthoritiesDto());
            }
            if (HussarUtils.isNotEmpty((Object)authorityDto.getOrganDataAuthorityDto())) {
                this.roleOrganDataAuthorityService.organDataAuthoritySave(authorityDto.getOrganDataAuthorityDto());
            }
            if (!HussarUtils.isNotEmpty((Object)authorityDto.getDataLogicAuthorityDto())) continue;
            this.dataLogicService.dataLogicAuthoritySave(authorityDto.getDataLogicAuthorityDto());
        }
        return ApiResponse.success((Object)Boolean.TRUE);
    }
}

