/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.properties;

import com.jxdinfo.hussar.base.portal.constant.GitConstants;
import java.io.File;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty")
public class GitlabConfigProperty {
    @Value(value="${hussar-formdesign.front-project-path}")
    private String frontPath;
    @Value(value="${hussar-formdesign.back-project-path:hussar-web}")
    private String backPath;
    @Value(value="${hussar-formdesign.mobile-front-project-path}")
    private String mobilePath;
    @Value(value="${hussar-formdesign.workspace}")
    private String localPath;
    @Value(value="${gitlab.uri.git-uri:default}")
    private String gitUri;
    @Value(value="${gitlab.uri.git-group:default}")
    private String gitGroup;
    @Value(value="${gitlab.defaultPassword:default}")
    private String defaultPassword;

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    public String getGitGroup() {
        return this.gitGroup;
    }

    public void setGitGroup(String gitGroup) {
        this.gitGroup = gitGroup;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getTemplateLocalPath() {
        return GitlabConfigProperty.convert(this.getLocalPath() + File.separator + this.getBackPath() + File.separator + "temp");
    }

    public void setFrontPath(String frontPath) {
        this.frontPath = frontPath;
    }

    public void setBackPath(String backPath) {
        this.backPath = backPath;
    }

    public void setMobilePath(String mobilePath) {
        this.mobilePath = mobilePath;
    }

    public String getFrontGitPath() {
        return GitlabConfigProperty.convert(GitlabConfigProperty.convert(this.localPath) + this.frontPath) + ".git";
    }

    public String getLocalPath() {
        return GitlabConfigProperty.convert(this.localPath);
    }

    public String getBackGitPath() {
        return GitlabConfigProperty.convert(GitlabConfigProperty.convert(this.localPath) + this.backPath) + ".git";
    }

    public String getMobileGitPath() {
        return GitlabConfigProperty.convert(GitlabConfigProperty.convert(this.localPath) + this.mobilePath) + ".git";
    }

    private static String convert(String str) {
        StringBuilder stringBuilder = new StringBuilder(str.replace(GitConstants.TWOSEPATOR, File.separator));
        if (!str.endsWith(File.separator)) {
            stringBuilder.append(File.separator);
        }
        return stringBuilder.toString();
    }

    public String getGitUri() {
        if (this.gitUri.endsWith(File.separator + ".git")) {
            int index = this.gitUri.indexOf(File.separator + ".git");
            this.gitUri = this.gitUri.substring(0, index);
        }
        return this.gitUri;
    }

    public void setGitUri(String gitUri) {
        this.gitUri = gitUri;
    }

    public String getFrontPath() {
        return this.frontPath;
    }

    public String getBackPath() {
        return GitlabConfigProperty.convert(this.backPath);
    }

    public String getMobilePath() {
        return this.mobilePath;
    }

    public String getTempPath() {
        return this.getLocalPath() + this.getBackPath() + "temp";
    }

    public String getTemplatePath() {
        return this.getLocalPath() + this.getBackPath() + "template";
    }

    public String getUpgradePath() {
        return this.getLocalPath() + this.getBackPath() + "upgrade";
    }
}

