/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.base.portal.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysApplicationGroup;
import com.jxdinfo.hussar.base.portal.gitlabServer.dto.GitServerDto;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7cfb\u7edf\u5e94\u7528"})
@RestController(value="com.jxdinfo.hussar.base.portal.application.controller.sysApplicationController")
@RequestMapping(value={"/hussarBase/application/"})
public class SysApplicationController {
    @Resource
    private ISysApplicationService sysApplicationService;

    @GetMapping(value={"/manage/list"})
    @ApiOperation(value="\u63a7\u5236\u53f0\u83b7\u53d6\u5e94\u7528\u5217\u8868", notes="\u63a7\u5236\u53f0\u83b7\u53d6\u5e94\u7528\u5217\u8868")
    public ApiResponse<List<SysAppGroupVo>> getManageAppList(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestParam(required=false) Long appGroupId, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestParam(required=false) String appName, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestParam(required=false) String appStatus, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestParam(required=false) String releaseStatus, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestParam(required=false) String resourceStatus) {
        return ApiResponse.success((Object)this.sysApplicationService.getManageAppList(appGroupId, appName, appStatus, releaseStatus, resourceStatus));
    }

    @PostMapping(value={"/saveOrUpdateNewApplication"})
    @ApiOperation(value="\u4fdd\u5b58\u6216\u66f4\u65b0\u65b0\u5e94\u7528\u6570\u636e", notes="\u4fdd\u5b58\u6216\u66f4\u65b0\u65b0\u5e94\u7528\u6570\u636e")
    public ApiResponse<Boolean> saveOrUpdateNewApplication(@ApiParam(value="\u4fdd\u5b58\u6216\u66f4\u65b0\u65b0\u5e94\u7528\u6570\u636e") @RequestBody Map<String, Object> data) {
        if (data != null) {
            SysApplication sysApplication = (SysApplication)JSONObject.parseObject((String)JSONObject.toJSONString((Object)data.get("sysApplication")), SysApplication.class);
            return ApiResponse.success((Object)this.sysApplicationService.saveOrUpdate((Object)sysApplication));
        }
        return ApiResponse.fail((String)"\u5e94\u7528\u7ba1\u7406\u4fe1\u606f\u521b\u5efa\u5931\u8d25");
    }

    @PostMapping(value={"/edit"})
    @CheckPermission(value={"hussarBase:application:edit"})
    @ApiOperation(value="\u7f16\u8f91\u5e94\u7528", notes="\u7f16\u8f91\u5e94\u7528")
    public ApiResponse<Long> updateApp(@ApiParam(value="\u5e94\u7528\u5b9e\u4f53") @RequestBody SysApplicationDto sysApplicationDto) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_NAME", (Object)sysApplicationDto.getSysApplication().getAppName())).ne((Object)"APP_ID", (Object)sysApplicationDto.getSysApplication().getId());
        if (this.sysApplicationService.count(queryWrapper) > 0L) {
            return ApiResponse.success((String)"false");
        }
        return ApiResponse.success((Object)this.sysApplicationService.updateApp(sysApplicationDto));
    }

    @PostMapping(value={"/delete"})
    @CheckPermission(value={"hussarBase:application:delete"})
    @ApiOperation(value="\u5e94\u7528\u5220\u9664", notes="\u5e94\u7528\u5220\u9664")
    public ApiResponse<Boolean> deleteApp(@ApiParam(value="\u5e94\u7528id") @RequestParam Long id) {
        Boolean flag = this.sysApplicationService.deleteApp(id);
        if (flag.booleanValue()) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((int)10001, (String)"\u5e94\u7528\u5728\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u53ef\u5220\u9664");
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u8be6\u60c5", notes="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u8be6\u60c5")
    public ApiResponse<SysApplicationDto> getAppDetail(@ApiParam(value="\u5e94\u7528Id") @RequestParam Long appId) {
        return this.sysApplicationService.getAppDetailAndDeploy(appId);
    }

    @GetMapping(value={"/getAppDetail"})
    @ApiOperation(value="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u8be6\u60c5", notes="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u8be6\u60c5")
    public ApiResponse<SysApplication> detail(@ApiParam(value="\u5e94\u7528Id") @RequestParam Long appId) {
        return ApiResponse.success((Object)this.sysApplicationService.getById((Serializable)appId));
    }

    @PostMapping(value={"/copyApplication"})
    @CheckPermission(value={"hussarBase:application:copyApplication"})
    @ApiOperation(value="\u751f\u6210\u526f\u672c", notes="\u751f\u6210\u526f\u672c")
    public ApiResponse<Long> copyApplication(@ApiParam(value="\u751f\u6210\u526f\u672c") @RequestBody SysApplicationDto sysApplicationDto) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_NAME", (Object)sysApplicationDto.getSysApplication().getAppName())).or()).eq((Object)"APP_CODE", (Object)sysApplicationDto.getSysApplication().getAppCode());
        if (this.sysApplicationService.count(queryWrapper) > 0L) {
            return ApiResponse.success((String)"false");
        }
        return ApiResponse.success((Object)this.sysApplicationService.copyApplication(sysApplicationDto));
    }

    @GetMapping(value={"/updateAppStatus"})
    @CheckPermission(value={"hussarBase:application:updateAppStatus"})
    @ApiOperation(value="\u5e94\u7528\u542f\u505c", notes="\u5e94\u7528\u542f\u505c")
    public ApiResponse<Boolean> updateAppStatus(@ApiParam(value="\u5e94\u7528\u542f\u505c") @RequestParam Long appId, @ApiParam(value="\u542f\u505c\u72b6\u6001") @RequestParam String appStatus) {
        Boolean flag = this.sysApplicationService.updateAppStatus(appId, appStatus);
        if (flag.booleanValue()) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u8be5\u5e94\u7528\u672a\u53d1\u5e03\u5230\u6b63\u5f0f\uff0c\u4e0d\u53ef\u505c\u7528");
    }

    @PostMapping(value={"/secretKey"})
    @ApiOperation(value="\u91cd\u7f6e\u5e94\u7528\u5bc6\u94a5", notes="\u91cd\u7f6e\u5e94\u7528\u5bc6\u94a5")
    public ApiResponse<Boolean> updateSecretKey(@ApiParam(value="\u5e94\u7528\u5217\u8868") @RequestParam Long appId) {
        return ApiResponse.success((Object)this.sysApplicationService.updateSecretKey(appId));
    }

    @GetMapping(value={"/getSysDeployInfo"})
    @ApiOperation(value="\u53d1\u5e03\u5230\u6d4b\u8bd5\u3001\u6b63\u5f0f\u6570\u636e\u56de\u663e", notes="\u53d1\u5e03\u5230\u6d4b\u8bd5\u3001\u6b63\u5f0f\u6570\u636e\u56de\u663e")
    public ApiResponse<SysAppDeploy> getSysDeployInfo(@ApiParam(value="\u53d1\u5e03\u5230\u6d4b\u8bd5\u3001\u6b63\u5f0f\u6570\u636e\u56de\u663e") @RequestParam Long appId, @RequestParam String deployType, @RequestParam Long userId) {
        SysAppDeploy sysAppDeploy = this.sysApplicationService.getSysDeployInfo(appId, deployType, userId);
        return ApiResponse.success((Object)sysAppDeploy);
    }

    @PostMapping(value={"/publishToTestEnvironment"})
    @CheckPermission(value={"hussarBase:application:publishToTestEnvironment"})
    @ApiOperation(value="\u53d1\u5e03\u5230\u6d4b\u8bd5\u73af\u5883", notes="\u53d1\u5e03\u5230\u6d4b\u8bd5\u73af\u5883")
    public ApiResponse<Long> publishToTestEnvironment(@ApiParam(value="\u53d1\u5e03\u5230\u6d4b\u8bd5\u73af\u5883") @RequestBody SysApplicationDto sysApplicationDto) {
        return ApiResponse.success((Object)this.sysApplicationService.publishToTestEnvironment(sysApplicationDto));
    }

    @PostMapping(value={"/publish"})
    @CheckPermission(value={"hussarBase:application:publish"})
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    public ApiResponse<Long> publish(@ApiParam(value="\u53d1\u5e03") @RequestBody SysApplicationDto sysApplicationDto) {
        int countMobile;
        int countFront;
        String threeDomainFront = sysApplicationDto.getSysAppDeploy().getThreeLevelDomainFront();
        String threeDomainMobile = sysApplicationDto.getSysAppDeploy().getThreeLevelDomainMobile();
        String twoDomainName = sysApplicationDto.getSysAppDeploy().getTwoLevelDomain();
        Long deployId = sysApplicationDto.getSysAppDeploy().getAppDeployId();
        if (HussarUtils.isNotBlank((CharSequence)threeDomainFront) && (countFront = this.sysApplicationService.getFrontCount(threeDomainFront, twoDomainName, deployId)) > 0) {
            return ApiResponse.fail((String)"\u540c\u4e00\u4e2a\u4e8c\u7ea7\u57df\u540d\u4e0b\u4e0d\u80fd\u6709\u76f8\u540c\u7684front\u57df\u540d");
        }
        if (HussarUtils.isNotBlank((CharSequence)threeDomainMobile) && (countMobile = this.sysApplicationService.getMobileCount(threeDomainMobile, twoDomainName, deployId)) > 0) {
            return ApiResponse.fail((String)"\u540c\u4e00\u4e2a\u4e8c\u7ea7\u57df\u540d\u4e0b\u4e0d\u80fd\u6709\u76f8\u540c\u7684mobile\u57df\u540d");
        }
        return ApiResponse.success((Object)this.sysApplicationService.publish(sysApplicationDto));
    }

    @PostMapping(value={"/publishToFormalEnvironment"})
    @CheckPermission(value={"hussarBase:application:publishToFormalEnvironment"})
    @ApiOperation(value="\u53d1\u5e03\u5230\u6b63\u5f0f\u73af\u5883", notes="\u53d1\u5e03\u5230\u6b63\u5f0f\u73af\u5883")
    public ApiResponse<Long> publishToFormalEnvironment(@ApiParam(value="\u53d1\u5e03\u5230\u6b63\u5f0f\u73af\u5883") @RequestBody SysApplicationDto sysApplicationDto) {
        return ApiResponse.success((Object)this.sysApplicationService.publishToFormalEnvironment(sysApplicationDto));
    }

    @GetMapping(value={"/getApplicationInfo"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u4fe1\u606f", notes="\u83b7\u53d6\u5e94\u7528\u4fe1\u606f")
    public ApiResponse<SysApplication> getApplicationInfo() {
        return ApiResponse.success((Object)this.sysApplicationService.getApplicationInfo());
    }

    @PostMapping(value={"/checkUser"})
    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u4e2d\u662f\u5426\u5b58\u5728\u8be5\u7528\u6237", notes="\u67e5\u8be2\u5e94\u7528\u4e2d\u662f\u5426\u5b58\u5728\u8be5\u7528\u6237")
    public ApiResponse<Boolean> checkUser(@ApiParam(value="\u7528\u6237\u540d") @RequestParam String userAccount) {
        return ApiResponse.success((Object)this.sysApplicationService.checkUser(userAccount));
    }

    @PostMapping(value={"/syncDevloper"})
    @ApiOperation(value="\u5c06\u7ba1\u7406\u5e73\u53f0\u6240\u9009\u62e9\u4eba\u5458\u540c\u6b65\u5230\u5e94\u7528\u6570\u636e\u5e93", notes="\u5c06\u7ba1\u7406\u5e73\u53f0\u6240\u9009\u62e9\u4eba\u5458\u540c\u6b65\u5230\u5e94\u7528\u6570\u636e\u5e93")
    public ApiResponse<String> syncDevloper(@RequestBody JSONObject jsonObject) {
        String ids = jsonObject.getString("ids");
        String appId = jsonObject.getString("appId");
        return ApiResponse.success((String)this.sysApplicationService.syncDevloper(ids, appId));
    }

    @ApiOperation(value="\u5bfc\u5165\u5e94\u7528")
    @PostMapping(value={"/importExcelApplication"})
    @CheckPermission(value={"hussarBase:application:importExcelApplication"})
    public ApiResponse importExcelApplication(@RequestParam(value="file") MultipartFile file) throws Exception {
        return ApiResponse.success((Object)this.sysApplicationService.importExcelApplication(file));
    }

    @PostMapping(value={"/downloadTemplate"})
    @CheckPermission(value={"hussarBase:application:downloadTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f")
    public void downloadTemplate(HttpServletResponse response, @RequestBody Map map) throws Exception {
        this.sysApplicationService.downloadTemplate(response, map);
    }

    @PostMapping(value={"/obtainChanges"})
    @CheckPermission(value={"hussarBase:application:obtainChanges"})
    @ApiOperation(value="\u83b7\u53d6\u53d8\u66f4\u64cd\u4f5c")
    public ApiResponse<Boolean> obtainChanges(@ApiParam(value="\u83b7\u53d6\u53d8\u66f4") @RequestBody GitServerDto gitServerDto) {
        return ApiResponse.success((Object)this.sysApplicationService.obtainChanges(gitServerDto));
    }

    @PostMapping(value={"/commitChanges"})
    @CheckPermission(value={"hussarBase:application:commitChanges"})
    @ApiOperation(value="\u63d0\u4ea4\u53d8\u66f4\u64cd\u4f5c")
    public ApiResponse<Boolean> commitChanges(@ApiParam(value="\u63d0\u4ea4\u53d8\u66f4") @RequestBody GitServerDto gitServerDto) {
        Boolean flag = this.sysApplicationService.commitChanges(gitServerDto);
        if (flag.booleanValue()) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u672a\u83b7\u53d6\u5230\u90e8\u7f72\u4fe1\u606f");
    }

    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u72b6\u6001")
    @GetMapping(value={"/proStatus"})
    public ApiResponse<Boolean> getAppProStatus(@RequestParam Long time) {
        return ApiResponse.success((Object)this.sysApplicationService.getAppProStatus(time));
    }

    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u72b6\u6001")
    @GetMapping(value={"/status"})
    public ApiResponse<Boolean> getAppStatus() {
        try {
            return ApiResponse.success((Object)(!"0".equals(((SysApplication)this.sysApplicationService.list().get(0)).getAppStatus()) ? 1 : 0));
        }
        catch (Exception e) {
            return ApiResponse.success((Object)true);
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6784\u5efa\u72b6\u6001\u548c\u6267\u884c\u6b65\u9aa4")
    @GetMapping(value={"/builddefs"})
    public ApiResponse<List<String>> getBuilddefs(@RequestParam String projectId) {
        return ApiResponse.success((Object)this.sysApplicationService.getBuilddefs(projectId));
    }

    @PostMapping(value={"/getDelApplication"})
    @CheckPermission(value={"hussarBase:application:getDelApplication"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5220\u9664\u7684\u5e94\u7528", notes="\u67e5\u8be2\u6240\u6709\u5220\u9664\u7684\u5e94\u7528")
    public ApiResponse<Page<SysApplicationGroup>> getDelApplication(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @RequestBody JSONObject jsonObject) {
        Page page = (Page)jsonObject.toJavaObject(Page.class);
        SysApplication sysApplication = (SysApplication)jsonObject.toJavaObject(SysApplication.class);
        sysApplication.setDelFlag("1");
        return ApiResponse.success((Object)this.sysApplicationService.pageList(page, sysApplication));
    }

    @GetMapping(value={"/restoreDelApplication"})
    @CheckPermission(value={"hussarBase:application:restoreDelApplication"})
    @ApiOperation(value="\u6062\u590d\u5220\u9664\u7684\u5e94\u7528", notes="\u6062\u590d\u5220\u9664\u7684\u5e94\u7528")
    public ApiResponse<Boolean> restoreDelApplication(@ApiParam(value="\u6062\u590d\u5220\u9664\u7684\u5e94\u7528") @RequestParam Long appId) {
        return ApiResponse.success((Object)this.sysApplicationService.restoreDelApplication(appId));
    }

    @GetMapping(value={"/completelyDelApplication"})
    @CheckPermission(value={"hussarBase:application:completelyDelApplication"})
    @ApiOperation(value="\u5f7b\u5e95\u5220\u9664\u7684\u5e94\u7528", notes="\u5f7b\u5e95\u5220\u9664\u7684\u5e94\u7528")
    public ApiResponse<Boolean> completelyDelApplication(@ApiParam(value="\u5f7b\u5e95\u5220\u9664\u7684\u5e94\u7528") @RequestParam Long appId) {
        return ApiResponse.success((Object)this.sysApplicationService.completelyDelApplication(appId));
    }
}

