/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.dao.SysUpgradeMapper;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.application.model.SysAppUpgrade;
import com.jxdinfo.hussar.base.portal.application.model.SysAppVersion;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.model.SysUpgrade;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppUpgradeService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppVersionService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.service.ISysDeployService;
import com.jxdinfo.hussar.base.portal.application.service.ISysUpgradeService;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.file.ZipFile;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysUpgradeServiceImpl")
public class SysUpgradeServiceImpl
extends HussarServiceImpl<SysUpgradeMapper, SysUpgrade>
implements ISysUpgradeService {
    private static final Logger logger = LoggerFactory.getLogger(SysUpgradeServiceImpl.class);
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysDeployService sysDeployService;
    @Resource
    private IGitlabService gitlabService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysAppUpgradeService sysAppUpgradeService;
    @Resource
    private ISysAppVersionService sysAppVersionService;
    private static final String importCache = "IMPORT_CACHE";

    public Boolean deleteById(String upgradeIdArray) {
        if (HussarUtils.isNotBlank((CharSequence)upgradeIdArray)) {
            String[] ids;
            for (String id : ids = upgradeIdArray.split(",")) {
                SysUpgrade sysUpgrade = (SysUpgrade)super.getById((Serializable)Long.valueOf(Long.parseLong(id)));
                sysUpgrade.setDelFlag("0");
                File file = new File(sysUpgrade.getFilePath());
                file.delete();
                this.updateById((BaseEntity)sysUpgrade);
            }
        }
        return true;
    }

    public void downloadSysUpgrade(Long id, HttpServletResponse response) {
        SysUpgrade sysUpgrade = (SysUpgrade)this.getById(id);
        String fileName = sysUpgrade.getFileName() + ".zip";
        String filePath = this.gitlabConfigProperty.getUpgradePath() + File.separator + fileName;
        File file = new File(filePath);
        try (FileInputStream fis = new FileInputStream(file);
             ServletOutputStream os = response.getOutputStream();){
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            IOUtils.copy((InputStream)fis, (OutputStream)os, (int)4096);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Long importSysUpgrade(MultipartFile multipartFile, SysUpgrade sysUpgrade) throws IOException {
        Long time = System.currentTimeMillis();
        if (ToolUtil.isEmpty((Object)multipartFile)) {
            throw new BaseException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fileName = sysUpgrade.getFileName() + ".zip";
        String path = this.gitlabConfigProperty.getUpgradePath() + File.separator + fileName;
        String tempPath = this.gitlabConfigProperty.getTempPath() + File.separator + time;
        HussarCacheUtil.put((String)importCache, (Object)time, (Object)"loading...", (long)600L);
        File tempFile = new File(path);
        multipartFile.transferTo(tempFile);
        new Thread(() -> {
            try {
                ZipFile.unzip((String)path, (String)tempPath, (Charset)Charset.forName("GBK"));
                if (this.checkFile(tempPath)) {
                    sysUpgrade.setFilePath(path);
                    sysUpgrade.setDelFlag("1");
                    this.save((BaseEntity)sysUpgrade);
                    HussarCacheUtil.put((String)importCache, (Object)time, (Object)"success", (long)600L);
                } else {
                    tempFile.delete();
                    HussarCacheUtil.put((String)importCache, (Object)time, (Object)"\u6587\u4ef6\u7ed3\u6784\u4e0d\u7b26\u5408\u8981\u6c42", (long)600L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                HussarCacheUtil.put((String)importCache, (Object)time, (Object)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u89e3\u538b\u9519\u8bef\uff0c\u5e94\u4e3a.zip\u683c\u5f0f\u4e14\u80fd\u6b63\u5e38\u89e3\u538b", (long)600L);
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        return time;
    }

    private boolean checkFile(String path) {
        File file = new File(path);
        File[] files = file.listFiles();
        return new File(path + File.separator + "hussar-web").exists() || new File(path + File.separator + "hussar-front").exists() || new File(path + File.separator + "hussar-mobile").exists() || new File(path + File.separator + "hussar-config").exists() || new File(path + File.separator + "sql").exists();
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }

    public Long upgradeApplication(String appId, Long upgradeId) {
        Long time = System.currentTimeMillis();
        String[] arr = appId.split(",");
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        HussarCacheUtil.put((String)importCache, (Object)time, (Object)"loading...", (long)1800L);
        new Thread(() -> {
            try {
                for (int i = 0; i < arr.length; ++i) {
                    SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)Long.valueOf(Long.parseLong(arr[i])));
                    List branchList = new ArrayList();
                    branchList = this.gitlabService.getAllBranch(sysApplication.getAppCode(), accessToken);
                    String localPath = this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode() + File.separator + "dev" + File.separator;
                    this.gitlabService.pullToLocalByBranch(sysApplication.getAppCode(), localPath, "dev", accessToken);
                    for (String branch : branchList) {
                        SysAppUpgrade sysAppUpgrade;
                        branch = this.gitlabService.getBranch(localPath, accessToken, branch);
                        if ("0".equals(sysApplication.getPersonalBrance())) {
                            if ("dev".equals(branch)) {
                                this.createTag(sysApplication, upgradeId, user, branch);
                            }
                            this.copyFile(upgradeId, localPath);
                            this.gitlabService.pushToGit(this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode() + File.separator + "dev", sysApplication.getAppCode(), "\u589e\u91cf\u5347\u7ea7", branch, accessToken);
                            sysAppUpgrade = new SysAppUpgrade();
                            sysAppUpgrade.setUpGradeId(upgradeId);
                            sysAppUpgrade.setAppId(Long.valueOf(Long.parseLong(arr[i])));
                            sysAppUpgrade.setAppName(sysApplication.getAppName());
                            sysAppUpgrade.setAppCode(sysApplication.getAppCode());
                            sysAppUpgrade.setBranch(branch);
                            this.sysAppUpgradeService.save((Object)sysAppUpgrade);
                            continue;
                        }
                        if ("master".equals(branch)) continue;
                        if ("dev".equals(branch)) {
                            this.createTag(sysApplication, upgradeId, user, branch);
                        }
                        this.copyFile(upgradeId, localPath);
                        this.gitlabService.pushToGit(this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode() + File.separator + "dev", sysApplication.getAppCode(), "\u589e\u91cf\u5347\u7ea7", branch, accessToken);
                        sysAppUpgrade = new SysAppUpgrade();
                        sysAppUpgrade.setUpGradeId(upgradeId);
                        sysAppUpgrade.setAppId(Long.valueOf(Long.parseLong(arr[i])));
                        sysAppUpgrade.setAppName(sysApplication.getAppName());
                        sysAppUpgrade.setAppCode(sysApplication.getAppCode());
                        sysAppUpgrade.setBranch(branch);
                        this.sysAppUpgradeService.save((Object)sysAppUpgrade);
                    }
                }
                HussarCacheUtil.put((String)importCache, (Object)time, (Object)"success", (long)1800L);
            }
            catch (Exception e) {
                e.printStackTrace();
                HussarCacheUtil.put((String)importCache, (Object)time, (Object)e.getMessage(), (long)2400L);
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        return time;
    }

    public Long autoUpgradeApplication(Long appId, Long upgradeId) {
        Long time = System.currentTimeMillis();
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        Long userId = user.getId();
        String accessToken = user.getChar1();
        HussarCacheUtil.put((String)importCache, (Object)time, (Object)"loading...", (long)1800L);
        new Thread(() -> {
            try {
                String branch = "";
                SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
                if ("1".equals(sysApplication.getIsOnline())) {
                    if (userId.equals(sysApplication.getProjectLeader())) {
                        branch = "dev";
                    } else {
                        SysAppDeploy sysAppDeploy = this.sysDeployService.getAppDeplyByAppId(appId, userId);
                        branch = sysAppDeploy.getBranchName();
                    }
                } else if ("0".equals(sysApplication.getIsOnline())) {
                    branch = "dev";
                }
                String localPath = this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode() + File.separator + "dev" + File.separator;
                this.gitlabService.pullToLocalByBranch(sysApplication.getAppCode(), localPath, "dev", accessToken);
                branch = this.gitlabService.getBranch(localPath, accessToken, branch);
                if ("dev".equals(branch)) {
                    this.createTag(sysApplication, upgradeId, user, branch);
                }
                this.copyFile(upgradeId, localPath);
                this.gitlabService.pushToGit(this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode() + File.separator + "dev", sysApplication.getAppCode(), "\u589e\u91cf\u5347\u7ea7", branch, accessToken);
                SysAppUpgrade sysAppUpgrade = new SysAppUpgrade();
                sysAppUpgrade.setUpGradeId(upgradeId);
                sysAppUpgrade.setAppId(appId);
                sysAppUpgrade.setAppName(sysApplication.getAppName());
                sysAppUpgrade.setAppCode(sysApplication.getAppCode());
                sysAppUpgrade.setBranch(branch);
                this.sysAppUpgradeService.save((Object)sysAppUpgrade);
                HussarCacheUtil.put((String)importCache, (Object)time, (Object)"success", (long)1800L);
            }
            catch (Exception e) {
                e.printStackTrace();
                HussarCacheUtil.put((String)importCache, (Object)time, (Object)e.getMessage(), (long)1800L);
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(Long upgradeId, String localPath) {
        Long time = System.currentTimeMillis();
        SysUpgrade sysUpgrade = (SysUpgrade)this.getById(upgradeId);
        String newPath = this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator;
        ZipFile.unzip((String)sysUpgrade.getFilePath(), (String)newPath, (Charset)Charset.forName("GBK"));
        File dir = new File(newPath);
        try {
            SysUpgradeServiceImpl.printDirByRecursive(dir, 0, localPath, newPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
        }
    }

    public static void printDirByRecursive(File dir, int level, String localPath, String newPath) throws IOException {
        for (int i = 0; i < level; ++i) {
            System.out.print("-");
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                String newDir;
                if (f.isFile()) {
                    newDir = f.toString().replace(newPath, localPath);
                    File dest = new File(newDir);
                    SysUpgradeServiceImpl.copyFileUsingStream(f, dest);
                    continue;
                }
                newDir = f.toString().replace(newPath, localPath);
                File destDir = new File(newDir);
                if (!destDir.exists()) {
                    destDir.mkdirs();
                }
                SysUpgradeServiceImpl.printDirByRecursive(f, level + 1, localPath, newPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileUsingStream(File source, File dest) throws IOException {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public void createTag(SysApplication sysApplication, Long upgradeId, SysUsers user, String branch) {
        SysAppVersion sysAppVersion = new SysAppVersion();
        SysUpgrade sysUpgrade = (SysUpgrade)this.getById(upgradeId);
        sysAppVersion.setVersionNum(sysUpgrade.getVersion());
        sysAppVersion.setVersionDesc(sysUpgrade.getVersion());
        sysAppVersion.setAppId(sysApplication.getId());
        sysAppVersion.setVersionType("D");
        sysAppVersion.setBranchName(branch);
        this.sysAppVersionService.saveVersion(sysAppVersion, user);
    }
}

