/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.yamlServer.service.impl;

import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.base.portal.yamlServer.service.IYamlService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Service(value="com.jxdinfo.hussar.base.portal.yamlServer.service.impl.YamlServiceImpl")
public class YamlServiceImpl
implements IYamlService {
    private static final Logger logger = LoggerFactory.getLogger(YamlServiceImpl.class);
    @Resource
    GitlabConfigProperty gitlabConfigProperty;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createValues(SysAppDeploy sysAppDeploy, String appType, String appCode, Long currentTime, String env, String branch) {
        OutputStreamWriter fileWriter = null;
        FileInputStream inputStream = null;
        try {
            String[] appTypeArray;
            String path = "";
            path = this.gitlabConfigProperty.getTemplateLocalPath() + currentTime + File.separator + appCode + File.separator + "hussar-config" + File.separator + "ddm-helm" + File.separator + "values" + File.separator;
            new File(this.gitlabConfigProperty.getTemplateLocalPath()).mkdir();
            new File(path).mkdir();
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(dumperOptions);
            if ("DEV".equals(env)) {
                inputStream = new FileInputStream(path + "values.dev.yaml");
            } else if ("TEST".equals(env)) {
                inputStream = new FileInputStream(path + "values.test.yaml");
            } else if ("PROD".equals(env)) {
                inputStream = new FileInputStream(path + "values.prod.yaml");
            }
            LinkedHashMap ymlMap = (LinkedHashMap)yaml.load(inputStream);
            ((InputStream)inputStream).close();
            if ("DEV".equals(env)) {
                fileWriter = new FileWriter(new File(path + "values.dev.yaml"));
            } else if ("TEST".equals(env)) {
                fileWriter = new FileWriter(new File(path + "values.test.yaml"));
            } else if ("PROD".equals(env)) {
                fileWriter = new FileWriter(new File(path + "values.prod.yaml"));
            }
            ymlMap.put("namespace", sysAppDeploy.getAppNamespace());
            HashMap<String, String> project = new HashMap<String, String>();
            String frontType = "";
            for (String type : appTypeArray = appType.split(",")) {
                frontType = "".equals(frontType) ? YamlServiceImpl.getAppType(type) : frontType + "," + YamlServiceImpl.getAppType(type);
            }
            project.put("projectType", frontType);
            ymlMap.put("project", project);
            Map appManage = (Map)ymlMap.get("appManage");
            appManage.put("enable", true);
            appManage.put("projectCode", appCode);
            appManage.put("branch", branch);
            appManage.put("deployType", sysAppDeploy.getDeployType());
            appManage.put("obtainChangeFlag", false);
            appManage.put("env", env);
            ymlMap.put("appManage", appManage);
            HashMap<String, String> service = new HashMap<String, String>();
            service.put("mobilePort", sysAppDeploy.getAppMobilePort());
            service.put("port", sysAppDeploy.getAppFrontPort());
            service.put("frontService", sysAppDeploy.getThreeLevelDomainFront() + "." + sysAppDeploy.getTwoLevelDomain());
            service.put("mobileService", sysAppDeploy.getThreeLevelDomainMobile() + "." + sysAppDeploy.getTwoLevelDomain());
            ymlMap.put("service", service);
            String databasetType = sysAppDeploy.getDatabasetType();
            if ("1".equals(databasetType)) {
                databasetType = "oracle";
            } else if ("2".equals(databasetType)) {
                databasetType = "mysql";
            } else if ("3".equals(databasetType)) {
                databasetType = "dm";
            } else if ("4".equals(databasetType)) {
                databasetType = "shentong";
            } else if ("5".equals(databasetType)) {
                databasetType = "pgSql";
            } else if ("6".equals(databasetType)) {
                databasetType = "sqlServer";
            } else if ("7".equals(databasetType)) {
                databasetType = "kingbase";
            }
            HashMap<String, String> database = new HashMap<String, String>();
            database.put("type", databasetType);
            ymlMap.put("database", database);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("host", sysAppDeploy.getDatabaseUrl());
            params.put("port", sysAppDeploy.getDatabasePort());
            params.put("database", sysAppDeploy.getDatabaseName());
            params.put("username", sysAppDeploy.getDatabaseAccount());
            params.put("password", sysAppDeploy.getDatabasePassword());
            ymlMap.put(databasetType, params);
            Map compile = (Map)ymlMap.get("compile");
            String compileImage = (String)compile.get("image");
            compile.put("image", compileImage.replace("namespace", sysAppDeploy.getAppNamespace()));
            Map curl = (Map)ymlMap.get("curl");
            String curlImage = (String)curl.get("image");
            curl.put("image", curlImage.replace("namespace", sysAppDeploy.getAppNamespace()));
            Map nginx = (Map)ymlMap.get("nginx");
            String nginxImage = (String)nginx.get("image");
            nginx.put("image", nginxImage.replace("namespace", sysAppDeploy.getAppNamespace()));
            Map backend = (Map)ymlMap.get("backend");
            String backendImage = (String)backend.get("image");
            backend.put("image", backendImage.replace("namespace", sysAppDeploy.getAppNamespace()));
            String projectCode = "";
            if ("DEV".equals(env)) {
                projectCode = appCode + "-" + branch;
            } else if ("TEST".equals(env)) {
                projectCode = appCode + "-test";
            } else if ("PROD".equals(env)) {
                projectCode = appCode + "-prod";
            }
            HashMap<String, String> ingress = new HashMap<String, String>();
            ingress.put("ingressName", projectCode + "-ingress");
            ymlMap.put("ingress", ingress);
            HashMap<String, String> configName = new HashMap<String, String>();
            configName.put("env", projectCode + "-hussar-lcdp-env");
            configName.put("nginxConfig", projectCode + "-hussar-nginx-server-block");
            configName.put("webConfig", projectCode + "-hussar-web-config");
            ymlMap.put("configName", configName);
            HashMap<String, String> serviceName = new HashMap<String, String>();
            serviceName.put("hussarCompile", projectCode + "-hussar-compile-svc");
            serviceName.put("hussarBackend", projectCode + "-hussar-backend-svc");
            serviceName.put("hussarNginx", projectCode + "-hussar-nginx-svc");
            ymlMap.put("serviceName", serviceName);
            HashMap<String, String> deploymentName = new HashMap<String, String>();
            deploymentName.put("hussarCompile", projectCode + "-hussar-compile");
            deploymentName.put("hussarBackend", projectCode + "-hussar-backend");
            deploymentName.put("hussarNginx", projectCode + "-hussar-nginx");
            ymlMap.put("deploymentName", deploymentName);
            HashMap<String, String> pvc = new HashMap<String, String>();
            pvc.put("frontSource", projectCode + "-hussar-front-source-pvc");
            pvc.put("mobileSource", projectCode + "-hussar-mobile-source-pvc");
            pvc.put("webSource", projectCode + "-hussar-web-source-pvc");
            pvc.put("output", projectCode + "-hussar-front-output-pvc");
            ymlMap.put("pvc", pvc);
            if ("1".equals(sysAppDeploy.getIsAbutmentIam())) {
                HashMap iam = new HashMap();
                HashMap<String, String> auth = new HashMap<String, String>();
                auth.put("address", sysAppDeploy.getIamAuthAddress());
                auth.put("clientId", sysAppDeploy.getIamAuthClientId());
                auth.put("clientSecret", sysAppDeploy.getIamAuthClientSecret());
                HashMap<String, String> grant = new HashMap<String, String>();
                grant.put("address", sysAppDeploy.getIamGrantAddress());
                grant.put("username", sysAppDeploy.getIamGrantUserName());
                grant.put("userId", sysAppDeploy.getIamGrantUserId());
                grant.put("appCode", sysAppDeploy.getIamGrantAppCode());
                iam.put("auth", auth);
                iam.put("grant", grant);
                ymlMap.put("IAM", iam);
            }
            logger.info("values\u6587\u4ef6\u751f\u6210\u6570\u636e\uff1a{}", (Object)ymlMap);
            yaml.dump((Object)ymlMap, (Writer)fileWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createValuesForObtainChange(String appCode, Long currentTime, String env) {
        OutputStreamWriter fileWriter = null;
        FileInputStream inputStream = null;
        try {
            String path = "";
            path = this.gitlabConfigProperty.getTemplateLocalPath() + currentTime + File.separator + appCode + File.separator + "hussar-config" + File.separator + "ddm-helm" + File.separator + "values" + File.separator;
            new File(this.gitlabConfigProperty.getTemplateLocalPath()).mkdir();
            new File(path).mkdir();
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(dumperOptions);
            if ("DEV".equals(env)) {
                inputStream = new FileInputStream(path + "values.dev.yaml");
            } else if ("TEST".equals(env)) {
                inputStream = new FileInputStream(path + "values.test.yaml");
            } else if ("PROD".equals(env)) {
                inputStream = new FileInputStream(path + "values.prod.yaml");
            }
            LinkedHashMap ymlMap = (LinkedHashMap)yaml.load(inputStream);
            ((InputStream)inputStream).close();
            if ("DEV".equals(env)) {
                fileWriter = new FileWriter(new File(path + "values.dev.yaml"));
            } else if ("TEST".equals(env)) {
                fileWriter = new FileWriter(new File(path + "values.test.yaml"));
            } else if ("PROD".equals(env)) {
                fileWriter = new FileWriter(new File(path + "values.prod.yaml"));
            }
            Map appManage = (Map)ymlMap.get("appManage");
            appManage.put("obtainChangeFlag", true);
            appManage.put("env", env);
            ymlMap.put("appManage", appManage);
            logger.info("values\u6587\u4ef6\u751f\u6210\u6570\u636e\uff1a{}", (Object)ymlMap);
            yaml.dump((Object)ymlMap, (Writer)fileWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String getAppType(String appType) {
        String type = "";
        type = "1".equals(appType) ? "web" : ("2".equals(appType) ? "app" : ("3".equals(appType) ? "h5" : ""));
        return type;
    }
}

