/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppVersionMapper;
import com.jxdinfo.hussar.base.portal.application.model.SysAppVersion;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppVersionService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.DevCloudUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.file.ZipFile;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppVersionImpl")
public class SysAppVersionImpl
extends HussarServiceImpl<SysAppVersionMapper, SysAppVersion>
implements ISysAppVersionService {
    @Resource
    ISysApplicationService sysApplicationService;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    SysAppVersionMapper sysAppVersionMapper;
    private static final String VERSION_IMPORT = "VERSION_IMPORT";
    private SecurityUser user;

    private String getUri() {
        return this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup();
    }

    public boolean removeById(Serializable id) {
        try {
            SysAppVersion sysAppVersion = (SysAppVersion)super.getById(id);
            SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)sysAppVersion.getAppId());
            String accessToken = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getUserId()).getChar1();
            sysAppVersion.setDelFlag("1");
            String branch = sysAppVersion.getBranchName();
            if (branch == null) {
                branch = "dev";
            }
            DevCloudUtil.removeTagToGitlab((String)sysApplication.getAppCode(), (String)this.gitlabConfigProperty.getGitUri(), (String)sysAppVersion.getVersionName(), (String)accessToken, (String)"projects", (String)branch);
            return super.updateById((BaseEntity)sysAppVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
    }

    public boolean saveVersion(SysAppVersion sysAppVersion, SysUsers user) {
        String timeMillis = String.valueOf(System.currentTimeMillis());
        File file = new File(this.gitlabConfigProperty.getTempPath() + File.separator + timeMillis);
        try {
            SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)sysAppVersion.getAppId());
            if ("D".equals(sysAppVersion.getVersionType())) {
                String currentTime = new SimpleDateFormat("yyyyMMdd").format(new Date());
                String tagName = sysApplication.getAppCode() + "_" + sysAppVersion.getVersionNum() + "_" + currentTime + "_D";
                sysAppVersion.setVersionName(tagName);
            }
            if (sysAppVersion.getBranchName() == null) {
                sysAppVersion.setBranchName("dev");
            }
            String accessToken = user.getChar1();
            DevCloudUtil.addTagToGitlab((String)sysApplication.getAppCode(), (String)this.gitlabConfigProperty.getGitUri(), (String)sysAppVersion.getVersionName(), (String)accessToken, (String)"projects", (String)sysAppVersion.getBranchName());
            boolean bl = super.save((BaseEntity)sysAppVersion);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
        finally {
            this.deleteFile(file);
        }
    }

    public boolean save(SysAppVersion sysAppVersion) {
        String timeMillis = String.valueOf(System.currentTimeMillis());
        File file = new File(this.gitlabConfigProperty.getTempPath() + File.separator + timeMillis);
        try {
            SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)sysAppVersion.getAppId());
            if ("D".equals(sysAppVersion.getVersionType())) {
                String currentTime = new SimpleDateFormat("yyyyMMdd").format(new Date());
                String tagName = sysApplication.getAppCode() + "_" + sysAppVersion.getVersionNum() + "_" + currentTime + "_D";
                sysAppVersion.setVersionName(tagName);
            }
            String accessToken = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getUserId()).getChar1();
            DevCloudUtil.addTagToGitlab((String)sysApplication.getAppCode(), (String)this.gitlabConfigProperty.getGitUri(), (String)sysAppVersion.getVersionName(), (String)accessToken, (String)"projects", (String)"dev");
            sysAppVersion.setBranchName("dev");
            boolean bl = super.save((BaseEntity)sysAppVersion);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
        finally {
            this.deleteFile(file);
        }
    }

    public Long importVersion(SysAppVersion sysAppVersion, MultipartFile multipartFile) throws IOException {
        if (ToolUtil.isEmpty((Object)multipartFile)) {
            throw new BaseException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)sysAppVersion.getAppId());
        Long timeMillis = System.currentTimeMillis();
        String fileName = "hussarImportTempZip.zip";
        File tempDir = new File(this.gitlabConfigProperty.getTempPath() + File.separator + timeMillis);
        tempDir.mkdir();
        File outFolder = new File(this.gitlabConfigProperty.getTempPath() + File.separator + timeMillis + File.separator + "hussarImportUnZip");
        outFolder.mkdir();
        File tempFile = new File(this.gitlabConfigProperty.getTempPath() + File.separator + timeMillis + File.separator + fileName);
        String tempPath = this.gitlabConfigProperty.getTempPath() + File.separator + timeMillis + File.separator + "hussarImportUnZip";
        multipartFile.transferTo(tempFile);
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        HussarCacheUtil.put((String)VERSION_IMPORT, (Object)timeMillis, (Object)"loading...", (long)600L);
        new Thread(() -> {
            try {
                try {
                    ZipFile.unzip((String)(this.gitlabConfigProperty.getTempPath() + File.separator + timeMillis + File.separator + fileName), (String)tempPath, (Charset)Charset.forName("GBK"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BaseException("\u89e3\u538b\u6587\u4ef6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f");
                }
                if (HussarUtils.isEmpty((Object)outFolder)) {
                    throw new BaseException("\u538b\u7f29\u5305\u4e2d\u5185\u5bb9\u4e3a\u7a7a");
                }
                if (!new File(tempPath + File.separator + "hussar-web").exists()) {
                    throw new BaseException("\u6587\u4ef6\u7ed3\u6784\u4e0d\u7b26\u5408\u8981\u6c42,\u7f3a\u5c11hussar-web\u76ee\u5f55");
                }
                if (!new File(tempPath + File.separator + "hussar-front").exists()) {
                    throw new BaseException("\u6587\u4ef6\u7ed3\u6784\u4e0d\u7b26\u5408\u8981\u6c42,\u7f3a\u5c11hussar-front\u76ee\u5f55");
                }
                if (!new File(tempPath + File.separator + "sql").exists()) {
                    throw new BaseException("\u6587\u4ef6\u7ed3\u6784\u4e0d\u7b26\u5408\u8981\u6c42,\u7f3a\u5c11sql\u76ee\u5f55");
                }
                if (!new File(tempPath + File.separator + ".git").exists()) {
                    throw new BaseException("\u6587\u4ef6\u7ed3\u6784\u4e0d\u7b26\u5408\u8981\u6c42,\u7f3a\u5c11.git\u76ee\u5f55");
                }
                if (!new File(tempPath + File.separator + ".gitignore").exists()) {
                    throw new BaseException("\u6587\u4ef6\u7ed3\u6784\u4e0d\u7b26\u5408\u8981\u6c42,\u7f3a\u5c11.gitignore\u6587\u4ef6");
                }
                if (!new File(tempPath + File.separator + "hussar-config").exists()) {
                    throw new BaseException("\u6587\u4ef6\u7ed3\u6784\u4e0d\u7b26\u5408\u8981\u6c42,\u7f3a\u5c11hussar-config\u76ee\u5f55");
                }
                if ("1".equals(sysApplication.getAppType()) && new File(tempPath + File.separator + "hussar-mobile").exists()) {
                    throw new BaseException("\u6587\u4ef6\u7ed3\u6784\u4e0d\u7b26\u5408\u8981\u6c42,\u5e94\u7528\u7c7b\u578b\u6ca1\u6709\u9009\u62e9APP\u65f6\u4e0d\u80fd\u4e0a\u4f20hussar-mobile\u76ee\u5f55");
                }
                if (sysApplication.getAppType().indexOf("2") > -1 && !new File(tempPath + File.separator + "hussar-mobile").exists()) {
                    throw new BaseException("\u6587\u4ef6\u7ed3\u6784\u4e0d\u7b26\u5408\u8981\u6c42,\u5e94\u7528\u7c7b\u578b\u9009\u62e9APP\u65f6\u7f3a\u5c11hussar-mobile\u76ee\u5f55");
                }
                List<String> versionNumList = this.getVersionNum(sysApplication.getId(), "D");
                String versionNum = "";
                if (versionNumList.size() > 0) {
                    int num = 0;
                    String[] numArray = versionNumList.get(0).split("\\.");
                    num = Integer.parseInt(numArray[2]) + 1;
                    versionNum = numArray[0] + "." + numArray[1] + "." + num;
                } else {
                    versionNum = "V1.0.0";
                }
                sysAppVersion.setVersionNum(versionNum);
                sysAppVersion.setVersionDesc(versionNum);
                sysAppVersion.setVersionType("D");
                sysAppVersion.setBranchName("dev");
                this.saveVersion(sysAppVersion, user);
                String gitUri = this.gitlabConfigProperty.getGitUri();
                String token = user.getChar1();
                String projectId = DevCloudUtil.getGroupOrProjectId((String)gitUri, (String)sysApplication.getAppCode(), (String)token, (String)"projects");
                DevCloudUtil.unProtectBranch((String)gitUri, (String)projectId, (String)"dev", (String)token);
                DevCloudUtil.upload2Gitlab((File)outFolder, (String)"dev", (String)sysApplication.getAppCode(), (String)this.getUri(), (String)token);
                if ("1".equals(sysApplication.getPersonalBrance())) {
                    DevCloudUtil.setProtectBranch((String)gitUri, (String)projectId, (String)"dev", (String)token);
                }
                HussarCacheUtil.put((String)VERSION_IMPORT, (Object)timeMillis, (Object)"success", (long)600L);
            }
            catch (Exception e) {
                e.printStackTrace();
                HussarCacheUtil.put((String)VERSION_IMPORT, (Object)timeMillis, (Object)(e.getMessage() == null ? e.getCause().getMessage() : e.getMessage()), (long)1800L);
            }
            finally {
                try {
                    this.deleteFile(outFolder);
                    FileUtils.forceDelete((File)tempFile);
                    this.deleteFile(tempDir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return timeMillis;
    }

    public String getImportStatus(Long time) {
        return (String)HussarCacheUtil.get((String)VERSION_IMPORT, (Object)time);
    }

    public void downVersion(Long id, HttpServletResponse response) {
        this.user = BaseSecurityUtil.getUser();
        String timeMillis = String.valueOf(System.currentTimeMillis());
        SysAppVersion sysAppVersion = (SysAppVersion)this.getById(id);
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)sysAppVersion.getAppId());
        HussarCacheUtil.put((String)this.user.getUserId().toString(), (Object)this.user.getUserId().toString(), (Object)false, (long)600L);
        new Thread(() -> this.downloadVersion(timeMillis, sysAppVersion, sysApplication)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadVersion(String timeMillis, SysAppVersion sysAppVersion, SysApplication sysApplication) {
        File outFolder = new File(this.gitlabConfigProperty.getTempPath() + File.separator + timeMillis);
        try {
            DevCloudUtil.downLoad((File)outFolder, (String)(this.gitlabConfigProperty.getTempPath() + File.separator + timeMillis), (String)"dev", (String)sysApplication.getAppCode(), (String)sysAppVersion.getVersionName(), (String)this.getUri(), (String)this.sysUsersService.getUser(this.user.getUserId()).getChar1());
            File tempFile = ZipFile.zip((File)outFolder, (Charset)Charset.forName("GBK"));
            HussarCacheUtil.put((String)this.user.getUserId().toString(), (Object)this.user.getUserId().toString(), (Object)true, (long)600L);
            HussarCacheUtil.put((String)(this.user.getUserId() + "downloadFilePath"), (Object)(this.user.getUserId() + "downloadFilePath"), (Object)tempFile.getPath(), (long)600L);
        }
        catch (Exception e) {
            e.printStackTrace();
            HussarCacheUtil.put((String)this.user.getUserId().toString(), (Object)this.user.getUserId().toString(), (Object)true, (long)600L);
            HussarCacheUtil.put((String)(this.user.getUserId() + "downloadFilePath"), (Object)(this.user.getUserId() + "downloadFilePath"), null, (long)600L);
        }
        finally {
            this.deleteFile(outFolder);
        }
    }

    public Long resetVersion(Long id) {
        Long timeMillis = System.currentTimeMillis();
        SysAppVersion sysAppVersion = (SysAppVersion)this.getById(id);
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)sysAppVersion.getAppId());
        SecurityUser user = BaseSecurityUtil.getUser();
        new Thread(() -> {
            File file = new File(this.gitlabConfigProperty.getTempPath() + File.separator + timeMillis);
            try {
                String gitUri = this.gitlabConfigProperty.getGitUri();
                String token = this.sysUsersService.getUser(user.getUserId()).getChar1();
                String projectId = DevCloudUtil.getGroupOrProjectId((String)gitUri, (String)sysApplication.getAppCode(), (String)token, (String)"projects");
                DevCloudUtil.unProtectBranch((String)gitUri, (String)projectId, (String)"dev", (String)token);
                DevCloudUtil.resetVersion((String)sysApplication.getAppCode(), (String)"dev", (String)sysAppVersion.getVersionName(), (File)file, (String)this.getUri(), (String)token);
                if ("1".equals(sysApplication.getPersonalBrance())) {
                    DevCloudUtil.setProtectBranch((String)gitUri, (String)projectId, (String)"dev", (String)token);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.deleteFile(file);
            }
        }).start();
        return timeMillis;
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }

    public List<String> getVersionNum(Long appId, String versionType) {
        return this.sysAppVersionMapper.getVersionNum(appId, versionType);
    }

    public int getCount(Long appId, String versionType) {
        return this.sysAppVersionMapper.getCount(appId, versionType);
    }

    public ApiResponse getDownloadFlag() {
        Boolean fileFlag = (Boolean)HussarCacheUtil.get((String)this.user.getUserId().toString(), (Object)this.user.getUserId().toString());
        if (!fileFlag.booleanValue()) {
            return ApiResponse.success((String)"\u4e0b\u8f7d\u4e2d");
        }
        String path = (String)HussarCacheUtil.get((String)(this.user.getUserId() + "downloadFilePath"), (Object)(this.user.getUserId() + "downloadFilePath"));
        if (HussarUtils.isEmpty((Object)path)) {
            return ApiResponse.success((String)"\u4e0b\u8f7d\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u4e0b\u8f7d\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(HttpServletResponse response) {
        String path = (String)HussarCacheUtil.get((String)(this.user.getUserId() + "downloadFilePath"), (Object)(this.user.getUserId() + "downloadFilePath"));
        if (HussarUtils.isEmpty((Object)path)) {
            throw new BaseException("\u4e0b\u8f7d\u8def\u5f84\u4e0d\u5b58\u5728\uff01");
        }
        File tempFile = new File(path);
        try (FileInputStream fis = new FileInputStream(tempFile);
             ServletOutputStream os = response.getOutputStream();){
            response.addHeader("Content-Disposition", "attachment;filename= hussarZip.zip");
            response.setContentType("multipart/form-data");
            IOUtils.copy((InputStream)fis, (OutputStream)os, (int)4096);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                FileUtils.forceDelete((File)tempFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

