/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.SysUsersApplicationVo;
import com.jxdinfo.hussar.base.portal.application.dto.SysAppAuthUserDto;
import com.jxdinfo.hussar.base.portal.application.dto.SysAppDeployDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppAuthUser;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppAuthUserService;
import com.jxdinfo.hussar.base.portal.application.service.ISysDeployService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e94\u7528\u6388\u6743\u4eba\u5458"})
@RestController(value="com.jxdinfo.hussar.base.portal.application.controller.SysAppAuthUserController")
@RequestMapping(value={"/hussarBase/application/authUser"})
public class SysAppAuthUserController {
    @Resource
    private ISysAppAuthUserService sysAppAuthUserService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysDeployService sysDeployService;

    @GetMapping(value={"/getUsers"})
    @ApiOperation(value="\u67e5\u8be2\u6388\u6743\u4eba\u5458", notes="\u67e5\u8be2\u6388\u6743\u4eba\u5458")
    public ApiResponse<List<SysUsersApplicationVo>> getUsers(@ApiParam(value="\u5e94\u7528id") @RequestParam Long appId, @ApiParam(value="\u6388\u6743\u7c7b\u578b") @RequestParam String authType) {
        return ApiResponse.success((Object)this.sysAppAuthUserService.getUsers(appId, authType));
    }

    @PostMapping(value={"/addUser"})
    @CheckPermission(value={"hussarBase:application:authUser:addUser"})
    @ApiOperation(value="\u6dfb\u52a0\u5e94\u7528\u6388\u6743\u4eba\u5458", notes="\u6dfb\u52a0\u5e94\u7528\u6388\u6743\u4eba\u5458")
    public ApiResponse<String> addAuthUser(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @RequestBody SysAppAuthUserDto sysAppAuthUserDto) {
        return this.sysAppAuthUserService.addAuthUser(sysAppAuthUserDto);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u6388\u6743\u4eba\u5458\u67e5\u8be2", notes="\u6388\u6743\u4eba\u5458\u67e5\u8be2")
    public ApiResponse<Page<SysAppAuthUser>> getManageAppList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @RequestBody SysAppAuthUserDto sysAppAuthUserDto) {
        return this.sysAppAuthUserService.getAuthUser(sysAppAuthUserDto);
    }

    @PostMapping(value={"/addDeploy"})
    @CheckPermission(value={"hussarBase:application:authUser:addDeploy"})
    @ApiOperation(value="\u6dfb\u52a0\u7528\u6237\u90e8\u7f72\u4fe1\u606f", notes="\u6dfb\u52a0\u7528\u6237\u90e8\u7f72\u4fe1\u606f")
    public ApiResponse<Long> addDeploy(@ApiParam(value="\u7528\u6237\u90e8\u7f72\u4fe1\u606f") @RequestBody SysAppDeployDto sysAppDeployDto) {
        try {
            int countMobile;
            int countFront;
            String threeDomainFront = sysAppDeployDto.getSysAppDeploy().getThreeLevelDomainFront();
            String threeDomainMobile = sysAppDeployDto.getSysAppDeploy().getThreeLevelDomainMobile();
            String twoDomainName = sysAppDeployDto.getSysAppDeploy().getTwoLevelDomain();
            Long deployId = sysAppDeployDto.getSysAppDeploy().getAppDeployId();
            if (HussarUtils.isNotBlank((CharSequence)threeDomainFront) && (countFront = this.sysDeployService.getFrontCount(threeDomainFront, twoDomainName, deployId)) > 0) {
                return ApiResponse.success((int)10001, (String)"\u540c\u4e00\u4e2a\u4e8c\u7ea7\u57df\u540d\u4e0b\u4e0d\u80fd\u6709\u76f8\u540c\u7684front\u57df\u540d");
            }
            if (HussarUtils.isNotBlank((CharSequence)threeDomainMobile) && (countMobile = this.sysDeployService.getMobileCount(threeDomainMobile, twoDomainName, deployId)) > 0) {
                return ApiResponse.success((int)10001, (String)"\u540c\u4e00\u4e2a\u4e8c\u7ea7\u57df\u540d\u4e0b\u4e0d\u80fd\u6709\u76f8\u540c\u7684mobile\u57df\u540d");
            }
            return ApiResponse.success((Object)this.sysAppAuthUserService.addDeploy(sysAppDeployDto));
        }
        catch (BaseException e) {
            return ApiResponse.success((int)10001, (String)e.getMessage());
        }
        catch (Exception e) {
            throw e;
        }
    }

    @GetMapping(value={"/addRoles"})
    @CheckPermission(value={"hussarBase:application:authUser:addRoles"})
    @ApiOperation(value="\u5206\u914d\u5e94\u7528\u7ba1\u7406\u4eba\u5458\u6dfb\u52a0\u89d2\u8272", notes="\u5206\u914d\u5e94\u7528\u7ba1\u7406\u4eba\u5458\u6dfb\u52a0\u89d2\u8272")
    public ApiResponse<Boolean> addRoles(@ApiParam(value="\u5206\u914d\u5e94\u7528\u7ba1\u7406\u4eba\u5458\u6dfb\u52a0\u89d2\u8272") @RequestParam String userIds, @RequestParam String userAccounts) {
        return ApiResponse.success((Object)this.sysAppAuthUserService.addRoles(userIds, userAccounts));
    }

    @GetMapping(value={"/getRoles"})
    @ApiOperation(value="\u56de\u663e\u5e94\u7528\u7ba1\u7406\u4eba\u5458\u6dfb\u52a0\u89d2\u8272", notes="\u56de\u663e\u5e94\u7528\u7ba1\u7406\u4eba\u5458\u6dfb\u52a0\u89d2\u8272")
    public ApiResponse<List<SysUsersApplicationVo>> getRoles() {
        return ApiResponse.success((Object)this.sysAppAuthUserService.getRoles());
    }

    @PostMapping(value={"/onlineAuth"})
    public ApiResponse<String> onlineAuth(@ApiParam(value="\u5e94\u7528id") @RequestBody Map<String, Object> param) {
        return this.sysAppAuthUserService.updateAppAuthUser(Long.valueOf(Long.parseLong((String)param.get("appAuthId"))), (Boolean)param.get("onlineAuth"));
    }
}

