/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDeployMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDomainMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppRecordLogMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppRecordMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppTemplateMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.base.portal.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppAuthUser;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevops;
import com.jxdinfo.hussar.base.portal.application.model.SysAppRecord;
import com.jxdinfo.hussar.base.portal.application.model.SysAppRecordLog;
import com.jxdinfo.hussar.base.portal.application.model.SysAppTemplate;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppAuthUserService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevopsService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppRecordLogService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppRecordService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppTemplateService;
import com.jxdinfo.hussar.base.portal.constant.AppConstants;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.DevCloudUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.file.ZipFile;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppTemplateImpl")
public class SysAppTemplateImpl
extends HussarServiceImpl<SysAppTemplateMapper, SysAppTemplate>
implements ISysAppTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(SysAppTemplateImpl.class);
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private IGitlabService gitlabService;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    public SysAppDeployMapper sysAppDeployMapper;
    @Autowired
    public SysAppDomainMapper sysAppDomainMapper;
    private static final String importCache = "IMPORT_CACHE";
    private static final String NOT_DEL = "0";
    @Autowired
    private SysAppRecordMapper sysAppRecordMapper;
    @Autowired
    private SysAppRecordLogMapper sysAppRecordLogMapper;
    @Autowired
    private ISysAppAuthUserService sysAppAuthUserService;
    @Autowired
    ISysAppRecordService sysAppRecordService;
    @Autowired
    ISysAppRecordLogService sysAppRecordLogService;
    @Autowired
    private ISysAppDevopsService sysAppDevopsService;

    public boolean removeById(Serializable id) {
        SysAppTemplate sysAppTemplate = (SysAppTemplate)super.getById(id);
        sysAppTemplate.setDelFlag("1");
        File file = new File(sysAppTemplate.getTemplatePath());
        file.delete();
        return super.updateById((BaseEntity)sysAppTemplate);
    }

    public Long importTemplate(MultipartFile multipartFile, SysAppTemplate sysAppTemplate) throws IOException {
        Long time = System.currentTimeMillis();
        if (ToolUtil.isEmpty((Object)multipartFile)) {
            throw new BaseException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fileName = sysAppTemplate.getTemplateName() + ".zip";
        String path = this.gitlabConfigProperty.getTemplatePath() + File.separator + fileName;
        String tempPath = this.gitlabConfigProperty.getTempPath() + File.separator + time;
        HussarCacheUtil.put((String)importCache, (Object)time, (Object)"loading...", (long)600L);
        File tempFile = new File(path);
        multipartFile.transferTo(tempFile);
        new Thread(() -> {
            try {
                ZipFile.unzip((String)path, (String)tempPath, (Charset)Charset.forName("GBK"));
                if (this.checkFile(tempPath)) {
                    sysAppTemplate.setTemplatePath(path);
                    this.save((BaseEntity)sysAppTemplate);
                    HussarCacheUtil.put((String)importCache, (Object)time, (Object)"success", (long)600L);
                } else {
                    tempFile.delete();
                    HussarCacheUtil.put((String)importCache, (Object)time, (Object)"\u6587\u4ef6\u7ed3\u6784\u4e0d\u7b26\u5408\u8981\u6c42", (long)600L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                HussarCacheUtil.put((String)importCache, (Object)time, (Object)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u89e3\u538b\u9519\u8bef\uff0c\u5e94\u4e3a.zip\u683c\u5f0f\u4e14\u80fd\u6b63\u5e38\u89e3\u538b", (long)600L);
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        return time;
    }

    public String getImportStatus(Long time) {
        return (String)HussarCacheUtil.get((String)importCache, (Object)time);
    }

    private boolean checkFile(String path) {
        File file = new File(path);
        File[] files = file.listFiles();
        if (files.length == 5 && new File(path + File.separator + "hussar-web").exists() && new File(path + File.separator + "hussar-front").exists() && new File(path + File.separator + "sql").exists() && new File(path + File.separator + ".gitignore").exists() && new File(path + File.separator + "hussar-config").exists()) {
            return true;
        }
        if (files.length == 6 && (new File(path + File.separator + "hussar-web").exists() && new File(path + File.separator + "hussar-front").exists() && new File(path + File.separator + "hussar-mobile").exists() && new File(path + File.separator + "sql").exists() && new File(path + File.separator + ".gitignore").exists() && new File(path + File.separator + "hussar-config").exists() || new File(path + File.separator + "hussar-web").exists() && new File(path + File.separator + "hussar-front").exists() && new File(path + File.separator + "hussar-mobile-uni").exists() && new File(path + File.separator + "sql").exists() && new File(path + File.separator + ".gitignore").exists() && new File(path + File.separator + "hussar-config").exists())) {
            return true;
        }
        return files.length == 7 && new File(path + File.separator + "hussar-web").exists() && new File(path + File.separator + "hussar-front").exists() && new File(path + File.separator + "hussar-mobile").exists() && new File(path + File.separator + "hussar-mobile-uni").exists() && new File(path + File.separator + "sql").exists() && new File(path + File.separator + ".gitignore").exists() && new File(path + File.separator + "hussar-config").exists();
    }

    public void downloadTemplate(Long id, HttpServletResponse response) {
        SysAppTemplate sysAppTemplate = (SysAppTemplate)this.getById(id);
        String filePath = this.gitlabConfigProperty.getTemplatePath() + File.separator + sysAppTemplate.getTemplateName() + ".zip";
        String fileName = sysAppTemplate.getTemplateName() + ".zip";
        File file = new File(filePath);
        try (FileInputStream fis = new FileInputStream(file);
             ServletOutputStream os = response.getOutputStream();){
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(sysAppTemplate.getTemplateName() + ".zip", StandardCharsets.UTF_8.name()));
            IOUtils.copy((InputStream)fis, (OutputStream)os, (int)4096);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @HussarTransactional
    public Long addApp(SysApplicationDto sysApplicationDto) {
        LocalDateTime log1StartTime = LocalDateTime.now();
        Long currentTime = System.currentTimeMillis();
        SysApplication sysApplication = sysApplicationDto.getSysApplication();
        List sysApplications = this.sysApplicationMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)sysApplication.getAppCode())).or()).eq(SysApplication::getAppName, (Object)sysApplication.getAppName()));
        if (ToolUtil.isNotEmpty((Object)sysApplications)) {
            throw new BaseException("\u5217\u8868\u6216\u56de\u6536\u7ad9\u4e2d\u5e94\u7528\u540d\u79f0\u6216\u5e94\u7528\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
        }
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String gitUri = this.gitlabConfigProperty.getGitUri();
        String token = user.getChar1();
        String projectId = "";
        String groupId = this.gitlabConfigProperty.getGitGroup();
        try {
            projectId = DevCloudUtil.getProjectIdByGroupIdAndName((String)gitUri, (String)sysApplication.getAppCode(), (String)token, (String)groupId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ToolUtil.isNotEmpty((Object)projectId)) {
            throw new BaseException("\u5e94\u7528\u540d\u79f0\u6216\u5e94\u7528\u6807\u8bc6\u5df2\u5728GIT\u5b58\u5728\uff01");
        }
        sysApplication.setAppStatus("2");
        sysApplication.setReleaseStatus(NOT_DEL);
        sysApplication.setDelFlag(NOT_DEL);
        sysApplication.setCreateFlag(NOT_DEL);
        sysApplication.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        sysApplication.setAppGitUrl(this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + File.separator + ".git");
        this.sysApplicationMapper.insert(sysApplication);
        SysAppRecord sysAppRecord = this.sysAppRecordService.saveRecord("1", "\u5e94\u7528\u521b\u5efa", "1", sysApplication.getId());
        SysAppRecordLog saveAppInfoLog = this.sysAppRecordLogService.saveRecordLog("\u4fdd\u5b58\u5e94\u7528\u4fe1\u606f", sysAppRecord.getId(), "2", "1", null);
        SysAppTemplateImpl that = this;
        SysUsers projectLeaderUser = this.sysUsersService.getUser(sysApplication.getProjectLeader());
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setUserId(projectLeaderUser.getId());
        sysUserRole.setGrantedRole(AppConstants.PROJECT_LEADER_ID);
        sysUserRole.setAdminOption("1");
        if (this.sysUserRoleService.getUserRole(sysUserRole.getUserId(), sysUserRole.getGrantedRole()) < 1) {
            this.sysUserRoleService.save((Object)sysUserRole);
        }
        if (HussarUtils.isNotEmpty((Object)sysApplicationDto.getViewUserIds())) {
            String[] split;
            ArrayList<SysAppAuthUser> list = new ArrayList<SysAppAuthUser>();
            for (String str : split = sysApplicationDto.getViewUserIds().split(",")) {
                SysAppAuthUser authUser = new SysAppAuthUser();
                authUser.setAppId(sysApplication.getId());
                authUser.setUserId(Long.valueOf(str));
                authUser.setAuthType("3");
                authUser.setOnlineAuth(NOT_DEL);
                authUser.setDelFlag(NOT_DEL);
                list.add(authUser);
                int userRole = this.sysUserRoleService.getUserRole(Long.valueOf(str), AppConstants.APP_VIEW_ROLE_ID);
                if (userRole != 0) continue;
                SysUserRole viewUserRole = new SysUserRole();
                viewUserRole.setUserId(Long.valueOf(str));
                viewUserRole.setGrantedRole(AppConstants.APP_VIEW_ROLE_ID);
                viewUserRole.setAdminOption("1");
                this.sysUserRoleService.save((Object)viewUserRole);
            }
            this.sysAppAuthUserService.saveBatch(list);
        }
        this.sysAppRecordLogService.updateRecordLog(saveAppInfoLog, NOT_DEL);
        new Thread(() -> {
            SysAppRecordLog downUnzipTemplateLog;
            SysAppRecordLog failRecordLog = new SysAppRecordLog();
            failRecordLog = downUnzipTemplateLog = this.sysAppRecordLogService.saveRecordLog("\u4e0b\u8f7d\u5e76\u89e3\u538b\u6e90\u7801", sysAppRecord.getId(), "2", "1", null);
            try {
                SysAppRecordLog gitPersonAppLeaderLog;
                SysAppRecordLog creatGitAppUploadLog;
                this.gitlabService.createDir(sysApplication.getAppCode(), currentTime);
                SysAppTemplate sysAppTemplate = (SysAppTemplate)that.getById(sysApplication.getTemplateId());
                String filePath = this.gitlabConfigProperty.getTemplatePath() + File.separator + sysAppTemplate.getTemplateName() + ".zip";
                String tempPath = this.gitlabConfigProperty.getTempPath() + File.separator + currentTime + File.separator + sysApplication.getAppCode();
                ZipFile.unzip((String)filePath, (String)tempPath, (Charset)Charset.forName("GBK"));
                Boolean h5Flag = false;
                if (!new File(tempPath + File.separator + "hussar-mobile").exists() && sysApplication.getAppType().contains("2")) {
                    SysAppRecordLog noH5Log = this.sysAppRecordLogService.saveRecordLog("\u6a21\u677f\u4e2d\u4e0d\u5305\u542b\u5e94\u7528\u7c7b\u578b\u4e3aH5\u7684\u6e90\u7801\u6587\u4ef6", sysAppRecord.getId(), NOT_DEL, "1", null);
                    h5Flag = true;
                }
                if (!sysApplication.getAppType().contains("2") && new File(tempPath + File.separator + "hussar-mobile").exists()) {
                    this.deleteFile(new File(tempPath + File.separator + "hussar-mobile"));
                }
                Boolean uniappFlag = false;
                if (!new File(tempPath + File.separator + "hussar-mobile-uni").exists() && (sysApplication.getAppType().contains("3") || sysApplication.getAppType().contains("4"))) {
                    SysAppRecordLog noUniappLog = this.sysAppRecordLogService.saveRecordLog("\u6a21\u677f\u4e2d\u4e0d\u5305\u542b\u5e94\u7528\u7c7b\u578b\u5c0f\u7a0b\u5e8f\u6216UNIAPP\u7684\u6e90\u7801\u6587\u4ef6", sysAppRecord.getId(), NOT_DEL, "1", null);
                    uniappFlag = true;
                }
                if (new File(tempPath + File.separator + "hussar-mobile-uni").exists() && !sysApplication.getAppType().contains("3") && !sysApplication.getAppType().contains("4")) {
                    this.deleteFile(new File(tempPath + File.separator + "hussar-mobile-uni"));
                }
                if (h5Flag.booleanValue() || uniappFlag.booleanValue()) {
                    LocalDateTime startTime = LocalDateTime.now();
                    String appType = sysApplication.getAppType();
                    String[] split = appType.split(",");
                    ArrayList<String> appTypeList = new ArrayList<String>(Arrays.asList(split));
                    if (h5Flag.booleanValue()) {
                        appTypeList.remove("2");
                    }
                    if (uniappFlag.booleanValue()) {
                        appTypeList.remove("3");
                        appTypeList.remove("4");
                    }
                    String newAppType = String.join((CharSequence)",", appTypeList);
                    sysApplication.setAppType(newAppType);
                    this.sysApplicationMapper.updateById(sysApplication);
                    SysAppRecordLog sysAppRecordLog = this.sysAppRecordLogService.saveRecordLog("\u4fee\u6539\u5e94\u7528\u7c7b\u578b", sysAppRecord.getId(), NOT_DEL, "1", null);
                }
                this.sysAppRecordLogService.updateRecordLog(downUnzipTemplateLog, NOT_DEL);
                failRecordLog = creatGitAppUploadLog = this.sysAppRecordLogService.saveRecordLog("\u521b\u5efagit\u9879\u76ee\u5e76\u4e0a\u4f20\u6e90\u7801", sysAppRecord.getId(), "2", "1", null);
                String accessToken = user.getChar1();
                this.gitlabService.createProject(sysApplication.getAppCode(), sysApplication.getAppDescribe(), "\u521b\u5efa\u5e94\u7528", accessToken, currentTime);
                this.sysAppRecordLogService.updateRecordLog(creatGitAppUploadLog, NOT_DEL);
                failRecordLog = gitPersonAppLeaderLog = this.sysAppRecordLogService.saveRecordLog("git\u9879\u76ee\u6388\u6743\u5e94\u7528\u8d1f\u8d23\u4eba", sysAppRecord.getId(), "2", "1", null);
                this.gitlabService.inviteUserJoinGroupOrProject(projectLeaderUser.getUserAccount(), user.getChar1(), "projects", sysApplication.getAppCode(), true);
                this.sysAppRecordLogService.updateRecordLog(gitPersonAppLeaderLog, NOT_DEL);
                SysAppRecordLog createAppSuccessLog = this.sysAppRecordLogService.saveRecordLog("\u5e94\u7528\u521b\u5efa\u6210\u529f", sysAppRecord.getId(), NOT_DEL, "1", null);
                sysAppRecord.setStatus("2");
                this.sysAppRecordMapper.updateById(sysAppRecord);
                JSONObject sysAppDevopsJson = this.sysAppDevopsService.createProject(sysApplication, projectLeaderUser.getUserAccount());
                SysAppDevops sysAppDevops = new SysAppDevops();
                sysAppDevops.setAppId(sysApplication.getId());
                sysAppDevops.setProjectId(String.valueOf(sysAppDevopsJson.get((Object)"projectId")));
                this.sysAppDevopsService.save((Object)sysAppDevops);
            }
            catch (Exception e) {
                e.printStackTrace();
                sysApplication.setCreateFlag("1");
                this.sysApplicationMapper.updateById(sysApplication);
                this.sysAppRecordLogService.updateRecordLog(failRecordLog, "1");
                this.sysAppRecordService.updateRecord(sysAppRecord, "3");
                logger.info("\u91cd\u521b\u5efa\u5e94\u7528\uff1a{}", (Object)e.getMessage());
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + currentTime));
            }
        }).start();
        return sysApplication.getId();
    }

    @HussarTransactional
    private void updateRecordLog(SysAppRecordLog sysAppRecordLog) {
        this.sysAppRecordLogMapper.updateById(sysAppRecordLog);
    }

    @HussarTransactional
    private void insertRecordLog(SysAppRecordLog sysAppRecordLog) {
        this.sysAppRecordLogMapper.insert(sysAppRecordLog);
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }
}

