/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDevopsMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppRecordLogMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppRecordMapper;
import com.jxdinfo.hussar.base.portal.application.dto.SysAppDevopsDto;
import com.jxdinfo.hussar.base.portal.application.dto.SysApplicationPublishProjectTypeDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevops;
import com.jxdinfo.hussar.base.portal.application.model.SysAppRecord;
import com.jxdinfo.hussar.base.portal.application.model.SysAppRecordLog;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.pojo.AppRecordLogTypeEnum;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevopsService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppRecordLogService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppRecordService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppResourceService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.service.ISysDeployService;
import com.jxdinfo.hussar.base.portal.nums.MSTestTypeNum;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.base.portal.utils.AppTypeUtil;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.DESUtil;
import com.jxdinfo.hussar.common.utils.DevopsUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppDevopsServiceImpl")
public class SysAppDevopsServiceImpl
extends HussarServiceImpl<SysAppDevopsMapper, SysAppDevops>
implements ISysAppDevopsService {
    private static final Logger logger = LoggerFactory.getLogger(SysAppDevopsServiceImpl.class);
    @Value(value="${devops.uri.devops-uri:default}")
    private String devopsUri;
    @Value(value="${devPlatForm.url:default}")
    private String devPlatformUri;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    private SysAppDevopsMapper sysAppDevopsMapper;
    @Resource
    private ISysDeployService sysDeployService;
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    ISysApplicationService sysApplicationService;
    @Resource
    ISysAppResourceService sysAppResourceService;
    @Resource
    ISysAppRecordService sysAppRecordService;
    @Resource
    ISysAppRecordLogService sysAppRecordLogService;
    @Resource
    private SysAppRecordMapper sysAppRecordMapper;
    @Resource
    private SysAppRecordLogMapper sysAppRecordLogMapper;

    public JSONObject createPipeline(SysApplication sysApplication, SysAppDeploy sysAppDeploy, String branch, String projectId, SysAppRecord sysAppRecord, SysAppRecordLog sysAppRecordLog) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("buildDefinitionName", sysApplication.getAppName());
        dataMap.put("projectId", projectId);
        String frontType = AppTypeUtil.getAppTypeLabel(sysApplication.getAppType());
        dataMap.put("frontType", frontType);
        dataMap.put("gitUrl", this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
        dataMap.put("branch", branch);
        dataMap.put("templateName", "lcdp");
        dataMap.put("databaseType", SysAppDevopsServiceImpl.databaseType(sysAppDeploy.getDatabasetType()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("databaseIp", sysAppDeploy.getDatabaseUrl());
        map.put("databasePort", sysAppDeploy.getDatabasePort());
        map.put("databaseName", sysAppDeploy.getDatabaseName());
        map.put("databaseUser", sysAppDeploy.getDatabaseAccount());
        map.put("databasePassword", DESUtil.encrypt((String)"qddt@2023", (String)sysAppDeploy.getDatabasePassword()));
        SysAppDevops sysAppDevops = (SysAppDevops)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)branch));
        int version = sysAppDevops != null ? sysAppDevops.getVersion() + 1 : 1;
        map.put("version", version + ".0.0");
        map.put("releas", sysApplication.getAppCode() + "-dev");
        map.put("imageRepo", sysAppDeploy.getAppNamespace());
        map.put("sqlPath", this.getSqlPath(sysAppDeploy.getDatabasetType()));
        dataMap.put("map", map);
        String urlDevops = this.devopsUri + "api/integration/ddm/create/createbuilddefinition";
        logger.info("\u5bf9\u63a5devops\u6784\u5efa\u6d41\u6c34\u7ebf\u63a5\u53e3\u53c2\u6570\uff1aurl\uff1a-------> {};param:----------->{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u5bf9\u63a5devops\u6784\u5efa\u6d41\u6c34\u7ebf\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1ajson:-->{},", (Object)json);
        json.put("version", (Object)version);
        json.put("releas", (Object)(sysApplication.getAppCode() + "-dev"));
        if ("200".equals(json.getString("statusCode"))) {
            sysAppRecordLog.setStatus("0");
            if ("1".equals(sysAppDeploy.getDeployType()) || "2".equals(sysAppDeploy.getDeployType())) {
                sysAppRecord.setDefinitionId(json.getString("devDefinitionId"));
            } else if ("3".equals(sysAppDeploy.getDeployType())) {
                sysAppRecord.setDefinitionId(json.getString("testDefinitionId"));
            } else if ("4".equals(sysAppDeploy.getDeployType())) {
                sysAppRecord.setDefinitionId(json.getString("prodDefinitionId"));
            } else if ("5".equals(sysAppDeploy.getDeployType())) {
                sysAppRecord.setDefinitionId(json.getString("preDefinitionId"));
            }
        } else {
            sysAppRecordLog.setStatus("1");
            sysAppRecordLog.setErrInfo(json.getString("errorLocalizedMessage"));
            sysAppRecord.setStatus("3");
        }
        sysAppRecordLog.setEndTime(LocalDateTime.now());
        this.sysAppRecordLogService.updateById((Object)sysAppRecordLog);
        this.sysAppRecordService.updateById((Object)sysAppRecord);
        logger.info("\u6d41\u6c34\u7ebf\u65e5\u5fd7\u4fe1\u606fsysAppRecordLog\uff1a-------->{}", (Object)sysAppRecordLog);
        return json;
    }

    public JSONObject executePipeline(String definitionId, String version, String frontType, String isInit, String env, String branch, SysAppDeploy sysAppDeploy, SysAppRecord sysAppRecord, SysAppRecordLog sysAppRecordLog, SysApplicationPublishProjectTypeDto sysApplicationPublishProjectTypeDto) {
        SysApplication appInfo = (SysApplication)this.sysApplicationService.getById((Serializable)sysAppDeploy.getAppId());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> project = new HashMap<String, String>();
        project.put("version", version);
        project.put("databaseType", SysAppDevopsServiceImpl.databaseType(sysAppDeploy.getDatabasetType()));
        project.put("databaseIp", sysAppDeploy.getDatabaseUrl());
        project.put("databasePort", sysAppDeploy.getDatabasePort());
        project.put("databaseName", sysAppDeploy.getDatabaseName());
        project.put("databaseUser", sysAppDeploy.getDatabaseAccount());
        project.put("databasePassword", DESUtil.encrypt((String)"qddt@2023", (String)sysAppDeploy.getDatabasePassword()));
        project.put("sqlPath", this.getSqlPath(sysAppDeploy.getDatabasetType()));
        project.put("imageRepo", sysAppDeploy.getAppNamespace());
        project.put("branch", branch);
        String releas = null;
        if ("DEV".equals(env) && "dev".equals(branch)) {
            releas = appInfo.getAppCode() + "-dev";
        } else if ("DEV".equals(env) && !"dev".equals(branch)) {
            releas = appInfo.getAppCode() + "-" + branch;
        } else if ("TEST".equals(env)) {
            releas = appInfo.getAppCode() + "-test";
        } else if ("PRE".equals(env)) {
            releas = appInfo.getAppCode() + "-pre";
        } else if ("PROD".equals(env)) {
            releas = appInfo.getAppCode() + "-prod";
        }
        project.put("releas", releas);
        dataMap.put("buildParams", project);
        dataMap.put("env", env);
        dataMap.put("frontType", frontType);
        dataMap.put("isInit", isInit);
        dataMap.put("webDisabled", String.valueOf(sysApplicationPublishProjectTypeDto.getIsPublishingWeb() == false));
        dataMap.put("frontDisabled", String.valueOf(sysApplicationPublishProjectTypeDto.getIsPublishingFront() == false));
        dataMap.put("mobileDisabled", String.valueOf(sysApplicationPublishProjectTypeDto.getIsPublishingMobile() == false));
        dataMap.put("uniMobileDisabled ", String.valueOf(sysApplicationPublishProjectTypeDto.getIsPublishingUni() == false));
        boolean isPublishingNonWeb = sysApplicationPublishProjectTypeDto.getIsPublishingFront() != false || sysApplicationPublishProjectTypeDto.getIsPublishingMobile() != false || sysApplicationPublishProjectTypeDto.getIsPublishingUni() != false;
        dataMap.put("uiDisabled", String.valueOf(!isPublishingNonWeb));
        String urlDevops = this.devopsUri + "api/integration/ddm/" + definitionId + "/execute";
        logger.info("\u5bf9\u63a5devops,\u6267\u884c\u6d41\u6c34\u7ebf\u53c2\u6570\uff1aurlDevops:---------->{}\uff0cdataMap:--------->{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u5bf9\u63a5devops,\u6267\u884c\u6d41\u6c34\u7ebf\u8fd4\u56de\u7ed3\u679cjson:--------->\uff1a{}", (Object)json);
        SysAppRecordLog pipelineUp = null;
        if ("200".equals(json.get((Object)"status").toString())) {
            sysAppRecord.setBuildId(json.get((Object)"buildId").toString());
            sysAppRecord.setPipelineStatus("1");
            sysAppRecordLog.setStatus("0");
            if (HussarUtils.isNotEmpty((Object)json.get((Object)"log").toString())) {
                pipelineUp = new SysAppRecordLog();
                pipelineUp.setRecordId(sysAppRecord.getId());
                pipelineUp.setLogInfo("\u6d41\u6c34\u7ebf\u6392\u961f");
                pipelineUp.setStartTime(LocalDateTime.now());
                pipelineUp.setStatus("2");
                pipelineUp.setType("1");
                sysAppRecord.setPipelineStatus("4");
                sysAppRecord.setStatus("4");
            }
        } else {
            sysAppRecord.setStatus("3");
            sysAppRecord.setPipelineStatus("3");
            sysAppRecordLog.setStatus("1");
            sysAppRecordLog.setErrInfo(json.getString("errorLocalizedMessage"));
        }
        sysAppRecordLog.setEndTime(LocalDateTime.now());
        sysAppRecord.setDefinitionId(definitionId);
        this.sysAppRecordService.updateById((Object)sysAppRecord);
        this.sysAppRecordLogService.saveOrUpdate((Object)sysAppRecordLog);
        logger.info("\u6d41\u6c34\u7ebf\u65e5\u5fd7\u4fe1\u606fsysAppRecordLog\uff1a-------->{}", (Object)sysAppRecordLog);
        if (HussarUtils.isNotEmpty((Object)pipelineUp)) {
            pipelineUp.setEndTime(LocalDateTime.now());
            this.sysAppRecordLogService.saveOrUpdate((Object)pipelineUp);
        }
        return json;
    }

    String getSqlPath(String dataType) {
        String sqlPath = "";
        if (HussarUtils.isNotEmpty((Object)dataType)) {
            switch (dataType) {
                case "1": {
                    sqlPath = "sql/ORACLE/qddt-oracle.sql";
                    break;
                }
                case "8": {
                    sqlPath = "sql/MYSQL/qddt-mysql.sql";
                    break;
                }
                case "9": {
                    sqlPath = "sql/MYSQL/qddt-mysql.sql";
                    break;
                }
                case "3": {
                    sqlPath = "sql/DM/qddt-dm.sql";
                    break;
                }
                case "4": {
                    sqlPath = "sql/OSCA/qddt-oscar.sql";
                    break;
                }
                case "5": {
                    sqlPath = "sql/POSTGRE/qddt-postgre.sql";
                    break;
                }
                case "6": {
                    sqlPath = "sql/SQLSERVER/qddt-sqlserver.sql";
                    break;
                }
                case "7": {
                    sqlPath = "sql/KINGBASE/qddt-kingbase.sql";
                    break;
                }
                default: {
                    sqlPath = "sql/MYSQL/qddt-mysql.sql";
                }
            }
        }
        return sqlPath;
    }

    public JSONObject createPipelineByPerson(SysApplication sysApplication, SysAppDeploy sysAppDeploy, String projectId, SysAppRecord sysAppRecord, SysAppRecordLog sysAppRecordLog) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("projectId", projectId);
        dataMap.put("gitUrl", this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
        dataMap.put("branch", sysAppDeploy.getBranchName());
        dataMap.put("templateName", "lcdp");
        HashMap<String, String> map = new HashMap<String, String>();
        String userAccount = this.sysUsersService.getUser(sysAppDeploy.getUserId()).getUserAccount();
        map.put("developer", userAccount + "-" + sysAppDeploy.getBranchName());
        int version = 0;
        SysAppDevops sysAppDevops = (SysAppDevops)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)sysAppDeploy.getBranchName()));
        version = sysAppDevops != null ? sysAppDevops.getVersion() + 1 : 1;
        map.put("version", "v" + version);
        map.put("projectCode", sysApplication.getAppCode());
        map.put("releas", sysApplication.getAppCode() + "-" + sysAppDeploy.getBranchName());
        map.put("imageRepo", sysAppDeploy.getAppNamespace());
        map.put("sqlPath", this.getSqlPath(sysAppDeploy.getDatabasetType()));
        dataMap.put("map", map);
        String urlDevops = this.devopsUri + "api/integration/ddm/build/branch";
        logger.info("\u4e2a\u4eba\u5206\u652f\u6784\u5efa\u6d41\u6c34\u7ebf\uff1a\u5bf9\u63a5devops\u53c2\u6570\uff1aurlDevops===============>{},dataMap:===============>{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u4e2a\u4eba\u5206\u652f\u6784\u5efa\u6d41\u6c34\u7ebf\uff0c\u8fd4\u56de\u53c2\u6570\uff1ajson:-->{},", (Object)json);
        json.put("version", (Object)version);
        json.put("releas", (Object)(sysApplication.getAppCode() + "-" + sysAppDeploy.getBranchName()));
        if ("200".equals(json.getString("statusCode"))) {
            sysAppRecord.setDefinitionId(json.getString("definitionId"));
        } else {
            sysAppRecordLog.setStatus("1");
            sysAppRecordLog.setErrInfo(json.getString("errorLocalizedMessage"));
            sysAppRecordLog.setEndTime(LocalDateTime.now());
            this.sysAppRecordLogService.saveOrUpdate((Object)sysAppRecordLog);
            sysAppRecord.setStatus("3");
        }
        this.sysAppRecordService.updateById((Object)sysAppRecord);
        return json;
    }

    private static String databaseType(String databaseType) {
        String name = "";
        if (HussarUtils.isNotEmpty((Object)databaseType)) {
            switch (databaseType) {
                case "1": {
                    name = "oracle";
                    break;
                }
                case "8": {
                    name = "mysql";
                    break;
                }
                case "9": {
                    name = "mysql8";
                    break;
                }
                case "3": {
                    name = "dameng";
                    break;
                }
                default: {
                    name = "db2";
                }
            }
        }
        return name;
    }

    public JSONObject releaseResource(String relase) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("env", "DEV");
        dataMap.put("relase", relase);
        String urlDevops = this.devopsUri + "/api/integration/ddm/remove/relase";
        logger.info("\u91ca\u653e\u5f00\u53d1\u73af\u5883\u8d44\u6e90\uff0c\u5bf9\u63a5devops\u53c2\u6570\uff1aurlDevops------->{},dataMap--------->{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u91ca\u653e\u5f00\u53d1\u73af\u5883\u8d44\u6e90\uff0c\u5bf9\u63a5devops\u8fd4\u56de\u53c2\u6570\uff1ajson----------------->{}", (Object)json);
        this.update((Wrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"RELEAS", Arrays.asList(relase.split(",")))).set((Object)"RECOVER_FLAG", (Object)"0"));
        return json;
    }

    public List<SysAppRecord> getAppRecordInfo(Long appId) {
        return this.sysAppRecordService.listRecordListInfo(appId);
    }

    private List<SysAppRecordLog> getPipelineInfo(SysAppRecord sysAppRecord) {
        ArrayList<SysAppRecordLog> resLogList = new ArrayList<SysAppRecordLog>();
        String definitionId = sysAppRecord.getDefinitionId();
        String buildId = sysAppRecord.getBuildId();
        CloseableHttpClient httpclients = null;
        try {
            String url = this.devopsUri + "api/ci/builddefs/" + definitionId + "/instances?buildDefinitionId=" + definitionId + "&cascadeStageInstance=true&refreshToken=true";
            logger.info("\u5bf9\u63a5devops\u67e5\u8be2\u8282\u70b9\u4fe1\u606f\u53c2\u6570\uff1a{}==========", (Object)url);
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            logger.info("response", (Object)response);
            HttpEntity httpEntity = response.getEntity();
            if (null != httpEntity) {
                JSONArray data;
                String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                JSONObject jsonObject = JSON.parseObject((String)result);
                if (null != jsonObject && null != (data = JSONArray.parseArray((String)jsonObject.getString("data")))) {
                    JSONObject pipelineInstance;
                    JSONArray engineStageInstances;
                    JSONObject single = null;
                    for (int i = 0; i < data.size(); ++i) {
                        if (!buildId.equals(data.getJSONObject(i).get((Object)"buildId").toString())) continue;
                        single = data.getJSONObject(i);
                    }
                    if (null != single && null != (engineStageInstances = JSONArray.parseArray((String)(pipelineInstance = single.getJSONObject("pipelineInstance")).getString("engineStageInstances")))) {
                        for (int j = 0; j < engineStageInstances.size(); ++j) {
                            JSONObject stageInfo = engineStageInstances.getJSONObject(j);
                            String instanceStatus = stageInfo.getString("instanceStatus");
                            if ("disable".equals(instanceStatus) || "unexecuted".equals(instanceStatus)) continue;
                            SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
                            sysAppRecordLog.setRecordId(sysAppRecord.getId());
                            String stageName = stageInfo.getString("stageName");
                            sysAppRecordLog.setLogInfo(stageName.substring(stageName.lastIndexOf(":") + 1));
                            sysAppRecordLog.setStartTime(LocalDateTime.parse(stageInfo.getString("beginTime"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                            sysAppRecordLog.setEndTime(null == stageInfo.getString("endTime") ? null : LocalDateTime.parse(stageInfo.getString("endTime"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                            String status = stageInfo.getString("instanceStatus");
                            if ("success".equals(status)) {
                                sysAppRecordLog.setStatus("0");
                            } else if ("failure".equals(status)) {
                                sysAppRecordLog.setStatus("1");
                            } else if ("executing".equals(status)) {
                                sysAppRecordLog.setStatus("2");
                            }
                            sysAppRecordLog.setType("2");
                            resLogList.add(sysAppRecordLog);
                        }
                    }
                }
            } else {
                logger.info("\u5bf9\u63a5devops\u67e5\u8be2\u8282\u70b9\u65e0\u8fd4\u56de\u4fe1\u606fhttpEntity\uff1a==============>{}", (Object)httpEntity);
            }
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new BaseException((Throwable)e);
                }
            }
        }
        return resLogList;
    }

    public List<SysAppRecordLog> getRecordLog(Long recordId, String type) {
        List dataLogList = null;
        if ("8".equals(type)) {
            dataLogList = this.sysAppRecordLogService.listForForceUpgrade(recordId);
        } else {
            dataLogList = this.sysAppRecordLogService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RECORD_ID", (Object)recordId)).orderByAsc((Object)"START_TIME")).orderByAsc((Object)"END_TIME"));
            if ("2".equals(type) || "5".equals(type)) {
                logger.info("\u65e5\u5fd7\u4fe1\u606f\u901a\u8fc7\u63a5\u53e3\u67e5\u8be2\u4fe1\u606f\uff1a============");
                SysAppRecord sysAppRecord = (SysAppRecord)this.sysAppRecordService.getById((Serializable)recordId);
                if ("1".equals(sysAppRecord.getPipelineStatus()) || "4".equals(sysAppRecord.getPipelineStatus())) {
                    List list;
                    List<SysAppRecordLog> pipelineInfo = this.getPipelineInfo(sysAppRecord);
                    if (HussarUtils.isNotEmpty(pipelineInfo) && HussarUtils.isNotEmpty((Object)(list = this.sysAppRecordLogService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppRecordLog::getRecordId, (Object)sysAppRecord.getId())).eq(SysAppRecordLog::getLogInfo, (Object)"\u6d41\u6c34\u7ebf\u6392\u961f")).eq(SysAppRecordLog::getStatus, (Object)"2"))))) {
                        sysAppRecord.setPipelineStatus("1");
                        sysAppRecord.setStatus("1");
                        this.sysAppRecordService.updateById((Object)sysAppRecord);
                        SysAppRecordLog sysAppRecordLineLog = (SysAppRecordLog)list.get(0);
                        sysAppRecordLineLog.setStatus("0");
                        sysAppRecordLineLog.setEndTime(LocalDateTime.now());
                        this.sysAppRecordLogService.updateById((Object)sysAppRecordLineLog);
                    }
                    dataLogList.addAll(pipelineInfo);
                }
            }
        }
        this.orderByStartTimeAEndTime(dataLogList);
        return dataLogList;
    }

    public void orderByStartTimeAEndTime(List<SysAppRecordLog> dataLogList) {
        Comparator<SysAppRecordLog> comparator = new Comparator<SysAppRecordLog>(){

            @Override
            public int compare(SysAppRecordLog log1, SysAppRecordLog log2) {
                int result = log1.getStartTime().compareTo(log2.getStartTime());
                if (result == 0) {
                    if (log1.getEndTime() != null && log2.getEndTime() == null) {
                        return -1;
                    }
                    if (log1.getEndTime() == null && log2.getEndTime() != null) {
                        return 1;
                    }
                    return log1.getStatus().compareTo(log2.getStatus());
                }
                return result;
            }
        };
        Collections.sort(dataLogList, comparator);
    }

    public SysAppRecord getRecordInfoById(Long recordId) {
        SysAppRecord sysAppRecord = (SysAppRecord)this.sysAppRecordService.getById((Serializable)recordId);
        if ("2".equals(sysAppRecord.getPipelineStatus()) || "3".equals(sysAppRecord.getPipelineStatus())) {
            sysAppRecord.setStatus(sysAppRecord.getPipelineStatus());
        }
        return sysAppRecord;
    }

    public Boolean stageInfo(SysAppDevopsDto sysAppDevopsDto) {
        logger.info("devops\u8282\u70b9\u56de\u8c03\u53c2\u6570\uff1asysAppDevopsDto------{}", (Object)(null == sysAppDevopsDto ? "" : sysAppDevopsDto.toString()));
        List list = this.sysAppRecordService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEFINITION_ID", (Object)sysAppDevopsDto.getDefinitionId())).orderByDesc((Object)"CREATE_TIME"));
        if (HussarUtils.isNotEmpty((Object)list)) {
            SysAppRecord sysAppRecord = (SysAppRecord)list.get(0);
            SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
            sysAppRecordLog.setRecordId(sysAppRecord.getId());
            sysAppRecordLog.setLogInfo(sysAppDevopsDto.getStageName());
            sysAppRecordLog.setStatus("200".equals(sysAppDevopsDto.getStatus()) ? "0" : "1");
            sysAppRecordLog.setErrInfo(sysAppDevopsDto.getMsg());
            sysAppRecordLog.setStartTime(sysAppDevopsDto.getStartTime());
            sysAppRecordLog.setEndTime(sysAppDevopsDto.getEndTime());
            this.sysAppRecordLogService.save((Object)sysAppRecordLog);
        }
        return true;
    }

    public Boolean msTest(SysAppDeploy sysAppDeploy, SysAppRecord sysAppRecord, SysAppRecordLog sysAppRecordLog) {
        List sysAppDevopsList = this.sysAppDevopsMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysAppDeploy.getAppId()));
        if (HussarUtils.isEmpty((Object)sysAppDevopsList)) {
            return null;
        }
        String projectId = ((SysAppDevops)sysAppDevopsList.get(0)).getProjectId();
        HashMap param = new HashMap();
        HashMap<String, String> testVariables = new HashMap<String, String>();
        testVariables.put("workspaceName", sysAppDeploy.getWorkspaceName());
        testVariables.put("projectMSName", sysAppDeploy.getProjectMsName());
        testVariables.put("method", sysAppDeploy.getMethod());
        testVariables.put("testPlanName", sysAppDeploy.getTestPlanName());
        testVariables.put("testCaseName", sysAppDeploy.getTestCaseName());
        testVariables.put("mode", sysAppDeploy.getMode());
        testVariables.put("projectId", projectId);
        param.put("testVariables", testVariables);
        String urlDevops = this.devopsUri + "api/integration/ddm/execution/test";
        logger.info("\u5bf9\u63a5devops,MS\u6d4b\u8bd5\u53c2\u6570\uff1aurlDevops:---------->{}\uff0cparam:--------->{}", (Object)urlDevops, param);
        JSONObject json = DevopsUtil.post((String)urlDevops, param);
        logger.info("\u5bf9\u63a5devops,MS\u6d4b\u8bd5\u6d41\u6c34\u7ebf\u8fd4\u56de\u4fe1\u606f:--------->\uff1a{}", (Object)json);
        SysAppRecordLog pipelineUp = null;
        if ("200".equals(json.get((Object)"statusCode").toString())) {
            sysAppRecord.setBuildId(json.get((Object)"buildId").toString());
            sysAppRecord.setDefinitionId(json.get((Object)"definitionId").toString());
            sysAppRecord.setPipelineStatus("1");
            sysAppRecordLog.setStatus(AppRecordLogTypeEnum.RECORD_LOG_MS_PIPEPLINE_CREATE_SUCCESS.getStatus());
            if (HussarUtils.isNotEmpty((Object)json.get((Object)"log").toString())) {
                pipelineUp = new SysAppRecordLog();
                pipelineUp.setRecordId(sysAppRecord.getId());
                pipelineUp.setLogInfo("\u6d41\u6c34\u7ebf\u6392\u961f");
                pipelineUp.setStartTime(LocalDateTime.now());
                pipelineUp.setStatus("2");
                pipelineUp.setType("1");
                sysAppRecord.setPipelineStatus("4");
                sysAppRecord.setStatus("4");
            }
        } else {
            sysAppRecord.setStatus("3");
            sysAppRecord.setPipelineStatus("3");
            sysAppRecordLog.setStatus(AppRecordLogTypeEnum.RECORD_LOG_MS_PIPEPLINE_CREATE_FAILED.getStatus());
            sysAppRecordLog.setErrInfo(json.getString("errorLocalizedMessage"));
        }
        sysAppRecordLog.setEndTime(LocalDateTime.now());
        this.sysAppRecordService.updateById((Object)sysAppRecord);
        this.sysAppRecordLogService.saveOrUpdate((Object)sysAppRecordLog);
        if (HussarUtils.isNotEmpty((Object)pipelineUp)) {
            pipelineUp.setEndTime(LocalDateTime.now());
            this.sysAppRecordLogService.saveOrUpdate((Object)pipelineUp);
        }
        return true;
    }

    public Boolean manualMSTest(SysAppDeploy sysAppDeploy) {
        SysAppRecord sysAppRecord = new SysAppRecord();
        sysAppRecord.setAppId(sysAppDeploy.getAppId());
        sysAppRecord.setRecordType("5");
        if ("3".equals(sysAppDeploy.getDeployType())) {
            sysAppRecord.setPipelineType("\u6d4b\u8bd5\u73af\u5883-\u624b\u52a8\u6d4b\u8bd5");
        } else if ("5".equals(sysAppDeploy.getDeployType())) {
            sysAppRecord.setPipelineType("\u9884\u53d1\u5e03\u73af\u5883-\u624b\u52a8\u6d4b\u8bd5");
        } else if ("4".equals(sysAppDeploy.getDeployType())) {
            sysAppRecord.setPipelineType("\u6b63\u5f0f\u73af\u5883-\u624b\u52a8\u6d4b\u8bd5");
        }
        sysAppRecord.setStatus("1");
        sysAppRecord.setPipelineStatus("1");
        this.sysAppRecordService.save((Object)sysAppRecord);
        SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
        sysAppRecordLog.setRecordId(sysAppRecord.getId());
        sysAppRecordLog.setLogInfo(AppRecordLogTypeEnum.RECORD_LOG_MS_PIPEPLINE_CREATE_DURING.getName());
        sysAppRecordLog.setStartTime(LocalDateTime.now());
        sysAppRecordLog.setStatus(AppRecordLogTypeEnum.RECORD_LOG_MS_PIPEPLINE_CREATE_DURING.getStatus());
        sysAppRecordLog.setType("1");
        this.sysAppRecordLogService.save((Object)sysAppRecordLog);
        SysAppDeploy one = (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)sysAppDeploy.getAppId())).eq(SysAppDeploy::getDeployType, (Object)sysAppDeploy.getDeployType()));
        one.setMethod(sysAppDeploy.getMethod());
        one.setMode(sysAppDeploy.getMode());
        one.setProjectMsName(sysAppDeploy.getProjectMsName());
        one.setTestCaseName(sysAppDeploy.getTestCaseName());
        one.setTestPlanName(sysAppDeploy.getTestPlanName());
        one.setWorkspaceName(sysAppDeploy.getWorkspaceName());
        logger.info("\u624b\u52a8\u8fdb\u884cMS\u6d4b\u8bd5\u53c2\u6570\u4fdd\u5b58\uff1a=========================={}", (Object)one);
        this.sysDeployService.updateById((Object)one);
        return this.msTest(sysAppDeploy, sysAppRecord, sysAppRecordLog);
    }

    public JSONArray queryAppAnalysisByDevPlatform() {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("lcdp", "lcdp"));
        if ("default".equals(this.devPlatformUri)) {
            return null;
        }
        logger.info("\u9996\u9875\u8c03\u7528\u5f00\u53d1\u6846\u67b6\u63a5\u53e3\u53c2\u6570\uff1adevPlatformUri======={}\uff0cparams======{}", (Object)this.devPlatformUri, params);
        JSONObject jsonObject = DevopsUtil.get((String)this.devPlatformUri, params);
        logger.info("\u9996\u9875\u8c03\u7528\u5f00\u53d1\u6846\u67b6\u63a5\u53e3\u83b7\u53d6\u6570\u636e\uff1ajsonObject======={}", (Object)jsonObject);
        if ("200".equals(jsonObject.get((Object)"code").toString())) {
            return JSONArray.parseArray((String)jsonObject.getString("data"));
        }
        return null;
    }

    public IPage<SysAppRecord> pageList(Page<SysAppRecord> pages, SysAppRecord sysAppRecord) {
        return this.sysAppRecordService.pageList(pages, sysAppRecord);
    }

    public Boolean updateStatus(SysAppDevopsDto sysAppDevopsDto) {
        logger.info("devops\u56de\u8c03\u63a5\u53e3\u63a5\u6536\u53c2\u6570\uff1asysAppDevopsDto------{}", (Object)(null == sysAppDevopsDto ? "" : sysAppDevopsDto.toString()));
        String type = sysAppDevopsDto.getType();
        if ("MS".equals(type)) {
            Object list;
            String msResultUrl = sysAppDevopsDto.getMsResultUrl();
            String definitionId = sysAppDevopsDto.getDefinitionId();
            String buildId = sysAppDevopsDto.getBuildId();
            List recordList = this.sysAppRecordService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppRecord::getDefinitionId, (Object)definitionId)).eq(SysAppRecord::getBuildId, (Object)buildId));
            SysAppRecord sysAppRecord = null;
            if (HussarUtils.isEmpty((Object)recordList)) {
                logger.info("MS\u6d4b\u8bd5\u56de\u8c03\uff1a\u672a\u67e5\u8be2\u5230MS\u6d4b\u8bd5\u65e5\u5fd7================");
                return false;
            }
            sysAppRecord = (SysAppRecord)recordList.get(0);
            logger.info("MS\u6d4b\u8bd5\u56de\u8c03\uff1aMS\u6d4b\u8bd5\u65e5\u5fd7\u4fe1\u606f================{}", (Object)sysAppRecord);
            List<SysAppRecordLog> pipelineInfo = this.getPipelineInfo(sysAppRecord);
            if (HussarUtils.isNotEmpty(pipelineInfo) && HussarUtils.isNotEmpty((Object)(list = this.sysAppRecordLogService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppRecordLog::getRecordId, (Object)sysAppRecord.getId())).eq(SysAppRecordLog::getLogInfo, (Object)"\u6d41\u6c34\u7ebf\u6392\u961f")).eq(SysAppRecordLog::getStatus, (Object)"2"))))) {
                ((SysAppRecordLog)list.get(0)).setStatus("0");
                ((SysAppRecordLog)list.get(0)).setEndTime(pipelineInfo.get(0).getStartTime());
                this.sysAppRecordLogService.updateById(list.get(0));
            }
            for (SysAppRecordLog item : pipelineInfo) {
                logger.info("MS\u6d4b\u8bd5\u56de\u8c03\uff1aMS\u6d4b\u8bd5\u65e5\u5fd7\u4fe1\u606flogInfo================{}", (Object)item.getLogInfo());
                if (!"httpRest\u670d\u52a1\u8c03\u7528".equals(item.getLogInfo())) continue;
                item.setStatus("0");
                item.setEndTime(LocalDateTime.now());
                break;
            }
            if ("200".equals(sysAppDevopsDto.getStatus())) {
                logger.info("MS\u6d4b\u8bd5\u56de\u8c03\uff1a\u6d41\u6c34\u7ebf\u6267\u884c\u6210\u529f================");
                sysAppRecord.setPipelineStatus("2");
                sysAppRecord.setStatus("2");
                SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
                sysAppRecordLog.setRecordId(sysAppRecord.getId());
                sysAppRecordLog.setLogInfo(AppRecordLogTypeEnum.RECORD_LOG_MS_PIPEPLINE_RESULT_SUCCESS.getName());
                sysAppRecordLog.setStartTime(LocalDateTime.now());
                if ("\u6210\u529f".equals(sysAppDevopsDto.getResultCode())) {
                    sysAppRecord.setStatus("2");
                    sysAppRecordLog.setStatus(AppRecordLogTypeEnum.RECORD_LOG_MS_PIPEPLINE_RESULT_SUCCESS.getStatus());
                    sysAppRecordLog.setType("1");
                    String pipelineType = sysAppRecord.getPipelineType();
                    logger.info("MS\u6d4b\u8bd5\u56de\u8c03\uff1a\u65e5\u5fd7\u7c7b\u578bpipelineType================{}", (Object)pipelineType);
                    String env = MSTestTypeNum.getValueByLabel((String)pipelineType);
                    logger.info("MS\u6d4b\u8bd5\u56de\u8c03\uff1a\u73af\u5883\u7c7b\u578benv================{}", (Object)env);
                    String deployType = "";
                    if ("TEST".equals(env)) {
                        deployType = "3";
                    } else if ("PRE".equals(env)) {
                        deployType = "5";
                    } else if ("PROD".equals(env)) {
                        deployType = "4";
                    } else {
                        logger.info("MS\u6d4b\u8bd5\u56de\u8c03\uff1a\u672a\u67e5\u8be2\u5230\u90e8\u7f72\u7c7b\u578b================");
                        return false;
                    }
                    SysAppDeploy sysAppDeploy = (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)sysAppRecord.getAppId())).eq(SysAppDeploy::getDeployType, (Object)deployType)).eq(SysAppDeploy::getDelFlag, (Object)"0"));
                    sysAppDeploy.setMsResultUrl(msResultUrl);
                    this.sysDeployService.updateById((Object)sysAppDeploy);
                } else {
                    logger.info("MS\u6d4b\u8bd5\u7ed3\u679c\u5931\u8d25================,{}", (Object)sysAppDevopsDto.getResultCode());
                    sysAppRecordLog.setStatus(AppRecordLogTypeEnum.RECORD_LOG_MS_PIPEPLINE_RESULT_FAILED.getStatus());
                    sysAppRecordLog.setErrInfo(sysAppDevopsDto.getMsg());
                }
                sysAppRecordLog.setEndTime(LocalDateTime.now());
                pipelineInfo.add(sysAppRecordLog);
            } else {
                sysAppRecord.setStatus("3");
                sysAppRecord.setPipelineStatus("3");
            }
            this.sysAppRecordLogService.saveBatch(pipelineInfo);
            this.sysAppRecordService.updateById((Object)sysAppRecord);
        } else {
            SysApplication appInfo;
            String env = sysAppDevopsDto.getEnv();
            SysAppDevops sysAppDevops = null;
            SysAppDeploy sysAppDeploy = null;
            sysAppDevops = "DEV".equals(env) && !"dev".equals(sysAppDevopsDto.getBranch()) ? (SysAppDevops)this.sysAppDevopsMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID", (Object)sysAppDevopsDto.getProjectId())).eq((Object)"BRANCH", (Object)sysAppDevopsDto.getBranch())) : (SysAppDevops)this.sysAppDevopsMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID", (Object)sysAppDevopsDto.getProjectId())).isNotNull((Object)"TEST_DEFINITION_ID")).ne((Object)"TEST_DEFINITION_ID", (Object)""));
            if (null != sysAppDevops && (appInfo = (SysApplication)this.sysApplicationService.getById((Serializable)sysAppDevops.getAppId())).getAppType().contains("4") && !env.equals("DEV")) {
                String deployType = "";
                if ("DEV".equals(env)) {
                    deployType = "dev".equals(sysAppDevopsDto.getBranch()) ? "1" : "2";
                } else if ("TEST".equals(env)) {
                    deployType = "3";
                } else if ("PROD".equals(env)) {
                    deployType = "4";
                } else if ("PRE".equals(env)) {
                    deployType = "5";
                }
                sysAppDeploy = (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)sysAppDevops.getAppId())).eq(SysAppDeploy::getDeployType, (Object)deployType)).eq(SysAppDeploy::getDelFlag, (Object)"0"));
                if (null != sysAppDeploy) {
                    sysAppDeploy.setArtifactUrl(sysAppDevopsDto.getArtifactUrl());
                    this.sysDeployService.updateById((Object)sysAppDeploy);
                }
            }
            if (null != sysAppDevops) {
                List list;
                String definitionId = "";
                if ("DEV".equals(env)) {
                    definitionId = sysAppDevops.getDevDefinitionId();
                } else if ("TEST".equals(env)) {
                    definitionId = sysAppDevops.getTestDefinitionId();
                } else if ("PROD".equals(env)) {
                    definitionId = sysAppDevops.getProdDefinitionId();
                } else if ("PRE".equals(env)) {
                    definitionId = sysAppDevops.getPreDefinitionId();
                }
                List recordlist = this.sysAppRecordService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEFINITION_ID", (Object)definitionId)).eq((Object)"BUILD_ID", (Object)sysAppDevopsDto.getBuildId()));
                List recordLogList = this.sysAppRecordLogService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RECORD_ID", (Object)((SysAppRecord)recordlist.get(0)).getId())).orderByDesc((Object)"CREATE_TIME"));
                List<SysAppRecordLog> pipelineInfo = this.getPipelineInfo((SysAppRecord)recordlist.get(0));
                if (HussarUtils.isNotEmpty(pipelineInfo) && HussarUtils.isNotEmpty((Object)(list = this.sysAppRecordLogService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppRecordLog::getRecordId, (Object)((SysAppRecord)recordlist.get(0)).getId())).eq(SysAppRecordLog::getLogInfo, (Object)"\u6d41\u6c34\u7ebf\u6392\u961f")).eq(SysAppRecordLog::getStatus, (Object)"2"))))) {
                    ((SysAppRecordLog)list.get(0)).setEndTime(pipelineInfo.get(0).getStartTime());
                    ((SysAppRecordLog)list.get(0)).setStatus("0");
                    this.sysAppRecordLogService.updateById(list.get(0));
                }
                SysAppRecord sysAppRecord = (SysAppRecord)recordlist.get(0);
                if ("200".equals(sysAppDevopsDto.getStatus())) {
                    sysAppRecord.setStatus("1");
                    sysAppRecord.setPipelineStatus("2");
                    SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
                    sysAppRecordLog.setRecordId(((SysAppRecord)recordlist.get(0)).getId());
                    sysAppRecordLog.setLogInfo("\u5e94\u7528\u90e8\u7f72");
                    sysAppRecordLog.setStartTime(LocalDateTime.now());
                    sysAppRecordLog.setStatus("2");
                    sysAppRecordLog.setErrInfo(sysAppDevopsDto.getMsg());
                    sysAppRecordLog.setType("1");
                    pipelineInfo.add(sysAppRecordLog);
                } else {
                    logger.info("\u5e94\u7528\u90e8\u7f72\u56de\u8c03\u5904\u7406\u90e8\u7f72\u9519\u8bef\uff1a================");
                    for (SysAppRecordLog item : pipelineInfo) {
                        if (!"\u53d1\u5e03\u5b9a\u4e49\u542f\u52a8".equals(item.getLogInfo()) || !"0".equals(item.getStatus())) continue;
                        SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
                        sysAppRecordLog.setRecordId(((SysAppRecord)recordlist.get(0)).getId());
                        sysAppRecordLog.setLogInfo("\u5e94\u7528\u90e8\u7f72");
                        sysAppRecordLog.setStartTime(LocalDateTime.now());
                        sysAppRecordLog.setStatus("1");
                        sysAppRecordLog.setErrInfo(sysAppDevopsDto.getMsg());
                        sysAppRecordLog.setType("1");
                        sysAppRecordLog.setEndTime(LocalDateTime.now());
                        pipelineInfo.add(sysAppRecordLog);
                        break;
                    }
                    sysAppRecord.setPipelineStatus("3");
                    sysAppRecord.setStatus("3");
                }
                this.sysAppRecordLogService.saveBatch(pipelineInfo);
                this.sysAppRecordService.updateById((Object)sysAppRecord);
            }
        }
        return true;
    }

    public JSONObject createProject(SysApplication sysApplication, String projectLeaderAccount) {
        SysAppRecord createProjectRecord = new SysAppRecord();
        createProjectRecord.setAppId(sysApplication.getId());
        createProjectRecord.setRecordType("1");
        createProjectRecord.setPipelineType("\u5e94\u7528\u521b\u5efa");
        createProjectRecord.setStatus("1");
        this.sysAppRecordMapper.insert(createProjectRecord);
        SysAppRecordLog createProjectRecordLog = new SysAppRecordLog();
        createProjectRecordLog.setRecordId(createProjectRecord.getId());
        createProjectRecordLog.setLogInfo("\u9879\u76ee\u6784\u5efa");
        createProjectRecordLog.setStatus("2");
        createProjectRecordLog.setType("1");
        createProjectRecordLog.setStartTime(LocalDateTime.now());
        this.sysAppRecordLogMapper.insert(createProjectRecordLog);
        HashMap dataMap = new HashMap();
        HashMap<String, String> project = new HashMap<String, String>();
        project.put("projectCode", sysApplication.getAppCode());
        project.put("projectName", sysApplication.getAppName());
        JSONObject extendObj = new JSONObject();
        extendObj.put("work-order", null);
        extendObj.put("\u9879\u76ee\u7ecf\u7406", (Object)projectLeaderAccount);
        project.put("extend", JSONObject.toJSONString((Object)extendObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        dataMap.put("project", project);
        String urlDevops = this.devopsUri + "api/integration/ddm/create/project";
        logger.info("\u5bf9\u63a5devops\u521b\u5efa\u9879\u76ee\u63a5\u53e3\u53c2\u6570\uff1aurl\uff1a-------> {};param:----------->{}", (Object)urlDevops, dataMap);
        JSONObject json = DevopsUtil.post((String)urlDevops, dataMap);
        logger.info("\u5bf9\u63a5devops\u521b\u5efa\u9879\u76ee\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1ajson:-->{},", (Object)json);
        createProjectRecord.setStatus("2");
        this.sysAppRecordMapper.updateById(createProjectRecord);
        return json;
    }
}

