/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.base.portal.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppTemplate;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppTemplateService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6a21\u677f"})
@RestController(value="com.jxdinfo.hussar.base.portal.group.controller.SysAppTemplateController")
@RequestMapping(value={"/hussarBase/application/template"})
public class SysAppTemplateController {
    @Resource
    private ISysAppTemplateService sysAppTemplateService;

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u6a21\u677f", notes="\u83b7\u53d6\u5168\u90e8\u6a21\u677f")
    public ApiResponse<List<SysAppTemplate>> getTemplateList() {
        return ApiResponse.success((Object)this.sysAppTemplateService.list((Wrapper)new QueryWrapper().eq((Object)"DEL_FLAG", (Object)"0")));
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u6a21\u677f", notes="\u65b0\u589e\u6a21\u677f")
    public ApiResponse<Boolean> addTemplate(@ApiParam(value="\u6a21\u677f\u5b9e\u4f53") @RequestBody SysAppTemplate sysAppTemplate) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TEMPLATE_NAME", (Object)sysAppTemplate.getTemplateName())).eq((Object)"DEL_FLAG", (Object)"0");
        if (this.sysAppTemplateService.count(queryWrapper) > 0L) {
            return ApiResponse.success((int)10001, (String)"\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728");
        }
        return ApiResponse.success((Object)this.sysAppTemplateService.save((Object)sysAppTemplate));
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u4fee\u6539\u6a21\u677f", notes="\u4fee\u6539\u6a21\u677f")
    public ApiResponse<Boolean> updateTemplate(@ApiParam(value="\u6a21\u677f\u5b9e\u4f53") @RequestBody SysAppTemplate sysAppTemplate) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TEMPLATE_NAME", (Object)sysAppTemplate.getTemplateName())).ne((Object)"TEMPLATE_ID", (Object)sysAppTemplate.getId())).eq((Object)"DEL_FLAG", (Object)"0");
        if (this.sysAppTemplateService.count(queryWrapper) > 0L) {
            return ApiResponse.fail((String)"\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728");
        }
        return ApiResponse.success((Object)this.sysAppTemplateService.updateById((Object)sysAppTemplate));
    }

    @PostMapping(value={"/delete"})
    @CheckPermission(value={"hussarBase:application:template:delete"})
    @ApiOperation(value="\u5220\u9664\u6a21\u677f", notes="\u5220\u9664\u6a21\u677f")
    public ApiResponse<Boolean> deleteTemplate(@ApiParam(value="\u6a21\u677fid") @RequestParam Long id) {
        return ApiResponse.success((Object)this.sysAppTemplateService.removeById((Serializable)id));
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u6839\u636e\u6a21\u677fID\u83b7\u53d6\u8be6\u60c5", notes="\u6839\u636e\u6a21\u677fID\u83b7\u53d6\u8be6\u60c5")
    public ApiResponse<SysAppTemplate> getTemplateDetail(@ApiParam(value="\u6a21\u677fId") @RequestParam Long id) {
        return ApiResponse.success((Object)this.sysAppTemplateService.getById((Serializable)id));
    }

    @PostMapping(value={"/pageList"})
    @CheckPermission(value={"hussarBase:application:template:pageList"})
    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f\u5217\u8868", notes="\u83b7\u53d6\u6a21\u677f\u5217\u8868")
    public ApiResponse<Page<SysAppTemplate>> getPageList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @RequestBody JSONObject jsonObject) {
        Page page = (Page)jsonObject.toJavaObject(Page.class);
        SysAppTemplate sysAppTemplate = (SysAppTemplate)jsonObject.toJavaObject(SysAppTemplate.class);
        AbstractWrapper queryWrapper = ((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEL_FLAG", (Object)"0")).like(!HussarUtils.isEmpty((Object)sysAppTemplate.getTemplateName()), (Object)"TEMPLATE_NAME", (Object)sysAppTemplate.getTemplateName())).like(!HussarUtils.isEmpty((Object)sysAppTemplate.getTemplateDesc()), (Object)"TEMPLATE_DESC", (Object)sysAppTemplate.getTemplateDesc());
        return ApiResponse.success((Object)this.sysAppTemplateService.page((IPage)page, (Wrapper)queryWrapper));
    }

    @PostMapping(value={"/import"})
    @CheckPermission(value={"hussarBase:application:template:import"})
    @ApiOperation(value="\u5bfc\u5165\u6a21\u677f", notes="\u5bfc\u5165\u6a21\u677f")
    public ApiResponse<Long> importTemplate(@ApiParam(value="\u6a21\u677f\u538b\u7f29\u5305") @RequestParam(value="file") MultipartFile file, @ApiParam(value="\u6a21\u677f\u4fe1\u606f") @Validated @RequestPart SysAppTemplate sysAppTemplate) throws IOException {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TEMPLATE_NAME", (Object)sysAppTemplate.getTemplateName())).eq((Object)"DEL_FLAG", (Object)"0");
        if (this.sysAppTemplateService.count(queryWrapper) > 0L) {
            return ApiResponse.fail((String)"\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728");
        }
        return ApiResponse.success((Object)this.sysAppTemplateService.importTemplate(file, sysAppTemplate));
    }

    @GetMapping(value={"/getImportStatus"})
    @ApiOperation(value="\u5bfc\u5165\u6a21\u677f", notes="\u5bfc\u5165\u6a21\u677f")
    public ApiResponse<Long> getImportStatus(Long time) {
        return ApiResponse.success((String)this.sysAppTemplateService.getImportStatus(time));
    }

    @GetMapping(value={"/download"})
    @CheckPermission(value={"hussarBase:application:template:download"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f", notes="\u4e0b\u8f7d\u6a21\u677f")
    public void download(Long id, HttpServletResponse response) {
        this.sysAppTemplateService.downloadTemplate(id, response);
    }

    @GetMapping(value={"/checkName"})
    @ApiOperation(value="\u68c0\u9a8c\u540d\u79f0\u662f\u5426\u91cd\u590d", notes="\u68c0\u9a8c\u540d\u79f0\u662f\u5426\u91cd\u590d")
    public ApiResponse<Boolean> checkName(@ApiParam(value="\u6a21\u677f\u540d\u79f0") @RequestParam String name) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TEMPLATE_NAME", (Object)name)).eq((Object)"DEL_FLAG", (Object)"0");
        return ApiResponse.success((Object)(this.sysAppTemplateService.count(queryWrapper) > 0L ? 1 : 0));
    }

    @PostMapping(value={"/addApplication"})
    @CheckPermission(value={"hussarBase:application:template:addApplication"})
    @ApiOperation(value="\u4ece\u6a21\u677f\u521b\u5efa\u5e94\u7528", notes="\u4ece\u6a21\u677f\u521b\u5efa\u5e94\u7528")
    public ApiResponse<Long> addApp(@ApiParam(value="\u5e94\u7528\u5b9e\u4f53") @RequestBody SysApplicationDto sysApplicationDto) {
        try {
            return ApiResponse.success((Object)this.sysAppTemplateService.addApp(sysApplicationDto));
        }
        catch (BaseException e) {
            return ApiResponse.success((String)"false");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

