/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.gitlabServer.service.impl;

import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.constant.AppConstants;
import com.jxdinfo.hussar.base.portal.gitlabServer.dto.GitServerDto;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.DevCloudUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.gitlabServer.service.impl.GitlabServiceImpl")
public class GitlabServiceImpl
implements IGitlabService {
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    private String gitUri;
    private String gitGroup;
    private String templateLocalPath;
    private String workSpacePath;
    @Resource
    private ISysUsersService sysUsersService;

    @PostConstruct
    public void init() {
        this.gitUri = this.gitlabConfigProperty.getGitUri();
        this.gitGroup = this.gitlabConfigProperty.getGitGroup();
        this.templateLocalPath = this.gitlabConfigProperty.getLocalPath() + this.gitlabConfigProperty.getBackPath() + "temp";
        this.workSpacePath = this.gitlabConfigProperty.getLocalPath();
    }

    public String pull2local(GitServerDto gitServerDto) {
        String branch = gitServerDto.getBranch();
        String accessToken = gitServerDto.getToken();
        DevCloudUtil.pull((String)(this.gitUri + this.gitGroup + gitServerDto.getAppCode()), (String)this.workSpacePath, (String)branch, (String)accessToken);
        return "\u66f4\u65b0\u6210\u529f";
    }

    public String push2remote(GitServerDto gitServerDto) {
        String branch = gitServerDto.getBranch();
        String accessToken = gitServerDto.getToken();
        if ("dev".equals(gitServerDto.getBranch()) && "1".equals(gitServerDto.getPersonalBrance())) {
            String id = DevCloudUtil.getProjectIdByGroupIdAndName((String)this.gitUri, (String)gitServerDto.getAppCode(), (String)accessToken, (String)this.gitGroup);
            DevCloudUtil.unProtectBranch((String)this.gitUri, (String)id, (String)"dev", (String)accessToken);
            DevCloudUtil.pushForce((String)(this.gitUri + this.gitGroup + gitServerDto.getAppCode()), (String)this.workSpacePath, (String)"\u7ebf\u4e0a\u5f00\u53d1\u5f3a\u5236\u63d0\u4ea4", (String)branch, (String)accessToken);
            DevCloudUtil.setProtectBranch((String)this.gitUri, (String)id, (String)"dev", (String)accessToken);
        } else {
            DevCloudUtil.pushForce((String)(this.gitUri + this.gitGroup + gitServerDto.getAppCode()), (String)this.workSpacePath, (String)"\u7ebf\u4e0a\u5f00\u53d1\u5f3a\u5236\u63d0\u4ea4", (String)branch, (String)accessToken);
        }
        return "\u63d0\u4ea4\u6210\u529f";
    }

    public Boolean createProject(String appCode, String appDescribe, String commitMsg, String accessToken, Long currentTime) {
        Boolean flag = true;
        File localDir = null;
        localDir = new File(this.templateLocalPath + File.separator + currentTime + File.separator + appCode);
        try {
            DevCloudUtil.createProject((File)localDir, (String)(this.gitUri + this.gitGroup), (String)appCode, (String)commitMsg, (String)accessToken);
            DevCloudUtil.pushQddt((File)localDir, (String)(this.gitUri + this.gitGroup), (String)appCode, (String)commitMsg, (String)accessToken);
            DevCloudUtil.createDevBranch((File)localDir, (String)appCode, (String)accessToken);
            String id = DevCloudUtil.getProjectIdByGroupIdAndName((String)this.gitUri, (String)appCode, (String)accessToken, (String)this.gitGroup);
            DevCloudUtil.setProtectBranch((String)this.gitUri, (String)id, (String)"dev", (String)accessToken);
            DevCloudUtil.editProjectDescribe((String)this.gitUri, (String)id, (String)accessToken, (String)appDescribe);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
        return flag;
    }

    public void editProjectDescribe(String appDescribe, String accessToken, String appCode) {
        String id = DevCloudUtil.getProjectIdByGroupIdAndName((String)this.gitUri, (String)appCode, (String)accessToken, (String)this.gitGroup);
        DevCloudUtil.editProjectDescribe((String)this.gitUri, (String)id, (String)accessToken, (String)appDescribe);
    }

    public void pushToDevForObtainChanges(String branchName, String personalBrance, String appCode, String pushObtainChangeMsg, String accessToken, Long time) {
        File localDir = null;
        localDir = new File(this.templateLocalPath + File.separator + time + File.separator + appCode);
        if (HussarUtils.isEmpty((Object)pushObtainChangeMsg)) {
            pushObtainChangeMsg = "\u9ed8\u8ba4\u63a8\u9001\u6d88\u606f";
        }
        try {
            String id = DevCloudUtil.getProjectIdByGroupIdAndName((String)this.gitUri, (String)appCode, (String)accessToken, (String)this.gitGroup);
            DevCloudUtil.unProtectBranch((String)this.gitUri, (String)id, (String)"dev", (String)accessToken);
            DevCloudUtil.pushToDev((File)localDir, (String)(this.gitUri + this.gitGroup), (String)appCode, (String)pushObtainChangeMsg, (String)accessToken);
            if ("1".equals(personalBrance)) {
                DevCloudUtil.setProtectBranch((String)this.gitUri, (String)id, (String)"dev", (String)accessToken);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
    }

    public void editMemberLevelFProject(String token, String appCode, String userAccount, String level) {
        try {
            String userId = DevCloudUtil.getUserId((String)userAccount, (String)this.gitUri);
            String prijectId = DevCloudUtil.getProjectIdByGroupIdAndName((String)this.gitUri, (String)appCode, (String)token, (String)this.gitGroup);
            DevCloudUtil.editMemberLevelFProject((String)prijectId, (String)userId, (String)this.gitUri, (String)token, (String)level);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void removeAllUserFProject(String token, String appCode) {
        String projectId = DevCloudUtil.getProjectIdByGroupIdAndName((String)this.gitUri, (String)appCode, (String)token, (String)this.gitGroup);
        List membersIdList = DevCloudUtil.getAllMembersIdListFProject((String)this.gitUri, (String)token, (String)projectId);
        if (HussarUtils.isNotEmpty((Object)membersIdList)) {
            for (String memberId : membersIdList) {
                DevCloudUtil.removeMemberFProjectById((String)this.gitUri, (String)token, (String)projectId, (String)memberId);
            }
        }
    }

    public void deleteGitProject(String appCode, String token) {
        String projectId = DevCloudUtil.getProjectIdByGroupNameAndProjectName((String)this.gitUri, (String)appCode, (String)token, (String)this.gitGroup);
        if (HussarUtils.isNotEmpty((Object)projectId)) {
            DevCloudUtil.deleteGitProject((String)this.gitUri, (String)projectId, (String)token);
        }
    }

    public void pushToDev(String branchName, String appCreateType, String appCode, String commitMsg, String accessToken, Long time) {
        File localDir = null;
        localDir = new File(this.templateLocalPath + File.separator + time + File.separator + appCode);
        if (HussarUtils.isEmpty((Object)commitMsg)) {
            commitMsg = "\u9ed8\u8ba4\u63a8\u9001\u6d88\u606f";
        }
        try {
            String id = DevCloudUtil.getProjectIdByGroupIdAndName((String)this.gitUri, (String)appCode, (String)accessToken, (String)this.gitGroup);
            if ("1".equals(appCreateType) || "dev".equals(branchName)) {
                DevCloudUtil.unProtectBranch((String)this.gitUri, (String)id, (String)"dev", (String)accessToken);
                DevCloudUtil.pushToDev((File)localDir, (String)(this.gitUri + this.gitGroup), (String)appCode, (String)commitMsg, (String)accessToken);
                DevCloudUtil.setProtectBranch((String)this.gitUri, (String)id, (String)"dev", (String)accessToken);
            } else {
                DevCloudUtil.unProtectBranch((String)this.gitUri, (String)id, (String)"master", (String)accessToken);
                DevCloudUtil.push((String)(this.gitUri + this.gitGroup + appCode), (String)(this.templateLocalPath + File.separator + time + File.separator + appCode), (String)commitMsg, (String)"master", (String)accessToken);
                DevCloudUtil.setProtectBranch((String)this.gitUri, (String)id, (String)"master", (String)accessToken);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
    }

    public void createDevByUser(String appCreateType, String appCode, String commitMsg, String gitlabBranch, String accessToken, Long time) {
        File localDir = null;
        localDir = new File(this.templateLocalPath + File.separator + time + File.separator + appCode);
        try {
            DevCloudUtil.createDevByUser((String)appCode, (String)(this.gitUri + this.gitGroup), (File)localDir, (String)gitlabBranch, (String)accessToken);
            DevCloudUtil.pushToDevByUser((String)appCode, (String)(this.gitUri + this.gitGroup), (File)localDir, (String)gitlabBranch, (String)accessToken, (String)commitMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
    }

    public void pushToGit(String localPath, String appCode, String commitMsg, String gitlabBranch, String accessToken) {
        try {
            DevCloudUtil.push((String)(this.gitUri + this.gitGroup + appCode), (String)localPath, (String)commitMsg, (String)gitlabBranch, (String)accessToken);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
    }

    public Boolean createUser(String userName, String name, String email) {
        try {
            return DevCloudUtil.createUser((String)this.gitUri, (String)this.sysUsersService.getUser(AppConstants.SUPER_ADMIN_ID).getChar1(), (String)userName, (String)name, (String)email, (String)this.gitlabConfigProperty.getDefaultPassword(), (String)"30");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
    }

    public void createDir(String appCode, Long currentTime) {
        File folder = new File(this.templateLocalPath + File.separator + currentTime + File.separator + appCode);
        if (!folder.exists() && !folder.isDirectory()) {
            folder.setWritable(true, false);
            folder.mkdirs();
            System.out.println("\u521b\u5efa\u6587\u4ef6\u5939");
        } else {
            System.out.println("\u6587\u4ef6\u5939\u5df2\u5b58\u5728");
        }
    }

    public void inviteUserJoinGroupOrProject(String userAccount, String privateToken, String type, String typeName, boolean projectLeader) {
        SysUsers sysUsers;
        String accessLevel = "30";
        if ("groups".equals(type)) {
            typeName = this.gitGroup.substring(0, this.gitGroup.length() - 1);
            accessLevel = "40";
        }
        if (projectLeader) {
            accessLevel = "40";
        }
        if (HussarUtils.isEmpty((Object)DevCloudUtil.getUserId((String)(sysUsers = this.sysUsersService.getUserByUserAccount(userAccount)).getUserAccount(), (String)this.gitUri))) {
            if (HussarUtils.isEmpty((Object)sysUsers.geteMail())) {
                throw new BaseException(sysUsers.getUserName() + "\u90ae\u7bb1\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efa\u7528\u6237");
            }
            DevCloudUtil.createUser((String)this.gitUri, (String)this.sysUsersService.getUser(AppConstants.SUPER_ADMIN_ID).getChar1(), (String)userAccount, (String)sysUsers.getUserName(), (String)sysUsers.geteMail(), (String)this.gitlabConfigProperty.getDefaultPassword(), (String)accessLevel);
        }
        DevCloudUtil.inviteUserJoinGroupOrProject((String)userAccount, (String)typeName, (String)this.gitUri, (String)privateToken, (String)type, (String)this.gitGroup, (String)accessLevel);
    }

    public void deleteUserFGroupOrProject(String userAccount, String privateToken, String type, String typeName) {
        if ("groups".equals(type)) {
            typeName = this.gitGroup.substring(0, this.gitGroup.length() - 1);
        }
        DevCloudUtil.deleteUserFGroupOrProject((String)userAccount, (String)typeName, (String)this.gitUri, (String)privateToken, (String)type, (String)this.gitGroup);
    }

    public void unProtectBranch(String appCode, String token) {
        String id = DevCloudUtil.getProjectIdByGroupIdAndName((String)this.gitUri, (String)appCode, (String)token, (String)this.gitGroup);
        DevCloudUtil.unProtectBranch((String)this.gitUri, (String)id, (String)"dev", (String)token);
    }

    public void setProtectBranch(String appCode, String token) {
        String id = DevCloudUtil.getProjectIdByGroupIdAndName((String)this.gitUri, (String)appCode, (String)token, (String)this.gitGroup);
        DevCloudUtil.setProtectBranch((String)this.gitUri, (String)id, (String)"dev", (String)token);
    }

    public void pullToLocal(String appCode, String localPath, String token, String brance) {
        try {
            DevCloudUtil.pull((String)(this.gitUri + this.gitGroup + appCode), (String)localPath, (String)brance, (String)token);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
    }

    public void pullToLocalByBranch(String appCode, String localPath, String branch, String token) {
        try {
            DevCloudUtil.pull((String)(this.gitUri + this.gitGroup + appCode), (String)localPath, (String)branch, (String)token);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException((Throwable)e);
        }
    }

    public void createBranch(String appCode, String branchName, String token) {
        String id = DevCloudUtil.getProjectIdByGroupIdAndName((String)this.gitUri, (String)appCode, (String)token, (String)this.gitGroup);
        DevCloudUtil.createBranch((String)this.gitUri, (String)id, (String)branchName, (String)"dev", (String)token);
    }

    public List<String> getAllBranch(String appCode, String token) {
        String id = DevCloudUtil.getProjectIdByGroupIdAndName((String)this.gitUri, (String)appCode, (String)token, (String)this.gitGroup);
        return DevCloudUtil.getAllBranch((String)this.gitUri, (String)id, (String)token);
    }

    public String getBranch(String localPath, String accessToken, String branch) {
        return DevCloudUtil.getBranch((String)localPath, (String)accessToken, (String)branch);
    }
}

