/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.websocket.service;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/api/appManageWebsocket/{sid}")
public class AppManageWebSocketServer {
    private static final Logger logger = LoggerFactory.getLogger(AppManageWebSocketServer.class);
    private static ISysApplicationService sysApplicationService = (ISysApplicationService)SpringContextHolder.getApplicationContext().getBean(ISysApplicationService.class);
    private static int onlineCount = 0;
    private static CopyOnWriteArraySet<AppManageWebSocketServer> webSocketSet = new CopyOnWriteArraySet();
    private Session session;
    private String sid = "";

    @OnOpen
    public void onOpen(Session session, @PathParam(value="sid") String sid) {
        this.session = session;
        webSocketSet.add(this);
        this.sid = sid;
        AppManageWebSocketServer.addOnlineCount();
        logger.info("\u5e94\u7528\u7ba1\u7406\u9875\u9762\u6709\u65b0\u7a97\u53e3\u5f00\u59cb\u76d1\u542c:" + sid + ",\u5f53\u524d\u5728\u7ebf\u4eba\u6570\u4e3a:" + AppManageWebSocketServer.getOnlineCount());
    }

    @OnClose
    public void onClose() {
        webSocketSet.remove(this);
        AppManageWebSocketServer.subOnlineCount();
        logger.info("close\u91ca\u653e\u7684sid\u4e3a\uff1a" + this.sid);
        logger.info("close\u6709\u4e00\u8fde\u63a5\u5173\u95ed\uff01\u5f53\u524d\u5728\u7ebf\u4eba\u6570\u4e3a" + AppManageWebSocketServer.getOnlineCount());
    }

    @OnMessage
    public void onMessage(String dataJsonString, Session session) {
        JSONObject jsonObject = JSONObject.parseObject((String)dataJsonString);
        String userId = jsonObject.getString("userId");
        String type = jsonObject.getString("type");
        logger.info("onMessage\u6536\u5230\u6765\u81ea\u7a97\u53e3" + userId + "\u7684\u4fe1\u606f:userId===={},type======{}", (Object)userId, (Object)type);
    }

    @OnError
    public void onError(Session session, Throwable error) {
        logger.error("onError\u53d1\u751f\u9519\u8bef");
        error.printStackTrace();
    }

    public void sendMessage(String data) {
        try {
            if (null != data) {
                ObjectMapper objectMapper = new ObjectMapper();
                String jsonData = objectMapper.writeValueAsString((Object)data);
                this.session.getBasicRemote().sendText(jsonData);
            }
        }
        catch (Exception e) {
            logger.info("\u670d\u52a1\u5668\u4e3b\u52a8\u63a8\u52a8\u5ba2\u6237\u7aef\u6d88\u606f\u5f02\u5e38\uff1a========={}", (Object)e.getMessage());
        }
    }

    public static void sendInfo(Map data, @PathParam(value="sid") String sid) {
        logger.info("\u63a8\u9001\u6d88\u606f\u5230\u7a97\u53e3" + sid + "\uff0c\u63a8\u9001\u5185\u5bb9:" + data.toString());
        for (AppManageWebSocketServer item : webSocketSet) {
            if (sid == null || !item.sid.equals(sid)) continue;
            item.sendMessage(null);
        }
    }

    public static void createAppFail(Long appCreateUserId) {
        if (sysApplicationService.isAppWebSocketFlag().booleanValue()) {
            for (AppManageWebSocketServer item : webSocketSet) {
                if (!item.sid.equals(appCreateUserId.toString())) continue;
                item.sendMessage("\u5e94\u7528\u521b\u5efa\u5931\u8d25\u8c03\u7528wensocket\uff1a....");
            }
        }
    }

    public static synchronized int getOnlineCount() {
        return onlineCount;
    }

    public static synchronized void addOnlineCount() {
        ++onlineCount;
    }

    public static synchronized void subOnlineCount() {
        --onlineCount;
    }

    public static CopyOnWriteArraySet<AppManageWebSocketServer> getWebSocketSet() {
        return webSocketSet;
    }
}

