/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.dao.SysAuthManageMapper;
import com.jxdinfo.hussar.base.portal.application.model.SysAuthManage;
import com.jxdinfo.hussar.base.portal.application.service.ISysAuthManageService;
import com.jxdinfo.hussar.base.portal.license.config.LicenseClientProperties;
import com.jxdinfo.hussar.rest.client.ApiClient;
import com.jxdinfo.hussar.rest.model.RequestBody;
import com.jxdinfo.hussar.rest.token.TokenUtil;
import com.jxdinfo.hussar.rest.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAuthManageServiceImpl")
public class SysAuthManageServiceImpl
implements ISysAuthManageService {
    private static final Logger logger = LoggerFactory.getLogger(SysAuthManageServiceImpl.class);
    @Autowired
    private LicenseClientProperties licenseClientProperties;
    @Resource
    ISysUsersService sysUsersService;
    @Resource
    private SysAuthManageMapper sysAuthManageMapper;

    public void downloadAuthFile(Long id, HttpServletResponse response) throws IOException {
        SysAuthManage sysAppAuthManage = this.sysAuthManageMapper.getAuthManageInfoById(id);
        String licenseId = sysAppAuthManage.getAuthType();
        RequestBody body = new RequestBody();
        if ("1".equals(licenseId)) {
            body.setIsDev(Boolean.valueOf(true));
            body.setType("V8-dev");
            body.setCode(sysAppAuthManage.getAuthCode());
            body.setName(this.sysUsersService.getUser(sysAppAuthManage.getUserId()).getUserName());
            body.setStartDate(sysAppAuthManage.getAuthCreateTime());
            body.setEndDate(sysAppAuthManage.getAuthEndTime());
        }
        if ("2".equals(licenseId)) {
            body.setType("V8");
            body.setCode(sysAppAuthManage.getAuthCode());
            body.setName(this.sysUsersService.getUser(sysAppAuthManage.getUserId()).getUserName());
            body.setStartDate(sysAppAuthManage.getAuthCreateTime());
            body.setEndDate(sysAppAuthManage.getAuthEndTime());
        }
        if ("3".equals(licenseId)) {
            body.setIsBatch(Boolean.valueOf(true));
            body.setType("V8-vol");
            body.setCode("Y8UN2BCE47-CFAELT4DE5-2DGNXMLV4D-NZEJRYAEVN");
            body.setName("\u6d4b\u8bd5-H");
            body.setStartDate("2022-07-03");
            body.setEndDate("2022-08-09");
            body.setQuantity(Integer.valueOf(100));
        }
        JSONObject exJsonObject = new JSONObject();
        exJsonObject.put("remarks", (Object)"\u6388\u6743\u5907\u6ce8\u4fe1\u606f");
        body.setExtendJson(exJsonObject.toJSONString());
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)body);
        ApiClient client = new ApiClient();
        String token = TokenUtil.getAccessToken((String)this.licenseClientProperties.getLicenseServerIp(), (String)this.licenseClientProperties.getLicenseServerPort(), (String)this.licenseClientProperties.getLicenseServerUserName(), (String)this.licenseClientProperties.getLicenseServerPassword());
        if (token == null) {
            logger.info("\u5ba2\u6237\u7aef\u8ba4\u8bc1\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u8ba4\u8bc1token");
            response.setHeader("Content-Type", "text/html;charset=utf-8");
            response.getWriter().print("\u5ba2\u6237\u7aef\u8ba4\u8bc1\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u8ba4\u8bc1token");
            return;
        }
        String license = client.getLicense(jsonObject, this.licenseClientProperties.getLicenseServerHeader(), token, this.licenseClientProperties.getLicenseServerIp(), this.licenseClientProperties.getLicenseServerPort());
        JSONObject licenseJSON = JSONObject.parseObject((String)license);
        String success = licenseJSON.getString("success");
        if (Boolean.valueOf(success).booleanValue()) {
            String fileName = licenseJSON.getString("fileName");
            String fileContent = licenseJSON.getString("fileContent");
            this.decodeToResponse(fileName, fileContent, response);
        } else {
            response.setHeader("Content-Type", "text/html;charset=utf-8");
            response.getWriter().print(JSON.toJSONString((Object)licenseJSON));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeToResponse(String fileName, String fileContent, HttpServletResponse response) {
        InputStream in = null;
        try {
            byte[] bytes = Base64.decode((byte[])fileContent.getBytes("UTF-8"));
            in = new ByteArrayInputStream(bytes);
            response.setContentType("multipart/form-data");
            response.addHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
            int b = 0;
            byte[] buffer = new byte[512];
            while (b != -1) {
                b = in.read(buffer);
                if (b == -1) continue;
                response.getOutputStream().write(buffer, 0, b);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                response.getOutputStream().flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("\u5173\u95ed\u6587\u4ef6IOException!");
            }
        }
    }
}

