/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppArchivalMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.base.portal.application.model.SysAppArchival;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppArchivalService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppArchivalImpl")
public class SysAppArchivalImpl
extends HussarServiceImpl<SysAppArchivalMapper, SysAppArchival>
implements ISysAppArchivalService {
    private static Logger logger = LoggerFactory.getLogger(SysAppArchivalImpl.class);
    @Autowired
    private SysAppArchivalMapper sysAppArchivalMapper;
    @Autowired
    private SysApplicationMapper sysApplicationMapper;

    public SysAppArchival getOneArchivalInfo(String hostName, LocalDateTime endTime) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysAppArchival::getEndTime, (Object)endTime)).eq(SysAppArchival::getDelFlag, (Object)"0");
        String[] split = hostName.split("-");
        if (split.length > 3) {
            int lastIndex = hostName.lastIndexOf(45);
            int secondLastIndex = hostName.lastIndexOf(45, lastIndex - 1);
            hostName = hostName.substring(0, secondLastIndex);
        } else {
            queryWrapper.eq(SysAppArchival::getHostName, (Object)hostName);
        }
        List sysAppArchivals = this.sysAppArchivalMapper.selectList((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)sysAppArchivals)) {
            ((SysAppArchival)sysAppArchivals.get(0)).setHostName(hostName);
        }
        return HussarUtils.isNotEmpty((Object)sysAppArchivals) ? (SysAppArchival)sysAppArchivals.get(0) : null;
    }

    public Boolean saveAppArchival(SysAppArchival sysAppArchival) {
        if (HussarUtils.isNotEmpty((Object)sysAppArchival.getId())) {
            SysAppArchival oldInfo = (SysAppArchival)this.sysAppArchivalMapper.selectById(sysAppArchival.getId());
            oldInfo.setEndTime(sysAppArchival.getEndTime());
            oldInfo.setRemark(null == sysAppArchival.getRemark() ? oldInfo.getRemark() : sysAppArchival.getRemark());
            this.sysAppArchivalMapper.updateById(oldInfo);
        } else {
            String hostName = sysAppArchival.getHostName();
            String[] split = hostName.split("-");
            if (split.length > 3) {
                int lastIndex = hostName.lastIndexOf(45);
                int secondLastIndex = hostName.lastIndexOf(45, lastIndex - 1);
                hostName = hostName.substring(0, secondLastIndex);
                sysAppArchival.setHostName(hostName);
            }
            sysAppArchival.setDelFlag("0");
            this.sysAppArchivalMapper.insert(sysAppArchival);
        }
        return true;
    }

    public String saveOrUpdateArchival(SysAppArchival sysAppArchival) {
        sysAppArchival.setDelFlag("0");
        SysApplication appInfo = (SysApplication)this.sysApplicationMapper.selectById(sysAppArchival.getAppId());
        String remark = appInfo.getAppName() + "(" + appInfo.getAppCode() + ")+" + sysAppArchival.getUserName() + "(" + sysAppArchival.getUserAccount() + ")+" + sysAppArchival.getOrganName();
        sysAppArchival.setRemark(remark);
        List sysAppArchivals = this.sysAppArchivalMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppArchival::getHostName, (Object)sysAppArchival.getHostName())).eq(SysAppArchival::getDelFlag, (Object)"0")).ne(SysAppArchival::getAppId, (Object)"")).isNotNull(SysAppArchival::getAppId));
        if (HussarUtils.isEmpty((Object)sysAppArchivals)) {
            if (HussarUtils.isNotEmpty((Object)sysAppArchival.getId())) {
                this.sysAppArchivalMapper.updateById(sysAppArchival);
            } else {
                this.sysAppArchivalMapper.insert(sysAppArchival);
            }
        } else if (HussarUtils.isEmpty((Object)sysAppArchival.getId())) {
            if (!((SysAppArchival)sysAppArchivals.get(0)).getUserAccount().equals(sysAppArchival.getUserAccount())) {
                return "\u8be5\u4e3b\u673a\u540d\u5df2\u88ab" + ((SysAppArchival)sysAppArchivals.get(0)).getUserName() + "\u5907\u6848";
            }
            for (SysAppArchival item : sysAppArchivals) {
                if (!item.getAppId().equals(sysAppArchival.getAppId())) continue;
                return "\u5f53\u524d\u4eba\u5458\u4f7f\u7528\u5f53\u524d\u4e3b\u673a\u5728\u8be5\u5e94\u7528\u5df2\u5907\u6848";
            }
            this.sysAppArchivalMapper.insert(sysAppArchival);
        } else {
            for (SysAppArchival item : sysAppArchivals) {
                if (item.getId().equals(sysAppArchival.getId())) continue;
                if (!((SysAppArchival)sysAppArchivals.get(0)).getUserAccount().equals(sysAppArchival.getUserAccount())) {
                    return "\u8be5\u4e3b\u673a\u540d\u5df2\u88ab" + ((SysAppArchival)sysAppArchivals.get(0)).getUserName() + "\u5907\u6848";
                }
                if (!item.getAppId().equals(sysAppArchival.getAppId())) continue;
                return "\u5f53\u524d\u4eba\u5458\u4f7f\u7528\u5f53\u524d\u4e3b\u673a\u5728\u8be5\u5e94\u7528\u5df2\u5907\u6848";
            }
            this.sysAppArchivalMapper.updateById(sysAppArchival);
        }
        return "success";
    }
}

