/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.base.portal.form.dao.SysFormGroupMapper;
import com.jxdinfo.hussar.base.portal.form.dao.SysFormMapper;
import com.jxdinfo.hussar.base.portal.form.dto.SysFormDto;
import com.jxdinfo.hussar.base.portal.form.model.SysForm;
import com.jxdinfo.hussar.base.portal.form.model.SysFormGroup;
import com.jxdinfo.hussar.base.portal.form.service.ISysFormService;
import com.jxdinfo.hussar.base.portal.form.vo.AppMenuVo;
import com.jxdinfo.hussar.base.portal.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.base.portal.form.vo.SysFormVo;
import com.jxdinfo.hussar.base.portal.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.form.service.impl.sysFormServiceImpl")
public class SysFormServiceImpl
extends HussarServiceImpl<SysFormMapper, SysForm>
implements ISysFormService {
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private SysFormGroupMapper sysFormGroupMapper;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;

    public ApiResponse<Boolean> editForm(SysFormDto sysFormDto) {
        boolean flag = this.updateById((BaseEntity)sysFormDto);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<Boolean> deleteForm(Long formId) {
        boolean flag = this.removeById(formId);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public SysSiftGroupList getFormList(String formName, String formStatus, Long appId) {
        SysSiftGroupList sysSiftGroupList = new SysSiftGroupList();
        List<SysFormVo> sysFormList = this.sysFormMapper.getSysFormList(formName, formStatus, null, appId);
        List<Object> sysFormGroups = new ArrayList();
        if (HussarUtils.isEmpty((Object)formName) && HussarUtils.isEmpty((Object)formStatus)) {
            sysFormGroups = this.sysFormGroupMapper.getSysFormGroupList(appId, null);
        } else {
            ArrayList<Long> groupIds = new ArrayList<Long>();
            for (SysFormVo sysFormVo : sysFormList) {
                Long formGroupId = sysFormVo.getFormGroupId();
                if (!HussarUtils.isNotEmpty((Object)formGroupId)) continue;
                groupIds.add(formGroupId);
            }
            if (HussarUtils.isNotEmpty(groupIds)) {
                sysFormGroups = this.sysFormGroupMapper.getSysFormGroupList(appId, groupIds);
            }
        }
        if (HussarUtils.isEmpty(sysFormList)) {
            sysSiftGroupList.setHaveGroupList(JSONObject.parseArray((String)JSONObject.toJSONString(sysFormGroups), SysFormGroupVo.class));
            return sysSiftGroupList;
        }
        return this.combinedData(sysFormList, sysFormGroups);
    }

    public ApiResponse<List<AppMenuVo>> getFormMenuList(Long appId) {
        List formIds = (List)this.sysAppVisitFormAuthorizeRolesService.getAuthorityFormList(appId).getData();
        if (HussarUtils.isEmpty((Object)formIds)) {
            return ApiResponse.success(new ArrayList(), (String)"\u6ca1\u6709\u53ef\u8bbf\u95ee\u7684\u83dc\u5355");
        }
        List<Object> sysFormGroups = new ArrayList();
        List<SysFormVo> sysFormList = this.sysFormMapper.getSysFormList(null, null, formIds, appId);
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (SysForm sysForm : sysFormList) {
            groupIds.add(sysForm.getFormGroupId());
        }
        sysFormGroups = this.sysFormGroupMapper.getSysFormGroupList(appId, groupIds);
        ArrayList<AppMenuVo> resultList = new ArrayList<AppMenuVo>();
        for (SysFormGroupVo sysFormGroupVo : sysFormGroups) {
            AppMenuVo appMenuVo = new AppMenuVo();
            appMenuVo.setId(sysFormGroupVo.getId());
            appMenuVo.setSeq(sysFormGroupVo.getSeq());
            appMenuVo.setName(sysFormGroupVo.getGroupName());
            appMenuVo.setIcon(sysFormGroupVo.getGroupIcon());
            appMenuVo.setIconType(sysFormGroupVo.getGroupIconType());
            appMenuVo.setIconColor(sysFormGroupVo.getGroupIconColor());
            appMenuVo.setType("1");
            resultList.add(appMenuVo);
        }
        Map map = JSON.parseArray((String)JSON.toJSONString(resultList), AppMenuVo.class).stream().distinct().collect(Collectors.toMap(AppMenuVo::getId, AppMenuVo2 -> AppMenuVo2, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysForm sysForm : sysFormList) {
            AppMenuVo appMenuVo = (AppMenuVo)map.get(sysForm.getFormGroupId());
            if (HussarUtils.isEmpty((Object)appMenuVo)) {
                AppMenuVo result = this.giveAppMenuVoProperty(sysForm);
                map.put(result.getId(), result);
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)appMenuVo.getAppMenuVoList())) {
                appMenuVo.getAppMenuVoList().add(this.giveAppMenuVoProperty(sysForm));
            }
            if (!HussarUtils.isEmpty((Object)appMenuVo.getAppMenuVoList())) continue;
            ArrayList<AppMenuVo> menuVoList = new ArrayList<AppMenuVo>();
            menuVoList.add(this.giveAppMenuVoProperty(sysForm));
            appMenuVo.setAppMenuVoList(menuVoList);
        }
        return ApiResponse.success(new ArrayList(map.values()));
    }

    public ApiResponse<SysForm> getDetailById(Long formId) {
        return ApiResponse.success((Object)this.getById(formId));
    }

    public ApiResponse<List<SysForm>> getSysFormByAppId(Long appId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysForm::getAppId, (Object)appId);
        return ApiResponse.success((Object)this.list((Wrapper)lambdaQueryWrapper));
    }

    private SysSiftGroupList combinedData(List<SysFormVo> sysFormList, List<SysFormGroupVo> sysFormGroups) {
        ArrayList<SysForm> noGroupList = new ArrayList<SysForm>();
        SysSiftGroupList sysSiftGroupList = new SysSiftGroupList();
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysFormGroups), SysFormGroupVo.class).stream().distinct().collect(Collectors.toMap(SysFormGroup::getId, sysFormGroupVo -> sysFormGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysForm sysForm : sysFormList) {
            SysFormGroupVo sysFormGroupVo2 = (SysFormGroupVo)resultCollect.get(sysForm.getFormGroupId());
            if (HussarUtils.isEmpty((Object)sysFormGroupVo2)) {
                noGroupList.add(sysForm);
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)sysFormGroupVo2.getSysFormList())) {
                sysFormGroupVo2.getSysFormList().add(sysForm);
            }
            if (!HussarUtils.isEmpty((Object)sysFormGroupVo2.getSysFormList())) continue;
            ArrayList<SysForm> formGroupList = new ArrayList<SysForm>();
            formGroupList.add(sysForm);
            sysFormGroupVo2.setSysFormList(formGroupList);
        }
        sysSiftGroupList.setHaveGroupList(new ArrayList(resultCollect.values()));
        sysSiftGroupList.setNoGroupList(noGroupList);
        return sysSiftGroupList;
    }

    private AppMenuVo giveAppMenuVoProperty(SysForm sysForm) {
        AppMenuVo trans = new AppMenuVo();
        trans.setId(sysForm.getId());
        trans.setSeq(sysForm.getSeq());
        trans.setName(sysForm.getFormName());
        trans.setIcon(sysForm.getFormIcon());
        trans.setIconType(sysForm.getFormIconType());
        trans.setIconColor(sysForm.getFormIconColor());
        trans.setFormType(sysForm.getFormType());
        trans.setTableName(sysForm.getTableName());
        trans.setType("2");
        return trans;
    }
}

