/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitFormAuthorizeRolesMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.base.portal.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.base.portal.authority.dto.SysAppVisitFormAuthorizeRolesDto;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.base.portal.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.base.portal.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.base.portal.authority.vo.FormRoleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.authority.service.impl.sysAppVisitFormAuthorizeRolesServiceImpl")
public class SysAppVisitFormAuthorizeRolesServiceImpl
extends HussarServiceImpl<SysAppVisitFormAuthorizeRolesMapper, SysAppVisitFormAuthorizeRoles>
implements ISysAppVisitFormAuthorizeRolesService {
    @Resource
    private SysAppVisitFormAuthorizeRolesMapper appVisitFormAuthorizeRolesMapper;
    @Resource
    private SysAppVisitRoleButtonMapper sysAppVisitRoleButtonMapper;
    @Autowired
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    @Resource
    private SysUpAppVisitRoleFieldMapper sysUpAppVisitRoleFieldMapper;
    @Autowired
    private ISysAppVisitDataLogicService sysAppVisitDataLogicService;

    @HussarTransactional
    public ApiResponse<Boolean> addFormAuthorizeRoles(SysAppVisitFormAuthorizeRolesDto sysAppVisitFormAuthorizeRolesDto) {
        ArrayList<SysAppVisitFormAuthorizeRoles> rolesList = new ArrayList<SysAppVisitFormAuthorizeRoles>();
        for (int i = 0; i < sysAppVisitFormAuthorizeRolesDto.getRoleIdList().size(); ++i) {
            this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getFormId, (Object)sysAppVisitFormAuthorizeRolesDto.getFormId())).eq(SysAppVisitFormAuthorizeRoles::getRoleId, sysAppVisitFormAuthorizeRolesDto.getRoleIdList().get(i)));
            SysAppVisitFormAuthorizeRoles authorizeRoles = new SysAppVisitFormAuthorizeRoles();
            BeanUtils.copyProperties((Object)sysAppVisitFormAuthorizeRolesDto, (Object)authorizeRoles);
            authorizeRoles.setRoleId((Long)sysAppVisitFormAuthorizeRolesDto.getRoleIdList().get(i));
            rolesList.add(authorizeRoles);
        }
        boolean flag = this.saveBatch(rolesList);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public ApiResponse<Boolean> deleteFormAuthorizeRoles(List<Long> roleIdList) {
        return ApiResponse.success((Object)this.removeByIds(roleIdList));
    }

    public ApiResponse<List<FormRoleVo>> getFormAuthorizeRolesList(Long appId, Long formId) {
        return ApiResponse.success(this.appVisitFormAuthorizeRolesMapper.getFormAuthorizeRolesList(appId, formId));
    }

    public ApiResponse<List<Long>> getAuthorityFormList(Long appId) {
        return ApiResponse.success(this.appVisitFormAuthorizeRolesMapper.getAuthorityFormList(BaseSecurityUtil.getUser().getRolesList(), appId));
    }

    @HussarTransactional
    public ApiResponse<Boolean> roleCancel(SysAppVisitFormAuthorizeRolesDto formAuthorizeRolesDto) {
        if (HussarUtils.isNotEmpty((Object)formAuthorizeRolesDto.getFormId()) && HussarUtils.isNotEmpty((Object)formAuthorizeRolesDto.getRoleId())) {
            Long formId = formAuthorizeRolesDto.getFormId();
            Long roleId = formAuthorizeRolesDto.getRoleId();
            this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getFormId, (Object)formId)).eq(SysAppVisitFormAuthorizeRoles::getRoleId, (Object)roleId));
            this.sysAppVisitRoleButtonMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getFormId, (Object)formId)).eq(SysAppVisitRoleButton::getRoleId, (Object)roleId));
            this.roleOrganDataAuthorityService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)roleId));
            this.sysUpAppVisitRoleFieldMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getFormId, (Object)formId)).eq(SysUpAppVisitRoleField::getRoleId, (Object)roleId));
            this.sysAppVisitDataLogicService.dataLogicAuthorityCancel(formId, roleId);
            return ApiResponse.success((Object)Boolean.TRUE);
        }
        throw new BaseException("\u8868\u5355id\u6216\u89d2\u8272id\u4e3a\u7a7a");
    }
}

