/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.jxdinfo.hussar.base.portal.application.service.ISysAppCommonService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppCommonVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.base.portal.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.base.portal.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.base.portal.authority.vo.ButtonVo;
import com.jxdinfo.hussar.base.portal.authority.vo.DataLogicAuthorityVo;
import com.jxdinfo.hussar.base.portal.authority.vo.FieldAuthorityVo;
import com.jxdinfo.hussar.base.portal.authority.vo.OrganDataAuthorityVo;
import com.jxdinfo.hussar.base.portal.form.model.SysForm;
import com.jxdinfo.hussar.base.portal.form.service.ISysFormService;
import com.jxdinfo.hussar.base.portal.form.vo.AppMenuVo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.sysApplicationExternalServiceImpl")
public class SysApplicationExternalServiceImpl
implements ISysApplicationExternalService {
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysAppCommonService sysAppCommonService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysAppVisitRoleButtonService roleButtonService;
    @Resource
    private ISysUpAppVisitRoleFieldService roleFieldService;
    @Resource
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    @Resource
    private ISysAppVisitDataLogicService dataLogicService;

    public List<SysAppGroupVo> getAppList(String appName) {
        return this.applicationService.getAppList(appName);
    }

    public List<SysAppCommonVo> getCommonAppList(String platform) {
        return this.sysAppCommonService.getCommonAppList(platform);
    }

    public List<AppMenuVo> getFormMenuList(Long appId) {
        return (List)this.sysFormService.getFormMenuList(appId).getData();
    }

    public SysForm getFormDetailById(Long formId) {
        return (SysForm)this.sysFormService.getDetailById(formId).getData();
    }

    public SysApplicationVo getAppDetailById(Long appId) {
        return (SysApplicationVo)this.applicationService.getAppDetail(appId).getData();
    }

    public SysApplicationVo getAuthorityAppDetailById(Long appId) {
        return this.applicationService.getAuthorityAppDetail(appId);
    }

    public List<ButtonVo> formAuthorityButton(Long formId) {
        return (List)this.roleButtonService.formAuthorityButton(formId).getData();
    }

    public List<FieldAuthorityVo> formAuthorityField(Long formId) {
        return (List)this.roleFieldService.formAuthorityField(formId).getData();
    }

    public List<OrganDataAuthorityVo> formAuthorityOrganData(Long formId) {
        return (List)this.roleOrganDataAuthorityService.formAuthorityOrganData(formId).getData();
    }

    public List<DataLogicAuthorityVo> formAuthorityDataLogic(Long formId) {
        return (List)this.dataLogicService.dataLogicAuthorityByFormId(formId).getData();
    }
}

