/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppRecycleMapper;
import com.jxdinfo.hussar.base.portal.application.enums.SysUserRole;
import com.jxdinfo.hussar.base.portal.application.model.SysAppRecycle;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppRecycleVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppRecycleServiceImpl")
public class SysAppRecycleServiceImpl
extends HussarServiceImpl<SysAppRecycleMapper, SysAppRecycle>
implements ISysAppRecycleService {
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private SysAppRecycleMapper sysAppRecycleMapper;
    @Resource
    private ISysAppGroupService sysAppGroupService;

    public Page<SysAppRecycleVo> getRecycleList(PageInfo pageInfo, String appName) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = null;
        if (!user.isSuperAdmin() || user.getRolesList().contains((Object)SysUserRole.APPLICATIONADMIN)) {
            userId = user.getUserId();
        }
        return this.sysAppRecycleMapper.getRecycleList((Page<SysAppRecycleVo>)page, userId, appName);
    }

    @HussarTransactional
    public Boolean revertApp(Long appId) {
        SysAppRecycle revertApp = (SysAppRecycle)this.getById(appId);
        if (HussarUtils.isEmpty((Object)this.sysAppGroupService.getById((Serializable)revertApp.getAppGroupId()))) {
            revertApp.setAppGroupId(Long.valueOf(1L));
        }
        SysApplication sysApplication = new SysApplication();
        BeanUtils.copyProperties((Object)revertApp, (Object)sysApplication);
        sysApplication.setAppStatus("1");
        sysApplication.setReleaseStatus("0");
        sysApplication.setCreator(revertApp.getCreateUser());
        sysApplication.setLastEditor(revertApp.getCreateUser());
        this.sysApplicationService.save((Object)sysApplication);
        return this.removeById(appId);
    }

    @HussarTransactional
    public Boolean deleteRecycleApp(Long appId) {
        return this.removeById(appId);
    }
}

