/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppDevelopTeamMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.base.portal.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.base.portal.application.dto.QueryUserAppDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.base.portal.application.vo.AppDevelopTeamDetailVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.service.ISysAppCopyService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.sysAppDevelopTeamServiceImpl")
public class SysAppDevelopTeamServiceImpl
extends HussarServiceImpl<SysAppDevelopTeamMapper, SysAppDevelopTeam>
implements ISysAppDevelopTeamService {
    @Resource
    private ISysAppDevelopTeamMemberService appDevelopTeamMemberService;
    @Resource
    private SysAppDevelopTeamMapper sysAppDevelopTeamMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private ISysAppCopyService sysAppCopyService;

    @HussarTransactional
    public Boolean saveAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto) {
        SysAppDevelopTeam sysAppDevelopTeam = new SysAppDevelopTeam();
        BeanUtils.copyProperties((Object)appDevelopTeamDto, (Object)sysAppDevelopTeam);
        long id = IdWorker.getId((Object)sysAppDevelopTeam);
        List userIds = appDevelopTeamDto.getUserIds();
        if (HussarUtils.isNotEmpty((Object)userIds)) {
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            ArrayList<SysAppDevelopTeamMember> memberList = new ArrayList<SysAppDevelopTeamMember>();
            for (Long userId : userIds) {
                SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
                member.setTeamId(Long.valueOf(id));
                member.setUserId(userId);
                memberList.add(member);
            }
            this.appDevelopTeamMemberService.saveBatch(memberList);
        }
        sysAppDevelopTeam.setId(Long.valueOf(id));
        return this.save((BaseEntity)sysAppDevelopTeam);
    }

    @HussarTransactional
    public Boolean updateAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto) {
        SysAppDevelopTeam sysAppDevelopTeam = new SysAppDevelopTeam();
        BeanUtils.copyProperties((Object)appDevelopTeamDto, (Object)sysAppDevelopTeam);
        Long teamId = appDevelopTeamDto.getTeamId();
        List userIds = appDevelopTeamDto.getUserIds();
        SysApplication sysApplication = (SysApplication)this.sysApplicationMapper.selectById(appDevelopTeamDto.getAppId());
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(sysApplication.getCreator());
        list.add(SysUserAndRole.SUPERADMIN.getValue());
        this.appDevelopTeamMemberService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId)).notIn(SysAppDevelopTeamMember::getUserId, list));
        if (HussarUtils.isNotEmpty((Object)userIds)) {
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            ArrayList<SysAppDevelopTeamMember> memberList = new ArrayList<SysAppDevelopTeamMember>();
            for (Long userId : userIds) {
                SysAppDevelopTeamMember member = new SysAppDevelopTeamMember();
                member.setTeamId(teamId);
                member.setUserId(userId);
                memberList.add(member);
            }
            this.appDevelopTeamMemberService.saveBatch(memberList);
        }
        sysAppDevelopTeam.setId(teamId);
        String appCode = appDevelopTeamDto.getAppCode();
        this.sysAppCopyService.copy(appCode, userIds);
        return this.updateById((BaseEntity)sysAppDevelopTeam);
    }

    public ApiResponse<AppDevelopTeamDetailVo> getAppDevelopTeamDetail(Long appId) {
        AppDevelopTeamDetailVo teamDetailVo = new AppDevelopTeamDetailVo();
        SysAppDevelopTeam team = (SysAppDevelopTeam)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)team)) {
            throw new BaseException("\u8be5\u5e94\u7528\u6ca1\u6709\u5e94\u7528\u5f00\u53d1\u56e2\u961f\uff01");
        }
        BeanUtils.copyProperties((Object)team, (Object)teamDetailVo);
        teamDetailVo.setTeamId(team.getId());
        SysApplication sysApplication = (SysApplication)this.sysApplicationMapper.selectById(appId);
        ArrayList<Long> notUserIds = new ArrayList<Long>();
        notUserIds.add(SysUserAndRole.SUPERADMIN.getValue());
        notUserIds.add(sysApplication.getCreator());
        List userVoList = this.appDevelopTeamMemberService.listAppDevelopTeamMember(team.getId(), notUserIds);
        teamDetailVo.setUserList(userVoList);
        return ApiResponse.success((Object)teamDetailVo);
    }

    public List<Long> selectAppListByCurrentUser() {
        Long userId = BaseSecurityUtil.getUser().getId();
        return this.sysAppDevelopTeamMapper.selectAppListByCurrentUser(userId);
    }

    public Boolean checkCurrentUserInTeam(Long appId) {
        List<Long> appIdList = this.selectAppListByCurrentUser();
        return appIdList.contains(appId);
    }

    public ApiResponse<Page<SearchUserVo>> searchUsers(PageInfo pageInfo, QueryUserAppDto queryUserDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        String struFid = "/";
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryUserDto.getDepStruId());
        if (currentUser.isGradeadmin()) {
            ConditionUtils.isTureOrFalse((boolean)HussarUtils.isEmpty((Object)depStruId.get())).trueOrFalseHandle(() -> depStruId.set(currentUser.getDeptId()), () -> {
                SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)queryUserDto.getDepStruId()));
                SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
                if (currentNodeStru.getStruLevel() <= sysStru.getStruLevel()) {
                    depStruId.set(currentUser.getDeptId());
                }
            });
        }
        if (HussarUtils.isNotEmpty((Object)depStruId.get()) && !Objects.equals(Constants.ROOT_NODE_ID, depStruId.get())) {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById((Serializable)depStruId.get());
            AssertUtil.isNotNull((Object)struTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784");
            struFid = struTemp.getStruFid();
        } else if (HussarUtils.isBlank((CharSequence)queryUserDto.getUserName()) || HussarUtils.isBlank((CharSequence)queryUserDto.getUserAccount()) || HussarUtils.isBlank((CharSequence)queryUserDto.getAccountStatus()) || HussarUtils.isBlank((CharSequence)queryUserDto.getAccountProperty())) {
            queryParams.put("containSys", StringUtils.trimToNull((String)queryUserDto.getContainSys()));
        }
        Object[] arr = new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode()};
        String accountStatus = queryUserDto.getAccountStatus();
        if (ArrayUtils.contains((Object[])arr, (Object)accountStatus)) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            if (HussarUtils.isEmpty((Object)keyList) && HussarUtils.equals((Object)accountStatus, (Object)UserStatus.LOCKED.getCode())) {
                page.setRecords(Collections.emptyList());
                return ApiResponse.success((Object)page);
            }
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            queryUserDto.setLockUserIds(lockUserIds);
            if (CollectionUtils.isNotEmpty((Collection)keyList)) {
                String tmpKey = null;
                Iterator iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    String cacheKey;
                    tmpKey = cacheKey = (String)iterator.next();
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            }
            if (HussarUtils.isNotEmpty(lockUserIds)) {
                queryParams.put("lockUserIds", lockUserIds);
            }
        }
        SysApplication sysApplication = (SysApplication)this.sysApplicationMapper.selectById(queryUserDto.getAppId());
        ArrayList<Long> notUserIds = new ArrayList<Long>();
        notUserIds.add(SysUserAndRole.SUPERADMIN.getValue());
        notUserIds.add(sysApplication.getCreator());
        queryParams.put("notUserIds", notUserIds);
        queryParams.put("depStruId", depStruId.get());
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", StringUtils.trimToEmpty((String)queryUserDto.getUserAccount()));
        queryParams.put("accountStatus", StringUtils.trimToEmpty((String)queryUserDto.getAccountStatus()));
        queryParams.put("userName", StringUtils.trimToEmpty((String)queryUserDto.getUserName()));
        queryParams.put("accountProperty", StringUtils.trimToEmpty((String)queryUserDto.getAccountProperty()));
        queryParams.put("struFid", StringUtils.trimToNull((String)struFid));
        List<SearchUserVo> userInfoList = this.sysAppDevelopTeamMapper.searchUsers((Page<SearchUserVo>)page, queryParams);
        this.wrapUsers(userInfoList);
        page.setRecords(userInfoList);
        return ApiResponse.success((Object)page);
    }

    private void wrapUsers(List<SearchUserVo> userInfoList) {
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        List list1 = this.sysDicRefService.getDicListByType("account_state");
        Map<String, String> mapStatus = list1.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        List list2 = this.sysDicRefService.getDicListByType("account_property");
        Map<String, String> mapProperty = list2.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        boolean flag = HussarUtils.isNotEmpty((Object)keyList);
        if (HussarUtils.isNotEmpty(userInfoList)) {
            for (SearchUserVo vo : userInfoList) {
                vo.setAccoutStatusName(mapStatus.get(vo.getAccountStatus()));
                vo.setAccountPropertyName(mapProperty.get(vo.getAccountProperty()));
                if (!flag) continue;
                Optional<String> optional = keyList.parallelStream().filter(item -> item.equalsIgnoreCase(String.valueOf(vo.getId()))).findAny();
                ConditionUtils.isTrue((boolean)optional.isPresent()).handle(() -> {
                    String tmpkey = (String)optional.get();
                    UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)tmpkey);
                    if (null != model && model.getLockTime() != null) {
                        vo.setAccountStatus(UserStatus.LOCKED.getCode());
                    }
                });
            }
        }
    }
}

