/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.yamlServer.service.impl;

import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.base.portal.yamlServer.service.IYamlService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Service(value="com.jxdinfo.hussar.base.portal.yamlServer.service.impl.YamlServiceImpl")
public class YamlServiceImpl
implements IYamlService {
    @Resource
    GitlabConfigProperty gitlabConfigProperty;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createValues(SysAppDeploy sysAppDeploy, String appCreateType, String appCode, Long currentTime) {
        OutputStreamWriter fileWriter = null;
        try {
            String path = "";
            path = this.gitlabConfigProperty.getTemplateLocalPath() + File.separator + currentTime + File.separator + appCode + File.separator + "hussar-config" + File.separator + "ddm-helm" + File.separator;
            new File(this.gitlabConfigProperty.getTemplateLocalPath()).mkdir();
            new File(path).mkdir();
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            fileWriter = new FileWriter(new File(path + "values.yaml"));
            Yaml yaml = new Yaml(dumperOptions);
            LinkedHashMap<String, Object> ymlMap = new LinkedHashMap<String, Object>();
            ymlMap.put("namespace", sysAppDeploy.getAppNamespace());
            HashMap<String, String> harbor = new HashMap<String, String>();
            harbor.put("secret", sysAppDeploy.getAppHarborKey());
            ymlMap.put("harbor", harbor);
            HashMap<String, String> service = new HashMap<String, String>();
            service.put("mobilePort", sysAppDeploy.getAppMobilePort());
            service.put("port", sysAppDeploy.getAppFrontPort());
            service.put("ip", sysAppDeploy.getAppIp());
            ymlMap.put("service", service);
            String databasetType = sysAppDeploy.getDatabasetType();
            if ("1".equals(databasetType)) {
                databasetType = "mysql";
            } else if ("2".equals(databasetType)) {
                databasetType = "oracle";
            } else if ("3".equals(databasetType)) {
                databasetType = "shentong";
            } else if ("4".equals(databasetType)) {
                databasetType = "dm";
            } else if ("5".equals(databasetType)) {
                databasetType = "kingbaseES";
            } else if ("6".equals(databasetType)) {
                databasetType = "sqlServer";
            } else if ("7".equals(databasetType)) {
                databasetType = "pgSql";
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("host", sysAppDeploy.getDatabaseUrl());
            params.put("port", sysAppDeploy.getAppFrontPort());
            params.put("database", sysAppDeploy.getDatabaseName());
            params.put("username", sysAppDeploy.getDatabaseAccount());
            params.put("password", sysAppDeploy.getDatabasePassword());
            ymlMap.put(databasetType, params);
            HashMap<String, Object> compile = new HashMap<String, Object>();
            compile.put("image", sysAppDeploy.getCompilerMirrorUrl());
            compile.put("imagePullPolicy", "Always");
            HashMap<String, String> name = new HashMap<String, String>();
            name.put("name", "harbor-secret");
            compile.put("imagePullSecrets", name);
            HashMap resources = new HashMap();
            HashMap<String, String> limits = new HashMap<String, String>();
            limits.put("cpu", "2000m");
            limits.put("memory", "4Gi");
            HashMap<String, String> requests = new HashMap<String, String>();
            requests.put("cpu", "2000m");
            requests.put("memory", "2Gi");
            resources.put("limits", limits);
            resources.put("requests", requests);
            compile.put("resources", resources);
            ymlMap.put("compile", compile);
            HashMap<String, Object> backend = new HashMap<String, Object>();
            backend.put("image", sysAppDeploy.getWebMirrorUrl());
            backend.put("imagePullPolicy", "Always");
            HashMap<String, String> nameBackend = new HashMap<String, String>();
            nameBackend.put("name", "harbor-secret");
            backend.put("imagePullSecrets", nameBackend);
            HashMap resourcesBackend = new HashMap();
            HashMap<String, String> limitsBackend = new HashMap<String, String>();
            limitsBackend.put("cpu", "2000m");
            limitsBackend.put("memory", "4Gi");
            HashMap<String, String> requestsBackend = new HashMap<String, String>();
            requestsBackend.put("cpu", "2000m");
            requestsBackend.put("memory", "2Gi");
            resourcesBackend.put("limits", limitsBackend);
            resourcesBackend.put("requests", requestsBackend);
            backend.put("resources", resourcesBackend);
            ymlMap.put("backend", backend);
            yaml.dump(ymlMap, (Writer)fileWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

